;;; trans-util.el --- useful functions for translating characters.

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: CCL, mule, multilingual, character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(defun char-codepoint (char)
  "Return a codepoint of char."
  (let ((info (split-char char)))
    (if (= (length info) 3)
	(+ (* (nth 1 info) ?\x80) (nth 2 info))
      (nth 1 info))))

(defun make-char-from-codepoint (charset codepoint)
  "Return a character of CODEPOINT in CHARSET"
  (if (> codepoint ?\xff)
      (make-char charset (lsh codepoint -8) (logand codepoint ?\xff))
    (make-char charset codepoint)))

(provide 'trans-util)
