(****************************************************************************)
(*                                                                          *)
(* HDevice.pas                                                         1.0  *)
(*                                                                          *)
(* This component is used to encapsulate the notion of "device context".    *)
(*                                                                          *)
(* A FT_Device has the following properties :                               *)
(*                                                                          *)
(*   - a horizontal and vertical resolutions, expressed in dots per         *)
(*     inches (dpi). Common values are : 96x72, 96x96 (for screens)         *)
(*     or 300x300, 600x600 and above (printers)                             *)
(*                                                                          *)
(*   - a color depth. It can be :                                           *)
(*        0 : the device uses vectorial graphics (like a Postscript filter) *)
(*        1 : the device is monochrome                                      *)
(*        2 : the device has gray-levels or colors (at least 5 levels/      *)
(*            colors are requested by font-smoothing)                       *)
(*                                                                          *)
(*   - a horizontal and vertical dimensions expressed in pixels             *)
(*                                                                          *)
(* It must also provide :                                                   *)
(*                                                                          *)
(*   - a function to blit a FT_Bitmap into its surface                      *)
(*                                                                          *)
(*   - if its depth is 2, a function to blit an 8-vit pixmap to its         *)
(*     surface.                                                             *)
(*                                                                          *)
(* for now, we do not consider sending vectorial outlines directly          *)
(* to a FT_Device, but this could come a bit later..                        *)
(*                                                                          *)
(* This component contains an abstract class that you should subclass       *)
(* to suit your environment. See the test programs for examples.            *)
(*                                                                          *)
(****************************************************************************)

unit HDevice;

interface

uses
{$IFDEF VIRTUAL}
  Use32,
{$ENDIF}
  HBitmap;

const
  FT_ColorDepth_Vector     = 0;
  FT_ColorDepth_Monochrome = 1;
  FT_ColorDepth_Color      = 2;

  FT_Device_Caps_Vector_Input  = 1;
  FT_Device_Caps_Bitmap_Input  = 2;
  FT_Device_Caps_Pixmap_Input  = 3;

type
  FT_ColorDepth  = integer;
  FT_Device_Caps = integer;

  FT_Device = ^FT_Device_Class;
  FT_Device_Class = object

    xResolutionDPI : integer;
    yResolutionDPI : integer;

    colorDepth     : FT_ColorDepth;

    xDimension     : integer;
    yDimension     : integer;

    procedure  blitBitmap( var bitmap : FT_Bitmap;
                           x_origin   : integer;
                           y_origin   : integer ); virtual;

    procedure  blitPixmap( var pixmap : FT_Pixmap;
                           x_origin   : integer;
                           y_origin   : integer ); virtual;

  end;



implementation

end.
