# This file is part of the FreeType project
#
# This builds the Watcom library with Watcom's wcc386 under DOS
#
# You'll need Watcom's wmake
#
#
# Invoke by "wmake -f arch\msdos\Makefile.wat" while in the "lib" directory
#
# This will build "freetype\lib\libttf.lib"
#

.EXTENSIONS:
.EXTENSIONS: .exe .obj .c .h
.obj:.;.\extend
.c:.;.\extend
.h:.;.\extend

CC = wcc386

CCFLAGS = /otexanl+ /s /w4 /zq /d3 -Iarch\msdos -I. -Iextend

OBJS = ttapi.obj     ttcache.obj  ttcalc.obj   ttcmap.obj    ttdebug.obj &
       tterror.obj   ttfile.obj   ttgload.obj  ttinterp.obj  ttlists.obj &
       ttload.obj    ttmemory.obj ttmutex.obj  ttobjs.obj    ttraster.obj &
       ttextend.obj  extend\ftxgasp.obj  extend\ftxkern.obj

.c.obj :
  $(CC) $(CCFLAGS) $[* /fo=$[*.obj

libname = libttf
libfile = $(libname).lib
cmdfile = $(libname).lst

$(libfile) : $(OBJS) $(cmdfile)
  wlib -q -n $(libfile) @$(cmdfile)

$(cmdfile) : $(OBJS)
  @for %i in ($(OBJS)) do @%append $(cmdfile) +-%i

clean: .symbolic
         @-erase *.obj
         @-erase extend\*.obj
         @-erase $(cmdfile)

distclean: .symbolic clean
         @-erase $(libfile)

new: .symbolic
         @-wtouch *.c

# end of Makefile.wat
