/*
 *  This is a cheap replacement for getopt() because that routine is not
 *  available on some platforms and behaves differently on other platforms.
 *
 *  This code is hereby expressly placed in the public domain.
 *  mleisher@crl.nmsu.edu (Mark Leisher)
 *  10 October 1997
 *
 * This file is a very simple variation of the original common.h.in
 * The definition of the macro HAVE_GETOPT_H must be now placed in the
 * makefile!
 * 05 November 1997 (turner@enst.fr)
 */

#ifndef _H_COMMON
#define _H_COMMON

/* This file must be compiled with the following configuration macro set:   */
/*                                                                          */
/*  HAVE_GETOPT_H   Indicates that the 'getopt' function is part of your    */
/*                  system's libc/environment.  If not, a generic getopt()  */
/*                  will be implemented in common.c.  Note that the         */
/*                  behaviour of getopt varies from one Unix system to      */
/*                  another.  If you encounter problems with parameter      */
/*                  passing, just undef the macro.                          */
/*                                                                          */

/* Note that by default, both functions are implemented in common.c */

#ifdef __cplusplus
  extern "C" {
#endif

#ifndef HAVE_GETOPT_H

  extern int    opterr;
  extern int    optind;
  extern char*  optarg;

  extern int  getopt(
#ifdef __STDC__
    int           argc,
    char* const*  argv,
    const char*   pattern
#endif
  );

#else /* HAVE_GETOPT_H */

#include <getopt.h>

#endif /* !HAVE_GETOPT_H */


  extern char*  ft_basename(
#ifdef __STDC__
    const char*  name
#endif
  );

#ifdef __cplusplus
  }
#endif

#endif /* _H_COMMON */


/* End */
