(* Language specific management *)

Unit HLang;

interface

const
  (******************************************************************)
  (*  TrueType Name ID numbers                                      *)
  (*                                                                *)
  FT_TrueType_Name_Copyright    = 0;
  FT_TrueType_Name_Family       = 1;
  FT_TrueType_Name_Style        = 2;
  FT_TrueType_Name_Unique       = 3;
  FT_TrueType_Name_Full_Name    = 4;
  FT_TrueType_Name_Version      = 5;
  FT_TrueType_Name_Postscript   = 6;
  FT_TrueType_Name_Trademark    = 7;
  FT_TrueType_Name_Manufacturer = 8;

  (******************************************************************)
  (*  Apple Language ID numbers                                     *)
  (*                                                                *)
  FT_Apple_Language_English      = 0;
  FT_Apple_Language_French       = 1;
  FT_Apple_Language_German       = 2;
  FT_Apple_Language_Italian      = 3;
  FT_Apple_Language_Dutch        = 4;
  FT_Apple_Language_Swedish      = 5;
  FT_Apple_Language_Spanish      = 6;
  FT_Apple_Language_Danish       = 7;
  FT_Apple_Language_Portuguese   = 8;
  FT_Apple_Language_Norwegian    = 9;
  FT_Apple_Language_Hebrew       = 10;
  FT_Apple_Language_Japanese     = 11;
  FT_Apple_Language_Arabic       = 12;
  FT_Apple_Language_Finnish      = 13;
  FT_Apple_Language_Greek        = 14;
  FT_Apple_Language_Icelandic    = 15;
  FT_Apple_Language_Maltese      = 16;
  FT_Apple_Language_Turkish      = 17;
  FT_Apple_Language_Croatian     = 18;
  FT_Apple_Language_Chinese      = 19;
  FT_Apple_Language_Urdu         = 20;
  FT_Apple_Language_Hindi        = 21;
  FT_Apple_Language_Thai         = 22;
  FT_Apple_Language_Korean       = 23;
  FT_Apple_Language_Lithuanian   = 24;
  FT_Apple_Language_Polish       = 25;
  FT_Apple_Language_Hungarian    = 26;
  FT_Apple_Language_Estonian     = 27;
  FT_Apple_Language_Lettish      = 28;
  FT_Apple_Language_Saamisk      = 29;
  FT_Apple_Language_Faeroese     = 30;
  FT_Apple_Language_Farsi        = 31;
  FT_Apple_Language_Russian      = 32;
  FT_Apple_Language_Chinese2     = 33;
  FT_Apple_Language_Flemish      = 34;
  FT_Apple_Language_Irish        = 35;
  FT_Apple_Language_Albanian     = 36;
  FT_Apple_Language_Romanian     = 37;
  FT_Apple_Language_Czech        = 38;
  FT_Apple_Language_Slovak       = 39;
  FT_Apple_Language_Slovenian    = 40;
  FT_Apple_Language_Yiddish      = 41;
  FT_Apple_Language_Serbian      = 42;
  FT_Apple_Language_Macedonian   = 43;
  FT_Apple_Language_Bulgarian    = 44;
  FT_Apple_Language_Ukrainian    = 45;
  FT_Apple_Language_Byelorussian = 46;
  FT_Apple_Language_Uzbek        = 47;
  FT_Apple_Language_Kazakh       = 48;
  FT_Apple_Language_Azerbaijani  = 49;
  FT_Apple_Language_Azerbaijani2 = 50;
  FT_Apple_Language_Armenian     = 51;
  FT_Apple_Language_Georgian     = 52;
  FT_Apple_Language_Moldavian    = 53;
  FT_Apple_Language_Kirghiz      = 54;
  FT_Apple_Language_Tajiki       = 55;
  FT_Apple_Language_Turkmen      = 56;
  FT_Apple_Language_Mongolian    = 57;
  FT_Apple_Language_Mongolian2   = 58;
  FT_Apple_Language_Pashto       = 59;
  FT_Apple_Language_Kurdish      = 60;
  FT_Apple_Language_Kashmiri     = 61;
  FT_Apple_Language_Sindhi       = 62;
  FT_Apple_Language_Tibetan      = 63;
  FT_Apple_Language_Nepali       = 64;
  FT_Apple_Language_Sanskrit     = 65;
  FT_Apple_Language_Marathi      = 66;
  FT_Apple_Language_Bengali      = 67;
  FT_Apple_Language_Assamese     = 68;
  FT_Apple_Language_Gujarati     = 69;
  FT_Apple_Language_Punjabi      = 70;
  FT_Apple_Language_Oriya        = 71;
  FT_Apple_Language_Malayalam    = 72;
  FT_Apple_Language_Kannada      = 73;
  FT_Apple_Language_Tamil        = 74;
  FT_Apple_Language_Telugu       = 75;
  FT_Apple_Language_Sinhalese    = 76;
  FT_Apple_Language_Burmese      = 77;
  FT_Apple_Language_Khmer        = 78;
  FT_Apple_Language_Lao          = 79;
  FT_Apple_Language_Vietnamese   = 80;
  FT_Apple_Language_Indonesian   = 81;
  FT_Apple_Language_Tagalog      = 82;
  FT_Apple_Language_Malay        = 83;
  FT_Apple_Language_Malay2       = 84;
  FT_Apple_Language_Amharic      = 85;
  FT_Apple_Language_Tigrinya     = 86;
  FT_Apple_Language_Galla        = 87;
  FT_Apple_Language_Somali       = 88;
  FT_Apple_Language_Swahili      = 89;
  FT_Apple_Language_Ruanda       = 90;
  FT_Apple_Language_Rundi        = 91;
  FT_Apple_Language_Chewa        = 92;
  FT_Apple_Language_Malagasy     = 93;
  FT_Apple_Language_Esperanto    = 94;
  FT_Apple_Language_Welsh        = 128;
  FT_Apple_Language_Basque       = 129;
  FT_Apple_Language_Catalan      = 130;
  FT_Apple_Language_Latin        = 131;
  FT_Apple_Language_Quechua      = 132;
  FT_Apple_Language_Guarani      = 133;
  FT_Apple_Language_Aymara       = 134;
  FT_Apple_Language_Tatar        = 135;
  FT_Apple_Language_Uighur       = 136;
  FT_Apple_Language_Dzongkha     = 137;
  FT_Apple_Language_Javanese     = 138;
  FT_Apple_Language_Sundanese    = 139;

  (******************************************************************)
  (*  Microsoft Language ID numbers                                 *)
  (*                                                                *)
  FT_Windows_Language_Albanian     = $041C;
  FT_Windows_Language_Basque       = $042D;
  FT_Windows_Language_Byelorussian = $0423;
  FT_Windows_Language_Bulgarian    = $0402;
  FT_Windows_Language_Catalan      = $0403;
  FT_Windows_Language_Croatian     = $041A;
  FT_Windows_Language_Czech        = $0405;
  FT_Windows_Language_Danish       = $0406;
  FT_Windows_Language_Dutch        = $0413;
  FT_Windows_Language_Dutch2       = $0813;
  FT_Windows_Language_English      = $0409;
  FT_Windows_Language_English2     = $0809;
  FT_Windows_Language_English3     = $0C09;
  FT_Windows_Language_English4     = $1009;
  FT_Windows_Language_English5     = $1409;
  FT_Windows_Language_English6     = $1809;
  FT_Windows_Language_Estonian     = $0425;
  FT_Windows_Language_Finnish      = $040B;
  FT_Windows_Language_French       = $040C;
  FT_Windows_Language_French2      = $080C;
  FT_Windows_Language_French3      = $0C0C;
  FT_Windows_Language_French4      = $100C;
  FT_Windows_Language_French5      = $140C;
  FT_Windows_Language_German       = $0407;
  FT_Windows_Language_German2      = $0807;
  FT_Windows_Language_German3      = $0C07;
  FT_Windows_Language_German4      = $1007;
  FT_Windows_Language_German5      = $1407;
  FT_Windows_Language_Greek        = $0408;
  FT_Windows_Language_Hungarian    = $040E;
  FT_Windows_Language_Icelandic    = $040F;
  FT_Windows_Language_Italian      = $0410;
  FT_Windows_Language_Italian2     = $0810;
  FT_Windows_Language_Latvian      = $0426;
  FT_Windows_Language_Lithuanian   = $0427;
  FT_Windows_Language_Norwegian    = $0414;
  FT_Windows_Language_Norwegian    = $0814;
  FT_Windows_Language_Polish       = $0415;
  FT_Windows_Language_Portuguese   = $0416;
  FT_Windows_Language_Portuguese   = $0816;
  FT_Windows_Language_Romanian     = $0418;
  FT_Windows_Language_Russian      = $0419;
  FT_Windows_Language_Slovak       = $041B;
  FT_Windows_Language_Slovenian    = $0424;
  FT_Windows_Language_Spanish      = $040A;
  FT_Windows_Language_Spanish2     = $080A;
  FT_Windows_Language_Spanish3     = $0C0A;
  FT_Windows_Language_Swedish      = $041D;
  FT_Windows_Language_Turkish      = $041F;
  FT_Windows_Language_Ukrainian    = $0422;

implementation

uses FreeType;

  function  Find_TrueType_Apple_Name( face        : TT_Face;
                                      nameid      : integer;
                                      languageid  : integer;
                                      var strBuff : Pointer;
                                      var strLen  : integer ) : integer;
  var
    i, n : integer;

    platform : integer;
    encoding : integer;
    language : integer;
    id       : integer;
  begin
    n := TT_Get_F
  end;

end.
