/*
 *   filesrch.c
 *
 *   This file is part of the ttf2pk package.
 *
 *   Copyright 1997-1998 by
 *     Frederic Loyer <loyer@ensta.fr>
 *     Werner Lemberg <wl@gnu.org>
 */

/*
 *   Interface to the system specific TeX file search routines.
 */

#include <stddef.h>         /* for size_t */

#include "filesrch.h"
#include "newobj.h"


#ifdef HAVE_LIBKPATHSEA

#include "kpathsea/kpathsea.h"


extern char *kpathsea_version_string;

/*
 *   Initialize kpathsea library; arguments are the full name of the
 *   executable (e.g. `/usr/bin/ttf2pk.exe') and two identification strings;
 *   the former for the program itself (to have texmf.cnf constructs like
 *   `TFMFONTS.ttf2pk'), the latter for the environment (to have environment
 *   constructs like `TTF2PKMAKEPK').
 */

void
TeX_search_init(char *exec_name,
                char *program_identifier,
                char *env_identifier)
{
#ifdef OLD_KPATHSEA
  kpse_set_progname(exec_name);
#else
  kpse_set_program_name(exec_name, program_identifier);
#endif
  kpse_init_prog(env_identifier, 300, "cx", "cmr10");
}


char *
TeX_search_version(void)
{
  return kpathsea_version_string;
}


char *
TeX_search_tfm(char *name)
{
  return kpse_find_file(name, kpse_tfm_format, True);
}


char *
TeX_search_encoding_file(char *name)
{
#ifdef OLD_KPATHSEA
  return kpse_find_file(name, kpse_tex_ps_header_format, True);
#else
  return kpse_find_file(name, kpse_program_text_format, True);
#endif
}


char *
TeX_search_sfd_file(char *name)
{
#ifdef OLD_KPATHSEA
  return kpse_find_file(name, kpse_tex_ps_header_format, True);
#else
  return kpse_find_file(name, kpse_program_text_format, True);
#endif
}


char *
TeX_search_config_file(char *name)
{
#ifdef OLD_KPATHSEA
  return kpse_find_file(name, kpse_dvips_config_format, True);
#else
  return kpse_find_file(name, kpse_program_text_format, True);
#endif
}


char *
TeX_search_ttf_file(char *name)
{
#ifdef OLD_KPATHSEA
  return kpse_find_file(name, kpse_type1_format, True);
#else
  return kpse_find_file(name, kpse_truetype_format, True);
#endif
}

#endif /* HAVE_LIBKPATHSEA */


void
get_tfm_fullname(Font *fnt)
{
  size_t len = 0;


  if (fnt->fullname)
    free(fnt->fullname);

  if (fnt->outname)
    len += strlen(fnt->outname);
  if (fnt->subfont_name)
    len += strlen(fnt->subfont_name);
  if (fnt->outname_postfix)
    len += strlen(fnt->outname_postfix);
  
  fnt->fullname = (char *)mymalloc(len);
  fnt->fullname[0] = '\0';

  if (fnt->outname)
    strcat(fnt->fullname, fnt->outname);
  if (fnt->subfont_name)
    strcat(fnt->fullname, fnt->subfont_name);
  if (fnt->outname_postfix)
    strcat(fnt->fullname, fnt->outname_postfix);
}


/*
 *   This function takes the address of a pointer to a string allocated
 *   with malloc() and checks whether it has an extension.  If not, a default
 *   extension given as a second argument will be appended using first
 *   realloc() and then strcat().
 *
 *   '/', ':', and '\\' will be recognized as directory separators.
 */

void
handle_extension(char **stringp,
                 char *extension)
{
  int i, lastext = -1;


  for (i = 0; (*stringp)[i]; i++)
    if ((*stringp)[i] == '.')
      lastext = i;
    else if ((*stringp)[i] == '/' ||
             (*stringp)[i] == ':' ||
             (*stringp)[i] == '\\')
      lastext = -1;

  if (lastext == -1)
  {
    *stringp = (char *)myrealloc((void *)*stringp,
                                 strlen(*stringp) + strlen(extension) + 1);
    strcat(*stringp, extension);
  }
}


/* end */
