package netfu.types;

import netfu.types.Type;
import netfu.selectors.*;
import java.awt.*;

public class GFont extends Type {

    private String defaultFontName = "RoosterHeavy";
    
    public GFont () { }

    public void setDefaults (String[] defaults) {
	defaultFontName = defaults [0];
    }


    /**
     * Invoke a font selection frame, lets the user select
     * the actual font associated with the current object
     */
    public Selector select () {
        return new GFontSelector (defaultFontName);
    }

    /**
     * Returns a quoted font name.
     */
    public String toList () {
	return new String ("");
    }
    

}


