/* XV Thumbnail loading filter for The GIMP version 1.0
 *
 *    - Adam D. Moss - <adam@gimp.org> <adam@foxbox.org>
 *
 * Version 1.0.0 - 98/05/12
 */

/*
 * REVISION HISTORY
 *
 * 98/05/12
 * 1.00.00 - Initial release.
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libgimp/gimp.h"



/* Declare some local functions.
 */
static void   query      (void);
static void   run        (char    *name,
                          int      nparams,
                          GParam  *param,
                          int     *nreturn_vals,
                          GParam **return_vals);
static gint32 load_image (char   *filename);



GPlugInInfo PLUG_IN_INFO =
{
  NULL,    /* init_proc */
  NULL,    /* quit_proc */
  query,   /* query_proc */
  run,     /* run_proc */
};



MAIN ()


static void
query ()
{
  static GParamDef load_args[] =
  {
    { PARAM_INT32, "run_mode", "Interactive, non-interactive" },
    { PARAM_STRING, "filename", "The name of the file to load" },
    { PARAM_STRING, "raw_filename", "The name entered" },
  };
  static GParamDef load_return_vals[] =
  {
    { PARAM_IMAGE, "image", "Output image" },
  };
  static int nload_args = sizeof (load_args) / sizeof (load_args[0]);
  static int nload_return_vals = sizeof (load_return_vals) / sizeof (load_return_vals[0]);

  gimp_install_procedure ("file_xvthumb_load",
                          "loads thumbnail images generated by XV",
                          "!",
                          "Adam D. Moss",
                          "Adam D. Moss",
                          "1998",
                          "<Load>/XV Thumbnail",
			  NULL,
                          PROC_PLUG_IN,
                          nload_args, nload_return_vals,
                          load_args, load_return_vals);

  gimp_register_magic_load_handler ("file_xvthumb_load", "", "", "0,string,P7 332");
}


static void
run (char    *name,
     int      nparams,
     GParam  *param,
     int     *nreturn_vals,
     GParam **return_vals)
{
  static GParam values[2];
  GRunModeType run_mode;
  gint32 image_ID;

  run_mode = param[0].data.d_int32;

  *nreturn_vals = 2;
  *return_vals = values;
  values[0].type = PARAM_STATUS;
  values[0].data.d_status = STATUS_CALLING_ERROR;

  if (strcmp (name, "file_xvthumb_load") == 0)
    {
      image_ID = load_image (param[1].data.d_string);

      if (image_ID != -1)
        {
          values[0].data.d_status = STATUS_SUCCESS;
          values[1].type = PARAM_IMAGE;
          values[1].data.d_image = image_ID;
        }
      else
        {
          values[0].data.d_status = STATUS_EXECUTION_ERROR;
        }
    }
}


static guchar* readXVThumb(gchar *fnam, gint* w, gint* h)
{
  FILE *fp;
  gchar *P7_332 = "P7 332";
  gchar P7_buf[7];
  gchar linebuf[200];
  guchar *buf;
  gint twofivefive;
  void *ptr;

  fp = fopen (fnam, "rb");

  fread (P7_buf, 6, 1, fp);

  if (strncmp(P7_buf, P7_332, 6)!=0) return(NULL);

  /*newline*/
  fread (P7_buf, 1, 1, fp);

  do
    {
      ptr = fgets(linebuf, 199, fp);
    }
  while (ptr && linebuf[0]=='#'); /* keep throwing away comment lines */

  sscanf(linebuf, "%d %d %d\n", w, h, &twofivefive);

  if (twofivefive!=255) return(NULL);

  buf = g_malloc((*w)*(*h));

  fread(buf, (*w)*(*h), 1, fp);
  
  fclose(fp);

  return(buf);
}


static gint32
load_image (char *filename)
{
  gint32 image_ID = -1;
  gint32 layer_ID = -1;
  GDrawable *drawable = NULL;
  guchar* imdata;
  gint width, height;
  gint i;
  guchar cmap_332[768];
  GPixelRgn pixel_rgn;


  imdata = readXVThumb(filename, &width, &height);
  
  if (!imdata) /* Error loading thumbnail. */
    {
      return (-1);
    }

  /* Loaded thumbnail okay. */

  /* Generate 332 colour-cube colourmap */
  for (i=0; i<256; i++)
    {
      cmap_332[i*3+0] = (255*((i&(7<<5))>>5))/7;
      cmap_332[i*3+1] = (255*((i&(7<<2))>>2))/7;
      cmap_332[i*3+2] = (255*((i&(3<<0))>>0))/3;
    }

  image_ID = gimp_image_new (width, height, INDEXED);
  layer_ID = gimp_layer_new (image_ID, "Background",
			     width, height,
			     INDEXED_IMAGE,
			     100, NORMAL_MODE);
  gimp_image_add_layer (image_ID, layer_ID, 0);
  drawable = gimp_drawable_get (layer_ID);

  gimp_pixel_rgn_init (&pixel_rgn, drawable,
		       0, 0,
		       drawable->width, drawable->height,
		       TRUE, FALSE);
  gimp_pixel_rgn_set_rect (&pixel_rgn, imdata,
			   0, 0,
			   drawable->width, drawable->height);
  
  gimp_drawable_flush (drawable);
  gimp_drawable_detach (drawable);

  g_free(imdata);

  gimp_image_set_cmap (image_ID,
		       cmap_332,
		       256);

  gimp_displays_flush();

  return image_ID;
}

/* The End */

