/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1999 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "procedural_db.h"

#include "gimage.h"
#include "gimpimage.h"
#include "undo.h"

static ProcRecord image_add_hguide_proc;
static ProcRecord image_add_vguide_proc;
static ProcRecord image_delete_guide_proc;
static ProcRecord image_find_next_guide_proc;
static ProcRecord image_get_guide_orientation_proc;
static ProcRecord image_get_guide_position_proc;

void
register_guides_procs (void)
{
  procedural_db_register (&image_add_hguide_proc);
  procedural_db_register (&image_add_vguide_proc);
  procedural_db_register (&image_delete_guide_proc);
  procedural_db_register (&image_find_next_guide_proc);
  procedural_db_register (&image_get_guide_orientation_proc);
  procedural_db_register (&image_get_guide_position_proc);
}

static Argument *
image_add_hguide_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 offset;
  gint32 guide_ID = 0;
  Guide *guide;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  offset = args[1].value.pdb_int;
  if (offset <= 0)
    success = FALSE;

  if (success)
    {
      if (offset < gimage->height)
	{
	  guide = gimp_image_add_hguide (gimage);
	  undo_push_guide (gimage, guide);
	  guide->position = offset;
	  guide_ID = guide->guide_ID;
	}
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&image_add_hguide_proc, success);

  if (success)
    return_args[1].value.pdb_int = guide_ID;

  return return_args;
}

static ProcArg image_add_hguide_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "yposition",
    "The guide's y-offset from top of image"
  }
};

static ProcArg image_add_hguide_outargs[] =
{
  {
    PDB_INT32,
    "guide",
    "The new guide"
  }
};

static ProcRecord image_add_hguide_proc =
{
  "gimp_image_add_hguide",
  "Add a horizontal guide to an image.",
  "This procedure adds a horizontal guide to an image. It takes the input image and the y-position of the new guide as parameters. It returns the guide ID of the new guide.",
  "Adam D. Moss",
  "Adam D. Moss",
  "1998",
  PDB_INTERNAL,
  2,
  image_add_hguide_inargs,
  1,
  image_add_hguide_outargs,
  { { image_add_hguide_invoker } }
};

static Argument *
image_add_vguide_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 offset;
  gint32 guide_ID = 0;
  Guide *guide;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  offset = args[1].value.pdb_int;
  if (offset <= 0)
    success = FALSE;

  if (success)
    {
      if (offset < gimage->width)
	{
	  guide = gimp_image_add_vguide (gimage);
	  undo_push_guide (gimage, guide);
	  guide->position = offset;
	  guide_ID = guide->guide_ID;
	}
      else
	success = FALSE;
    }

  return_args = procedural_db_return_args (&image_add_vguide_proc, success);

  if (success)
    return_args[1].value.pdb_int = guide_ID;

  return return_args;
}

static ProcArg image_add_vguide_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "xposition",
    "The guide's x-offset from left of image"
  }
};

static ProcArg image_add_vguide_outargs[] =
{
  {
    PDB_INT32,
    "guide",
    "The new guide"
  }
};

static ProcRecord image_add_vguide_proc =
{
  "gimp_image_add_vguide",
  "Add a vertical guide to an image.",
  "This procedure adds a vertical guide to an image. It takes the input image and the x-position of the new guide as parameters. It returns the guide ID of the new guide.",
  "Adam D. Moss",
  "Adam D. Moss",
  "1998",
  PDB_INTERNAL,
  2,
  image_add_vguide_inargs,
  1,
  image_add_vguide_outargs,
  { { image_add_vguide_invoker } }
};

static Argument *
image_delete_guide_invoker (Argument *args)
{
  gboolean success = TRUE;
  GimpImage *gimage;
  gint32 guide;
  GList *guides;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  guide = args[1].value.pdb_int;

  if (success)
    {
      success = FALSE;
    
      guides = gimage->guides;
    
      while (guides)
	{
	  if ((((Guide *) guides->data)->guide_ID == guide) &&
	      (((Guide *) guides->data)->position >= 0))
	    {
	      GList *tmp_next;
    
	      success = TRUE;
    
	      tmp_next = guides->next;
    
	      undo_push_guide (gimage, ((Guide *) guides->data));
	      gimp_image_delete_guide (gimage, (Guide *) guides->data);
	      guides = tmp_next;
	    }
	  else
	    guides = guides->next;
	}
    }

  return procedural_db_return_args (&image_delete_guide_proc, success);
}

static ProcArg image_delete_guide_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "guide",
    "The ID of the guide to be removed"
  }
};

static ProcRecord image_delete_guide_proc =
{
  "gimp_image_delete_guide",
  "Deletes a guide from an image.",
  "This procedure takes an image and a guide ID as input and removes the specified guide from the specified image.",
  "Adam D. Moss",
  "Adam D. Moss",
  "1998",
  PDB_INTERNAL,
  2,
  image_delete_guide_inargs,
  0,
  NULL,
  { { image_delete_guide_invoker } }
};

static Argument *
image_find_next_guide_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 guide;
  gint32 next_guide = 0;
  GList *guides;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  guide = args[1].value.pdb_int;

  if (success)
    {
      guides = gimage->guides;
    
      if (guides != NULL)
	{
	  if (guide == 0) /* init - Return first guide ID in list */
	    {
	      while (guides && (((Guide *) guides->data)->position < 0))
		guides = guides->next;
    
	      if (guides) /* didn't just come to end of list */
		next_guide = ((Guide *) guides->data)->guide_ID;
	    }
	  else
	    {
	      success = FALSE;
		  
	      while (guides)
		{
		  if ((((Guide *) guides->data)->guide_ID == guide) &&
		      (((Guide *) guides->data)->position >= 0))
		    {
		      GList* tmplist;
    
		      success = TRUE;
    
		      tmplist = guides->next;
			  
		      while (tmplist && (((Guide *) tmplist->data)->position < 0))
			tmplist = tmplist->next;
    
		      if (tmplist)
			next_guide = ((Guide *) tmplist->data)->guide_ID;
		      else
			next_guide = 0;
    
		      break;
		    }
    
		  guides = guides->next;
		}
    
	    }
	}
    }

  return_args = procedural_db_return_args (&image_find_next_guide_proc, success);

  if (success)
    return_args[1].value.pdb_int = next_guide;

  return return_args;
}

static ProcArg image_find_next_guide_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "guide",
    "The ID of the current guide (0 if first invocation)"
  }
};

static ProcArg image_find_next_guide_outargs[] =
{
  {
    PDB_INT32,
    "next_guide",
    "The next guide's ID"
  }
};

static ProcRecord image_find_next_guide_proc =
{
  "gimp_image_find_next_guide",
  "Find next guide on an image.",
  "This procedure takes an image and a guide ID as input and finds the guide ID of the successor of the given guide ID in the image's guide list. If the supplied guide ID is 0, the procedure will return the first Guide. The procedure will return 0 if given the final guide ID as an argument or the image has no guides.",
  "Adam D. Moss",
  "Adam D. Moss",
  "1998",
  PDB_INTERNAL,
  2,
  image_find_next_guide_inargs,
  1,
  image_find_next_guide_outargs,
  { { image_find_next_guide_invoker } }
};

static Argument *
image_get_guide_orientation_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 guide;
  gint32 orientation = 0;
  GList *guides;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  guide = args[1].value.pdb_int;

  if (success)
    {
      guides = gimage->guides;
    
      success = FALSE;
    
      while (guides)
	{
	  if ((((Guide *) guides->data)->guide_ID == guide) &&
	      (((Guide *) guides->data)->position >= 0))
	    {
	      orientation = ((Guide *) guides->data)->orientation - 1;
	      success = TRUE;
	      break;
	    }
    
	  guides = guides->next;
	}
    }

  return_args = procedural_db_return_args (&image_get_guide_orientation_proc, success);

  if (success)
    return_args[1].value.pdb_int = orientation;

  return return_args;
}

static ProcArg image_get_guide_orientation_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "guide",
    "The guide"
  }
};

static ProcArg image_get_guide_orientation_outargs[] =
{
  {
    PDB_INT32,
    "orientation",
    "The guide's orientation: { HORIZONTAL (0), VERTICAL (1) }"
  }
};

static ProcRecord image_get_guide_orientation_proc =
{
  "gimp_image_get_guide_orientation",
  "Get orientation of a guide on an image.",
  "This procedure takes an image and a guide ID as input and returns the orientations of the guide.",
  "Adam D. Moss",
  "Adam D. Moss",
  "1998",
  PDB_INTERNAL,
  2,
  image_get_guide_orientation_inargs,
  1,
  image_get_guide_orientation_outargs,
  { { image_get_guide_orientation_invoker } }
};

static Argument *
image_get_guide_position_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 guide;
  gint32 position = 0;
  GList *guides;

  gimage = pdb_id_to_image (args[0].value.pdb_int);
  if (gimage == NULL)
    success = FALSE;

  guide = args[1].value.pdb_int;

  if (success)
    {
      guides = gimage->guides;
    
      success = FALSE;
    
      while (guides)
	{
	  if ((((Guide *) guides->data)->guide_ID == guide) &&
	      (((Guide *) guides->data)->position >= 0))
	    {
	      position = ((Guide *) guides->data)->position;
	      success = TRUE;
	      break;
	    }
    
	  guides = guides->next;
	} 
    }

  return_args = procedural_db_return_args (&image_get_guide_position_proc, success);

  if (success)
    return_args[1].value.pdb_int = position;

  return return_args;
}

static ProcArg image_get_guide_position_inargs[] =
{
  {
    PDB_IMAGE,
    "image",
    "The image"
  },
  {
    PDB_INT32,
    "guide",
    "The guide"
  }
};

static ProcArg image_get_guide_position_outargs[] =
{
  {
    PDB_INT32,
    "position",
    "The guide's position relative to top or left of image"
  }
};

static ProcRecord image_get_guide_position_proc =
{
  "gimp_image_get_guide_position",
  "Get position of a guide on an image.",
  "This procedure takes an image and a guide ID as input and returns the position of the guide relative to the top or left of the image.",
  "Adam D. Moss",
  "Adam D. Moss",
  "1998",
  PDB_INTERNAL,
  2,
  image_get_guide_position_inargs,
  1,
  image_get_guide_position_outargs,
  { { image_get_guide_position_invoker } }
};
