/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimplayer_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

gint32
_gimp_layer_new (gint32                image_ID,
		 gint                  width,
		 gint                  height,
		 GimpImageType         type,
		 gchar                *name,
		 gdouble               opacity,
		 GimpLayerModeEffects  mode)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 layer_ID = -1;

  return_vals = gimp_run_procedure ("gimp_layer_new",
				    &nreturn_vals,
				    PARAM_IMAGE, image_ID,
				    PARAM_INT32, width,
				    PARAM_INT32, height,
				    PARAM_INT32, type,
				    PARAM_STRING, name,
				    PARAM_FLOAT, opacity,
				    PARAM_INT32, mode,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    layer_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_ID;
}

gint32
_gimp_layer_copy (gint32   layer_ID,
		  gboolean add_alpha)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 layer_copy_ID = -1;

  return_vals = gimp_run_procedure ("gimp_layer_copy",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, add_alpha,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    layer_copy_ID = return_vals[1].data.d_layer;

  gimp_destroy_params (return_vals, nreturn_vals);

  return layer_copy_ID;
}

gint32
gimp_layer_create_mask (gint32          layer_ID,
			GimpAddMaskType mask_type)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 mask_ID = -1;

  return_vals = gimp_run_procedure ("gimp_layer_create_mask",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, mask_type,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    mask_ID = return_vals[1].data.d_layer_mask;

  gimp_destroy_params (return_vals, nreturn_vals);

  return mask_ID;
}

void
gimp_layer_scale (gint32   layer_ID,
		  gint     new_width,
		  gint     new_height,
		  gboolean local_origin)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_scale",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, new_width,
				    PARAM_INT32, new_height,
				    PARAM_INT32, local_origin,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_layer_resize (gint32 layer_ID,
		   gint   new_width,
		   gint   new_height,
		   gint   offx,
		   gint   offy)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_resize",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, new_width,
				    PARAM_INT32, new_height,
				    PARAM_INT32, offx,
				    PARAM_INT32, offy,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_layer_delete (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_delete",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_layer_translate (gint32 layer_ID,
		      gint   offx,
		      gint   offy)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_translate",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, offx,
				    PARAM_INT32, offy,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_layer_add_alpha (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_add_alpha",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_layer_set_offsets (gint32 layer_ID,
			gint   offx,
			gint   offy)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_offsets",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, offx,
				    PARAM_INT32, offy,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint32
gimp_layer_mask (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint32 mask_ID = -1;

  return_vals = gimp_run_procedure ("gimp_layer_mask",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    mask_ID = return_vals[1].data.d_channel;

  gimp_destroy_params (return_vals, nreturn_vals);

  return mask_ID;
}

gboolean
gimp_layer_is_floating_sel (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean is_floating_sel = FALSE;

  return_vals = gimp_run_procedure ("gimp_layer_is_floating_sel",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    is_floating_sel = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return is_floating_sel;
}

gchar *
gimp_layer_get_name (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp_layer_get_name",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

void
gimp_layer_set_name (gint32  layer_ID,
		     gchar  *name)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_name",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_STRING, name,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
gimp_layer_get_visible (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean visible = FALSE;

  return_vals = gimp_run_procedure ("gimp_layer_get_visible",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    visible = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return visible;
}

void
gimp_layer_set_visible (gint32   layer_ID,
			gboolean visible)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_visible",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, visible,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
gimp_layer_get_preserve_trans (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean preserve_trans = FALSE;

  return_vals = gimp_run_procedure ("gimp_layer_get_preserve_trans",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    preserve_trans = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return preserve_trans;
}

void
gimp_layer_set_preserve_trans (gint32   layer_ID,
			       gboolean preserve_trans)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_preserve_trans",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, preserve_trans,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
gimp_layer_get_apply_mask (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean apply_mask = FALSE;

  return_vals = gimp_run_procedure ("gimp_layer_get_apply_mask",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    apply_mask = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return apply_mask;
}

void
gimp_layer_set_apply_mask (gint32   layer_ID,
			   gboolean apply_mask)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_apply_mask",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, apply_mask,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
gimp_layer_get_show_mask (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean show_mask = FALSE;

  return_vals = gimp_run_procedure ("gimp_layer_get_show_mask",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    show_mask = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return show_mask;
}

void
gimp_layer_set_show_mask (gint32   layer_ID,
			  gboolean show_mask)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_show_mask",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, show_mask,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
gimp_layer_get_edit_mask (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean edit_mask = FALSE;

  return_vals = gimp_run_procedure ("gimp_layer_get_edit_mask",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    edit_mask = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return edit_mask;
}

void
gimp_layer_set_edit_mask (gint32   layer_ID,
			  gboolean edit_mask)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_edit_mask",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, edit_mask,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gdouble
gimp_layer_get_opacity (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gdouble opacity = 0;

  return_vals = gimp_run_procedure ("gimp_layer_get_opacity",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    opacity = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return opacity;
}

void
gimp_layer_set_opacity (gint32  layer_ID,
			gdouble opacity)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_opacity",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_FLOAT, opacity,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

GimpLayerModeEffects
gimp_layer_get_mode (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  GimpLayerModeEffects mode = 0;

  return_vals = gimp_run_procedure ("gimp_layer_get_mode",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    mode = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return mode;
}

void
gimp_layer_set_mode (gint32               layer_ID,
		     GimpLayerModeEffects mode)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_mode",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, mode,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
gimp_layer_get_linked (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean linked = FALSE;

  return_vals = gimp_run_procedure ("gimp_layer_get_linked",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    linked = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return linked;
}

void
gimp_layer_set_linked (gint32   layer_ID,
		       gboolean linked)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_linked",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, linked,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint
gimp_layer_get_tattoo (gint32 layer_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint tattoo = 0;

  return_vals = gimp_run_procedure ("gimp_layer_get_tattoo",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    tattoo = return_vals[1].data.d_tattoo;

  gimp_destroy_params (return_vals, nreturn_vals);

  return tattoo;
}

void
gimp_layer_set_tattoo (gint32 layer_ID,
		       gint   tattoo)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_layer_set_tattoo",
				    &nreturn_vals,
				    PARAM_LAYER, layer_ID,
				    PARAM_INT32, tattoo,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}
