/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpproceduraldb_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

void
gimp_procedural_db_dump (gchar *filename)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_procedural_db_dump",
				    &nreturn_vals,
				    PARAM_STRING, filename,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

void
gimp_procedural_db_query (gchar   *name,
			  gchar   *blurb,
			  gchar   *help,
			  gchar   *author,
			  gchar   *copyright,
			  gchar   *date,
			  gchar   *proc_type,
			  gint    *num_matches,
			  gchar ***proc_names)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint i;

  return_vals = gimp_run_procedure ("gimp_procedural_db_query",
				    &nreturn_vals,
				    PARAM_STRING, name,
				    PARAM_STRING, blurb,
				    PARAM_STRING, help,
				    PARAM_STRING, author,
				    PARAM_STRING, copyright,
				    PARAM_STRING, date,
				    PARAM_STRING, proc_type,
				    PARAM_END);

  *num_matches = 0;
  *proc_names = NULL;
  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *num_matches = return_vals[1].data.d_int32;
      *proc_names = g_new (gchar *, *num_matches);
      for (i = 0; i < *num_matches; i++)
	(*proc_names)[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
    }

  gimp_destroy_params (return_vals, nreturn_vals);
}

gboolean
_gimp_procedural_db_proc_info (gchar            *procedure,
			       gchar           **blurb,
			       gchar           **help,
			       gchar           **author,
			       gchar           **copyright,
			       gchar           **date,
			       GimpPDBProcType  *proc_type,
			       gint             *num_args,
			       gint             *num_values)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean success = FALSE;

  return_vals = gimp_run_procedure ("gimp_procedural_db_proc_info",
				    &nreturn_vals,
				    PARAM_STRING, procedure,
				    PARAM_END);

  success = (return_vals[0].data.d_status == STATUS_SUCCESS);

  if (success)
    {
      *blurb = g_strdup (return_vals[1].data.d_string);
      *help = g_strdup (return_vals[2].data.d_string);
      *author = g_strdup (return_vals[3].data.d_string);
      *copyright = g_strdup (return_vals[4].data.d_string);
      *date = g_strdup (return_vals[5].data.d_string);
      *proc_type = return_vals[6].data.d_int32;
      *num_args = return_vals[7].data.d_int32;
      *num_values = return_vals[8].data.d_int32;
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

gboolean
gimp_procedural_db_proc_arg (gchar           *procedure,
			     gint             arg_num,
			     GimpPDBArgType  *arg_type,
			     gchar          **arg_name,
			     gchar          **arg_desc)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean success = FALSE;

  return_vals = gimp_run_procedure ("gimp_procedural_db_proc_arg",
				    &nreturn_vals,
				    PARAM_STRING, procedure,
				    PARAM_INT32, arg_num,
				    PARAM_END);

  *arg_type = 0;
  *arg_name = NULL;
  *arg_desc = NULL;

  success = (return_vals[0].data.d_status == STATUS_SUCCESS);

  if (success)
    {
      *arg_type = return_vals[1].data.d_int32;
      *arg_name = g_strdup (return_vals[2].data.d_string);
      *arg_desc = g_strdup (return_vals[3].data.d_string);
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

gboolean
gimp_procedural_db_proc_val (gchar           *procedure,
			     gint             val_num,
			     GimpPDBArgType  *val_type,
			     gchar          **val_name,
			     gchar          **val_desc)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean success = FALSE;

  return_vals = gimp_run_procedure ("gimp_procedural_db_proc_val",
				    &nreturn_vals,
				    PARAM_STRING, procedure,
				    PARAM_INT32, val_num,
				    PARAM_END);

  *val_type = 0;
  *val_name = NULL;
  *val_desc = NULL;

  success = (return_vals[0].data.d_status == STATUS_SUCCESS);

  if (success)
    {
      *val_type = return_vals[1].data.d_int32;
      *val_name = g_strdup (return_vals[2].data.d_string);
      *val_desc = g_strdup (return_vals[3].data.d_string);
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

void
_gimp_procedural_db_get_data (gchar   *identifier,
			      gint    *bytes,
			      guint8 **data)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_procedural_db_get_data",
				    &nreturn_vals,
				    PARAM_STRING, identifier,
				    PARAM_END);

  *bytes = 0;
  *data = NULL;
  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    {
      *bytes = return_vals[1].data.d_int32;
      *data = g_new (guint8, *bytes);
      memcpy (*data, return_vals[2].data.d_int8array,
	      *bytes * sizeof (guint8));
    }

  gimp_destroy_params (return_vals, nreturn_vals);
}

gint
gimp_procedural_db_get_data_size (gchar *identifier)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint bytes = 0;

  return_vals = gimp_run_procedure ("gimp_procedural_db_get_data_size",
				    &nreturn_vals,
				    PARAM_STRING, identifier,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    bytes = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return bytes;
}

void
_gimp_procedural_db_set_data (gchar  *identifier,
			      gint    bytes,
			      guint8 *data)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_procedural_db_set_data",
				    &nreturn_vals,
				    PARAM_STRING, identifier,
				    PARAM_INT32, bytes,
				    PARAM_INT8ARRAY, data,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}
