/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpunit_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"


gint
_gimp_unit_get_number_of_units (void)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint num_units = GIMP_UNIT_END;

  return_vals = gimp_run_procedure ("gimp_unit_get_number_of_units",
				    &nreturn_vals,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    num_units = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return num_units;
}

gint
_gimp_unit_get_number_of_built_in_units (void)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint num_units = GIMP_UNIT_END;

  return_vals = gimp_run_procedure ("gimp_unit_get_number_of_built_in_units",
                                    &nreturn_vals,
                                    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    num_units = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return num_units;
}

GimpUnit
_gimp_unit_new (gchar   *identifier,
		gdouble  factor,
		gint     digits,
		gchar   *symbol,
		gchar   *abbreviation,
		gchar   *singular,
		gchar   *plural)
{
  GParam *return_vals;
  gint nreturn_vals;
  GimpUnit unit_ID = GIMP_UNIT_INCH;

  return_vals = gimp_run_procedure ("gimp_unit_new",
				    &nreturn_vals,
				    PARAM_STRING, identifier,
				    PARAM_FLOAT, factor,
				    PARAM_INT32, digits,
				    PARAM_STRING, symbol,
				    PARAM_STRING, abbreviation,
				    PARAM_STRING, singular,
				    PARAM_STRING, plural,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    unit_ID = return_vals[1].data.d_unit;

  gimp_destroy_params (return_vals, nreturn_vals);

  return unit_ID;
}

gboolean
_gimp_unit_get_deletion_flag (GimpUnit unit_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gboolean deletion_flag = TRUE;

  return_vals = gimp_run_procedure ("gimp_unit_get_deletion_flag",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    deletion_flag = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return deletion_flag;
}

void
_gimp_unit_set_deletion_flag (GimpUnit unit_ID,
			      gboolean deletion_flag)
{
  GParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_unit_set_deletion_flag",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_INT32, deletion_flag,
				    PARAM_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gchar *
_gimp_unit_get_identifier (GimpUnit unit_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *identifier = NULL;

  return_vals = gimp_run_procedure ("gimp_unit_get_identifier",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    identifier = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return identifier;
}

gdouble
_gimp_unit_get_factor (GimpUnit unit_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gdouble factor = 1.0;

  return_vals = gimp_run_procedure ("gimp_unit_get_factor",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    factor = return_vals[1].data.d_float;

  gimp_destroy_params (return_vals, nreturn_vals);

  return factor;
}

gint
_gimp_unit_get_digits (GimpUnit unit_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gint digits = 2;

  return_vals = gimp_run_procedure ("gimp_unit_get_digits",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    digits = return_vals[1].data.d_int32;

  gimp_destroy_params (return_vals, nreturn_vals);

  return digits;
}

gchar *
_gimp_unit_get_symbol (GimpUnit unit_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *symbol = NULL;

  return_vals = gimp_run_procedure ("gimp_unit_get_symbol",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    symbol = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return symbol;
}

gchar *
_gimp_unit_get_abbreviation (GimpUnit unit_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *abbreviation = NULL;

  return_vals = gimp_run_procedure ("gimp_unit_get_abbreviation",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    abbreviation = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return abbreviation;
}

gchar *
_gimp_unit_get_singular (GimpUnit unit_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *singular = NULL;

  return_vals = gimp_run_procedure ("gimp_unit_get_singular",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    singular = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return singular;
}

gchar *
_gimp_unit_get_plural (GimpUnit unit_ID)
{
  GParam *return_vals;
  gint nreturn_vals;
  gchar *plural = NULL;

  return_vals = gimp_run_procedure ("gimp_unit_get_plural",
				    &nreturn_vals,
				    PARAM_INT32, unit_ID,
				    PARAM_END);

  if (return_vals[0].data.d_status == STATUS_SUCCESS)
    plural = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return plural;
}
