/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpgradients_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "gimp.h"

gchar **
gimp_gradients_get_list (gint *num_gradients)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar **gradient_names = NULL;
  gint i;

  return_vals = gimp_run_procedure ("gimp_gradients_get_list",
				    &nreturn_vals,
				    GIMP_PDB_END);

  *num_gradients = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_gradients = return_vals[1].data.d_int32;
      gradient_names = g_new (gchar *, *num_gradients);
      for (i = 0; i < *num_gradients; i++)
	gradient_names[i] = g_strdup (return_vals[2].data.d_stringarray[i]);
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return gradient_names;
}

gchar *
gimp_gradients_get_active (void)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gchar *name = NULL;

  return_vals = gimp_run_procedure ("gimp_gradients_get_active",
				    &nreturn_vals,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    name = g_strdup (return_vals[1].data.d_string);

  gimp_destroy_params (return_vals, nreturn_vals);

  return name;
}

void
gimp_gradients_set_active (gchar *name)
{
  GimpParam *return_vals;
  gint nreturn_vals;

  return_vals = gimp_run_procedure ("gimp_gradients_set_active",
				    &nreturn_vals,
				    GIMP_PDB_STRING, name,
				    GIMP_PDB_END);

  gimp_destroy_params (return_vals, nreturn_vals);
}

gdouble *
gimp_gradients_sample_uniform (gint num_samples)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble *color_samples = NULL;
  gint num_color_samples;

  return_vals = gimp_run_procedure ("gimp_gradients_sample_uniform",
				    &nreturn_vals,
				    GIMP_PDB_INT32, num_samples,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      num_color_samples = return_vals[1].data.d_int32;
      color_samples = g_new (gdouble, num_color_samples);
      memcpy (color_samples, return_vals[2].data.d_floatarray,
	      num_color_samples * sizeof (gdouble));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return color_samples;
}

gdouble *
gimp_gradients_sample_custom (gint     num_samples,
			      gdouble *positions)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gdouble *color_samples = NULL;
  gint num_color_samples;

  return_vals = gimp_run_procedure ("gimp_gradients_sample_custom",
				    &nreturn_vals,
				    GIMP_PDB_INT32, num_samples,
				    GIMP_PDB_FLOATARRAY, positions,
				    GIMP_PDB_END);

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      num_color_samples = return_vals[1].data.d_int32;
      color_samples = g_new (gdouble, num_color_samples);
      memcpy (color_samples, return_vals[2].data.d_floatarray,
	      num_color_samples * sizeof (gdouble));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return color_samples;
}
