#!/usr/bin/perl -w

# The GIMP -- an image manipulation program
# Copyright (C) 1999-2000 Manish Singh <yosh@gimp.org>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUTFILE ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# This file would be included in enumcode.pl, but plug-ins/pygimp isn't
# currently in the distribution, so keep it seperate for now.

BEGIN {
    $srcdir  = $ENV{srcdir}  || '.';
    $destdir = $ENV{destdir} || '.';
}

use lib $srcdir;

require 'enums.pl';
require 'util.pl';

*enums = \%Gimp::CodeGen::enums::enums;

*write_file = \&Gimp::CodeGen::util::write_file;
*FILE_EXT   = \$Gimp::CodeGen::util::FILE_EXT;

my $enumfile = "$destdir/plug-ins/pygimp/gimpenums.py$FILE_EXT";
open ENUMFILE, "> $enumfile" or die "Can't open $enumfile: $!\n";

print ENUMFILE <<'GPL';
#   Gimp-Python - allows the writing of Gimp plugins in Python.
#   Copyright (C) 1997  James Henstridge <james@daa.com.au>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# gimpenums.py -- constants for use with the gimp module
#
# this file contains constants that are useful for use in
# gimp plugins.  Just add 'from gimpenums import *' to the top
# of the script

# NOTE: This file is autogenerated by enumcode-py.pl.

GPL

print ENUMFILE <<'CODE';
# TRUE and FALSE constants ...
import __builtin__
if not hasattr(__builtin__, 'True'):
    __builtin__.True = (1 == 1)
    __builtin__.False = (1 != 1)
del __builtin__

FALSE = False
TRUE = True
CODE

foreach (sort keys %enums) {
    my $enum = $enums{$_}; my $body = ""; my $i=0;
    $body .= "\n# ";
    $body .= "Gimp" if !/^Gimp/;
    $body .= "$_\n";    
    foreach $symbol (@{$enum->{symbols}}) {
	my $sym = $symbol; 
	# Maybe Python has nice enough namespace handling that we don't
	# need to prefix all constants with GIMP_
	$sym =~ s/^GIMP\_//;
	$body .= "$sym";
	if (!$enum->{contig}) {
	  $i = $enum->{mapping}->{$symbol};
	}

	$body .= " = $i\n";	

	$i++ if($enum->{contig});
      }
    print ENUMFILE $body;
}

print ENUMFILE "\n";

close ENUMFILE;
&write_file($enumfile);
