/**********************************************************************
 *  AlienMap2 (Co-)sine color transformation plug-in (Version 1.01)
 *  Martin Weber (martweb@gmx.net)
 **********************************************************************
 *  Most code taken from AlienMap by Daniel Cotting
 *  This is not a replacement for AlienMap!
 **********************************************************************    
 */

/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#ifdef __GNUC__
#warning GTK_DISABLE_DEPRECATED
#endif
#undef GTK_DISABLE_DEPRECATED

#include <gtk/gtk.h>

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "libgimp/stdplugins-intl.h"


static unsigned int logo_width = 200;
static unsigned int logo_height = 72;

#define HEADER_PIXEL(data,pixel) \
  pixel[0] = palette_data[data[0]*3+2]; \
  pixel[1] = palette_data[data[0]*3+1]; \
  pixel[2] = palette_data[data[0]*3+0]; \
  data--;

static unsigned char 
palette_data[]  =  { 4,2,2,4,110,178,32,4,122,4,36,
86,15,3,66,4,58,127,36,8,186,4,34,122,17,2,
34,4,19,66,12,4,162,90,2,69,88,2,48,7,20,
2,25,2,103,8,14,48,4,58,186,90,3,154,82,2,
129,55,2,34,17,2,18,17,34,191,94,2,101,57,2,
70,7,32,154,12,22,157,17,3,50,4,88,150,96,3,
186,86,2,138,87,2,86,212,214,210,4,19,98,52,2,
154,15,11,2,4,132,216,7,18,125,12,6,82,37,12,
18,4,88,189,86,14,48,128,2,157,32,4,138,4,60,
155,4,48,126,60,2,218,7,10,52,13,12,66,129,2,
50,56,2,52,52,14,98,4,47,157,6,20,87,48,2,
24,58,2,101,120,2,141,52,5,170,4,113,215,127,2,
73,4,90,210,4,52,112,36,18,194,59,2,85,42,2,
10,107,2,173,95,2,114,31,3,52,4,79,160,84,3,
189,14,10,40,30,2,69,96,2,58,113,2,126,9,37,
231,17,33,170,28,14,2,4,30,146,68,10,37,132,2,
82,23,4,7,4,10,122,4,36,108,32,2,37,7,27,
2,4,98,175,84,10,146,4,101,191,4,14,146,8,29,
86,4,2,170,8,60,230,84,10,162,72,2,39,102,2,
142,4,142,221,4,49,143,68,12,170,4,124,213,15,4,
74,114,2,69,112,2,158,32,3,23,8,50,190,111,2,
104,6,40,154,96,2,210,6,28,104,60,2,138,61,2,
25,68,2,114,58,2,125,39,2,114,73,2,69,16,4,
58,4,88,177,56,14,26,138,2,173,4,68,176,71,2,
55,76,2,210,4,78,130,17,3,42,6,27,69,112,2,
49,12,26,178,47,13,159,18,11,10,13,11,74,141,2,
58,52,18,234,4,82,186,4,126,198,4,103,213,4,62,
206,4,72,226,12,46,210,72,12,222,12,26,146,20,34,
210,4,113,197,4,131,229,4,48,170,4,76,170,7,43,
95,52,30,218,15,11,170,52,14,202,12,14,86,4,40,
174,108,14,202,156,2,186,60,12,130,5,40,129,73,13,
189,12,42,138,44,14,202,4,59,143,4,124,229,4,69,
191,4,69,157,4,60,114,4,43,110,14,14,58,20,26,
157,28,26,210,4,87,162,4,91,202,4,110,226,4,98,
226,4,101,202,17,14,186,28,18,18,60,2,234,28,10,
114,4,30,114,8,10,162,12,54,186,20,26,130,100,10,
170,40,18,154,4,22,114,28,26,234,4,22,58,4,66,
226,4,54,202,12,42,202,4,38,98,4,145,234,4,76,
146,4,94,148,4,138,213,4,94,186,4,54,126,4,54,
154,4,118,211,4,106,178,4,106,188,4,54,142,4,94,
170,4,70,202,4,118,197,4,54,173,4,82,178,72,4,
172,36,10,138,76,14,162,4,98,210,4,118,226,112,2,
114,24,19,8,30,2,85,84,6,226,141,2,73,28,30,
10,28,46,186,112,4,206,36,10,90,36,2,174,108,2,
58,41,3,130,44,10,194,9,33,130,92,2,162,51,2,
42,12,32,162,81,3,146,44,11,26,28,6,146,44,2,
178,30,12,10,60,10,178,64,2,146,28,10,178,92,10,
210,5,41,146,40,2,102,96,2,125,100,2,88,74,2,
157,142,2,159,26,10,55,143,2,50,73,2,102,134,2,
142,73,2,84,127,2,126,142,2,82,156,2,178,28,10,
158,28,26,114,84,14,202,12,4,10,5,20,74,17,2,
26,92,2,194,7,19,106};

static unsigned char header_data[] = { 71,99,218,218,99,11,71,218,71,71,
218,99,99,99,71,99,218,99,99,99,99,218,71,218,99,218,218,99,99,218,
218,99,99,218,99,218,99,58,218,99,99,99,58,218,99,99,99,58,99,58,
99,58,11,58,99,58,58,11,99,58,99,58,99,99,99,218,99,218,99,58,
99,71,99,218,71,12,12,12,12,12,12,12,12,12,92,19,19,19,92,92,
92,92,19,108,19,19,19,19,19,19,53,53,53,53,101,19,19,53,53,19,
19,19,12,92,92,12,12,12,71,71,218,99,218,218,71,71,12,12,218,99,
58,58,58,99,99,99,58,99,99,99,11,58,11,58,58,99,58,99,99,99,
58,99,99,99,99,58,99,99,99,99,99,218,99,99,11,99,99,99,11,99,
99,218,218,218,99,218,99,99,218,218,99,99,218,99,218,218,99,99,218,11,
218,71,99,218,99,218,218,99,71,8,218,99,218,218,99,99,99,99,99,99,
218,218,99,99,218,99,218,99,218,71,99,99,99,218,99,99,218,99,99,99,
218,218,99,99,99,99,58,99,58,30,99,99,99,99,99,99,58,99,99,58,
99,58,99,58,99,99,58,58,58,99,58,58,99,218,218,71,99,99,71,71,
71,123,12,118,71,71,12,71,123,12,12,19,19,19,53,19,19,53,53,19,
19,53,101,63,20,63,20,63,53,53,53,101,53,53,53,19,53,53,53,19,
92,12,12,12,71,12,12,12,12,12,92,71,218,218,71,218,71,71,71,71,
99,218,58,58,58,99,99,99,99,58,58,58,99,58,99,58,58,99,58,58,
99,99,58,99,99,99,99,58,99,58,30,99,99,99,218,99,58,99,99,58,
11,99,99,218,99,218,218,99,99,218,71,99,218,99,99,218,99,99,218,99,
11,218,99,218,99,11,218,99,99,8,71,71,71,99,218,71,218,99,71,218,
11,99,218,218,99,218,99,218,99,99,99,99,218,99,99,99,99,99,218,99,
99,99,99,99,99,11,99,99,99,99,99,99,58,99,58,99,58,99,58,58,
99,11,58,58,99,58,99,99,58,58,218,99,123,71,71,71,123,71,71,218,
99,99,218,71,12,12,12,12,92,19,19,53,19,53,53,53,53,19,53,53,
53,53,19,53,19,53,53,53,53,53,63,63,101,63,63,20,53,19,53,53,
53,19,92,92,12,12,12,71,71,71,71,12,12,71,71,12,12,12,12,12,
12,218,218,99,58,58,99,58,99,58,99,58,99,99,58,218,58,99,58,99,
99,99,99,11,58,99,99,58,99,99,58,58,99,99,99,99,99,99,99,99,
99,58,218,99,218,99,99,99,218,99,99,218,99,11,218,99,218,218,99,99,
218,99,218,11,99,71,99,218,71,8,99,99,218,99,99,99,218,99,99,218,
218,99,11,99,99,218,99,218,99,218,218,99,58,99,99,99,58,11,99,99,
58,99,99,58,58,58,58,99,99,99,99,218,58,99,99,99,58,58,99,99,
58,58,99,58,99,58,99,99,58,58,99,218,71,71,218,218,218,58,58,58,
218,99,71,123,12,12,12,19,19,108,108,108,92,92,92,12,71,12,12,92,
19,53,53,53,101,53,53,19,53,101,53,20,53,79,79,0,34,79,20,63,
53,53,53,19,19,19,12,12,12,71,71,71,71,71,71,123,71,12,12,12,
12,12,71,71,218,58,99,58,218,58,218,99,58,99,58,99,99,218,58,58,
58,99,58,58,99,99,58,99,58,99,99,218,58,58,99,99,99,99,99,99,
58,11,99,99,218,218,218,99,218,99,99,218,218,99,218,99,99,218,218,99,
218,99,71,218,99,218,99,99,99,8,218,218,99,218,99,218,99,218,218,99,
11,218,218,218,218,99,71,99,218,99,99,99,218,58,99,99,99,99,218,30,
58,99,58,99,58,11,58,99,58,99,58,58,58,99,58,58,99,99,58,58,
58,99,58,99,58,58,99,58,218,99,99,218,58,99,58,58,58,58,58,218,
71,12,12,71,71,12,12,12,12,71,71,118,71,71,118,71,71,12,223,19,
19,53,53,53,53,63,229,20,79,20,34,0,20,101,101,63,20,101,101,53,
108,53,53,53,53,53,101,19,92,12,12,12,12,71,71,218,218,218,71,71,
118,12,71,71,218,218,58,58,58,58,58,58,218,58,58,58,99,99,218,99,
58,58,99,99,58,99,58,99,58,58,58,99,99,99,58,99,99,99,58,58,
99,58,58,99,99,99,99,99,99,99,218,99,99,218,99,218,218,99,99,218,
99,58,99,99,218,99,218,218,218,8,99,218,99,218,99,218,11,99,218,99,
99,99,99,99,218,99,58,99,99,99,58,99,218,99,99,99,99,99,58,99,
58,218,99,99,99,58,218,58,58,58,99,99,58,99,218,58,99,99,58,218,
58,99,58,99,99,99,58,99,58,58,58,58,99,58,58,58,58,218,218,12,
71,71,71,12,12,71,71,12,71,12,71,71,71,71,12,92,19,53,53,53,
101,63,79,34,251,0,0,63,20,53,19,53,53,53,53,19,19,53,19,19,
19,108,19,19,19,19,19,19,53,53,108,12,12,12,71,71,218,58,58,58,
99,218,71,71,71,12,218,99,99,58,58,58,58,218,58,58,58,58,58,99,
99,58,58,99,58,218,58,99,99,99,99,58,99,128,99,58,99,99,11,99,
99,58,11,58,99,99,99,218,58,11,99,58,99,218,99,99,218,99,99,99,
218,71,99,99,218,99,11,99,218,8,218,99,218,99,218,99,99,218,99,218,
58,218,58,218,99,99,218,99,58,99,99,99,99,78,11,58,99,58,99,99,
99,58,58,99,58,11,58,58,218,99,99,58,58,58,99,58,58,58,99,99,
58,58,58,58,58,58,99,58,99,99,99,58,58,58,58,58,218,71,118,12,
71,71,71,71,71,12,71,71,71,71,71,12,92,19,19,53,53,63,20,251,
0,79,79,0,79,34,34,79,0,63,229,20,63,101,53,101,19,53,19,92,
12,71,12,92,12,12,12,12,12,92,19,92,92,71,12,118,71,218,99,58,
58,58,58,58,218,123,71,218,58,58,58,99,58,58,58,218,58,218,58,58,
218,58,99,58,58,58,99,99,58,99,58,99,218,99,99,99,58,58,58,11,
58,58,99,58,99,99,30,99,99,99,58,218,218,30,99,218,99,99,99,218,
99,99,218,218,99,99,218,71,99,8,99,99,71,99,218,218,99,218,99,218,
99,218,99,58,11,58,99,99,11,58,99,58,99,99,99,99,58,58,99,99,
58,99,99,99,99,58,99,78,58,58,99,99,218,78,58,218,58,99,212,58,
99,58,58,58,218,58,58,58,58,58,58,58,58,58,218,71,12,12,71,71,
123,218,218,58,99,71,123,71,71,12,19,19,19,53,53,19,19,53,63,53,
101,101,101,63,101,101,20,20,79,0,0,79,79,34,251,79,79,251,101,53,
19,92,12,71,71,71,218,12,218,12,71,71,71,71,71,12,71,71,123,71,
58,58,58,58,58,58,58,99,99,58,58,58,99,58,58,58,99,58,99,58,
99,58,58,99,58,58,58,58,99,58,99,58,99,58,99,58,99,99,58,58,
99,99,99,58,99,58,58,58,99,99,99,30,128,58,99,99,99,99,99,58,
218,99,99,218,218,99,99,218,71,8,71,218,99,99,99,99,218,99,99,99,
99,30,58,11,58,58,99,58,58,58,58,30,58,58,99,99,99,58,99,58,
99,58,99,58,58,58,218,99,58,99,58,58,58,218,99,58,58,58,58,58,
58,99,99,99,58,99,99,58,58,212,99,58,58,218,71,71,218,218,99,58,
58,58,58,218,123,71,71,12,108,19,19,108,19,19,223,92,19,92,12,12,
19,19,19,19,53,53,63,63,229,0,34,34,79,0,79,0,75,34,0,34,
79,20,53,19,92,12,71,71,71,218,71,123,71,123,71,71,71,71,71,71,
71,218,58,58,58,58,58,58,58,99,58,58,58,58,58,58,58,58,99,58,
58,99,99,58,99,58,58,58,58,58,58,99,58,99,58,99,58,58,99,99,
58,58,99,99,58,58,218,58,58,99,58,99,11,58,58,99,58,218,99,99,
99,99,218,99,99,218,99,99,99,8,99,218,99,218,99,99,99,99,58,58,
11,58,99,58,58,30,58,11,58,11,58,99,99,58,99,58,58,58,99,58,
58,99,58,99,99,58,58,99,58,99,58,99,58,99,212,58,58,58,58,58,
58,58,58,58,58,58,58,58,58,58,212,58,218,218,218,99,58,58,58,58,
58,99,71,71,71,12,71,71,12,12,12,71,71,123,71,218,71,71,71,92,
19,108,63,79,229,126,0,79,0,0,34,34,34,126,34,251,79,0,126,34,
79,0,79,20,63,19,19,12,71,71,71,218,71,99,71,71,71,71,71,71,
71,71,218,58,58,58,212,58,58,58,58,58,58,58,58,58,58,58,58,58,
58,58,99,58,58,99,58,58,99,99,128,218,58,58,99,58,99,58,58,99,
218,58,58,218,99,99,99,99,99,99,58,99,99,58,30,218,99,99,99,99,
99,99,218,99,99,99,218,218,99,8,218,99,99,99,58,99,99,99,99,99,
58,58,218,99,99,99,58,99,58,58,58,99,58,99,58,99,99,99,58,58,
99,99,58,58,58,58,58,58,99,99,58,99,99,58,58,58,58,99,58,58,
99,58,99,58,78,212,99,212,99,58,58,99,58,58,78,78,246,99,212,58,
99,71,123,71,71,71,71,71,218,218,71,123,218,218,218,118,12,19,63,63,
0,0,0,34,34,0,34,79,79,79,0,34,79,79,20,101,53,101,53,19,
53,53,101,101,53,53,19,19,19,92,218,218,218,218,218,212,78,58,218,218,
71,71,71,11,58,246,58,78,246,58,58,58,99,99,58,58,99,58,212,58,
99,58,99,58,58,99,58,58,58,58,58,212,218,58,58,99,58,58,99,58,
99,99,99,58,58,99,99,99,58,99,58,58,99,99,99,58,58,99,99,99,
99,99,99,11,58,99,99,99,218,8,99,99,218,99,99,218,99,218,58,58,
11,78,58,99,58,99,58,99,58,11,58,99,58,99,58,58,58,99,99,58,
99,99,99,58,58,58,58,58,58,58,58,58,58,58,58,212,99,58,212,99,
58,58,78,58,78,58,58,58,58,58,58,58,58,58,246,58,246,58,58,71,
218,71,71,71,218,71,71,71,71,218,218,71,71,92,92,53,63,126,79,0,
0,79,0,79,34,79,0,126,79,79,79,79,79,229,229,101,53,108,92,71,
71,71,71,71,71,12,12,19,108,19,92,71,71,71,71,218,212,246,78,58,
58,218,218,71,71,58,58,212,212,78,212,78,78,58,58,58,58,58,99,58,
78,58,58,99,58,58,58,58,58,58,58,58,99,58,99,58,58,212,99,58,
58,99,58,99,58,99,99,58,58,99,99,58,58,58,58,11,78,99,99,99,
99,58,99,58,71,99,99,99,99,8,99,99,99,218,99,58,99,30,58,11,
58,11,58,58,99,58,58,99,58,99,58,99,99,58,99,58,99,58,58,99,
58,58,58,58,58,78,58,99,58,99,58,58,58,58,99,58,212,99,58,58,
58,78,78,78,58,58,58,58,58,212,58,78,58,78,78,78,58,99,218,218,
71,218,218,71,58,99,58,99,71,71,71,12,19,20,79,251,0,251,79,251,
79,63,126,79,79,79,79,229,79,79,79,126,126,79,79,63,20,53,53,92,
12,12,218,71,71,218,218,218,71,218,71,71,71,218,71,218,218,58,246,246,
78,212,78,58,218,218,58,58,58,246,78,212,78,212,58,58,58,58,58,212,
78,78,78,58,58,99,58,58,58,58,58,58,58,58,58,218,99,99,58,99,
58,58,218,99,58,58,99,58,99,99,58,99,99,99,58,99,99,58,58,58,
218,99,11,58,99,99,99,218,99,8,99,30,218,58,11,99,99,58,99,58,
99,58,58,99,218,99,218,58,99,99,58,58,58,58,99,58,99,99,58,99,
58,58,58,78,78,58,58,58,58,58,99,246,78,78,58,58,58,58,58,78,
78,212,78,246,246,58,58,58,212,58,212,246,78,246,58,212,218,218,218,218,
218,58,246,58,246,58,218,218,123,12,19,19,53,53,101,53,63,101,63,63,
63,63,63,63,63,101,63,53,63,53,53,53,53,108,19,19,19,19,108,19,
92,92,12,12,71,71,218,99,99,218,218,218,218,218,71,71,71,218,218,246,
78,78,246,78,78,78,58,58,58,78,78,78,78,246,58,58,58,58,58,78,
212,78,78,58,58,58,58,99,58,58,58,58,58,58,99,58,58,58,58,58,
58,99,58,58,99,58,58,58,58,58,58,99,58,58,58,58,58,99,99,99,
58,99,58,99,99,58,99,99,99,8,99,99,30,58,58,58,58,58,58,99,
58,11,99,58,99,58,58,58,58,58,58,99,58,58,58,58,58,58,99,58,
99,58,78,58,58,58,99,58,58,78,246,78,58,78,58,58,58,58,78,212,
246,78,246,78,78,99,212,246,78,246,58,246,246,78,246,218,218,218,58,58,
246,78,78,246,58,218,218,71,12,12,108,92,108,19,108,53,63,63,63,53,
53,53,19,223,92,92,49,118,118,118,118,118,118,118,71,118,118,12,12,12,
92,71,71,123,218,99,11,58,58,58,58,78,58,99,99,123,71,218,218,218,
246,246,78,212,78,212,78,246,78,78,58,78,246,78,246,78,58,58,58,58,
99,78,246,78,246,99,58,58,58,58,58,78,78,78,78,99,58,99,58,99,
78,58,58,99,58,218,218,58,58,99,58,58,58,218,99,58,58,58,58,11,
58,99,99,99,58,99,99,218,58,8,99,99,58,99,58,11,58,11,58,58,
99,58,99,58,99,58,99,58,58,218,58,58,58,99,58,99,58,58,58,99,
78,58,58,58,99,58,58,78,78,58,246,78,246,99,58,58,58,212,78,78,
246,58,246,58,78,78,78,58,246,78,78,58,246,58,58,58,212,58,246,78,
212,246,58,58,71,71,71,71,12,92,92,92,108,53,53,53,19,19,223,223,
49,223,92,49,49,223,92,49,118,118,118,71,118,112,118,11,11,112,71,112,
71,71,11,11,11,99,99,58,58,78,78,78,246,78,246,58,99,71,218,71,
218,78,78,246,78,246,58,246,78,246,212,58,246,58,246,78,212,78,246,58,
58,58,78,246,246,78,78,99,58,58,58,212,78,58,78,58,58,58,58,58,
78,58,78,99,58,58,99,58,58,58,58,99,58,58,99,218,58,99,58,58,
58,58,99,58,99,99,58,99,99,8,99,99,58,58,58,99,58,99,99,58,
99,58,58,58,58,58,58,218,99,58,99,58,58,58,58,58,99,58,58,78,
58,78,78,78,78,58,78,58,78,78,78,212,78,58,78,58,78,212,78,246,
78,246,78,78,212,246,246,78,246,212,246,246,78,246,58,246,78,246,58,246,
246,58,99,218,218,218,71,12,92,19,19,19,19,19,223,223,49,223,49,118,
49,112,30,30,237,103,208,208,245,208,245,208,245,245,245,103,208,103,22,237,
30,30,11,11,11,11,71,71,11,99,58,78,78,246,58,246,246,246,58,99,
99,218,212,78,246,78,246,78,246,58,78,58,246,78,58,246,78,212,78,246,
58,212,58,78,78,212,78,78,58,58,99,78,78,78,78,78,58,58,99,58,
58,78,78,78,58,58,99,58,99,58,58,99,58,218,58,58,99,58,58,218,
99,58,99,99,58,99,30,99,99,8,58,99,58,99,58,58,58,99,58,99,
58,218,218,58,99,58,99,58,58,58,78,99,78,58,99,58,58,78,58,78,
78,58,78,78,58,78,78,246,246,212,78,78,78,58,78,246,78,246,58,246,
212,78,58,78,78,58,246,78,78,78,58,246,78,246,78,58,246,78,78,78,
58,218,99,11,71,12,92,92,92,223,223,223,223,223,49,118,112,22,237,208,
72,245,55,243,245,72,72,72,65,208,236,208,208,245,72,55,243,55,55,243,
245,245,245,103,237,237,30,11,11,112,71,11,99,58,78,246,246,246,246,78,
58,218,58,58,246,78,212,78,246,78,246,78,212,78,78,212,78,246,78,78,
58,78,78,78,78,78,246,246,246,58,58,78,58,246,78,212,78,78,99,58,
58,78,58,58,58,58,58,99,58,58,58,58,78,58,58,99,99,58,58,58,
99,218,58,99,99,99,58,99,58,8,99,99,99,58,11,58,58,58,99,58,
58,58,58,58,58,58,58,99,99,78,78,58,58,78,58,58,99,78,78,78,
78,78,78,78,78,78,212,246,246,246,246,78,78,246,246,58,246,78,246,78,
78,78,212,246,246,246,78,78,212,246,246,246,58,246,246,78,246,246,78,58,
218,99,71,12,12,92,92,82,223,49,223,118,112,22,208,72,72,208,65,22,
22,112,11,112,112,112,112,112,118,118,118,112,112,112,30,244,244,30,237,65,
236,72,55,55,243,243,208,208,237,237,11,71,11,11,71,11,99,58,246,246,
246,78,78,246,58,246,78,246,58,246,58,246,58,246,246,78,78,78,212,78,
212,246,212,78,246,246,58,78,78,246,99,246,246,58,246,58,78,78,78,58,
78,78,78,78,78,78,58,58,58,99,58,58,78,99,58,58,58,218,99,99,
58,58,99,58,99,58,58,99,99,8,58,58,99,58,99,218,99,58,99,99,
99,58,99,58,99,58,58,58,58,78,58,58,58,58,58,58,58,78,212,78,
78,58,246,78,58,246,246,246,246,246,246,246,78,58,246,78,246,58,246,58,
246,78,78,78,58,246,212,78,78,78,58,246,78,212,246,58,78,212,58,99,
218,71,12,92,19,223,49,49,118,62,30,22,208,208,103,30,244,112,244,118,
112,23,49,49,49,49,49,49,49,49,82,82,223,82,49,118,23,118,118,112,
11,30,237,22,65,245,55,243,245,245,103,237,237,11,71,11,71,71,218,58,
246,246,78,246,78,212,78,246,246,78,246,246,78,78,212,78,212,78,246,78,
78,58,246,78,58,246,78,212,78,246,78,78,78,78,78,212,246,246,246,78,
58,78,78,78,58,78,78,58,58,58,58,58,99,58,58,58,58,58,99,58,
58,58,58,58,58,99,99,58,58,8,99,99,58,58,58,99,99,99,99,58,
58,99,78,58,78,99,58,58,99,78,78,78,58,78,58,58,78,246,78,212,
78,78,58,78,246,246,246,246,246,246,58,78,78,246,58,246,78,246,78,246,
78,212,78,212,212,246,78,78,246,246,78,212,58,99,212,246,246,58,99,218,
118,12,92,223,223,49,49,11,237,208,208,103,244,23,118,112,118,112,49,49,
19,82,82,82,223,49,66,49,49,82,223,223,101,19,223,82,223,82,223,82,
82,49,23,112,11,244,30,65,72,55,55,245,208,22,237,112,11,118,71,218,
218,58,58,78,246,78,212,78,78,212,99,78,212,246,78,246,78,246,78,212,
246,246,78,246,246,78,246,78,246,58,246,78,58,78,246,246,246,246,212,246,
78,78,78,78,78,58,78,78,99,58,78,78,78,99,58,58,99,58,99,99,
58,99,99,99,99,58,99,58,99,8,99,99,99,58,58,99,58,58,99,58,
58,58,78,78,58,58,58,58,58,58,78,78,78,78,78,58,246,246,246,246,
246,78,78,212,246,246,246,246,246,246,78,212,78,246,78,212,78,246,58,246,
78,246,78,58,58,212,246,58,78,246,246,58,58,58,58,246,58,218,71,12,
223,223,49,49,49,30,65,72,72,30,112,118,118,112,118,49,223,223,223,49,
244,244,244,244,23,23,23,23,70,66,49,70,49,70,70,118,23,23,23,23,
49,223,19,82,223,223,23,11,244,237,208,72,55,55,208,103,30,11,11,49,
71,71,99,58,246,78,246,246,58,246,58,58,246,212,78,246,58,246,78,58,
58,212,78,78,212,78,212,78,78,78,212,78,78,78,246,212,246,246,246,212,
246,58,78,78,78,78,58,78,78,99,58,58,78,58,58,58,99,58,58,58,
58,58,58,58,99,58,99,58,99,8,99,58,58,218,58,58,58,99,58,58,
58,99,58,58,99,58,78,78,78,78,78,78,78,58,246,246,246,212,246,246,
212,246,78,246,246,246,246,246,212,246,246,78,246,58,212,246,78,78,78,246,
58,246,212,99,58,246,78,246,246,58,58,58,58,78,246,58,99,118,12,92,
223,223,223,11,22,72,208,244,49,112,112,118,49,82,223,49,244,244,242,62,
23,62,23,23,244,244,244,244,244,244,62,30,244,244,244,244,23,112,210,23,
62,244,244,23,223,82,53,82,49,112,30,30,65,72,55,245,208,237,30,112,
71,49,118,71,99,78,78,78,246,246,58,99,58,246,212,78,246,58,246,212,
99,58,212,246,78,246,78,246,212,246,78,246,246,212,246,246,246,212,246,246,
246,246,78,78,246,246,78,78,78,78,58,58,78,58,58,58,58,58,99,99,
99,78,99,58,99,99,58,99,58,8,58,99,58,99,99,58,58,99,58,58,
58,58,58,58,78,58,78,78,58,78,58,246,78,78,78,212,246,246,212,246,
246,246,246,246,246,246,246,246,246,246,246,58,246,58,99,212,246,212,78,78,
78,99,58,58,78,246,58,78,246,58,58,58,58,212,58,218,71,12,49,49,
49,112,22,72,65,112,49,112,112,112,223,19,118,62,244,62,62,23,23,244,
244,244,244,112,23,49,49,223,19,223,82,223,223,49,223,23,118,112,244,30,
62,62,62,62,23,62,23,223,82,8,82,71,30,244,22,72,55,245,103,237,
11,71,12,12,71,99,78,78,78,58,212,58,58,58,58,212,78,58,246,78,
58,58,58,212,78,246,58,78,78,212,212,246,246,246,212,246,246,246,246,246,
246,246,58,78,78,58,246,212,78,78,58,78,58,78,78,78,58,78,58,58,
218,58,58,99,58,99,99,99,58,8,218,99,58,58,58,99,58,58,99,78,
78,58,99,58,58,78,58,78,246,78,78,58,78,212,246,246,246,246,246,246,
246,246,246,212,246,212,246,246,246,212,78,246,58,58,58,246,78,78,212,246,
58,58,58,58,212,78,246,212,58,58,58,58,58,58,71,12,49,223,223,49,
30,208,72,30,49,49,112,49,223,223,23,22,244,62,23,23,62,22,112,118,
49,49,223,118,23,244,30,242,22,242,242,62,242,244,244,112,23,49,49,223,
23,112,30,244,62,112,210,23,23,49,82,8,223,244,237,30,208,55,243,245,
22,30,71,118,12,71,99,78,78,246,212,58,58,58,58,246,246,246,78,246,
58,58,58,78,212,78,246,246,246,58,58,212,246,246,246,246,246,246,246,246,
246,78,246,58,246,246,246,78,212,78,78,78,58,78,58,78,58,58,99,58,
58,58,99,58,58,58,58,58,58,8,58,99,58,58,58,58,99,58,78,78,
58,58,78,58,58,78,78,58,78,78,78,78,78,246,212,246,246,246,246,246,
246,246,246,246,246,246,212,246,246,246,78,58,58,58,58,246,78,78,246,99,
212,58,212,58,212,78,78,58,58,218,58,212,58,99,71,49,223,49,49,30,
55,72,112,49,244,11,49,82,112,242,242,62,23,62,244,112,118,223,82,118,
30,236,29,225,231,33,248,42,42,42,219,2,42,219,110,107,231,29,65,244,
112,223,223,49,112,30,30,23,23,23,23,49,82,101,49,30,30,242,72,243,
208,103,30,71,118,12,71,99,78,78,78,58,58,58,58,58,78,58,246,78,
58,58,99,58,246,58,246,58,246,58,99,58,212,246,246,212,246,246,246,246,
246,246,246,246,212,246,246,246,246,78,58,78,78,78,78,78,58,78,78,78,
58,78,99,99,99,58,58,99,99,8,99,58,99,99,58,58,58,58,78,78,
78,78,58,58,58,78,78,78,78,78,246,246,58,246,246,246,246,246,246,246,
246,246,212,246,99,58,246,246,246,246,212,58,58,58,99,212,78,212,212,58,
78,58,58,58,246,246,78,58,71,218,58,58,11,71,118,223,49,23,103,243,
22,49,118,30,118,82,49,30,242,62,70,62,244,118,223,82,112,65,93,205,
217,42,80,147,98,4,26,8,8,8,8,121,8,8,26,4,98,210,111,219,
29,29,65,112,223,82,23,30,244,62,62,62,62,49,82,82,112,30,30,65,
243,245,103,30,71,118,12,71,218,212,246,58,58,212,212,58,58,246,212,78,
58,58,212,58,58,246,78,246,58,58,58,58,246,212,246,246,246,246,246,246,
246,212,246,246,246,246,212,246,246,212,78,246,212,78,58,78,78,78,58,78,
78,78,58,58,58,58,99,58,58,8,58,58,58,58,58,58,58,58,237,78,
58,78,78,58,78,78,212,78,246,78,78,246,246,246,246,246,246,246,246,246,
246,246,246,58,58,58,246,246,246,246,58,58,99,58,58,246,246,78,99,78,
246,78,58,58,58,58,58,218,12,99,58,99,71,92,49,223,118,22,41,65,
223,23,30,118,19,23,22,242,23,23,30,112,223,19,112,29,222,232,87,80,
98,26,121,8,20,253,20,20,20,20,101,20,20,20,253,253,20,8,121,26,
4,14,2,231,29,30,49,82,112,30,244,62,23,210,118,82,101,223,30,244,
65,55,243,103,237,71,118,71,71,99,58,58,58,58,218,58,58,58,246,212,
58,58,212,78,99,58,246,246,78,58,58,58,58,246,246,246,246,246,246,246,
246,246,246,212,246,246,246,246,246,246,246,78,78,78,78,78,58,78,58,78,
78,58,58,58,78,99,58,58,99,8,99,58,58,99,99,58,58,58,58,237,
78,78,58,78,78,246,78,246,78,246,78,246,246,246,246,246,246,246,246,246,
246,246,58,58,58,58,246,246,246,58,99,78,246,212,99,246,212,58,78,246,
58,246,58,58,58,212,218,12,118,58,58,71,12,49,19,49,237,41,65,49,
118,112,223,82,244,236,62,66,62,30,82,8,112,93,68,6,137,88,162,253,
253,20,253,19,223,23,244,244,54,242,54,242,244,62,112,49,223,20,20,20,
20,253,26,98,14,33,29,244,82,101,112,22,62,62,62,23,49,53,82,30,
112,22,243,243,208,11,71,118,12,218,99,58,58,58,12,71,58,58,58,58,
99,58,58,246,246,58,58,246,246,58,58,58,99,58,246,246,246,246,78,58,
246,212,246,246,246,246,246,212,246,246,78,78,78,78,58,78,78,78,78,58,
78,58,78,237,78,58,99,99,78,8,58,99,58,58,78,78,78,78,78,78,
58,78,78,58,78,246,78,212,246,246,246,246,246,246,246,246,246,103,246,246,
246,246,58,58,58,99,212,246,246,58,212,78,246,58,58,58,58,58,212,78,
78,78,58,58,58,58,123,49,218,99,11,118,223,223,82,237,41,208,23,118,
237,223,82,244,18,210,23,23,112,19,223,103,64,6,148,147,26,253,20,8,
66,23,54,111,219,219,137,24,76,24,163,25,137,42,204,42,151,109,244,223,
20,20,20,20,8,4,111,231,236,23,82,12,237,62,62,23,62,223,253,223,
237,244,22,41,245,103,11,112,118,71,218,58,58,99,92,92,128,58,58,58,
58,58,58,212,78,58,58,212,58,58,58,78,78,58,212,246,246,246,58,58,
212,246,212,246,246,246,246,246,246,212,246,78,246,246,78,78,78,78,78,58,
78,58,58,78,99,58,58,58,99,8,99,58,58,58,58,78,78,58,78,78,
78,78,78,78,78,58,246,246,246,246,246,246,246,246,103,246,246,246,246,246,
246,78,58,58,58,58,58,212,58,58,78,212,78,78,99,58,58,212,78,246,
212,212,58,58,58,218,92,12,218,99,71,12,223,82,118,243,55,23,223,30,
223,19,244,93,54,49,23,112,82,82,245,153,138,234,162,8,253,101,49,30,
111,125,24,201,142,16,159,142,43,95,197,156,193,193,51,141,224,25,248,231,
65,118,20,20,20,20,121,210,231,55,244,82,49,30,244,62,62,244,223,20,
118,237,112,208,243,245,237,71,118,49,71,58,58,218,92,92,12,58,58,99,
58,58,212,78,212,212,58,58,58,58,58,212,78,58,58,246,246,246,99,58,
99,246,246,246,246,246,246,246,246,246,212,246,58,78,78,78,78,78,58,78,
78,58,78,78,58,78,58,99,58,8,99,99,58,58,58,78,78,58,78,58,
78,78,78,246,78,78,78,246,246,246,246,246,246,246,246,103,246,246,246,246,
246,58,58,58,58,58,58,58,58,58,78,78,246,78,58,58,58,212,78,58,
58,78,58,58,58,12,92,12,99,218,118,19,82,223,22,116,237,49,112,112,
101,112,93,109,70,112,118,82,223,55,136,185,44,26,253,253,82,62,107,163,
117,16,114,159,161,106,98,46,26,26,26,26,26,4,32,81,44,142,43,234,
10,56,236,23,20,20,20,8,4,219,225,237,19,82,11,244,62,54,62,223,
20,112,30,244,72,239,103,237,71,12,12,71,58,71,92,92,12,128,58,58,
58,58,246,78,246,58,58,58,99,58,58,246,78,78,58,246,246,58,58,58,
58,212,246,212,246,246,246,246,246,246,78,78,246,58,246,58,78,246,78,58,
78,58,78,78,58,58,58,58,58,8,58,58,58,58,78,237,58,78,78,78,
78,78,78,58,246,246,212,246,246,246,246,246,246,246,246,246,246,246,246,246,
78,58,58,58,58,58,99,58,58,246,246,246,58,246,58,58,58,78,246,218,
11,58,58,58,58,12,92,71,218,11,49,223,101,23,239,93,23,118,244,223,
223,65,29,70,70,112,82,82,72,233,135,152,121,253,20,49,242,179,176,39,
198,156,32,47,26,26,69,113,26,47,9,47,162,113,26,121,113,252,152,159,
43,234,217,238,30,253,20,251,8,4,107,17,30,82,223,22,62,62,54,244,
82,19,237,112,244,41,245,30,112,71,92,71,99,71,12,92,92,71,78,58,
58,246,246,58,78,212,58,58,58,58,58,78,246,58,99,58,212,58,58,58,
58,78,246,246,246,246,246,246,246,246,246,246,78,78,78,78,246,58,78,78,
58,58,58,99,58,99,58,58,58,8,58,99,99,58,58,78,78,58,78,58,
78,58,78,78,78,78,78,246,246,246,246,246,246,246,246,246,78,246,246,246,
58,58,78,58,78,58,58,99,58,78,58,246,246,58,58,58,212,58,58,12,
71,58,58,58,99,92,92,71,218,71,223,8,19,22,150,30,49,11,23,101,
30,93,54,49,112,49,20,30,254,181,95,26,253,253,49,65,163,166,206,202,
52,26,8,121,4,161,43,114,139,131,57,200,195,188,192,88,26,26,121,98,
197,67,234,145,230,22,82,20,20,8,98,107,100,112,253,112,103,244,54,62,
49,20,49,237,118,208,243,103,11,11,12,92,92,92,92,12,49,12,58,58,
78,58,246,78,246,78,212,99,58,58,78,246,58,78,58,58,58,99,58,58,
58,99,246,246,246,246,246,246,246,246,246,246,246,78,246,78,246,78,58,78,
78,58,78,78,78,58,58,99,58,8,99,58,58,58,99,78,58,78,78,78,
78,78,78,78,78,246,246,246,246,246,246,246,246,246,246,246,58,212,58,246,
99,212,58,99,78,99,58,58,78,246,58,58,58,78,78,58,78,78,99,71,
12,71,58,58,12,12,12,71,11,12,223,101,49,243,100,118,223,112,82,19,
93,225,113,23,244,101,223,41,129,199,52,253,20,223,242,124,39,57,117,122,
121,121,47,44,195,35,94,196,165,189,189,189,27,84,200,139,67,186,26,121,
240,106,159,234,175,68,242,20,20,20,8,210,238,93,223,19,237,244,23,54,
62,19,101,244,112,30,243,208,237,11,12,92,49,223,12,12,92,12,58,78,
246,78,58,246,78,212,78,78,58,58,212,58,58,58,78,99,58,58,99,58,
58,58,246,246,246,246,246,246,246,246,246,246,78,246,58,78,58,78,78,78,
78,78,237,78,58,58,58,58,58,8,99,58,99,58,78,78,78,58,78,78,
78,78,78,78,78,58,246,246,246,246,103,246,246,246,246,218,58,58,78,78,
58,99,71,12,58,78,58,78,58,78,123,12,78,78,58,212,78,78,123,92,
12,12,99,99,12,92,92,71,11,118,82,101,112,116,236,82,112,112,82,118,
100,110,66,23,49,101,244,215,73,43,69,253,101,23,219,59,97,202,52,8,
8,4,120,97,187,139,27,143,46,113,26,26,46,88,60,27,131,200,192,47,
82,66,81,159,234,170,68,118,20,251,20,26,2,64,244,101,118,22,23,62,
62,49,20,118,244,23,208,245,30,11,71,12,92,12,12,49,12,12,71,58,
246,246,78,246,78,246,58,78,58,78,212,218,12,246,78,99,58,78,78,11,
12,58,58,246,246,103,246,246,58,246,246,246,246,78,246,78,78,78,58,78,
78,58,58,58,78,58,58,99,58,8,99,58,58,58,99,78,58,78,78,78,
78,212,78,246,246,78,99,58,246,246,246,246,246,246,71,12,99,58,58,99,
58,58,53,251,71,78,78,78,78,246,19,19,71,246,246,78,212,246,12,92,
12,12,12,12,92,12,12,71,218,118,19,101,244,239,65,223,244,11,53,112,
222,235,66,112,223,20,72,45,90,221,8,253,19,242,214,97,57,152,26,8,
26,188,57,187,139,186,8,8,8,8,121,121,8,8,26,4,44,131,94,67,
162,82,113,44,159,76,220,29,82,0,20,8,98,238,245,82,82,237,23,62,
54,112,20,223,237,49,22,245,237,11,71,49,12,92,12,12,12,12,71,78,
246,58,246,58,246,78,246,58,246,212,58,19,101,218,78,78,99,58,58,53,
101,71,58,246,246,246,78,71,92,58,246,246,212,246,78,58,58,78,78,58,
78,78,78,78,58,58,58,58,58,8,99,99,58,99,58,78,78,58,99,58,
78,78,58,246,78,58,71,92,218,246,246,246,103,246,12,92,92,58,58,58,
58,218,63,53,19,246,246,78,78,212,53,92,92,212,246,78,78,58,92,218,
12,12,92,92,92,12,12,71,11,118,101,101,22,116,242,223,237,11,8,30,
17,62,70,112,8,53,72,172,134,143,8,20,223,109,102,57,97,81,121,82,
252,114,35,157,165,26,253,8,8,46,182,4,26,26,8,8,113,160,190,35,
186,66,121,106,117,152,232,68,49,79,20,8,26,42,17,223,53,22,112,244,
54,244,8,82,30,118,30,245,30,11,99,12,12,92,123,12,12,12,71,78,
246,78,246,78,58,246,246,58,246,58,12,53,53,12,78,78,78,99,12,63,
63,92,78,78,246,246,78,229,229,12,246,246,246,212,78,71,71,58,78,78,
58,78,78,58,58,58,212,58,58,8,99,58,58,58,58,78,78,58,99,218,
99,58,246,78,78,58,12,92,12,78,246,246,246,218,92,92,19,71,58,58,
58,12,38,92,53,71,246,58,246,218,108,92,92,218,246,212,78,58,12,218,
12,12,12,92,12,92,12,71,71,118,82,8,103,116,242,82,244,11,82,30,
222,210,223,23,8,101,55,172,183,186,8,253,223,110,102,157,97,161,8,8,
127,67,190,140,189,26,8,8,69,127,120,5,52,26,26,8,121,9,84,187,
43,113,82,98,142,152,89,119,244,20,0,253,121,219,64,23,101,30,30,23,
54,244,82,101,30,112,112,72,237,71,30,12,12,92,118,12,12,12,71,58,
246,246,58,246,58,212,78,246,58,246,108,63,53,19,78,78,78,58,53,101,
53,108,78,246,246,246,108,79,20,53,246,246,246,78,99,92,92,12,99,78,
78,58,58,218,218,218,99,58,58,8,99,99,58,58,58,99,99,218,71,11,
99,99,78,246,212,71,218,71,92,71,246,246,246,71,92,92,19,19,58,58,
58,92,53,92,92,108,58,246,246,71,92,92,92,92,212,246,246,58,123,48,
12,12,12,92,92,12,12,12,99,118,19,101,237,116,65,49,30,112,82,244,
222,235,26,118,82,101,65,136,183,7,8,8,82,242,21,157,57,192,69,8,
26,7,191,157,190,60,9,8,26,52,84,131,60,4,121,8,26,113,67,94,
142,113,82,98,43,152,10,119,244,251,0,253,121,111,64,23,101,244,22,49,
62,62,82,101,112,23,112,103,30,71,11,12,12,118,12,12,118,12,71,78,
78,246,78,58,218,58,78,246,246,12,53,101,53,19,58,78,58,12,63,63,
53,63,218,246,246,71,79,20,63,101,218,246,246,218,12,19,108,12,99,58,
99,71,218,71,71,218,71,218,71,8,99,58,99,99,58,58,11,218,71,218,
71,71,218,58,58,99,218,99,71,92,218,78,246,92,92,12,223,53,71,58,
58,19,19,92,92,19,12,78,78,12,92,92,92,92,71,78,78,218,123,241,
48,12,12,92,49,12,118,12,71,49,223,101,11,116,65,66,112,11,82,112,
100,54,66,66,223,20,244,105,90,159,8,8,8,244,10,167,187,202,98,8,
121,47,192,169,190,35,195,188,188,195,57,84,106,47,8,8,8,122,195,140,
95,66,82,98,142,221,175,119,244,251,251,20,8,219,64,112,101,30,242,118,
23,62,19,20,11,118,112,22,11,11,99,12,12,12,12,71,12,118,71,58,
246,58,246,99,12,99,212,78,58,19,53,53,101,53,58,78,218,53,101,53,
53,63,218,246,246,63,0,101,19,53,12,78,58,12,108,92,19,108,92,71,
71,12,71,71,123,71,71,123,71,8,99,99,58,58,58,11,58,11,99,218,
99,11,99,99,218,99,218,99,71,12,12,99,99,92,92,92,12,19,53,71,
99,38,53,12,12,92,19,218,212,92,92,92,48,12,108,128,246,218,123,48,
128,123,12,12,12,12,12,118,71,71,223,8,112,41,55,49,49,244,223,49,
93,231,70,82,223,20,82,116,181,158,252,8,20,223,242,214,57,157,156,46,
8,66,26,147,44,198,86,196,86,198,44,52,4,8,8,8,46,60,97,194,
52,82,82,180,159,177,232,64,66,79,20,8,26,231,100,49,8,237,62,23,
62,244,82,82,30,223,11,237,112,11,11,12,12,71,12,12,118,12,71,218,
246,78,58,218,92,99,246,212,92,53,79,79,53,53,218,58,19,63,38,126,
53,101,92,58,19,251,63,223,19,19,92,71,12,223,92,223,223,92,19,92,
12,71,123,71,71,71,71,71,71,8,11,58,11,58,99,58,99,58,99,58,
58,218,218,218,99,218,11,99,99,71,92,92,12,49,92,71,99,12,53,53,
92,20,53,123,48,12,92,19,218,19,92,12,241,48,92,92,58,218,92,241,
128,212,71,12,118,12,12,71,71,112,223,19,82,55,116,112,49,244,223,19,
208,238,235,66,223,253,82,22,250,73,95,113,8,82,49,111,102,207,132,188,
252,69,8,121,162,4,47,52,127,4,4,26,26,8,8,46,186,86,169,95,
66,8,4,95,192,87,45,236,101,251,253,8,70,222,236,223,223,237,244,23,
54,244,82,82,237,118,11,244,71,11,99,71,118,12,12,12,12,12,12,58,
78,78,246,123,108,12,212,12,53,63,13,83,63,53,12,92,53,226,13,13,
53,53,53,226,75,63,12,71,92,19,19,92,92,92,19,12,12,12,92,12,
71,71,71,71,71,12,71,71,71,8,99,99,58,99,99,58,58,99,58,58,
11,218,71,71,11,218,99,99,58,218,12,19,92,92,92,99,78,58,92,101,
75,251,53,12,123,48,92,108,101,63,92,12,241,241,92,92,108,92,108,128,
212,246,58,12,12,12,49,12,12,118,12,49,19,237,116,22,49,118,244,82,
112,17,231,70,223,82,20,82,93,45,133,7,46,8,8,49,50,224,168,207,
142,60,127,46,8,26,8,8,8,8,8,8,121,26,47,192,166,169,7,113,
66,113,7,156,36,217,28,23,251,251,20,26,111,222,30,8,49,22,112,62,
242,112,101,112,30,49,244,11,112,11,99,71,12,12,118,12,12,12,71,246,
246,78,212,92,108,92,218,53,38,13,0,0,63,101,20,63,101,75,83,83,
63,101,229,79,126,92,58,78,12,19,92,92,19,92,12,71,71,118,71,71,
218,12,71,71,71,71,71,218,99,8,218,99,218,58,58,218,99,99,58,99,
58,58,99,99,218,99,218,99,58,58,99,92,92,92,19,58,78,78,99,108,
0,34,38,123,123,48,123,92,53,108,92,12,241,241,241,123,92,19,19,123,
241,212,246,99,12,71,12,71,12,71,118,223,82,118,245,100,112,49,30,118,
223,237,238,111,113,223,19,20,49,93,144,184,44,113,8,253,19,210,173,141,
168,57,196,142,60,52,122,182,113,113,122,3,60,159,130,86,43,122,26,223,
47,106,95,76,89,68,244,20,251,20,8,210,238,72,223,19,30,112,23,62,
244,223,20,118,112,112,244,118,11,99,99,218,71,218,71,12,12,71,58,58,
78,246,246,92,63,53,53,101,83,0,83,83,53,63,63,53,20,83,0,0,
53,53,79,0,226,78,58,78,12,108,92,19,92,71,58,58,99,71,71,123,
71,218,218,71,218,218,99,218,99,8,99,99,218,218,99,99,99,99,58,99,
99,58,99,11,71,99,99,58,58,58,58,71,92,92,19,78,78,58,78,218,
53,63,101,123,123,48,48,123,92,19,92,92,241,241,241,241,92,92,92,12,
241,212,78,78,123,118,12,12,12,12,112,92,49,223,30,247,65,49,23,112,
82,23,72,231,14,26,82,19,101,49,17,146,102,154,147,69,8,82,49,23,
249,104,158,39,206,169,86,130,202,142,202,114,39,117,76,88,4,66,66,113,
7,95,234,175,68,22,101,20,251,8,4,107,100,112,101,112,30,23,112,62,
49,101,49,244,118,112,112,118,11,78,99,99,99,58,71,12,92,99,246,78,
246,58,218,108,108,53,63,229,0,83,34,13,53,53,101,38,13,0,0,13,
53,101,63,101,99,78,58,78,71,19,19,92,71,58,99,58,11,218,218,71,
99,99,99,99,218,58,99,218,218,8,71,218,99,99,218,58,99,99,99,99,
99,58,99,58,99,218,11,58,58,99,58,58,71,92,92,58,78,78,78,78,
118,19,53,123,48,128,128,48,123,12,92,92,48,128,212,48,241,12,12,92,
241,128,246,246,246,71,12,12,12,71,71,118,49,223,49,208,116,22,49,23,
11,223,223,72,225,235,113,82,82,101,49,65,68,164,201,7,162,26,8,121,
66,223,23,216,14,36,177,152,154,152,80,255,98,66,66,223,66,4,32,152,
152,163,228,222,112,251,20,20,8,113,219,222,22,82,23,22,62,112,54,244,
101,82,112,112,23,118,112,11,11,78,58,58,246,99,71,71,99,58,246,212,
58,58,123,108,108,53,20,13,101,19,34,13,53,53,53,0,75,38,0,34,
63,53,53,71,58,78,58,78,11,92,92,71,58,58,58,58,99,218,11,99,
11,58,218,218,99,99,218,99,99,8,99,71,99,99,99,99,99,218,58,99,
218,58,99,99,99,58,58,78,58,99,58,58,58,71,12,78,78,78,78,78,
58,12,19,12,48,218,246,218,48,12,92,92,241,48,58,212,48,241,12,92,
48,241,212,58,212,212,123,118,12,71,118,118,12,223,49,118,55,239,244,223,
112,112,82,118,236,225,14,4,26,82,101,19,112,93,153,21,224,174,88,162,
26,26,121,82,66,66,66,66,66,66,26,82,66,26,113,127,32,44,51,87,
248,222,236,223,20,20,20,8,70,111,17,237,223,49,237,30,62,54,30,118,
253,49,112,118,23,118,118,11,99,58,58,58,212,99,71,218,246,78,78,58,
58,58,108,108,63,38,13,92,58,12,13,251,53,63,251,79,12,71,34,34,
251,53,19,58,78,78,78,58,58,71,71,58,99,99,58,99,58,11,58,99,
99,99,99,218,218,99,218,218,99,8,71,99,218,218,218,99,218,99,99,99,
99,71,58,99,99,99,99,58,58,99,58,58,78,58,99,78,58,78,58,78,
78,78,99,218,128,58,58,78,128,48,12,92,123,241,78,246,58,48,241,218,
12,128,212,212,58,58,212,218,71,12,71,12,118,12,223,49,11,243,55,244,
49,112,244,223,49,236,17,111,4,121,82,82,8,223,244,29,153,61,148,234,
152,32,147,52,4,4,113,26,113,26,98,98,147,255,7,193,24,163,217,238,
110,112,101,20,20,253,8,70,107,222,22,223,223,244,244,244,244,242,112,82,
223,118,23,23,49,118,71,11,58,58,58,246,246,58,99,78,58,212,212,78,
58,99,53,53,38,83,19,58,246,19,34,79,251,34,34,71,58,71,79,13,
83,63,218,58,58,99,58,78,58,99,78,58,99,99,99,58,58,99,99,58,
218,11,218,99,11,218,11,99,71,8,71,218,218,11,71,99,218,99,99,99,
99,218,11,99,58,58,58,58,11,58,99,218,58,58,78,78,78,78,58,58,
78,78,78,78,58,78,78,78,58,58,48,123,48,48,128,78,246,78,128,241,
241,241,128,212,58,58,58,58,218,12,118,71,71,112,118,223,49,11,245,55,
30,49,112,244,223,19,30,93,107,111,4,26,101,101,8,101,112,242,93,203,
6,170,21,74,51,51,104,24,234,76,24,104,76,124,232,56,225,18,30,223,
20,20,20,20,8,66,235,231,236,112,223,118,30,112,112,54,244,112,82,49,
112,23,118,118,12,11,99,99,246,58,58,58,78,58,246,246,78,78,212,78,
58,12,53,229,34,40,78,78,58,38,0,13,13,79,71,58,58,71,13,0,
38,71,58,99,58,99,58,99,78,58,58,99,99,99,71,99,58,99,218,99,
71,99,218,99,99,71,218,99,71,8,71,71,71,123,218,218,11,218,218,218,
218,99,218,218,99,99,99,99,58,99,99,99,99,99,58,78,78,58,58,99,
99,78,78,246,78,212,78,78,58,78,128,48,48,241,48,246,78,58,246,128,
128,128,128,128,212,78,212,78,58,218,71,71,12,12,118,118,49,49,112,208,
41,22,49,112,244,23,19,49,22,93,219,14,4,8,82,101,20,101,223,49,
30,65,18,29,17,203,228,230,56,96,91,225,225,236,242,112,49,82,20,20,
20,20,82,113,210,107,29,22,118,223,112,30,244,244,62,112,23,82,223,49,
118,118,49,49,118,71,99,246,58,58,212,246,246,78,212,58,246,246,78,58,
218,53,209,126,40,78,78,78,218,0,34,34,79,71,78,99,58,71,251,229,
12,58,99,99,99,58,58,58,58,99,99,99,99,218,99,58,99,99,99,218,
99,218,11,218,218,11,218,71,71,8,71,123,71,71,218,123,71,99,11,99,
218,11,99,71,218,99,58,99,99,58,218,218,99,99,58,58,58,58,99,58,
58,99,58,246,246,246,78,58,58,58,78,58,48,48,241,78,246,78,78,58,
58,241,241,241,212,58,246,78,246,58,218,71,71,71,118,118,118,49,49,112,
103,243,236,112,49,244,112,49,223,118,65,93,107,14,98,113,82,8,101,253,
101,20,101,82,82,223,118,118,49,49,49,82,82,101,101,20,20,253,253,121,
26,70,235,110,29,103,118,223,223,11,244,244,54,242,244,49,19,223,49,118,
118,49,12,71,11,99,212,246,78,78,78,78,212,246,78,58,78,212,78,58,
12,38,213,71,78,58,58,78,40,83,79,20,99,58,99,58,99,12,92,71,
78,58,99,99,99,99,99,99,99,99,218,218,99,218,218,99,218,218,11,218,
11,218,218,71,218,218,71,123,71,8,71,71,12,71,71,218,218,218,71,71,
218,218,218,218,71,218,218,99,99,218,99,99,99,99,99,99,58,99,58,99,
99,99,99,58,78,78,78,78,58,99,58,58,58,128,48,128,78,78,58,78,
212,212,212,241,128,58,246,246,58,246,58,218,218,118,71,71,118,12,118,49,
23,237,245,55,208,23,118,23,112,223,223,118,244,236,18,110,14,210,4,66,
121,8,82,20,82,101,101,251,20,20,20,101,8,20,8,8,26,26,210,235,
109,110,65,30,118,223,49,244,244,244,244,242,65,30,223,82,49,118,118,49,
92,49,118,71,11,78,246,78,58,246,212,246,78,78,246,78,246,78,212,218,
53,92,99,78,58,58,58,246,53,0,53,99,99,58,99,58,99,71,218,58,
99,58,99,218,58,99,58,78,99,99,11,99,71,99,99,218,99,99,218,71,
123,218,71,218,12,71,71,71,71,8,71,71,71,71,71,118,71,71,218,99,
71,71,71,123,71,71,218,99,99,218,218,71,11,218,99,99,58,99,58,99,
99,99,218,58,58,78,78,78,58,99,99,58,58,58,58,128,246,78,58,58,
58,58,246,128,128,58,212,246,78,78,78,58,58,218,71,71,11,118,118,49,
12,23,11,103,243,72,237,23,23,112,23,223,19,223,112,22,109,18,29,111,
111,210,210,70,4,26,26,26,26,26,26,4,4,70,98,235,2,18,29,65,
54,23,223,49,23,244,244,112,244,54,22,244,118,82,223,223,118,92,49,49,
223,71,11,99,99,78,246,58,246,78,58,212,78,78,58,58,246,78,58,218,
71,78,58,58,99,58,58,99,19,77,58,58,58,218,99,58,58,58,58,58,
218,99,11,218,58,99,218,58,218,218,71,218,218,71,99,71,218,71,71,218,
71,123,71,71,71,71,71,71,12,8,118,118,71,71,118,71,71,71,118,12,
71,123,71,71,71,71,71,71,218,99,99,99,218,218,71,218,99,99,58,99,
99,218,99,218,58,58,246,78,78,99,99,99,99,58,246,78,58,246,58,58,
58,58,58,78,78,58,58,58,246,212,99,58,58,58,218,99,71,118,11,118,
49,49,49,23,11,208,55,245,22,112,23,23,23,23,49,49,49,223,112,30,
22,236,18,18,18,29,18,18,18,18,107,236,29,236,236,22,30,23,223,223,
223,118,118,112,244,112,244,242,242,30,23,223,82,223,49,49,49,223,49,12,
71,71,99,58,246,212,58,58,58,78,78,78,58,58,58,58,78,212,246,78,
78,58,58,11,99,58,78,78,99,58,58,99,218,99,58,99,58,58,58,218,
99,71,218,99,218,58,99,218,218,71,218,123,71,99,71,218,71,71,71,12,
71,71,12,12,12,12,12,12,12,8,12,12,12,12,12,12,118,118,71,71,
71,218,71,123,71,71,71,71,123,71,218,11,218,71,218,123,218,99,218,58,
99,99,11,218,71,99,99,58,78,58,99,99,71,99,58,78,246,246,246,58,
58,218,58,99,78,78,246,78,78,246,58,58,58,212,58,58,99,71,71,118,
71,118,118,23,49,112,112,103,72,72,65,244,112,23,118,118,70,223,223,223,
223,49,118,23,118,112,112,244,112,112,23,23,23,49,49,223,223,49,23,118,
244,244,112,62,244,109,22,30,49,223,223,82,49,223,49,223,223,118,118,71,
99,99,99,78,78,246,58,58,78,78,58,58,58,99,78,246,78,78,78,78,
99,99,99,58,99,58,78,78,58,99,99,11,218,99,99,58,58,11,99,218,
218,218,71,99,218,218,11,218,123,71,218,71,71,218,71,71,123,71,118,12,
71,12,12,12,12,12,12,12,12,8,12,12,12,12,12,12,71,71,71,118,
71,118,71,71,118,12,71,71,71,71,99,218,123,71,218,71,218,71,99,99,
99,218,218,71,218,218,99,58,58,58,58,218,99,218,218,99,58,99,78,58,
58,99,99,99,58,58,78,246,246,78,78,78,58,99,58,58,99,58,99,71,
11,71,12,23,118,118,118,23,112,30,103,208,208,65,242,112,118,23,23,118,
118,118,49,112,23,112,11,112,112,112,118,49,49,49,49,112,23,23,112,244,
244,22,22,22,242,112,49,223,223,66,223,49,223,49,223,49,12,71,71,99,
99,58,212,212,246,58,78,78,58,58,99,99,99,58,78,78,78,78,58,58,
99,99,99,58,58,58,58,58,99,218,71,218,99,99,218,58,99,99,71,218,
71,71,218,99,71,99,123,71,118,118,123,71,71,123,71,71,12,12,118,12,
12,12,12,12,12,12,71,12,71,8,12,92,12,92,71,12,118,118,12,12,
118,71,71,12,71,71,118,12,12,71,118,218,71,71,71,12,71,12,218,218,
99,99,218,218,71,71,71,218,99,99,99,99,71,71,218,71,99,58,58,58,
58,58,99,11,99,99,99,58,246,78,246,78,58,99,99,99,58,58,99,99,
99,11,71,112,112,118,118,92,118,23,118,112,30,237,103,65,65,22,30,54,
244,244,23,112,244,112,244,112,244,23,244,23,112,62,244,244,30,242,22,242,
22,30,23,49,49,19,82,223,223,49,49,49,223,49,12,11,11,218,99,58,
58,78,78,78,246,78,78,99,99,58,99,58,58,78,78,78,58,99,218,218,
71,99,99,99,58,99,58,99,71,123,71,218,99,99,218,99,218,71,12,71,
71,218,71,71,218,71,71,71,71,71,12,71,71,71,118,12,12,12,71,71,
12,12,12,12,118,12,12,92,12,8,12,12,71,12,12,12,12,12,71,12,
118,12,12,12,118,12,71,12,12,71,71,71,71,123,71,12,12,71,71,218,
218,218,11,71,123,71,71,218,71,99,99,58,99,99,71,218,218,99,218,58,
58,58,58,99,218,71,99,218,58,58,58,246,212,58,58,99,99,58,99,58,
58,58,58,218,71,71,112,71,118,118,49,23,118,118,49,112,112,30,237,22,
22,22,103,22,22,22,22,22,30,242,22,22,22,103,22,22,30,112,112,23,
49,49,49,82,223,66,49,49,49,49,223,12,118,71,218,99,99,58,99,58,
78,246,78,246,58,58,99,99,218,218,99,99,99,58,58,58,99,218,71,218,
99,99,58,58,58,99,218,123,71,71,218,218,99,99,99,123,71,71,71,92,
71,71,218,218,71,12,12,12,118,71,12,118,71,71,71,12,12,12,12,12,
12,12,118,118,12,12,12,12,12,8,92,92,92,12,12,12,12,12,12,12,
92,12,12,12,71,12,118,12,12,12,12,12,71,71,71,12,12,71,118,71,
71,123,71,71,71,118,71,71,71,123,71,218,218,99,218,71,12,71,71,218,
218,58,58,99,58,71,71,218,218,218,99,58,58,58,58,58,99,99,99,218,
218,99,58,58,99,99,99,11,11,11,23,112,118,112,49,118,118,118,23,118,
49,118,23,112,112,112,112,244,112,112,118,112,118,49,49,223,49,223,223,49,
223,223,49,49,223,49,223,223,118,118,71,11,218,99,218,99,218,78,58,58,
58,58,58,218,218,218,218,218,58,99,58,58,58,58,218,99,71,71,123,71,
218,99,58,99,99,71,71,12,12,71,71,71,218,218,218,71,118,71,71,12,
123,71,12,71,71,12,12,12,118,71,12,12,12,118,118,12,71,118,12,118,
12,12,12,12,12,92,12,12,92,8,92,92,12,12,92,12,92,12,12,12,
12,12,118,12,12,12,12,12,12,12,118,12,12,71,118,71,12,12,71,118,
71,71,71,123,218,118,12,71,71,71,71,99,99,218,218,71,71,71,71,71,
99,218,99,58,99,218,218,71,71,71,218,71,58,99,58,58,99,58,218,99,
99,218,99,99,58,58,58,99,58,99,218,11,71,112,11,112,118,23,118,23,
49,118,118,92,49,92,49,92,49,92,49,223,223,49,223,49,49,49,49,82,
49,49,49,223,118,118,71,71,11,71,99,218,218,99,58,58,58,58,58,58,
58,218,218,218,71,218,218,99,99,99,99,58,218,218,71,123,71,71,218,11,
99,99,218,218,71,71,12,71,12,218,218,218,71,218,118,12,71,118,71,71,
71,71,71,71,118,71,12,12,12,71,12,12,12,12,12,12,12,49,12,12,
12,92,12,49,12,92,12,12,92,8,92,92,92,92,92,12,92,12,12,92,
12,92,12,92,12,71,71,12,12,12,12,71,12,118,71,118,71,118,12,12,
12,12,71,71,218,71,71,118,118,12,12,118,71,218,71,218,123,12,12,12,
12,71,71,99,99,99,218,71,71,71,71,123,71,218,218,58,99,99,58,218,
99,218,218,11,99,218,99,218,218,58,58,58,99,218,71,11,71,71,118,11,
112,71,112,118,112,12,118,118,118,118,118,118,118,118,118,118,223,223,49,49,
118,118,118,71,71,71,218,71,218,71,99,99,99,218,58,58,58,218,218,218,
218,71,71,218,123,71,218,99,58,218,218,99,71,118,12,71,71,71,218,218,
218,99,71,118,12,12,12,71,71,123,71,71,71,12,118,12,92,71,118,71,
12,12,71,12,12,92,12,12,12,118,12,12,12,12,12,92,12,12,12,92,
71,92,12,92,92,92,92,92,12,8,92,92,92,92,92,92,92,92,92,12,
92,12,92,12,92,92,12,118,92,12,12,92,92,12,12,12,12,12,12,12,
12,12,71,118,12,118,71,71,12,12,12,12,118,71,218,71,218,71,118,12,
12,71,12,71,218,71,99,218,123,71,71,12,71,118,71,71,99,218,218,99,
218,99,218,218,218,71,123,71,218,218,218,218,99,99,99,58,99,99,99,218,
99,71,71,71,11,71,11,11,11,11,11,11,11,11,71,118,12,118,218,218,
71,218,71,71,218,71,99,71,99,99,99,58,218,99,218,218,71,71,71,71,
71,71,123,71,11,99,99,99,218,218,71,71,12,12,12,71,123,218,71,218,
71,118,71,12,118,12,12,71,71,218,118,12,12,12,92,12,71,118,71,71,
12,71,92,12,92,12,12,12,118,12,12,92,92,12,92,12,92,92,92,92,
92,92,92,92,12,92,92,92,92,8,92,92,92,12,92,92,92,92,92,92,
92,92,92,12,92,92,12,12,92,92,92,12,92,92,12,12,118,12,12,92,
92,12,12,12,71,71,71,118,12,118,12,12,12,71,12,71,71,71,71,12,
12,12,118,12,12,118,218,71,71,71,12,71,71,71,12,12,71,71,71,11,
218,99,218,218,218,218,71,71,71,71,71,71,71,71,218,218,218,218,99,218,
218,218,99,218,99,218,218,218,218,218,218,218,218,99,218,11,218,71,71,71,
71,123,71,123,71,218,99,218,218,11,218,99,71,71,71,71,71,71,71,92,
71,71,71,123,71,218,71,71,71,118,12,12,12,12,71,71,71,218,71,71,
12,12,12,12,12,12,12,71,71,71,12,12,12,12,12,12,12,12,118,12,
12,92,92,92,12,92,12,71,12,92,92,12,92,92,92,92,92,12,92,92,
92,92,92,92,92,92,92,92,92,8,92,19,92,92,92,92,92,223,92,92,
92,92,92,92,92,92,92,92,92,92,92,92,12,92,12,92,12,118,12,12,
12,92,92,12,92,12,12,12,71,12,49,12,92,92,12,12,71,12,12,12,
12,71,12,12,12,12,71,12,71,71,218,218,71,118,12,12,12,71,12,12,
71,123,71,71,99,71,71,123,71,123,71,123,71,71,71,71,71,71,71,71,
71,218,218,218,71,71,218,71,218,71,218,71,71,123,71,123,71,123,71,123,
218,71,218,218,218,218,71,71,71,71,71,12,12,12,12,12,12,12,71,71,
71,123,218,218,71,71,12,12,12,71,12,12,12,12,71,71,71,12,118,12,
12,92,12,12,12,12,12,12,71,12,92,12,92,12,12,118,12,12,12,92,
92,92,92,92,92,12,92,92,12,92,92,92,92,19,12,92,92,92,92,92,
12,92,92,92,92,92,92,92,92,8,19,108,19,108,12,19,92,92,92,92,
92,92,92,92,92,19,92,92,92,92,92,92,92,92,92,92,92,92,12,92,
92,92,92,92,92,92,12,12,12,12,71,12,92,92,92,92,12,92,118,12,
12,12,12,12,92,12,12,12,71,12,71,71,71,12,12,12,12,12,12,92,
112,118,71,12,71,71,71,218,71,71,71,71,71,71,12,12,12,12,12,12,
12,118,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
71,71,71,71,71,71,71,71,118,71,12,71,12,12,12,12,12,71,71,123,
71,71,71,92,12,12,12,12,92,92,71,12,12,12,12,71,12,12,92,12,
92,92,12,118,12,12,118,12,12,92,92,92,92,12,12,12,12,92,92,92,
92,12,92,12,92,12,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,92,92,92,12,19,19,108,92,8,92,92,19,92,108,92,19,92,92,92,
92,108,92,92,92,12,92,92,12,92,92,92,92,92,92,92,92,92,92,12,
12,92,92,92,92,223,12,92,12,12,12,12,12,92,92,12,92,12,12,12,
12,12,12,12,49,12,92,92,92,92,12,12,71,12,12,12,12,12,12,12,
92,92,118,92,12,12,118,12,12,12,12,12,12,71,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12,118,118,12,118,12,12,12,12,12,12,12,12,12,12,12,12,71,12,
12,12,71,92,12,92,92,49,12,12,12,12,118,12,12,118,92,12,92,92,
12,12,12,12,123,12,92,92,92,92,92,92,12,92,12,92,92,92,92,92,
92,92,92,92,92,92,92,92,92,92,92,92,12,92,92,92,19,92,92,108,
92,19,92,108,108,92,108,92,108,8,19,108,19,92,19,108,108,108,92,19,
92,92,19,92,108,108,92,108,108,92,92,92,92,92,92,19,92,92,92,92,
92,92,92,92,92,92,92,92,92,92,92,92,12,92,12,92,92,92,92,92,
92,12,12,12,12,12,12,92,92,92,92,92,92,12,12,12,12,12,118,12,
12,12,12,92,12,12,12,12,71,12,12,12,12,71,71,12,12,71,118,118,
12,12,12,12,12,118,12,12,12,92,12,12,12,12,12,71,12,12,118,12,
12,71,12,12,12,12,12,92,118,118,12,12,12,12,71,12,12,12,49,12,
92,12,92,92,92,12,92,12,12,12,12,12,92,92,92,92,92,92,92,92,
12,12,71,92,92,92,12,92,223,92,92,92,12,92,92,92,92,92,12,19,
92,92,92,92,92,92,108,92,108,19,92,108,108,108,92,92,19,108,92,108,
19,92,19,92,108,92,108,19,19,8,19,108,19,108,108,19,92,19,108,19,
19,108,108,19,19,92,108,92,92,108,19,12,108,108,92,19,108,108,92,19,
92,92,92,92,92,92,108,19,92,92,92,92,12,92,92,92,92,92,92,92,
92,92,92,12,12,118,123,92,12,12,92,92,92,92,92,92,12,12,12,12,
12,92,12,12,92,12,92,92,92,92,92,92,12,12,12,12,12,12,12,71,
71,12,12,12,12,12,12,12,71,12,12,12,12,12,12,92,12,12,92,12,
92,12,12,49,12,92,12,12,12,12,12,71,12,12,12,12,92,12,92,12,
92,92,92,92,92,12,12,12,12,92,12,12,92,92,92,92,92,92,12,12,
12,92,92,92,92,19,108,92,92,92,92,92,92,92,92,19,92,108,108,92,
92,92,92,19,108,92,19,108,92,108,108,92,19,92,108,19,108,92,108,92,
19,108,108,92,108,108,19,92,108,8,19,19,19,19,19,108,19,19,108,92,
19,19,108,92,19,19,108,19,108,92,108,19,92,19,92,92,92,19,92,92,
92,92,92,92,92,92,19,108,92,19,19,92,92,92,92,92,92,92,223,92,
223,92,92,92,92,92,92,92,92,92,92,92,92,223,92,92,92,12,92,12,
12,12,12,12,92,12,12,92,12,92,92,92,92,92,92,92,92,92,92,92,
92,92,12,92,49,92,12,92,92,12,12,92,12,92,12,92,12,12,92,12,
12,12,12,12,12,12,12,92,92,92,12,92,92,92,92,92,92,92,92,92,
92,92,12,12,12,12,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,92,12,19,92,92,108,12,92,92,92,12,19,92,92,108,92,19,19,92,
92,92,92,92,108,19,92,19,19,92,92,108,108,92,108,92,19,19,19,108,
19,19,19,19,19,19,108,19,19,8,19,53,19,53,19,53,19,53,19,108,
19,108,19,108,108,108,19,108,19,108,19,108,108,108,108,19,108,19,108,19,
19,92,108,19,19,12,108,92,108,92,108,19,108,92,92,92,92,92,92,19,
92,19,108,92,19,92,92,92,92,92,92,92,92,92,92,92,108,108,19,92,
92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,92,92,92,12,92,92,92,12,92,19,92,92,92,92,92,92,92,92,92,
92,92,92,92,92,92,92,92,92,108,19,92,92,223,92,92,92,92,92,92,
19,108,108,108,108,19,92,92,92,92,108,108,108,108,108,92,108,92,108,19,
92,19,108,108,19,108,108,108,108,108,19,19,19,19,19,19,108,108,53,19,
108,19,108,53,19,53,19,53,19,8,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,108,19,108,19,
19,19,19,19,108,19,108,19,108,19,108,19,19,19,19,108,19,92,92,92,
19,19,108,19,108,19,19,92,92,92,92,92,92,92,92,19,19,108,19,108,
19,92,19,92,92,92,92,92,92,92,92,92,92,92,92,19,92,92,92,92,
92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,92,92,19,19,19,92,19,19,92,19,19,108,92,92,92,19,92,92,92,
92,92,92,92,92,19,19,19,19,108,19,108,92,92,92,92,92,92,19,19,
92,19,223,19,108,19,108,92,19,19,19,19,19,19,108,19,108,19,108,19,
19,19,19,19,19,19,19,19,19,108,19,108,19,108,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,8};
/***** Magic numbers *****/

#define SCALE_WIDTH  200
#define ENTRY_WIDTH    6

/***** Color model *****/

#define RGB_MODEL 0
#define HSL_MODEL 1 

/***** Types *****/
typedef struct
{
  gdouble redfrequency;
  gdouble redangle;
  gdouble greenfrequency;
  gdouble greenangle;
  gdouble bluefrequency;
  gdouble blueangle;
  gint	  colormodel;
  gint    redmode;
  gint    greenmode;
  gint    bluemode;
} alienmap2_vals_t;

typedef struct
{
  gint run;
} alienmap2_interface_t;

/* Declare local functions. */

static void      query  (void);
static void      run    (char         *name,
        		 int           nparams,
        		 GimpParam    *param,
        		 int          *nreturn_vals,
        		 GimpParam   **return_vals);

static void      alienmap2 	       (GimpDrawable  *drawable);
static void    	 transform             (guchar*, guchar*, guchar*);

static gint      alienmap2_dialog        (void);
static void      dialog_update_preview   (void);
static void      dialog_scale_update     (GtkAdjustment *adjustment,
					  gdouble *value);
static void      dialog_ok_callback      (GtkWidget *widget, gpointer data);
static void      alienmap2_toggle_update (GtkWidget *widget,
					  gpointer   data);
static void      alienmap2_radio_update  (GtkWidget *widget,
					  gpointer   data);
static void      alienmap2_logo_dialog   (void);

/***** Variables *****/

static GimpRunMode run_mode;
static GimpFixMePreview *preview;

GimpPlugInInfo PLUG_IN_INFO =
{
  NULL,  /* init_proc  */
  NULL,  /* quit_proc  */
  query, /* query_proc */
  run,   /* run_proc   */
};

static alienmap2_interface_t wint =
{
  FALSE  /* run     */
};

static alienmap2_vals_t wvals =
{
  1.0,
  0.0,
  1.0,
  0.0,
  1.0,
  0.0,
  RGB_MODEL,
  TRUE,
  TRUE,
  TRUE,
};

static GimpDrawable *drawable;

/***** Functions *****/

MAIN ()

static void
query (void)
{
  static GimpParamDef args[] =
  {
    { GIMP_PDB_INT32,    "run_mode",       "Interactive, non-interactive" },
    { GIMP_PDB_IMAGE,    "image",          "Input image" },
    { GIMP_PDB_DRAWABLE, "drawable",       "Input drawable" },
    { GIMP_PDB_FLOAT,    "redfrequency",   "Red/hue component frequency factor" },
    { GIMP_PDB_FLOAT,    "redangle",       "Red/hue component angle factor (0-360)" },
    { GIMP_PDB_FLOAT,    "greenfrequency", "Green/saturation component frequency factor" },
    { GIMP_PDB_FLOAT,    "greenangle",     "Green/saturation component angle factor (0-360)" },
    { GIMP_PDB_FLOAT,    "bluefrequency",  "Blue/luminance component frequency factor" },
    { GIMP_PDB_FLOAT,    "blueangle",      "Blue/luminance component angle factor (0-360)" },
    { GIMP_PDB_INT8,     "colormodel",     "Color model (0: RGB_MODEL, 1: HSL_MODEL)" },
    { GIMP_PDB_INT8,     "redmode",        "Red/hue application mode (TRUE, FALSE)" },
    { GIMP_PDB_INT8,     "greenmode",      "Green/saturation application mode (TRUE, FALSE)" },
    { GIMP_PDB_INT8,     "bluemode",       "Blue/luminance application mode (TRUE, FALSE)" },
  };
  static GimpParamDef *return_vals = NULL;
  static int nreturn_vals = 0;

  gimp_install_procedure ("plug_in_alienmap2",
        		  "AlienMap2 Color Transformation Plug-In",
        		  "No help yet. Just try it and you'll see!",
        		  "Martin Weber (martweb@gmx.net)",
        		  "Martin Weber (martweb@gmx.net",
        		  "24th April 1998",
        		  N_("<Image>/Filters/Colors/Map/Alien Map 2..."),
        		  "RGB*",
        		  GIMP_PLUGIN,
        		  G_N_ELEMENTS (args), nreturn_vals,
        		  args, return_vals);
}

static void
transform (guchar *r,
	   guchar *g,
	   guchar *b)
{
  if (wvals.colormodel == HSL_MODEL)
    {
      gdouble h, s, l;
      GimpRGB rgb;

      gimp_rgb_set_uchar (&rgb, *r, *g, *b);
      gimp_rgb_to_hsl (&rgb, &h, &s, &l);
      h /= 360.0;

      if (wvals.redmode)
	h = 0.5*(1.0+sin(((2*h-1.0)*wvals.redfrequency+
			  wvals.redangle/180.0)*G_PI));
      if (wvals.greenmode)
	s = 0.5*(1.0+sin(((2*s-1.0)*wvals.greenfrequency+
			  wvals.greenangle/180.0)*G_PI));
      if (wvals.bluemode)
	l = 0.5*(1.0+sin(((2*l-1.0)*wvals.bluefrequency+
			  wvals.blueangle/180.0)*G_PI));

      h *= 360.0;
      gimp_hsl_to_rgb (h, s, l, &rgb);
      gimp_rgb_get_uchar (&rgb, r, g, b);
    }
  else if (wvals.colormodel == RGB_MODEL)
    {
      if (wvals.redmode)
	*r = (int) (127.5*(1.0+sin(((*r/127.5-1.0)*wvals.redfrequency+
				    wvals.redangle/180.0)*G_PI))+0.5);
      if (wvals.greenmode)
	*g = (int) (127.5*(1.0+sin(((*g/127.5-1.0)*wvals.greenfrequency
				    +wvals.greenangle/180.0)*G_PI))+0.5);
      if (wvals.bluemode)
	*b = (int) (127.5*(1.0+sin(((*b/127.5-1.0)*wvals.bluefrequency
				    +wvals.blueangle/180.0)*G_PI))+0.5);
    }
}

static void
run (gchar      *name,
     gint        nparams,
     GimpParam  *param,
     gint       *nreturn_vals,
     GimpParam **return_vals)
{
  static GimpParam values[1];
  GimpPDBStatusType status = GIMP_PDB_SUCCESS;

  INIT_I18N ();

  run_mode = param[0].data.d_int32;

  values[0].type = GIMP_PDB_STATUS;
  values[0].data.d_status = status;

  *nreturn_vals = 1;
  *return_vals = values;

  /*  Get the specified drawable  */
  drawable = gimp_drawable_get (param[2].data.d_drawable);

  /* See how we will run */
  switch (run_mode)
    {
    case GIMP_RUN_INTERACTIVE:
      /* Possibly retrieve data */
      gimp_get_data("plug_in_alienmap2", &wvals);

      /* Get information from the dialog */
      if (!alienmap2_dialog())
	return;

      break;

    case GIMP_RUN_NONINTERACTIVE:
      /* Make sure all the arguments are present */
      if (nparams != 13)
	status = GIMP_PDB_CALLING_ERROR;

      if (status == GIMP_PDB_SUCCESS)
	{
	  wvals.redfrequency   = param[3].data.d_float;
	  wvals.redangle       = param[4].data.d_float;
	  wvals.greenfrequency = param[5].data.d_float;
	  wvals.greenangle     = param[6].data.d_float;
	  wvals.bluefrequency  = param[7].data.d_float;
	  wvals.blueangle      = param[8].data.d_float;
	  wvals.colormodel     = param[9].data.d_int8;
	  wvals.redmode        = param[10].data.d_int8 ? TRUE : FALSE;
	  wvals.greenmode      = param[11].data.d_int8 ? TRUE : FALSE;
	  wvals.bluemode       = param[12].data.d_int8 ? TRUE : FALSE;
	}

      break;

    case GIMP_RUN_WITH_LAST_VALS:
      /* Possibly retrieve data */
      gimp_get_data("plug_in_alienmap2", &wvals);
      break;

    default:
      break;
    }

  if (status == GIMP_PDB_SUCCESS)
    {
      /*  Make sure that the drawable is indexed or RGB_MODEL color  */
      if (gimp_drawable_is_rgb (drawable->drawable_id))
        {
          gimp_progress_init (_("AlienMap2: Transforming..."));

	  /* Set the tile cache size */
	  gimp_tile_cache_ntiles(2*(drawable->width / gimp_tile_width()+1));

	  /* Run! */

          alienmap2 (drawable);
	  if (run_mode != GIMP_RUN_NONINTERACTIVE)
	    gimp_displays_flush();

	  /* Store data */
	  if (run_mode == GIMP_RUN_INTERACTIVE)
	    gimp_set_data("plug_in_alienmap2", &wvals, sizeof(alienmap2_vals_t));
        }
      else
        {
	  /* gimp_message("This filter only applies on RGB_MODEL-images"); */
          status = GIMP_PDB_EXECUTION_ERROR;
        }
    }

  values[0].data.d_status = status;

  gimp_drawable_detach (drawable);
}

static void 
alienmap2_func (guchar *src, guchar *dest, gint bpp, gpointer data)
{
  guchar v1, v2, v3;

  v1 = src[0];
  v2 = src[1];
  v3 = src[2];

  transform(&v1, &v2, &v3);

  dest[0] = v1;
  dest[1] = v2;
  dest[2] = v3;

  if (bpp == 4)
    dest[3] = src[3];
}

static void
alienmap2 (GimpDrawable *drawable)
{
  gimp_rgn_iterate2 (drawable, run_mode, alienmap2_func, NULL);
}

static gint
alienmap2_dialog (void)
{
  GtkWidget *dialog;
  GtkWidget *top_table;
  GtkWidget *frame;
  GtkWidget *toggle;
  GtkWidget *toggle_vbox;
  GtkWidget *sep;
  GtkWidget *table;
  GtkObject *adj;

  gimp_ui_init ("alienmap2", TRUE);

  dialog =
    gimp_dialog_new (_("AlienMap2"), "alienmap2",
		     gimp_standard_help_func, "filters/alienmap2.html",
		     GTK_WIN_POS_MOUSE,
		     FALSE, TRUE, FALSE,

		     _("About..."), alienmap2_logo_dialog,
		     NULL, NULL, NULL, FALSE, FALSE,

		     GTK_STOCK_CANCEL, gtk_widget_destroy,
		     NULL, 1, NULL, FALSE, TRUE,

		     GTK_STOCK_OK, dialog_ok_callback,
		     NULL, NULL, NULL, TRUE, FALSE,

		     NULL);

  g_signal_connect (dialog, "destroy",
                    G_CALLBACK (gtk_main_quit),
                    NULL);

  top_table = gtk_table_new (2, 2, FALSE);
  gtk_table_set_col_spacings (GTK_TABLE (top_table), 4);
  gtk_table_set_row_spacings (GTK_TABLE (top_table), 4);
  gtk_container_set_border_width (GTK_CONTAINER (top_table), 6);
  gtk_table_set_row_spacings (GTK_TABLE (top_table), 4);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), top_table,
		      FALSE, FALSE, 0);
  gtk_widget_show (top_table);

  /* Preview */
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_table_attach (GTK_TABLE (top_table), frame, 0, 1, 0, 1, 0, 0, 0, 0);
  gtk_widget_show (frame);

  preview = gimp_fixme_preview_new (NULL, FALSE);
  gimp_fixme_preview_fill_scaled (preview, drawable);
  gtk_container_add (GTK_CONTAINER (frame), preview->widget);
  gtk_widget_show (preview->widget);

  /* Controls */
  table = gtk_table_new (6, 3, FALSE);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_table_set_row_spacings (GTK_TABLE (table), 2);
  gtk_table_attach (GTK_TABLE (top_table), table, 0, 2, 1, 2,
		    GTK_EXPAND | GTK_FILL, 0, 0, 0);
  gtk_widget_show (table);

  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, 0,
			      _("R/H-_Frequency:"), SCALE_WIDTH, ENTRY_WIDTH,
			      wvals.redfrequency, 0, 5.0, 0.1, 1, 2,
			      TRUE, 0, 0,
			      _("Change frequency of the red/hue channel"),
			      NULL);
  g_signal_connect (adj, "value_changed",
                    G_CALLBACK (dialog_scale_update),
                    &wvals.redfrequency);

  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, 1,
			      _("R/H-_Phaseshift:"), SCALE_WIDTH, ENTRY_WIDTH,
			      wvals.redangle, 0, 360.0, 1, 15, 2,
			      TRUE, 0, 0,
			      _("Change angle of the red/hue channel"),
			      NULL);
  g_signal_connect (adj, "value_changed",
                    G_CALLBACK (dialog_scale_update),
                    &wvals.redangle);

  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, 2,
			      _("G/S-Fr_equency:"), SCALE_WIDTH, ENTRY_WIDTH,
			      wvals.greenfrequency, 0, 5.0, 0.1, 1, 2,
			      TRUE, 0, 0,
			      _("Change frequency of the green/saturation "
				"channel"), NULL);
  g_signal_connect (adj, "value_changed",
                    G_CALLBACK (dialog_scale_update),
                    &wvals.greenfrequency);

  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, 3,
			      _("G/S-Ph_aseshift:"), SCALE_WIDTH, ENTRY_WIDTH,
			      wvals.redangle, 0, 360.0, 1, 15, 2,
			      TRUE, 0, 0,
			      _("Change angle of the green/saturation channel"),
			      NULL);
  g_signal_connect (adj, "value_changed",
                    G_CALLBACK (dialog_scale_update),
                    &wvals.greenangle);

  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, 4,
			      _("B/L-Freq_uency:"), SCALE_WIDTH, ENTRY_WIDTH,
			      wvals.bluefrequency, 0, 5.0, 0.1, 1, 2,
			      TRUE, 0, 0,
			      _("Change frequency of the blue/luminance "
				"channel"), NULL);
  g_signal_connect (adj, "value_changed",
                    G_CALLBACK (dialog_scale_update),
                    &wvals.bluefrequency);

  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, 5,
			      _("B/L-Pha_seshift:"), SCALE_WIDTH, ENTRY_WIDTH,
			      wvals.blueangle, 0, 360.0, 1, 15, 2,
			      TRUE, 0, 0,
			      _("Change angle of the blue/luminance channel"),
			      NULL);
  g_signal_connect (adj, "value_changed",
                    G_CALLBACK (dialog_scale_update),
                    &wvals.blueangle);

  /*  Mode toggle box  */
  frame =
    gimp_radio_group_new2 (TRUE, _("Mode"),
			   G_CALLBACK (alienmap2_radio_update),
			   &wvals.colormodel, (gpointer) wvals.colormodel,

			   _("_RGB Color Model"), (gpointer) RGB_MODEL, NULL,
			   _("_HSL Color Model"), (gpointer) HSL_MODEL, NULL,

			   NULL);
  gtk_table_attach (GTK_TABLE (top_table), frame, 1, 2, 0, 1,
		    GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 0);

  toggle_vbox = GTK_BIN (frame)->child;

  sep = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (toggle_vbox), sep, FALSE, FALSE, 0);
  gtk_widget_show (sep);

  toggle = gtk_check_button_new_with_mnemonic (_("_Modify Red/Hue Channel"));
  gtk_box_pack_start (GTK_BOX (toggle_vbox), toggle, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), wvals.redmode);
  gtk_widget_show (toggle);

  gimp_help_set_help_data (toggle, _("Use function for red/hue component"),
			   NULL);

  g_signal_connect (toggle, "toggled",
                    G_CALLBACK (alienmap2_toggle_update),
                    &wvals.redmode);

  toggle = gtk_check_button_new_with_mnemonic (_("Mo_dify Green/Saturation Channel"));
  gtk_box_pack_start (GTK_BOX (toggle_vbox), toggle, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), wvals.greenmode);
  gtk_widget_show (toggle);

  gimp_help_set_help_data (toggle,
			   _("Use function for green/saturation component"),
			   NULL);

  g_signal_connect (toggle, "toggled",
                    G_CALLBACK (alienmap2_toggle_update),
                    &wvals.greenmode);

  toggle = gtk_check_button_new_with_mnemonic (_("Mod_ify Blue/Luminance Channel"));
  gtk_box_pack_start (GTK_BOX (toggle_vbox), toggle, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), wvals.bluemode);
  gtk_widget_show (toggle);

  gimp_help_set_help_data (toggle,
			   _("Use function for blue/luminance component"),
			   NULL);

  g_signal_connect (toggle, "toggled",
                    G_CALLBACK (alienmap2_toggle_update),
                    &wvals.bluemode);

  gtk_widget_show (frame);

  gtk_widget_show (dialog);
  dialog_update_preview ();

  gtk_main ();
  gdk_flush ();

  return wint.run;
}

static void
dialog_update_preview (void)
{
  gimp_fixme_preview_update (preview, alienmap2_func, NULL);
}

static void
dialog_scale_update (GtkAdjustment *adjustment,
		     gdouble       *value)
{
  gimp_double_adjustment_update (adjustment, value);

  dialog_update_preview();
}

static void
dialog_ok_callback (GtkWidget *widget,
		    gpointer   data)
{
  wint.run = TRUE;

  gtk_widget_destroy (GTK_WIDGET (data));
}

static void
alienmap2_toggle_update (GtkWidget *widget,
			 gpointer   data)
{
  gimp_toggle_button_update (widget, data);

  dialog_update_preview ();
}

static void
alienmap2_radio_update (GtkWidget *widget,
			gpointer   data)
{
  gimp_radio_button_update (widget, data);

  dialog_update_preview ();
}

static void
alienmap2_logo_dialog (void)
{
  static GtkWidget *logodlg = NULL;
  GtkWidget *xlabel;
  GtkWidget *xlogo_box;
  GtkWidget *xpreview;
  GtkWidget *xframe, *xframe2;
  GtkWidget *xvbox;
  GtkWidget *xhbox;
  gchar  *text;
  guchar *temp, *temp2;
  guchar *datapointer;
  gint    y,x;

  if (!logodlg)
    {
      logodlg = gimp_dialog_new (_("About AlienMap2"), "alienmap2",
				 gimp_standard_help_func, "filters/alienmap2.html",
				 GTK_WIN_POS_MOUSE,
				 FALSE, TRUE, FALSE,

				 GTK_STOCK_CLOSE, gtk_widget_hide,
				 NULL, 1, NULL, TRUE, TRUE,

				 NULL);

      g_signal_connect (logodlg, "destroy",
			G_CALLBACK (gtk_widget_destroyed),
			&logodlg);

      gtk_quit_add_destroy (1, GTK_OBJECT (logodlg));

      xframe = gtk_frame_new(NULL);
      gtk_frame_set_shadow_type (GTK_FRAME (xframe), GTK_SHADOW_ETCHED_IN);
      gtk_container_set_border_width (GTK_CONTAINER (xframe), 6);
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (logodlg)->vbox), xframe,
			  TRUE, TRUE, 0);
      xvbox = gtk_vbox_new (FALSE, 4);
      gtk_container_set_border_width (GTK_CONTAINER (xvbox), 4);
      gtk_container_add (GTK_CONTAINER(xframe), xvbox);
      
      /*  The logo frame & drawing area  */
      xhbox = gtk_hbox_new (FALSE, 5);
      gtk_box_pack_start (GTK_BOX (xvbox), xhbox, FALSE, TRUE, 0);

      xlogo_box = gtk_vbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (xhbox), xlogo_box, FALSE, FALSE, 0);

      xframe2 = gtk_frame_new (NULL);
      gtk_frame_set_shadow_type (GTK_FRAME (xframe2), GTK_SHADOW_IN);
      gtk_box_pack_start (GTK_BOX (xlogo_box), xframe2, FALSE, FALSE, 0);
      
      xpreview = gtk_preview_new (GTK_PREVIEW_COLOR);
      gtk_preview_size (GTK_PREVIEW (xpreview), logo_width, logo_height);
      temp = g_malloc ((logo_width + 10) * 3);
      datapointer = header_data+logo_width*logo_height-1;
      for (y = 0; y < logo_height; y++)
	{
	  temp2=temp;
	  for (x = 0; x< logo_width; x++)
	    {
	      HEADER_PIXEL (datapointer,temp2);
	      temp2 += 3;
	    }
	  gtk_preview_draw_row (GTK_PREVIEW (xpreview),
				temp,
				0, y, logo_width); 
	}			  
      g_free (temp);
      gtk_container_add (GTK_CONTAINER (xframe2), xpreview);
      gtk_widget_show (xpreview);
      gtk_widget_show (xframe2);
      gtk_widget_show (xlogo_box);
      gtk_widget_show (xhbox);

      xhbox = gtk_hbox_new(FALSE, 5);
      gtk_box_pack_start (GTK_BOX (xvbox), xhbox, TRUE, TRUE, 0);
      text = ("\nMartin Weber\n"
	      "martweb@gmx.net\n"
	      "\n"
	      "AlienMap2 Plug-In for the GIMP\n"
	      "Version 1.0\n");
      xlabel = gtk_label_new (text);
      gtk_box_pack_start (GTK_BOX (xhbox), xlabel, TRUE, FALSE, 0);
      gtk_widget_show (xlabel);

      gtk_widget_show (xhbox);

      gtk_widget_show (xvbox);
      gtk_widget_show (xframe);
      gtk_widget_show (logodlg);
    }
  else
    {
      gtk_window_present (GTK_WINDOW (logodlg));
    }
}
