/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpvectors_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include <string.h>

#include "gimp.h"

/**
 * gimp_vectors_get_strokes:
 * @vectors_ID: The vectors object.
 * @num_strokes: The number of strokes returned.
 *
 * List the strokes associated with the passed path.
 *
 * Returns an Array with the stroke-IDs associated with the passed
 * path.
 *
 * Returns: List of the paths belonging to this image.
 *
 * Since: GIMP 2.4
 */
gint *
gimp_vectors_get_strokes (gint32  vectors_ID,
			  gint   *num_strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint *stroke_list = NULL;

  return_vals = gimp_run_procedure ("gimp_vectors_get_strokes",
				    &nreturn_vals,
				    GIMP_PDB_PATH, vectors_ID,
				    GIMP_PDB_END);

  *num_strokes = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_strokes = return_vals[1].data.d_int32;
      stroke_list = g_new (gint32, *num_strokes);
      memcpy (stroke_list, return_vals[2].data.d_int32array,
	      *num_strokes * sizeof (gint32));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return stroke_list;
}
