/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "config/gimpcoreconfig.h"
#include "core/gimp.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage-undo.h"
#include "core/gimpimage.h"
#include "core/gimpitem-linked.h"
#include "core/gimplayer.h"
#include "core/gimplayermask.h"
#include "gimp-intl.h"
#include "pdb_glue.h"

static ProcRecord layer_new_proc;
static ProcRecord layer_new_from_drawable_proc;
static ProcRecord layer_copy_proc;
static ProcRecord layer_add_alpha_proc;
static ProcRecord layer_scale_proc;
static ProcRecord layer_resize_proc;
static ProcRecord layer_resize_to_image_size_proc;
static ProcRecord layer_translate_proc;
static ProcRecord layer_set_offsets_proc;
static ProcRecord layer_create_mask_proc;
static ProcRecord layer_get_mask_proc;
static ProcRecord layer_from_mask_proc;
static ProcRecord layer_add_mask_proc;
static ProcRecord layer_remove_mask_proc;
static ProcRecord layer_is_floating_sel_proc;
static ProcRecord layer_get_preserve_trans_proc;
static ProcRecord layer_set_preserve_trans_proc;
static ProcRecord layer_get_apply_mask_proc;
static ProcRecord layer_set_apply_mask_proc;
static ProcRecord layer_get_show_mask_proc;
static ProcRecord layer_set_show_mask_proc;
static ProcRecord layer_get_edit_mask_proc;
static ProcRecord layer_set_edit_mask_proc;
static ProcRecord layer_get_opacity_proc;
static ProcRecord layer_set_opacity_proc;
static ProcRecord layer_get_mode_proc;
static ProcRecord layer_set_mode_proc;

void
register_layer_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &layer_new_proc);
  procedural_db_register (gimp, &layer_new_from_drawable_proc);
  procedural_db_register (gimp, &layer_copy_proc);
  procedural_db_register (gimp, &layer_add_alpha_proc);
  procedural_db_register (gimp, &layer_scale_proc);
  procedural_db_register (gimp, &layer_resize_proc);
  procedural_db_register (gimp, &layer_resize_to_image_size_proc);
  procedural_db_register (gimp, &layer_translate_proc);
  procedural_db_register (gimp, &layer_set_offsets_proc);
  procedural_db_register (gimp, &layer_create_mask_proc);
  procedural_db_register (gimp, &layer_get_mask_proc);
  procedural_db_register (gimp, &layer_from_mask_proc);
  procedural_db_register (gimp, &layer_add_mask_proc);
  procedural_db_register (gimp, &layer_remove_mask_proc);
  procedural_db_register (gimp, &layer_is_floating_sel_proc);
  procedural_db_register (gimp, &layer_get_preserve_trans_proc);
  procedural_db_register (gimp, &layer_set_preserve_trans_proc);
  procedural_db_register (gimp, &layer_get_apply_mask_proc);
  procedural_db_register (gimp, &layer_set_apply_mask_proc);
  procedural_db_register (gimp, &layer_get_show_mask_proc);
  procedural_db_register (gimp, &layer_set_show_mask_proc);
  procedural_db_register (gimp, &layer_get_edit_mask_proc);
  procedural_db_register (gimp, &layer_set_edit_mask_proc);
  procedural_db_register (gimp, &layer_get_opacity_proc);
  procedural_db_register (gimp, &layer_set_opacity_proc);
  procedural_db_register (gimp, &layer_get_mode_proc);
  procedural_db_register (gimp, &layer_set_mode_proc);
}

static Argument *
layer_new_invoker (Gimp         *gimp,
                   GimpContext  *context,
                   GimpProgress *progress,
                   Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpImage *gimage;
  gint32 width;
  gint32 height;
  gint32 type;
  gchar *name;
  gdouble opacity;
  gint32 mode;
  GimpLayer *layer = NULL;

  gimage = gimp_image_get_by_ID (gimp, args[0].value.pdb_int);
  if (! GIMP_IS_IMAGE (gimage))
    success = FALSE;

  width = args[1].value.pdb_int;
  if (width <= 0)
    success = FALSE;

  height = args[2].value.pdb_int;
  if (height <= 0)
    success = FALSE;

  type = args[3].value.pdb_int;
  if (type < GIMP_RGB_IMAGE || type > GIMP_INDEXEDA_IMAGE)
    success = FALSE;

  name = (gchar *) args[4].value.pdb_pointer;
  if (name && !g_utf8_validate (name, -1, NULL))
    success = FALSE;

  opacity = args[5].value.pdb_float;
  if (opacity < 0.0 || opacity > 100.0)
    success = FALSE;

  mode = args[6].value.pdb_int;
  if (mode < GIMP_NORMAL_MODE || mode > GIMP_COLOR_ERASE_MODE)
    success = FALSE;

  if (success)
    {
      layer = gimp_layer_new (gimage,
                              width, height,
                              type,
                              name,
                              opacity / 100.0, mode);
      success = (layer != NULL);
    }

  return_args = procedural_db_return_args (&layer_new_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (layer));

  return return_args;
}

static ProcArg layer_new_inargs[] =
{
  {
    GIMP_PDB_IMAGE,
    "image",
    "The image to which to add the layer"
  },
  {
    GIMP_PDB_INT32,
    "width",
    "The layer width: (0 < width)"
  },
  {
    GIMP_PDB_INT32,
    "height",
    "The layer height: (0 < height)"
  },
  {
    GIMP_PDB_INT32,
    "type",
    "The layer type: { GIMP_RGB_IMAGE (0), GIMP_RGBA_IMAGE (1), GIMP_GRAY_IMAGE (2), GIMP_GRAYA_IMAGE (3), GIMP_INDEXED_IMAGE (4), GIMP_INDEXEDA_IMAGE (5) }"
  },
  {
    GIMP_PDB_STRING,
    "name",
    "The layer name"
  },
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The layer opacity: (0 <= opacity <= 100)"
  },
  {
    GIMP_PDB_INT32,
    "mode",
    "The layer combination mode: { GIMP_NORMAL_MODE (0), GIMP_DISSOLVE_MODE (1), GIMP_BEHIND_MODE (2), GIMP_MULTIPLY_MODE (3), GIMP_SCREEN_MODE (4), GIMP_OVERLAY_MODE (5), GIMP_DIFFERENCE_MODE (6), GIMP_ADDITION_MODE (7), GIMP_SUBTRACT_MODE (8), GIMP_DARKEN_ONLY_MODE (9), GIMP_LIGHTEN_ONLY_MODE (10), GIMP_HUE_MODE (11), GIMP_SATURATION_MODE (12), GIMP_COLOR_MODE (13), GIMP_VALUE_MODE (14), GIMP_DIVIDE_MODE (15), GIMP_DODGE_MODE (16), GIMP_BURN_MODE (17), GIMP_HARDLIGHT_MODE (18), GIMP_SOFTLIGHT_MODE (19), GIMP_GRAIN_EXTRACT_MODE (20), GIMP_GRAIN_MERGE_MODE (21), GIMP_COLOR_ERASE_MODE (22) }"
  }
};

static ProcArg layer_new_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The newly created layer"
  }
};

static ProcRecord layer_new_proc =
{
  "gimp_layer_new",
  "Create a new layer.",
  "This procedure creates a new layer with the specified width, height, and type. Name, opacity, and mode are also supplied parameters. The new layer still needs to be added to the image, as this is not automatic. Add the new layer with the 'gimp_image_add_layer' command. Other attributes such as layer mask modes, and offsets should be set with explicit procedure calls.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  7,
  layer_new_inargs,
  1,
  layer_new_outargs,
  { { layer_new_invoker } }
};

static Argument *
layer_new_from_drawable_invoker (Gimp         *gimp,
                                 GimpContext  *context,
                                 GimpProgress *progress,
                                 Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpDrawable *drawable;
  GimpImage *dest_image;
  GimpLayer *layer_copy = NULL;

  drawable = (GimpDrawable *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_DRAWABLE (drawable) && ! gimp_item_is_removed (GIMP_ITEM (drawable))))
    success = FALSE;

  dest_image = gimp_image_get_by_ID (gimp, args[1].value.pdb_int);
  if (! GIMP_IS_IMAGE (dest_image))
    success = FALSE;

  if (success)
    {
      GType     new_type;
      GimpItem *new_item;

      if (GIMP_IS_LAYER (drawable))
        new_type = G_TYPE_FROM_INSTANCE (drawable);
      else
        new_type = GIMP_TYPE_LAYER;

      if (dest_image == gimp_item_get_image (GIMP_ITEM (drawable)))
        new_item = gimp_item_duplicate (GIMP_ITEM (drawable), new_type, TRUE);
      else
        new_item = gimp_item_convert (GIMP_ITEM (drawable), dest_image, new_type, TRUE);

      if (new_item)
        layer_copy = GIMP_LAYER (new_item);
      else
        success = FALSE;
    }

  return_args = procedural_db_return_args (&layer_new_from_drawable_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (layer_copy));

  return return_args;
}

static ProcArg layer_new_from_drawable_inargs[] =
{
  {
    GIMP_PDB_DRAWABLE,
    "drawable",
    "The source drawable from where the new layer is copied"
  },
  {
    GIMP_PDB_IMAGE,
    "dest_image",
    "The destination image to which to add the layer"
  }
};

static ProcArg layer_new_from_drawable_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer_copy",
    "The newly copied layer"
  }
};

static ProcRecord layer_new_from_drawable_proc =
{
  "gimp_layer_new_from_drawable",
  "Create a new layer by copying an existing drawable.",
  "This procedure creates a new layer as a copy of the specified drawable. The new layer still needs to be added to the image, as this is not automatic. Add the new layer with the 'gimp_image_add_layer' command. Other attributes such as layer mask modes, and offsets should be set with explicit procedure calls.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_new_from_drawable_inargs,
  1,
  layer_new_from_drawable_outargs,
  { { layer_new_from_drawable_invoker } }
};

static Argument *
layer_copy_invoker (Gimp         *gimp,
                    GimpContext  *context,
                    GimpProgress *progress,
                    Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;
  gboolean add_alpha;
  GimpLayer *layer_copy = NULL;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  add_alpha = args[1].value.pdb_int ? TRUE : FALSE;

  if (success)
    success = (layer_copy = GIMP_LAYER (gimp_item_duplicate (GIMP_ITEM (layer), G_TYPE_FROM_INSTANCE (layer), add_alpha))) != NULL;

  return_args = procedural_db_return_args (&layer_copy_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (layer_copy));

  return return_args;
}

static ProcArg layer_copy_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to copy"
  },
  {
    GIMP_PDB_INT32,
    "add_alpha",
    "Add an alpha channel to the copied layer"
  }
};

static ProcArg layer_copy_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer_copy",
    "The newly copied layer"
  }
};

static ProcRecord layer_copy_proc =
{
  "gimp_layer_copy",
  "Copy a layer.",
  "This procedure copies the specified layer and returns the copy. The newly copied layer is for use within the original layer's image. It should not be subsequently added to any other image. The copied layer can optionally have an added alpha channel. This is useful if the background layer in an image is being copied and added to the same image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_copy_inargs,
  1,
  layer_copy_outargs,
  { { layer_copy_invoker } }
};

static Argument *
layer_add_alpha_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  if (success)
    gimp_layer_add_alpha (layer);

  return procedural_db_return_args (&layer_add_alpha_proc, success);
}

static ProcArg layer_add_alpha_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcRecord layer_add_alpha_proc =
{
  "gimp_layer_add_alpha",
  "Add an alpha channel to the layer if it doesn't already have one.",
  "This procedure adds an additional component to the specified layer if it does not already possess an alpha channel. An alpha channel makes it possible to move a layer from the bottom of the layer stack and to clear and erase to transparency, instead of the background color. This transforms images of type RGB to RGBA, GRAY to GRAYA, and INDEXED to INDEXEDA.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_add_alpha_inargs,
  0,
  NULL,
  { { layer_add_alpha_invoker } }
};

static Argument *
layer_scale_invoker (Gimp         *gimp,
                     GimpContext  *context,
                     GimpProgress *progress,
                     Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 new_width;
  gint32 new_height;
  gboolean local_origin;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  new_width = args[1].value.pdb_int;
  if (new_width <= 0)
    success = FALSE;

  new_height = args[2].value.pdb_int;
  if (new_height <= 0)
    success = FALSE;

  local_origin = args[3].value.pdb_int ? TRUE : FALSE;

  if (success)
    {
      success = gimp_item_is_attached (GIMP_ITEM (layer));

      if (success)
        gimp_item_scale_by_origin (GIMP_ITEM (layer), new_width, new_height, gimp->config->interpolation_type, NULL, local_origin);
    }

  return procedural_db_return_args (&layer_scale_proc, success);
}

static ProcArg layer_scale_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "new_width",
    "New layer width: (0 < new_width)"
  },
  {
    GIMP_PDB_INT32,
    "new_height",
    "New layer height: (0 < new_height)"
  },
  {
    GIMP_PDB_INT32,
    "local_origin",
    "Use a local origin (as opposed to the image origin)"
  }
};

static ProcRecord layer_scale_proc =
{
  "gimp_layer_scale",
  "Scale the layer to the specified extents.",
  "This procedure scales the layer so that it's new width and height are equal to the supplied parameters. The \"local_origin\" parameter specifies whether to scale from the center of the layer, or from the image origin. This operation only works if the layer has been added to an image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  4,
  layer_scale_inargs,
  0,
  NULL,
  { { layer_scale_invoker } }
};

static Argument *
layer_resize_invoker (Gimp         *gimp,
                      GimpContext  *context,
                      GimpProgress *progress,
                      Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 new_width;
  gint32 new_height;
  gint32 offx;
  gint32 offy;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  new_width = args[1].value.pdb_int;
  if (new_width <= 0)
    success = FALSE;

  new_height = args[2].value.pdb_int;
  if (new_height <= 0)
    success = FALSE;

  offx = args[3].value.pdb_int;

  offy = args[4].value.pdb_int;

  if (success)
    {
      success = gimp_item_is_attached (GIMP_ITEM (layer));

      if (success)
        gimp_item_resize (GIMP_ITEM (layer), context, new_width, new_height, offx, offy);
    }

  return procedural_db_return_args (&layer_resize_proc, success);
}

static ProcArg layer_resize_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "new_width",
    "New layer width: (0 < new_width)"
  },
  {
    GIMP_PDB_INT32,
    "new_height",
    "New layer height: (0 < new_height)"
  },
  {
    GIMP_PDB_INT32,
    "offx",
    "x offset between upper left corner of old and new layers: (old - new)"
  },
  {
    GIMP_PDB_INT32,
    "offy",
    "y offset between upper left corner of old and new layers: (old - new)"
  }
};

static ProcRecord layer_resize_proc =
{
  "gimp_layer_resize",
  "Resize the layer to the specified extents.",
  "This procedure resizes the layer so that it's new width and height are equal to the supplied parameters. Offsets are also provided which describe the position of the previous layer's content. This operation only works if the layer has been added to an image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  5,
  layer_resize_inargs,
  0,
  NULL,
  { { layer_resize_invoker } }
};

static Argument *
layer_resize_to_image_size_invoker (Gimp         *gimp,
                                    GimpContext  *context,
                                    GimpProgress *progress,
                                    Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  if (success)
    {
      success = gimp_item_is_attached (GIMP_ITEM (layer));

      if (success)
        gimp_layer_resize_to_image (layer, context);
    }

  return procedural_db_return_args (&layer_resize_to_image_size_proc, success);
}

static ProcArg layer_resize_to_image_size_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to resize"
  }
};

static ProcRecord layer_resize_to_image_size_proc =
{
  "gimp_layer_resize_to_image_size",
  "Resize a layer to the image size.",
  "This procedure resizes the layer so that it's new width and height are equal to the width and height of its image container.",
  "Manish Singh",
  "Manish Singh",
  "2003",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_resize_to_image_size_inargs,
  0,
  NULL,
  { { layer_resize_to_image_size_invoker } }
};

static Argument *
layer_translate_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 offx;
  gint32 offy;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  offx = args[1].value.pdb_int;

  offy = args[2].value.pdb_int;

  if (success)
    {
      GimpImage *gimage = gimp_item_get_image (GIMP_ITEM (layer));

      gimp_image_undo_group_start (gimage, GIMP_UNDO_GROUP_ITEM_DISPLACE,
                                   _("Move Layer"));

      gimp_item_translate (GIMP_ITEM (layer), offx, offy, TRUE);

      if (gimp_item_get_linked (GIMP_ITEM (layer)))
        gimp_item_linked_translate (GIMP_ITEM (layer), offx, offy, TRUE);

      gimp_image_undo_group_end (gimage);
    }

  return procedural_db_return_args (&layer_translate_proc, success);
}

static ProcArg layer_translate_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "offx",
    "Offset in x direction"
  },
  {
    GIMP_PDB_INT32,
    "offy",
    "Offset in y direction"
  }
};

static ProcRecord layer_translate_proc =
{
  "gimp_layer_translate",
  "Translate the layer by the specified offsets.",
  "This procedure translates the layer by the amounts specified in the x and y arguments. These can be negative, and are considered offsets from the current position. This command only works if the layer has been added to an image. All additional layers contained in the image which have the linked flag set to TRUE w ill also be translated by the specified offsets.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  layer_translate_inargs,
  0,
  NULL,
  { { layer_translate_invoker } }
};

static Argument *
layer_set_offsets_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 offx;
  gint32 offy;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  offx = args[1].value.pdb_int;

  offy = args[2].value.pdb_int;

  if (success)
    {
      GimpImage *gimage = gimp_item_get_image (GIMP_ITEM (layer));

      gimp_image_undo_group_start (gimage, GIMP_UNDO_GROUP_ITEM_DISPLACE,
                                   _("Move Layer"));

      gimp_item_translate (GIMP_ITEM (layer), offx - GIMP_ITEM (layer)->offset_x, offy - GIMP_ITEM (layer)->offset_y, TRUE);

      if (gimp_item_get_linked (GIMP_ITEM (layer)))
        gimp_item_linked_translate (GIMP_ITEM (layer), offx, offy, TRUE);

      gimp_image_undo_group_end (gimage);
    }

  return procedural_db_return_args (&layer_set_offsets_proc, success);
}

static ProcArg layer_set_offsets_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "offx",
    "Offset in x direction"
  },
  {
    GIMP_PDB_INT32,
    "offy",
    "Offset in y direction"
  }
};

static ProcRecord layer_set_offsets_proc =
{
  "gimp_layer_set_offsets",
  "Set the layer offsets.",
  "This procedure sets the offsets for the specified layer. The offsets are relative to the image origin and can be any values. This operation is valid only on layers which have been added to an image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  3,
  layer_set_offsets_inargs,
  0,
  NULL,
  { { layer_set_offsets_invoker } }
};

static Argument *
layer_create_mask_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;
  gint32 mask_type;
  GimpLayerMask *mask = NULL;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  mask_type = args[1].value.pdb_int;
  if (mask_type < GIMP_ADD_WHITE_MASK || mask_type > GIMP_ADD_COPY_MASK)
    success = FALSE;

  if (success)
    success = (mask = gimp_layer_create_mask (layer, (GimpAddMaskType) mask_type)) != NULL;

  return_args = procedural_db_return_args (&layer_create_mask_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_item_get_ID (GIMP_ITEM (mask));

  return return_args;
}

static ProcArg layer_create_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to which to add the mask"
  },
  {
    GIMP_PDB_INT32,
    "mask_type",
    "The type of mask: { GIMP_ADD_WHITE_MASK (0), GIMP_ADD_BLACK_MASK (1), GIMP_ADD_ALPHA_MASK (2), GIMP_ADD_ALPHA_TRANSFER_MASK (3), GIMP_ADD_SELECTION_MASK (4), GIMP_ADD_COPY_MASK (5) }"
  }
};

static ProcArg layer_create_mask_outargs[] =
{
  {
    GIMP_PDB_CHANNEL,
    "mask",
    "The newly created mask"
  }
};

static ProcRecord layer_create_mask_proc =
{
  "gimp_layer_create_mask",
  "Create a layer mask for the specified specified layer.",
  "This procedure creates a layer mask for the specified layer. Layer masks serve as an additional alpha channel for a layer. A number of ifferent types of masks are allowed for initialisation: completely white masks (which will leave the layer fully visible), completely black masks (which will give the layer complete transparency, the layer's already existing alpha channel (which will leave the layer fully visible, but which may be more useful than a white mask), the current selection or a grayscale copy of the layer. The layer mask still needs to be added to the layer. This can be done with a call to 'gimp_layer_add_mask'.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_create_mask_inargs,
  1,
  layer_create_mask_outargs,
  { { layer_create_mask_invoker } }
};

static Argument *
layer_get_mask_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  return_args = procedural_db_return_args (&layer_get_mask_proc, success);

  if (success)
    return_args[1].value.pdb_int = layer->mask ? gimp_item_get_ID (GIMP_ITEM (layer->mask)) : -1;

  return return_args;
}

static ProcArg layer_get_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcArg layer_get_mask_outargs[] =
{
  {
    GIMP_PDB_CHANNEL,
    "mask",
    "The layer mask"
  }
};

static ProcRecord layer_get_mask_proc =
{
  "gimp_layer_get_mask",
  "Get the specified layer's mask if it exists.",
  "This procedure returns the specified layer's mask, or -1 if none exists.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_get_mask_inargs,
  1,
  layer_get_mask_outargs,
  { { layer_get_mask_invoker } }
};

static Argument *
layer_from_mask_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayerMask *mask;
  GimpLayer *layer = NULL;

  mask = (GimpLayerMask *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER_MASK (mask) && ! gimp_item_is_removed (GIMP_ITEM (mask))))
    success = FALSE;

  if (success)
    {
      layer = gimp_layer_mask_get_layer (mask);
    }

  return_args = procedural_db_return_args (&layer_from_mask_proc, success);

  if (success)
    return_args[1].value.pdb_int = layer ? gimp_item_get_ID (GIMP_ITEM (layer)) : -1;

  return return_args;
}

static ProcArg layer_from_mask_inargs[] =
{
  {
    GIMP_PDB_CHANNEL,
    "mask",
    "Mask for which to return the layer"
  }
};

static ProcArg layer_from_mask_outargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The mask's layer"
  }
};

static ProcRecord layer_from_mask_proc =
{
  "gimp_layer_from_mask",
  "Get the specified mask's layer.",
  "This procedure returns the specified mask's layer , or -1 if none exists.",
  "Geert Jordaens",
  "Geert Jordaens",
  "2004",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_from_mask_inargs,
  1,
  layer_from_mask_outargs,
  { { layer_from_mask_invoker } }
};

static Argument *
layer_add_mask_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  GimpLayerMask *mask;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  mask = (GimpLayerMask *) gimp_item_get_by_ID (gimp, args[1].value.pdb_int);
  if (! (GIMP_IS_LAYER_MASK (mask) && ! gimp_item_is_removed (GIMP_ITEM (mask))))
    success = FALSE;

  if (success)
    {
      success = gimp_item_is_attached (GIMP_ITEM (layer));

      if (success)
        gimp_layer_add_mask (layer, mask, TRUE);
    }

  return procedural_db_return_args (&layer_add_mask_proc, success);
}

static ProcArg layer_add_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer to receive the mask"
  },
  {
    GIMP_PDB_CHANNEL,
    "mask",
    "The mask to add to the layer"
  }
};

static ProcRecord layer_add_mask_proc =
{
  "gimp_layer_add_mask",
  "Add a layer mask to the specified layer.",
  "This procedure adds a layer mask to the specified layer. Layer masks serve as an additional alpha channel for a layer. This procedure will fail if a number of prerequisites aren't met. The layer cannot already have a layer mask. The specified mask must exist and have the same dimensions as the layer. Both the mask and the layer must have been created for use with the specified image.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_add_mask_inargs,
  0,
  NULL,
  { { layer_add_mask_invoker } }
};

static Argument *
layer_remove_mask_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 mode;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  mode = args[1].value.pdb_int;
  if (mode < GIMP_MASK_APPLY || mode > GIMP_MASK_DISCARD)
    success = FALSE;

  if (success)
    {
      success = gimp_item_is_attached (GIMP_ITEM (layer));

      if (success)
        gimp_layer_apply_mask (layer, mode, TRUE);
    }

  return procedural_db_return_args (&layer_remove_mask_proc, success);
}

static ProcArg layer_remove_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer from which to remove mask"
  },
  {
    GIMP_PDB_INT32,
    "mode",
    "Removal mode: { GIMP_MASK_APPLY (0), GIMP_MASK_DISCARD (1) }"
  }
};

static ProcRecord layer_remove_mask_proc =
{
  "gimp_layer_remove_mask",
  "Remove the specified layer mask from the layer.",
  "This procedure removes the specified layer mask from the layer. If the mask doesn't exist, an error is returned.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_remove_mask_inargs,
  0,
  NULL,
  { { layer_remove_mask_invoker } }
};

static Argument *
layer_is_floating_sel_invoker (Gimp         *gimp,
                               GimpContext  *context,
                               GimpProgress *progress,
                               Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  return_args = procedural_db_return_args (&layer_is_floating_sel_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_layer_is_floating_sel (layer);

  return return_args;
}

static ProcArg layer_is_floating_sel_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcArg layer_is_floating_sel_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "is_floating_sel",
    "Non-zero if the layer is a floating selection"
  }
};

static ProcRecord layer_is_floating_sel_proc =
{
  "gimp_layer_is_floating_sel",
  "Is the specified layer a floating selection?",
  "This procedure returns whether the layer is a floating selection. Floating selections are special cases of layers which are attached to a specific drawable.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_is_floating_sel_inargs,
  1,
  layer_is_floating_sel_outargs,
  { { layer_is_floating_sel_invoker } }
};

static Argument *
layer_get_preserve_trans_invoker (Gimp         *gimp,
                                  GimpContext  *context,
                                  GimpProgress *progress,
                                  Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  return_args = procedural_db_return_args (&layer_get_preserve_trans_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_layer_get_preserve_trans (layer);

  return return_args;
}

static ProcArg layer_get_preserve_trans_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcArg layer_get_preserve_trans_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "preserve_trans",
    "The layer's preserve transperancy setting"
  }
};

static ProcRecord layer_get_preserve_trans_proc =
{
  "gimp_layer_get_preserve_trans",
  "Get the preserve transperancy setting of the specified layer.",
  "This procedure returns the specified layer's preserve transperancy setting.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_get_preserve_trans_inargs,
  1,
  layer_get_preserve_trans_outargs,
  { { layer_get_preserve_trans_invoker } }
};

static Argument *
layer_set_preserve_trans_invoker (Gimp         *gimp,
                                  GimpContext  *context,
                                  GimpProgress *progress,
                                  Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean preserve_trans;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  preserve_trans = args[1].value.pdb_int ? TRUE : FALSE;

  if (success)
    gimp_layer_set_preserve_trans (layer, preserve_trans, TRUE);

  return procedural_db_return_args (&layer_set_preserve_trans_proc, success);
}

static ProcArg layer_set_preserve_trans_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "preserve_trans",
    "The new layer's preserve transperancy setting"
  }
};

static ProcRecord layer_set_preserve_trans_proc =
{
  "gimp_layer_set_preserve_trans",
  "Set the preserve transperancy setting of the specified layer.",
  "This procedure sets the specified layer's preserve transperancy setting.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_set_preserve_trans_inargs,
  0,
  NULL,
  { { layer_set_preserve_trans_invoker } }
};

static Argument *
layer_get_apply_mask_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  return_args = procedural_db_return_args (&layer_get_apply_mask_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_layer_get_apply_mask (layer);

  return return_args;
}

static ProcArg layer_get_apply_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcArg layer_get_apply_mask_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "apply_mask",
    "The layer apply mask"
  }
};

static ProcRecord layer_get_apply_mask_proc =
{
  "gimp_layer_get_apply_mask",
  "Get the apply mask of the specified layer.",
  "This procedure returns the specified layer's apply mask. If the value is non-zero, then the layer mask for this layer is currently being composited with the layer's alpha channel.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_get_apply_mask_inargs,
  1,
  layer_get_apply_mask_outargs,
  { { layer_get_apply_mask_invoker } }
};

static Argument *
layer_set_apply_mask_invoker (Gimp         *gimp,
                              GimpContext  *context,
                              GimpProgress *progress,
                              Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean apply_mask;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  apply_mask = args[1].value.pdb_int ? TRUE : FALSE;

  if (success)
    gimp_layer_set_apply_mask (layer, apply_mask);

  return procedural_db_return_args (&layer_set_apply_mask_proc, success);
}

static ProcArg layer_set_apply_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "apply_mask",
    "The new layer apply mask"
  }
};

static ProcRecord layer_set_apply_mask_proc =
{
  "gimp_layer_set_apply_mask",
  "Set the apply mask of the specified layer.",
  "This procedure sets the specified layer's apply mask. This controls whether the layer's mask is currently affecting the alpha channel. If there is no layer mask, this function will return an error.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_set_apply_mask_inargs,
  0,
  NULL,
  { { layer_set_apply_mask_invoker } }
};

static Argument *
layer_get_show_mask_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  return_args = procedural_db_return_args (&layer_get_show_mask_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_layer_get_show_mask (layer);

  return return_args;
}

static ProcArg layer_get_show_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcArg layer_get_show_mask_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "show_mask",
    "The layer show mask"
  }
};

static ProcRecord layer_get_show_mask_proc =
{
  "gimp_layer_get_show_mask",
  "Get the show mask of the specified layer.",
  "This procedure returns the specified layer's show mask. If the value is non-zero, then the layer mask for this layer is currently being shown instead of the layer.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_get_show_mask_inargs,
  1,
  layer_get_show_mask_outargs,
  { { layer_get_show_mask_invoker } }
};

static Argument *
layer_set_show_mask_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean show_mask;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  show_mask = args[1].value.pdb_int ? TRUE : FALSE;

  if (success)
    gimp_layer_set_show_mask (layer, show_mask);

  return procedural_db_return_args (&layer_set_show_mask_proc, success);
}

static ProcArg layer_set_show_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "show_mask",
    "The new layer show mask"
  }
};

static ProcRecord layer_set_show_mask_proc =
{
  "gimp_layer_set_show_mask",
  "Set the show mask of the specified layer.",
  "This procedure sets the specified layer's show mask. This controls whether the layer or it's mask is visible. Non-zero values indicate that the mask should be visible. If the layer has no mask, then this function returns an error.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_set_show_mask_inargs,
  0,
  NULL,
  { { layer_set_show_mask_invoker } }
};

static Argument *
layer_get_edit_mask_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  return_args = procedural_db_return_args (&layer_get_edit_mask_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_layer_get_edit_mask (layer);

  return return_args;
}

static ProcArg layer_get_edit_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcArg layer_get_edit_mask_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "edit_mask",
    "The layer edit mask"
  }
};

static ProcRecord layer_get_edit_mask_proc =
{
  "gimp_layer_get_edit_mask",
  "Get the edit mask of the specified layer.",
  "This procedure returns the specified layer's edit mask. If the value is non-zero, then the layer mask for this layer is currently active, and not the layer.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_get_edit_mask_inargs,
  1,
  layer_get_edit_mask_outargs,
  { { layer_get_edit_mask_invoker } }
};

static Argument *
layer_set_edit_mask_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gboolean edit_mask;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  edit_mask = args[1].value.pdb_int ? TRUE : FALSE;

  if (success)
    gimp_layer_set_edit_mask (layer, edit_mask);

  return procedural_db_return_args (&layer_set_edit_mask_proc, success);
}

static ProcArg layer_set_edit_mask_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "edit_mask",
    "The new layer edit mask"
  }
};

static ProcRecord layer_set_edit_mask_proc =
{
  "gimp_layer_set_edit_mask",
  "Set the edit mask of the specified layer.",
  "This procedure sets the specified layer's edit mask. This controls whether the layer or it's mask is currently active for editing. If the specified layer has no layer mask, then this procedure will return an error.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_set_edit_mask_inargs,
  0,
  NULL,
  { { layer_set_edit_mask_invoker } }
};

static Argument *
layer_get_opacity_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  return_args = procedural_db_return_args (&layer_get_opacity_proc, success);

  if (success)
    return_args[1].value.pdb_float = gimp_layer_get_opacity (layer) * 100.0;

  return return_args;
}

static ProcArg layer_get_opacity_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcArg layer_get_opacity_outargs[] =
{
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The layer opacity"
  }
};

static ProcRecord layer_get_opacity_proc =
{
  "gimp_layer_get_opacity",
  "Get the opacity of the specified layer.",
  "This procedure returns the specified layer's opacity.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_get_opacity_inargs,
  1,
  layer_get_opacity_outargs,
  { { layer_get_opacity_invoker } }
};

static Argument *
layer_set_opacity_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gdouble opacity;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  opacity = args[1].value.pdb_float;
  if (opacity < 0.0 || opacity > 100.0)
    success = FALSE;

  if (success)
    gimp_layer_set_opacity (layer, opacity / 100.0, TRUE);

  return procedural_db_return_args (&layer_set_opacity_proc, success);
}

static ProcArg layer_set_opacity_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_FLOAT,
    "opacity",
    "The new layer opacity (0 <= opacity <= 100)"
  }
};

static ProcRecord layer_set_opacity_proc =
{
  "gimp_layer_set_opacity",
  "Set the opacity of the specified layer.",
  "This procedure sets the specified layer's opacity.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_set_opacity_inargs,
  0,
  NULL,
  { { layer_set_opacity_invoker } }
};

static Argument *
layer_get_mode_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpLayer *layer;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  return_args = procedural_db_return_args (&layer_get_mode_proc, success);

  if (success)
    return_args[1].value.pdb_int = gimp_layer_get_mode (layer);

  return return_args;
}

static ProcArg layer_get_mode_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  }
};

static ProcArg layer_get_mode_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "mode",
    "The layer combination mode"
  }
};

static ProcRecord layer_get_mode_proc =
{
  "gimp_layer_get_mode",
  "Get the combination mode of the specified layer.",
  "This procedure returns the specified layer's combination mode.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  1,
  layer_get_mode_inargs,
  1,
  layer_get_mode_outargs,
  { { layer_get_mode_invoker } }
};

static Argument *
layer_set_mode_invoker (Gimp         *gimp,
                        GimpContext  *context,
                        GimpProgress *progress,
                        Argument     *args)
{
  gboolean success = TRUE;
  GimpLayer *layer;
  gint32 mode;

  layer = (GimpLayer *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_LAYER (layer) && ! gimp_item_is_removed (GIMP_ITEM (layer))))
    success = FALSE;

  mode = args[1].value.pdb_int;
  if (mode < GIMP_NORMAL_MODE || mode > GIMP_COLOR_ERASE_MODE)
    success = FALSE;

  if (success)
    gimp_layer_set_mode (layer, mode, TRUE);

  return procedural_db_return_args (&layer_set_mode_proc, success);
}

static ProcArg layer_set_mode_inargs[] =
{
  {
    GIMP_PDB_LAYER,
    "layer",
    "The layer"
  },
  {
    GIMP_PDB_INT32,
    "mode",
    "The new layer combination mode"
  }
};

static ProcRecord layer_set_mode_proc =
{
  "gimp_layer_set_mode",
  "Set the combination mode of the specified layer.",
  "This procedure sets the specified layer's combination mode.",
  "Spencer Kimball & Peter Mattis",
  "Spencer Kimball & Peter Mattis",
  "1995-1996",
  NULL,
  GIMP_INTERNAL,
  2,
  layer_set_mode_inargs,
  0,
  NULL,
  { { layer_set_mode_invoker } }
};
