/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpvectors_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include <string.h>

#include "gimp.h"

/**
 * gimp_vectors_get_strokes:
 * @vectors_ID: The vectors object.
 * @num_strokes: The number of strokes returned.
 *
 * List the strokes associated with the passed path.
 *
 * Returns an Array with the stroke-IDs associated with the passed
 * path.
 *
 * Returns: List of the strokes belonging to the path.
 *
 * Since: GIMP 2.4
 */
gint *
gimp_vectors_get_strokes (gint32  vectors_ID,
			  gint   *num_strokes)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gint *stroke_ids = NULL;

  return_vals = gimp_run_procedure ("gimp_vectors_get_strokes",
				    &nreturn_vals,
				    GIMP_PDB_PATH, vectors_ID,
				    GIMP_PDB_END);

  *num_strokes = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      *num_strokes = return_vals[1].data.d_int32;
      stroke_ids = g_new (gint32, *num_strokes);
      memcpy (stroke_ids, return_vals[2].data.d_int32array,
	      *num_strokes * sizeof (gint32));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return stroke_ids;
}

/**
 * gimp_vectors_stroke_remove:
 * @vectors_ID: The vectors object.
 * @stroke_id: The stroke ID.
 *
 * return coordinates along the given stroke.
 *
 * Returns a lot of coordinates along the passed stroke.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.4
 */
gboolean
gimp_vectors_stroke_remove (gint32 vectors_ID,
			    gint   stroke_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_vectors_stroke_remove",
				    &nreturn_vals,
				    GIMP_PDB_PATH, vectors_ID,
				    GIMP_PDB_INT32, stroke_id,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_vectors_stroke_translate:
 * @vectors_ID: The vectors object.
 * @stroke_id: The stroke ID.
 * @offx: Offset in x direction.
 * @offy: Offset in y direction.
 *
 * translate the given stroke.
 *
 * Translate the given stroke.
 *
 * Returns: TRUE on success.
 *
 * Since: GIMP 2.4
 */
gboolean
gimp_vectors_stroke_translate (gint32 vectors_ID,
			       gint   stroke_id,
			       gint   offx,
			       gint   offy)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_vectors_stroke_translate",
				    &nreturn_vals,
				    GIMP_PDB_PATH, vectors_ID,
				    GIMP_PDB_INT32, stroke_id,
				    GIMP_PDB_INT32, offx,
				    GIMP_PDB_INT32, offy,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_vectors_stroke_interpolate:
 * @vectors_ID: The vectors object.
 * @stroke_id: The stroke ID.
 * @prescision: The prescision used for the approximation.
 * @num_coords: The number of floats returned.
 * @coords: List of the coords along the path (x0, y0, x1, y1, ...).
 *
 * returns polygonal approximation of the stroke.
 *
 * returns polygonal approximation of the stroke.
 *
 * Returns: List of the strokes belonging to the path.
 *
 * Since: GIMP 2.4
 */
gboolean
gimp_vectors_stroke_interpolate (gint32    vectors_ID,
				 gint      stroke_id,
				 gdouble   prescision,
				 gint     *num_coords,
				 gdouble **coords)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean closed = FALSE;

  return_vals = gimp_run_procedure ("gimp_vectors_stroke_interpolate",
				    &nreturn_vals,
				    GIMP_PDB_PATH, vectors_ID,
				    GIMP_PDB_INT32, stroke_id,
				    GIMP_PDB_FLOAT, prescision,
				    GIMP_PDB_END);

  *num_coords = 0;

  if (return_vals[0].data.d_status == GIMP_PDB_SUCCESS)
    {
      closed = return_vals[1].data.d_int32;
      *num_coords = return_vals[2].data.d_int32;
      *coords = g_new (gdouble, *num_coords);
      memcpy (*coords, return_vals[3].data.d_floatarray,
	      *num_coords * sizeof (gdouble));
    }

  gimp_destroy_params (return_vals, nreturn_vals);

  return closed;
}
