/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "pdb-types.h"
#include "gimppdb.h"
#include "gimpprocedure.h"
#include "core/gimpparamspecs.h"

#include "core/gimp.h"
#include "core/gimpchannel-select.h"
#include "core/gimpimage.h"
#include "core/gimplist.h"
#include "core/gimpstrokedesc.h"
#include "gimp-intl.h"
#include "vectors/gimpanchor.h"
#include "vectors/gimpbezierstroke.h"
#include "vectors/gimpvectors-compat.h"
#include "vectors/gimpvectors-import.h"
#include "vectors/gimpvectors.h"


static GValueArray *
path_list_invoker (GimpProcedure     *procedure,
                   Gimp              *gimp,
                   GimpContext       *context,
                   GimpProgress      *progress,
                   const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gint32 num_paths = 0;
  gchar **path_list = NULL;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      path_list = gimp_container_get_name_array (image->vectors, &num_paths);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    {
      g_value_set_int (&return_vals->values[1], num_paths);
      gimp_value_take_stringarray (&return_vals->values[2], path_list, num_paths);
    }

  return return_vals;
}

static GValueArray *
path_get_current_invoker (GimpProcedure     *procedure,
                          Gimp              *gimp,
                          GimpContext       *context,
                          GimpProgress      *progress,
                          const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gchar *name = NULL;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_active_vectors (image);

      if (vectors)
        name = g_strdup (gimp_object_get_name (GIMP_OBJECT (vectors)));
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
path_set_current_invoker (GimpProcedure     *procedure,
                          Gimp              *gimp,
                          GimpContext       *context,
                          GimpProgress      *progress,
                          const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *name;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_name (image, name);

      if (vectors)
        gimp_image_set_active_vectors (image, vectors);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
path_delete_invoker (GimpProcedure     *procedure,
                     Gimp              *gimp,
                     GimpContext       *context,
                     GimpProgress      *progress,
                     const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *name;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_name (image, name);

      if (vectors)
        gimp_image_remove_vectors (image, vectors);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
path_get_points_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  const gchar *name;
  gint32 path_type = 0;
  gint32 path_closed = 0;
  gint32 num_path_point_details = 0;
  gdouble *points_pairs = NULL;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_name (image, name);

      if (vectors)
        {
          GimpVectorsCompatPoint *points;
          gint num_points;

          path_type = 1; /* BEZIER (1.2 compat) */

          points = gimp_vectors_compat_get_points (vectors, &num_points,
                                                   &path_closed);

          num_path_point_details = num_points * 3;

          if (points)
            {
              gdouble *curr_point;
              gint     i;

              points_pairs = g_new0 (gdouble, num_path_point_details);

              for (i = 0, curr_point = points_pairs;
                   i < num_points;
                   i++, curr_point += 3)
                {
                  curr_point[0] = points[i].x;
                  curr_point[1] = points[i].y;
                  curr_point[2] = points[i].type;
                }

              g_free (points);
            }
          else
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    {
      g_value_set_int (&return_vals->values[1], path_type);
      g_value_set_int (&return_vals->values[2], path_closed);
      g_value_set_int (&return_vals->values[3], num_path_point_details);
      gimp_value_take_floatarray (&return_vals->values[4], points_pairs, num_path_point_details);
    }

  return return_vals;
}

static GValueArray *
path_set_points_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *name;
  gint32 ptype;
  gint32 num_path_points;
  const gdouble *points_pairs;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);
  ptype = g_value_get_int (&args->values[2]);
  num_path_points = g_value_get_int (&args->values[3]);
  points_pairs = gimp_value_get_floatarray (&args->values[4]);

  if (success)
    {
      gboolean closed = FALSE;

      if ((num_path_points / 3) % 3 == 0)
        closed = TRUE;
      else if ((num_path_points / 3) % 3 != 2)
        success = FALSE;

      if (success)
        {
          GimpVectors            *vectors;
          const gdouble          *curr_point_pair;
          GimpVectorsCompatPoint *points;
          gint                    n_points;
          gint                    i;

          n_points = num_path_points / 3;

          points = g_new0 (GimpVectorsCompatPoint, n_points);

          for (i = 0, curr_point_pair = points_pairs;
               i < n_points;
               i++, curr_point_pair += 3)
            {
              points[i].x    = curr_point_pair[0];
              points[i].y    = curr_point_pair[1];
              points[i].type = curr_point_pair[2];
            }

          vectors = gimp_vectors_compat_new (image, name, points, n_points,
                                             closed);

          g_free (points);

          if (vectors)
            gimp_image_add_vectors (image, vectors, 0);
          else
            success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
path_stroke_current_invoker (GimpProcedure     *procedure,
                             Gimp              *gimp,
                             GimpContext       *context,
                             GimpProgress      *progress,
                             const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      GimpVectors  *vectors  = gimp_image_get_active_vectors (image);
      GimpDrawable *drawable = gimp_image_active_drawable (image);

      if (vectors && drawable)
        {
          GimpStrokeDesc *desc = gimp_stroke_desc_new (gimp, context);

          g_object_set (desc, "method", GIMP_STROKE_METHOD_PAINT_CORE, NULL);

          success = gimp_item_stroke (GIMP_ITEM (vectors),
                                      drawable, context, desc, TRUE);

          g_object_unref (desc);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
path_get_point_at_dist_invoker (GimpProcedure     *procedure,
                                Gimp              *gimp,
                                GimpContext       *context,
                                GimpProgress      *progress,
                                const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gdouble distance;
  gint32 x_point = 0;
  gint32 y_point = 0;
  gdouble slope = 0.0;

  image = gimp_value_get_image (&args->values[0], gimp);
  distance = g_value_get_double (&args->values[1]);

  if (success)
    {
      GimpVectors *vectors;
      GimpStroke  *stroke;
      gdouble      distance_along;
      gdouble      stroke_length;
      gdouble      stroke_distance;
      GimpCoords   position;

      vectors = gimp_image_get_active_vectors (image);

      if (vectors)
        {
          distance_along = 0.0;
          stroke = gimp_vectors_stroke_get_next (vectors, NULL);

          while (stroke != NULL )
            {
              stroke_length = gimp_stroke_get_length (stroke, 0.5);

              if (distance_along + stroke_length < distance)
                {
                  distance_along += stroke_length;
                }
              else
                {
                  stroke_distance = distance - distance_along;
                  stroke_distance = stroke_distance < 0 ? 0: stroke_distance;

                  if (!gimp_stroke_get_point_at_dist (stroke, stroke_distance, 0.5,
                                                      &position, &slope))
                    {
                      success = FALSE;
                      break;
                    }
                  else
                    {
                      success = TRUE;
                      x_point = ROUND (position.x);
                      y_point = ROUND (position.y);
                      break;
                    }
                }

              stroke = gimp_vectors_stroke_get_next (vectors, stroke);
            }
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    {
      g_value_set_int (&return_vals->values[1], x_point);
      g_value_set_int (&return_vals->values[2], y_point);
      g_value_set_double (&return_vals->values[3], slope);
    }

  return return_vals;
}

static GValueArray *
path_get_tattoo_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  const gchar *name;
  gint32 tattoo = 0;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_name (image, name);

      if (vectors)
        tattoo = gimp_item_get_tattoo (GIMP_ITEM (vectors));
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_int (&return_vals->values[1], tattoo);

  return return_vals;
}

static GValueArray *
path_set_tattoo_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *name;
  gint32 tattovalue;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);
  tattovalue = g_value_get_int (&args->values[2]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_name (image, name);

      if (vectors)
        gimp_item_set_tattoo (GIMP_ITEM (vectors), tattovalue);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
get_path_by_tattoo_invoker (GimpProcedure     *procedure,
                            Gimp              *gimp,
                            GimpContext       *context,
                            GimpProgress      *progress,
                            const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gint32 tattoo;
  gchar *name = NULL;

  image = gimp_value_get_image (&args->values[0], gimp);
  tattoo = g_value_get_int (&args->values[1]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_tattoo (image, tattoo);

      if (vectors)
        name = g_strdup (gimp_object_get_name (GIMP_OBJECT (vectors)));
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
path_get_locked_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  const gchar *name;
  gboolean locked = FALSE;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_name (image, name);

      if (vectors)
        locked = gimp_item_get_linked (GIMP_ITEM (vectors));
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    g_value_set_boolean (&return_vals->values[1], locked);

  return return_vals;
}

static GValueArray *
path_set_locked_invoker (GimpProcedure     *procedure,
                         Gimp              *gimp,
                         GimpContext       *context,
                         GimpProgress      *progress,
                         const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *name;
  gboolean locked;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);
  locked = g_value_get_boolean (&args->values[2]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_name (image, name);

      if (vectors)
        gimp_item_set_linked (GIMP_ITEM (vectors), locked, TRUE);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
path_to_selection_invoker (GimpProcedure     *procedure,
                           Gimp              *gimp,
                           GimpContext       *context,
                           GimpProgress      *progress,
                           const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *name;
  gint32 op;
  gboolean antialias;
  gboolean feather;
  gdouble feather_radius_x;
  gdouble feather_radius_y;

  image = gimp_value_get_image (&args->values[0], gimp);
  name = g_value_get_string (&args->values[1]);
  op = g_value_get_enum (&args->values[2]);
  antialias = g_value_get_boolean (&args->values[3]);
  feather = g_value_get_boolean (&args->values[4]);
  feather_radius_x = g_value_get_double (&args->values[5]);
  feather_radius_y = g_value_get_double (&args->values[6]);

  if (success)
    {
      GimpVectors *vectors = gimp_image_get_vectors_by_name (image, name);

      if (vectors)
        gimp_channel_select_vectors (gimp_image_get_mask (image),
                                     _("Path to Selection"),
                                     vectors,
                                     op,
                                     antialias,
                                     feather,
                                     feather_radius_x,
                                     feather_radius_y);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
path_import_invoker (GimpProcedure     *procedure,
                     Gimp              *gimp,
                     GimpContext       *context,
                     GimpProgress      *progress,
                     const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *filename;
  gboolean merge;
  gboolean scale;

  image = gimp_value_get_image (&args->values[0], gimp);
  filename = g_value_get_string (&args->values[1]);
  merge = g_value_get_boolean (&args->values[2]);
  scale = g_value_get_boolean (&args->values[3]);

  if (success)
    {
      success = gimp_vectors_import_file (image, filename, merge, scale, -1, NULL);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

static GValueArray *
path_import_string_invoker (GimpProcedure     *procedure,
                            Gimp              *gimp,
                            GimpContext       *context,
                            GimpProgress      *progress,
                            const GValueArray *args)
{
  gboolean success = TRUE;
  GimpImage *image;
  const gchar *string;
  gint32 length;
  gboolean merge;
  gboolean scale;

  image = gimp_value_get_image (&args->values[0], gimp);
  string = g_value_get_string (&args->values[1]);
  length = g_value_get_int (&args->values[2]);
  merge = g_value_get_boolean (&args->values[3]);
  scale = g_value_get_boolean (&args->values[4]);

  if (success)
    {
      success = gimp_vectors_import_buffer (image, string, length,
                                            merge, scale, -1, NULL);
    }

  return gimp_procedure_get_return_values (procedure, success);
}

void
register_paths_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-path-list
   */
  procedure = gimp_procedure_new (path_list_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-list");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-list",
                                     "This procedure is deprecated! Use 'gimp-image-get-vectors' instead.",
                                     "This procedure is deprecated! Use 'gimp-image-get-vectors' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-image-get-vectors");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image to list the paths from",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-paths",
                                                          "num paths",
                                                          "The number of paths returned.",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string_array ("path-list",
                                                                 "path list",
                                                                 "List of the paths belonging to this image.",
                                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-get-current
   */
  procedure = gimp_procedure_new (path_get_current_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-get-current");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-get-current",
                                     "This procedure is deprecated! Use 'gimp-image-get-active-vectors' instead.",
                                     "This procedure is deprecated! Use 'gimp-image-get-active-vectors' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-image-get-active-vectors");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image to get the current path from",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the current path.",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-set-current
   */
  procedure = gimp_procedure_new (path_set_current_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-set-current");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-set-current",
                                     "This procedure is deprecated! Use 'gimp-image-set-active-vectors' instead.",
                                     "This procedure is deprecated! Use 'gimp-image-set-active-vectors' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-image-set-active-vectors");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image in which a path will become current",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the path to make current.",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-delete
   */
  procedure = gimp_procedure_new (path_delete_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-delete");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-delete",
                                     "This procedure is deprecated! Use 'gimp-image-remove-vectors' instead.",
                                     "This procedure is deprecated! Use 'gimp-image-remove-vectors' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-image-remove-vectors");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image to delete the path from",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the path to delete.",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-get-points
   */
  procedure = gimp_procedure_new (path_get_points_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-get-points");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-get-points",
                                     "List the points associated with the named path.",
                                     "List the points associated with the named path.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image to list the paths from",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the path whose points should be listed.",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("path-type",
                                                          "path type",
                                                          "The type of the path. Currently only one type (1 = Bezier) is supported",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("path-closed",
                                                          "path closed",
                                                          "Return if the path is closed. (0 = path open, 1 = path closed)",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-path-point-details",
                                                          "num path point details",
                                                          "The number of points returned. Each point is made up of (x, y, pnt_type) of floats.",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_float_array ("points-pairs",
                                                                "points pairs",
                                                                "The points in the path represented as 3 floats. The first is the x pos, next is the y pos, last is the type of the pnt. The type field is dependant on the path type. For beziers (type 1 paths) the type can either be (1.0 = BEZIER_ANCHOR, 2.0 = BEZIER_CONTROL, 3.0 = BEZIER_MOVE). Note all points are returned in pixel resolution.",
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-set-points
   */
  procedure = gimp_procedure_new (path_set_points_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-set-points");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-set-points",
                                     "Set the points associated with the named path.",
                                     "Set the points associated with the named path.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image to set the paths in",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the path to create. If it exists then a unique name will be created - query the list of paths if you want to make sure that the name of the path you create is unique. This will be set as the current path.",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("ptype",
                                                      "ptype",
                                                      "The type of the path. Currently only one type (1 = Bezier) is supported.",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("num-path-points",
                                                      "num path points",
                                                      "The number of elements in the array, i.e. the number of points in the path * 3. Each point is made up of (x, y, type) of floats. Currently only the creation of bezier curves is allowed. The type parameter must be set to (1) to indicate a BEZIER type curve. Note that for BEZIER curves, points must be given in the following order: ACCACCAC... If the path is not closed the last control point is missed off. Points consist of three control points (control/anchor/control) so for a curve that is not closed there must be at least two points passed (2 x,y pairs). If (num_path_points/3) % 3 = 0 then the path is assumed to be closed and the points are ACCACCACCACC.",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_float_array ("points-pairs",
                                                            "points pairs",
                                                            "The points in the path represented as 3 floats. The first is the x pos, next is the y pos, last is the type of the pnt. The type field is dependant on the path type. For beziers (type 1 paths) the type can either be (1.0 = BEZIER_ANCHOR, 2.0 = BEZIER_CONTROL, 3.0= BEZIER_MOVE). Note all points are returned in pixel resolution.",
                                                            GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-stroke-current
   */
  procedure = gimp_procedure_new (path_stroke_current_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-stroke-current");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-stroke-current",
                                     "Stroke the current path in the passed image.",
                                     "Stroke the current path in the passed image.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "1999",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image which contains the path to stroke",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-get-point-at-dist
   */
  procedure = gimp_procedure_new (path_get_point_at_dist_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-get-point-at-dist");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-get-point-at-dist",
                                     "This procedure is deprecated! Use 'gimp-vectors-stroke-get-point-at-dist' instead.",
                                     "This procedure is deprecated! Use 'gimp-vectors-stroke-get-point-at-dist' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-vectors-stroke-get-point-at-dist");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image the paths belongs to",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("distance",
                                                    "distance",
                                                    "The distance along the path.",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("x-point",
                                                          "x point",
                                                          "The x position of the point.",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("y-point",
                                                          "y point",
                                                          "The y position of the point.",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("slope",
                                                        "slope",
                                                        "The slope (dy / dx) at the specified point.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-get-tattoo
   */
  procedure = gimp_procedure_new (path_get_tattoo_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-get-tattoo");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-get-tattoo",
                                     "This procedure is deprecated! Use 'gimp-vectors-get-tattoo' instead.",
                                     "This procedure is deprecated! Use 'gimp-vectors-get-tattoo' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-vectors-get-tattoo");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the path whose tattoo should be obtained.",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("tattoo",
                                                          "tattoo",
                                                          "The tattoo associated with the named path.",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-set-tattoo
   */
  procedure = gimp_procedure_new (path_set_tattoo_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-set-tattoo");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-set-tattoo",
                                     "This procedure is deprecated! Use 'gimp-vectors-set-tattoo' instead.",
                                     "This procedure is deprecated! Use 'gimp-vectors-set-tattoo' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-vectors-set-tattoo");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "the name of the path whose tattoo should be set",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("tattovalue",
                                                      "tattovalue",
                                                      "The tattoo associated with the name path. Only values returned from 'path_get_tattoo' should be used here",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-get-path-by-tattoo
   */
  procedure = gimp_procedure_new (get_path_by_tattoo_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-get-path-by-tattoo");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-get-path-by-tattoo",
                                     "This procedure is deprecated! Use 'gimp-image-get-vectors-by-tattoo' instead.",
                                     "This procedure is deprecated! Use 'gimp-image-get-vectors-by-tattoo' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-image-get-vectors-by-tattoo");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("tattoo",
                                                      "tattoo",
                                                      "The tattoo of the required path.",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the path with the specified tattoo.",
                                                           FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-get-locked
   */
  procedure = gimp_procedure_new (path_get_locked_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-get-locked");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-get-locked",
                                     "This procedure is deprecated! Use 'gimp-vectors-get-linked' instead.",
                                     "This procedure is deprecated! Use 'gimp-vectors-get-linked' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-vectors-get-linked");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the path whose locked status should be obtained.",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("locked",
                                                         "locked",
                                                         "TRUE if the path is locked, FALSE otherwise",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-set-locked
   */
  procedure = gimp_procedure_new (path_set_locked_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-set-locked");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-set-locked",
                                     "This procedure is deprecated! Use 'gimp-vectors-set-linked' instead.",
                                     "This procedure is deprecated! Use 'gimp-vectors-set-linked' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-vectors-set-linked");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "the name of the path whose locked status should be set",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("locked",
                                                     "locked",
                                                     "Whether the path is locked",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-to-selection
   */
  procedure = gimp_procedure_new (path_to_selection_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-to-selection");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-to-selection",
                                     "Transforms the active path into a selection",
                                     "This procedure renders the desired path into the current selection.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2003",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the path which should be made into selection.",
                                                       FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("op",
                                                  "op",
                                                  "The desired operation with current selection",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("antialias",
                                                     "antialias",
                                                     "Antialias selection.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("feather",
                                                     "feather",
                                                     "Feather selection.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("feather-radius-x",
                                                    "feather radius x",
                                                    "Feather radius x.",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("feather-radius-y",
                                                    "feather radius y",
                                                    "Feather radius y.",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-import
   */
  procedure = gimp_procedure_new (path_import_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-import");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-import",
                                     "Import paths from an SVG file.",
                                     "This procedure imports paths from an SVG file. SVG elements other than paths and basic shapes are ignored.",
                                     "Sven Neumann <sven@gimp.org>",
                                     "Sven Neumann",
                                     "2003",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("filename",
                                                       "filename",
                                                       "The name of the SVG file to import.",
                                                       TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("merge",
                                                     "merge",
                                                     "Merge paths into a single vectors object.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("scale",
                                                     "scale",
                                                     "Scale the SVG to image dimensions.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-path-import-string
   */
  procedure = gimp_procedure_new (path_import_string_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-path-import-string");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-path-import-string",
                                     "Import paths from an SVG string.",
                                     "This procedure works like 'gimp-path-import' but takes a string rather than reading the SVG from a file. This allows you to write scripts that generate SVG and feed it to GIMP.",
                                     "Sven Neumann <sven@gimp.org>",
                                     "Sven Neumann",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("string",
                                                       "string",
                                                       "A string that must be a complete and valid SVG document.",
                                                       TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("length",
                                                      "length",
                                                      "Number of bytes in string or -1 if the string is NULL terminated.",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("merge",
                                                     "merge",
                                                     "Merge paths into a single vectors object.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("scale",
                                                     "scale",
                                                     "Scale the SVG to image dimensions.",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
