/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * gimppdbprogress.h
 * Copyright (C) 2004 Michael Natterer <mitch@gimp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIMP_PDB_PROGRESS_H__
#define __GIMP_PDB_PROGRESS_H__

G_BEGIN_DECLS


#define GIMP_TYPE_PDB_PROGRESS            (gimp_pdb_progress_get_type ())
#define GIMP_PDB_PROGRESS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIMP_TYPE_PDB_PROGRESS, GimpPdbProgress))
#define GIMP_PDB_PROGRESS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GIMP_TYPE_PDB_PROGRESS, GimpPdbProgressClass))
#define GIMP_IS_PDB_PROGRESS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIMP_TYPE_PDB_PROGRESS))
#define GIMP_IS_PDB_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GIMP_TYPE_PDB_PROGRESS))
#define GIMP_PDB_PROGRESS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GIMP_TYPE_PDB_PROGRESS, GimpPdbProgressClass))


typedef struct _GimpPdbProgressClass  GimpPdbProgressClass;

struct _GimpPdbProgress
{
  GObject      object;

  gboolean     active;
  gdouble      value;

  GimpContext *context;
  gchar       *callback_name;
  gboolean     callback_busy;
};

struct _GimpPdbProgressClass
{
  GObjectClass  parent_class;

  GList        *progresses;
};


GType             gimp_pdb_progress_get_type        (void) G_GNUC_CONST;

GimpPdbProgress * gimp_pdb_progress_get_by_callback (GimpPdbProgressClass *klass,
                                                     const gchar          *callback_name);


G_END_DECLS

#endif /* __GIMP_PDB_PROGRESS_H__ */
