/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include <string.h>

#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "core/gimp.h"
#include "core/gimpimage-undo.h"
#include "core/gimplist.h"
#include "gimp-intl.h"
#include "vectors/gimpanchor.h"
#include "vectors/gimpbezierstroke.h"
#include "vectors/gimpvectors-compat.h"
#include "vectors/gimpvectors.h"

static ProcRecord vectors_get_strokes_proc;
static ProcRecord vectors_stroke_remove_proc;
static ProcRecord vectors_stroke_translate_proc;
static ProcRecord vectors_stroke_interpolate_proc;

void
register_vectors_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &vectors_get_strokes_proc);
  procedural_db_register (gimp, &vectors_stroke_remove_proc);
  procedural_db_register (gimp, &vectors_stroke_translate_proc);
  procedural_db_register (gimp, &vectors_stroke_interpolate_proc);
}

static Argument *
vectors_get_strokes_invoker (Gimp         *gimp,
                             GimpContext  *context,
                             GimpProgress *progress,
                             Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpVectors *vectors;
  gint32 num_strokes = 0;
  gint32 *stroke_ids = NULL;
  gint i = 0;
  GimpStroke *cur_stroke = NULL;

  vectors = (GimpVectors *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_VECTORS (vectors) && ! gimp_item_is_removed (GIMP_ITEM (vectors))))
    success = FALSE;

  if (success)
    {
      num_strokes = gimp_vectors_get_n_strokes (vectors);

      if (num_strokes)
        {
          stroke_ids = g_new (gint32, num_strokes);

          for (cur_stroke = gimp_vectors_stroke_get_next (vectors, NULL);
               cur_stroke;
               cur_stroke = gimp_vectors_stroke_get_next (vectors, cur_stroke))
            {
              stroke_ids[i] = gimp_stroke_get_ID (cur_stroke);
              i++;
            }
        }
    }

  return_args = procedural_db_return_args (&vectors_get_strokes_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = num_strokes;
      return_args[2].value.pdb_pointer = stroke_ids;
    }

  return return_args;
}

static ProcArg vectors_get_strokes_inargs[] =
{
  {
    GIMP_PDB_PATH,
    "vectors",
    "The vectors object"
  }
};

static ProcArg vectors_get_strokes_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "num-strokes",
    "The number of strokes returned."
  },
  {
    GIMP_PDB_INT32ARRAY,
    "stroke-ids",
    "List of the strokes belonging to the path."
  }
};

static ProcRecord vectors_get_strokes_proc =
{
  "gimp-vectors-get-strokes",
  "gimp-vectors-get-strokes",
  "List the strokes associated with the passed path.",
  "Returns an Array with the stroke-IDs associated with the passed path.",
  "Simon Budig",
  "Simon Budig",
  "2005",
  NULL,
  GIMP_INTERNAL,
  1,
  vectors_get_strokes_inargs,
  2,
  vectors_get_strokes_outargs,
  { { vectors_get_strokes_invoker } }
};

static Argument *
vectors_stroke_remove_invoker (Gimp         *gimp,
                               GimpContext  *context,
                               GimpProgress *progress,
                               Argument     *args)
{
  gboolean success = TRUE;
  GimpVectors *vectors;
  gint32 stroke_id;
  GimpStroke *stroke;

  vectors = (GimpVectors *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_VECTORS (vectors) && ! gimp_item_is_removed (GIMP_ITEM (vectors))))
    success = FALSE;

  stroke_id = args[1].value.pdb_int;

  if (success)
    {
      stroke = gimp_vectors_stroke_get_by_ID (vectors, stroke_id);

      if (stroke)
        gimp_vectors_stroke_remove (vectors, stroke);
      else
        success = FALSE;
    }

  return procedural_db_return_args (&vectors_stroke_remove_proc, success);
}

static ProcArg vectors_stroke_remove_inargs[] =
{
  {
    GIMP_PDB_PATH,
    "vectors",
    "The vectors object"
  },
  {
    GIMP_PDB_INT32,
    "stroke-id",
    "The stroke ID"
  }
};

static ProcRecord vectors_stroke_remove_proc =
{
  "gimp-vectors-stroke-remove",
  "gimp-vectors-stroke-remove",
  "return coordinates along the given stroke.",
  "Returns a lot of coordinates along the passed stroke.",
  "Simon Budig",
  "Simon Budig",
  "2005",
  NULL,
  GIMP_INTERNAL,
  2,
  vectors_stroke_remove_inargs,
  0,
  NULL,
  { { vectors_stroke_remove_invoker } }
};

static Argument *
vectors_stroke_translate_invoker (Gimp         *gimp,
                                  GimpContext  *context,
                                  GimpProgress *progress,
                                  Argument     *args)
{
  gboolean success = TRUE;
  GimpVectors *vectors;
  gint32 stroke_id;
  gint32 offx;
  gint32 offy;
  GimpStroke *stroke;

  vectors = (GimpVectors *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_VECTORS (vectors) && ! gimp_item_is_removed (GIMP_ITEM (vectors))))
    success = FALSE;

  stroke_id = args[1].value.pdb_int;

  offx = args[2].value.pdb_int;

  offy = args[3].value.pdb_int;

  if (success)
    {
      GimpImage *gimage = gimp_item_get_image (GIMP_ITEM (vectors));
      stroke = gimp_vectors_stroke_get_by_ID (vectors, stroke_id);

      if (!stroke)
        {
          success = FALSE;
        }
      else
        {
          /* need to figure out how undo is supposed to work */

          gimp_image_undo_group_start (gimage, GIMP_UNDO_GROUP_ITEM_DISPLACE,
                                       _("Modify Path"));
          gimp_vectors_freeze (vectors);
          gimp_stroke_translate (stroke, offx, offy);
          gimp_vectors_thaw (vectors);
          gimp_image_undo_group_end (gimage);
        }
    }

  return procedural_db_return_args (&vectors_stroke_translate_proc, success);
}

static ProcArg vectors_stroke_translate_inargs[] =
{
  {
    GIMP_PDB_PATH,
    "vectors",
    "The vectors object"
  },
  {
    GIMP_PDB_INT32,
    "stroke-id",
    "The stroke ID"
  },
  {
    GIMP_PDB_INT32,
    "offx",
    "Offset in x direction"
  },
  {
    GIMP_PDB_INT32,
    "offy",
    "Offset in y direction"
  }
};

static ProcRecord vectors_stroke_translate_proc =
{
  "gimp-vectors-stroke-translate",
  "gimp-vectors-stroke-translate",
  "translate the given stroke.",
  "Translate the given stroke.",
  "Simon Budig",
  "Simon Budig",
  "2005",
  NULL,
  GIMP_INTERNAL,
  4,
  vectors_stroke_translate_inargs,
  0,
  NULL,
  { { vectors_stroke_translate_invoker } }
};

static Argument *
vectors_stroke_interpolate_invoker (Gimp         *gimp,
                                    GimpContext  *context,
                                    GimpProgress *progress,
                                    Argument     *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  GimpVectors *vectors;
  gint32 stroke_id;
  gdouble prescision;
  gboolean closed;
  gint32 num_coords = 0;
  gdouble *coords = NULL;
  GimpStroke *stroke;
  GArray     *coords_array;
  gint        i;

  vectors = (GimpVectors *) gimp_item_get_by_ID (gimp, args[0].value.pdb_int);
  if (! (GIMP_IS_VECTORS (vectors) && ! gimp_item_is_removed (GIMP_ITEM (vectors))))
    success = FALSE;

  stroke_id = args[1].value.pdb_int;

  prescision = args[2].value.pdb_float;

  if (success)
    {
      stroke = gimp_vectors_stroke_get_by_ID (vectors, stroke_id);

      if (stroke)
        {
          /* need to figure out how undo is supposed to work */

          coords_array = gimp_stroke_interpolate (stroke, prescision, &closed);
          if (coords_array)
            {
              num_coords = coords_array->len;
              coords = g_new (gdouble, num_coords * 2);

              for (i = 0; i < num_coords; i++)
                {
                  coords[2*i]   = g_array_index (coords_array, GimpCoords, i).x;
                  coords[2*i+1] = g_array_index (coords_array, GimpCoords, i).y;
                }
              g_array_free (coords_array, TRUE);
              num_coords *= 2;
            }
          else
            {
              success = FALSE;
            }
        }
      else
        {
          success = FALSE;
        }
    }

  return_args = procedural_db_return_args (&vectors_stroke_interpolate_proc, success);

  if (success)
    {
      return_args[1].value.pdb_int = closed;
      return_args[2].value.pdb_int = num_coords;
      return_args[3].value.pdb_pointer = coords;
    }

  return return_args;
}

static ProcArg vectors_stroke_interpolate_inargs[] =
{
  {
    GIMP_PDB_PATH,
    "vectors",
    "The vectors object"
  },
  {
    GIMP_PDB_INT32,
    "stroke-id",
    "The stroke ID"
  },
  {
    GIMP_PDB_FLOAT,
    "prescision",
    "The prescision used for the approximation"
  }
};

static ProcArg vectors_stroke_interpolate_outargs[] =
{
  {
    GIMP_PDB_INT32,
    "closed",
    "List of the strokes belonging to the path."
  },
  {
    GIMP_PDB_INT32,
    "num-coords",
    "The number of floats returned."
  },
  {
    GIMP_PDB_FLOATARRAY,
    "coords",
    "List of the coords along the path (x0, y0, x1, y1, ...)."
  }
};

static ProcRecord vectors_stroke_interpolate_proc =
{
  "gimp-vectors-stroke-interpolate",
  "gimp-vectors-stroke-interpolate",
  "returns polygonal approximation of the stroke.",
  "returns polygonal approximation of the stroke.",
  "Simon Budig",
  "Simon Budig",
  "2005",
  NULL,
  GIMP_INTERNAL,
  3,
  vectors_stroke_interpolate_inargs,
  3,
  vectors_stroke_interpolate_outargs,
  { { vectors_stroke_interpolate_invoker } }
};
