/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <gegl.h>

#include "libgimpcolor/gimpcolor.h"
#include "libgimpconfig/gimpconfig.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpcontainer.h"
#include "core/gimpdatafactory.h"
#include "core/gimpparamspecs.h"
#include "plug-in/gimpplugin-context.h"
#include "plug-in/gimpplugin.h"
#include "plug-in/gimppluginmanager.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimppdbcontext.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GValueArray *
context_push_invoker (GimpProcedure      *procedure,
                      Gimp               *gimp,
                      GimpContext        *context,
                      GimpProgress       *progress,
                      const GValueArray  *args,
                      GError            **error)
{
  gboolean success = TRUE;
  GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

  if (plug_in && plug_in->open)
    success = gimp_plug_in_context_push (plug_in);
  else
    success = FALSE;

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_pop_invoker (GimpProcedure      *procedure,
                     Gimp               *gimp,
                     GimpContext        *context,
                     GimpProgress       *progress,
                     const GValueArray  *args,
                     GError            **error)
{
  gboolean success = TRUE;
  GimpPlugIn *plug_in = gimp->plug_in_manager->current_plug_in;

  if (plug_in && plug_in->open)
    success = gimp_plug_in_context_pop (plug_in);
  else
    success = FALSE;

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_set_defaults_invoker (GimpProcedure      *procedure,
                              Gimp               *gimp,
                              GimpContext        *context,
                              GimpProgress       *progress,
                              const GValueArray  *args,
                              GError            **error)
{
    gimp_config_reset (GIMP_CONFIG (context));

  return gimp_procedure_get_return_values (procedure, TRUE, NULL);
}

static GValueArray *
context_list_paint_methods_invoker (GimpProcedure      *procedure,
                                    Gimp               *gimp,
                                    GimpContext        *context,
                                    GimpProgress       *progress,
                                    const GValueArray  *args,
                                    GError            **error)
{
  GValueArray *return_vals;
  gint32 num_paint_methods = 0;
  gchar **paint_methods = NULL;

  paint_methods = gimp_container_get_name_array (gimp->paint_info_list,
                                                 &num_paint_methods);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);

  g_value_set_int (&return_vals->values[1], num_paint_methods);
  gimp_value_take_stringarray (&return_vals->values[2], paint_methods, num_paint_methods);

  return return_vals;
}

static GValueArray *
context_get_paint_method_invoker (GimpProcedure      *procedure,
                                  Gimp               *gimp,
                                  GimpContext        *context,
                                  GimpProgress       *progress,
                                  const GValueArray  *args,
                                  GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpPaintInfo *paint_info = gimp_context_get_paint_info (context);

  if (paint_info)
    name = g_strdup (gimp_object_get_name (paint_info));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_paint_method_invoker (GimpProcedure      *procedure,
                                  Gimp               *gimp,
                                  GimpContext        *context,
                                  GimpProgress       *progress,
                                  const GValueArray  *args,
                                  GError            **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPaintInfo *paint_info = gimp_pdb_get_paint_info (gimp, name, error);

      if (paint_info)
        gimp_context_set_paint_info (context, paint_info);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_foreground_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  GValueArray *return_vals;
  GimpRGB foreground = { 0.0, 0.0, 0.0, 1.0 };

  gimp_context_get_foreground (context, &foreground);
  gimp_rgb_set_alpha (&foreground, 1.0);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  gimp_value_set_rgb (&return_vals->values[1], &foreground);

  return return_vals;
}

static GValueArray *
context_set_foreground_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  gboolean success = TRUE;
  GimpRGB foreground;

  gimp_value_get_rgb (&args->values[0], &foreground);

  if (success)
    {
      gimp_rgb_set_alpha (&foreground, 1.0);
      gimp_context_set_foreground (context, &foreground);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_background_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  GValueArray *return_vals;
  GimpRGB background = { 0.0, 0.0, 0.0, 1.0 };

  gimp_context_get_background (context, &background);
  gimp_rgb_set_alpha (&background, 1.0);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  gimp_value_set_rgb (&return_vals->values[1], &background);

  return return_vals;
}

static GValueArray *
context_set_background_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  gboolean success = TRUE;
  GimpRGB background;

  gimp_value_get_rgb (&args->values[0], &background);

  if (success)
    {
      gimp_rgb_set_alpha (&background, 1.0);
      gimp_context_set_background (context, &background);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_set_default_colors_invoker (GimpProcedure      *procedure,
                                    Gimp               *gimp,
                                    GimpContext        *context,
                                    GimpProgress       *progress,
                                    const GValueArray  *args,
                                    GError            **error)
{
  gimp_context_set_default_colors (context);

  return gimp_procedure_get_return_values (procedure, TRUE, NULL);
}

static GValueArray *
context_swap_colors_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gimp_context_swap_colors (context);

  return gimp_procedure_get_return_values (procedure, TRUE, NULL);
}

static GValueArray *
context_get_opacity_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  GValueArray *return_vals;
  gdouble opacity = 0.0;

  opacity = gimp_context_get_opacity (context) * 100.0;

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_double (&return_vals->values[1], opacity);

  return return_vals;
}

static GValueArray *
context_set_opacity_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  gdouble opacity;

  opacity = g_value_get_double (&args->values[0]);

  if (success)
    {
      gimp_context_set_opacity (context, opacity / 100.0);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_paint_mode_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  GValueArray *return_vals;
  gint32 paint_mode = 0;

  paint_mode = gimp_context_get_paint_mode (context);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (&return_vals->values[1], paint_mode);

  return return_vals;
}

static GValueArray *
context_set_paint_mode_invoker (GimpProcedure      *procedure,
                                Gimp               *gimp,
                                GimpContext        *context,
                                GimpProgress       *progress,
                                const GValueArray  *args,
                                GError            **error)
{
  gboolean success = TRUE;
  gint32 paint_mode;

  paint_mode = g_value_get_enum (&args->values[0]);

  if (success)
    {
      gimp_context_set_paint_mode (context, paint_mode);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_brush_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpBrush *brush = gimp_context_get_brush (context);

  if (brush)
    name = g_strdup (gimp_object_get_name (brush));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_brush_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpBrush *brush = gimp_pdb_get_brush (gimp, name, FALSE, error);

      if (brush)
        gimp_context_set_brush (context, brush);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_pattern_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpPattern *pattern = gimp_context_get_pattern (context);

  if (pattern)
    name = g_strdup (gimp_object_get_name (pattern));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_pattern_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPattern *pattern = gimp_pdb_get_pattern (gimp, name, error);

      if (pattern)
        gimp_context_set_pattern (context, pattern);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_gradient_invoker (GimpProcedure      *procedure,
                              Gimp               *gimp,
                              GimpContext        *context,
                              GimpProgress       *progress,
                              const GValueArray  *args,
                              GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpGradient *gradient = gimp_context_get_gradient (context);

  if (gradient)
    name = g_strdup (gimp_object_get_name (gradient));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_gradient_invoker (GimpProcedure      *procedure,
                              Gimp               *gimp,
                              GimpContext        *context,
                              GimpProgress       *progress,
                              const GValueArray  *args,
                              GError            **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpGradient *gradient = gimp_pdb_get_gradient (gimp, name, FALSE, error);

      if (gradient)
        gimp_context_set_gradient (context, gradient);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_palette_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpPalette *palette = gimp_context_get_palette (context);

  if (palette)
    name = g_strdup (gimp_object_get_name (palette));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_palette_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpPalette *palette = gimp_pdb_get_palette (gimp, name, FALSE, error);

      if (palette)
        gimp_context_set_palette (context, palette);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_font_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  gchar *name = NULL;

  GimpFont *font = gimp_context_get_font (context);

  if (font)
    name = g_strdup (gimp_object_get_name (font));
  else
    success = FALSE;

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (&return_vals->values[1], name);

  return return_vals;
}

static GValueArray *
context_set_font_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  const gchar *name;

  name = g_value_get_string (&args->values[0]);

  if (success)
    {
      GimpFont *font = gimp_pdb_get_font (gimp, name, error);

      if (font)
        gimp_context_set_font (context, font);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_antialias_invoker (GimpProcedure      *procedure,
                               Gimp               *gimp,
                               GimpContext        *context,
                               GimpProgress       *progress,
                               const GValueArray  *args,
                               GError            **error)
{
  GValueArray *return_vals;
  gboolean antialias = FALSE;

  g_object_get (context,
                "antialias", &antialias,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_boolean (&return_vals->values[1], antialias);

  return return_vals;
}

static GValueArray *
context_set_antialias_invoker (GimpProcedure      *procedure,
                               Gimp               *gimp,
                               GimpContext        *context,
                               GimpProgress       *progress,
                               const GValueArray  *args,
                               GError            **error)
{
  gboolean success = TRUE;
  gboolean antialias;

  antialias = g_value_get_boolean (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "antialias", antialias,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_feather_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  GValueArray *return_vals;
  gboolean feather = FALSE;

  g_object_get (context,
                "feather", &feather,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_boolean (&return_vals->values[1], feather);

  return return_vals;
}

static GValueArray *
context_set_feather_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  gboolean feather;

  feather = g_value_get_boolean (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "feather", feather,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_feather_radius_invoker (GimpProcedure      *procedure,
                                    Gimp               *gimp,
                                    GimpContext        *context,
                                    GimpProgress       *progress,
                                    const GValueArray  *args,
                                    GError            **error)
{
  GValueArray *return_vals;
  gdouble feather_radius_x = 0.0;
  gdouble feather_radius_y = 0.0;

  g_object_get (context,
                "feather-radius-x", &feather_radius_x,
                "feather-radius-y", &feather_radius_y,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);

  g_value_set_double (&return_vals->values[1], feather_radius_x);
  g_value_set_double (&return_vals->values[2], feather_radius_y);

  return return_vals;
}

static GValueArray *
context_set_feather_radius_invoker (GimpProcedure      *procedure,
                                    Gimp               *gimp,
                                    GimpContext        *context,
                                    GimpProgress       *progress,
                                    const GValueArray  *args,
                                    GError            **error)
{
  gboolean success = TRUE;
  gdouble feather_radius_x;
  gdouble feather_radius_y;

  feather_radius_x = g_value_get_double (&args->values[0]);
  feather_radius_y = g_value_get_double (&args->values[1]);

  if (success)
    {
      g_object_set (context,
                    "feather-radius-x", feather_radius_x,
                    "feather-radius-y", feather_radius_y,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_sample_merged_invoker (GimpProcedure      *procedure,
                                   Gimp               *gimp,
                                   GimpContext        *context,
                                   GimpProgress       *progress,
                                   const GValueArray  *args,
                                   GError            **error)
{
  GValueArray *return_vals;
  gboolean sample_merged = FALSE;

  g_object_get (context,
                "sample-merged", &sample_merged,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_boolean (&return_vals->values[1], sample_merged);

  return return_vals;
}

static GValueArray *
context_set_sample_merged_invoker (GimpProcedure      *procedure,
                                   Gimp               *gimp,
                                   GimpContext        *context,
                                   GimpProgress       *progress,
                                   const GValueArray  *args,
                                   GError            **error)
{
  gboolean success = TRUE;
  gboolean sample_merged;

  sample_merged = g_value_get_boolean (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "sample-merged", sample_merged,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_sample_criterion_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  GValueArray *return_vals;
  gint32 sample_criterion = 0;

  g_object_get (context,
                "sample-criterion", &sample_criterion,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (&return_vals->values[1], sample_criterion);

  return return_vals;
}

static GValueArray *
context_set_sample_criterion_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  gboolean success = TRUE;
  gint32 sample_criterion;

  sample_criterion = g_value_get_enum (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "sample-criterion", sample_criterion,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_sample_threshold_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  GValueArray *return_vals;
  gdouble sample_threshold = 0.0;

  g_object_get (context,
                "sample-threshold", &sample_threshold,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_double (&return_vals->values[1], sample_threshold);

  return return_vals;
}

static GValueArray *
context_set_sample_threshold_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  gboolean success = TRUE;
  gdouble sample_threshold;

  sample_threshold = g_value_get_double (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "sample-threshold", sample_threshold,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_sample_threshold_int_invoker (GimpProcedure      *procedure,
                                          Gimp               *gimp,
                                          GimpContext        *context,
                                          GimpProgress       *progress,
                                          const GValueArray  *args,
                                          GError            **error)
{
  GValueArray *return_vals;
  gint32 sample_threshold = 0;

  gdouble threshold;

  g_object_get (context,
                "sample-threshold", &threshold,
                NULL);

  sample_threshold = (gint) (threshold * 255.99);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_int (&return_vals->values[1], sample_threshold);

  return return_vals;
}

static GValueArray *
context_set_sample_threshold_int_invoker (GimpProcedure      *procedure,
                                          Gimp               *gimp,
                                          GimpContext        *context,
                                          GimpProgress       *progress,
                                          const GValueArray  *args,
                                          GError            **error)
{
  gboolean success = TRUE;
  gint32 sample_threshold;

  sample_threshold = g_value_get_int (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "sample-threshold", (gdouble) sample_threshold / 255.0,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_sample_transparent_invoker (GimpProcedure      *procedure,
                                        Gimp               *gimp,
                                        GimpContext        *context,
                                        GimpProgress       *progress,
                                        const GValueArray  *args,
                                        GError            **error)
{
  GValueArray *return_vals;
  gboolean sample_transparent = FALSE;

  g_object_get (context,
                "sample-transparent", &sample_transparent,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_boolean (&return_vals->values[1], sample_transparent);

  return return_vals;
}

static GValueArray *
context_set_sample_transparent_invoker (GimpProcedure      *procedure,
                                        Gimp               *gimp,
                                        GimpContext        *context,
                                        GimpProgress       *progress,
                                        const GValueArray  *args,
                                        GError            **error)
{
  gboolean success = TRUE;
  gboolean sample_transparent;

  sample_transparent = g_value_get_boolean (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "sample-transparent", sample_transparent,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_interpolation_invoker (GimpProcedure      *procedure,
                                   Gimp               *gimp,
                                   GimpContext        *context,
                                   GimpProgress       *progress,
                                   const GValueArray  *args,
                                   GError            **error)
{
  GValueArray *return_vals;
  gint32 interpolation = 0;

  g_object_get (context,
                "interpolation", &interpolation,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (&return_vals->values[1], interpolation);

  return return_vals;
}

static GValueArray *
context_set_interpolation_invoker (GimpProcedure      *procedure,
                                   Gimp               *gimp,
                                   GimpContext        *context,
                                   GimpProgress       *progress,
                                   const GValueArray  *args,
                                   GError            **error)
{
  gboolean success = TRUE;
  gint32 interpolation;

  interpolation = g_value_get_enum (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "interpolation", interpolation,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_transform_direction_invoker (GimpProcedure      *procedure,
                                         Gimp               *gimp,
                                         GimpContext        *context,
                                         GimpProgress       *progress,
                                         const GValueArray  *args,
                                         GError            **error)
{
  GValueArray *return_vals;
  gint32 transform_direction = 0;

  g_object_get (context,
                "transform-direction", &transform_direction,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (&return_vals->values[1], transform_direction);

  return return_vals;
}

static GValueArray *
context_set_transform_direction_invoker (GimpProcedure      *procedure,
                                         Gimp               *gimp,
                                         GimpContext        *context,
                                         GimpProgress       *progress,
                                         const GValueArray  *args,
                                         GError            **error)
{
  gboolean success = TRUE;
  gint32 transform_direction;

  transform_direction = g_value_get_enum (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "transform-direction", transform_direction,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_transform_resize_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  GValueArray *return_vals;
  gint32 transform_resize = 0;

  g_object_get (context,
                "transform-resize", &transform_resize,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_enum (&return_vals->values[1], transform_resize);

  return return_vals;
}

static GValueArray *
context_set_transform_resize_invoker (GimpProcedure      *procedure,
                                      Gimp               *gimp,
                                      GimpContext        *context,
                                      GimpProgress       *progress,
                                      const GValueArray  *args,
                                      GError            **error)
{
  gboolean success = TRUE;
  gint32 transform_resize;

  transform_resize = g_value_get_enum (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "transform-resize", transform_resize,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
context_get_transform_recursion_invoker (GimpProcedure      *procedure,
                                         Gimp               *gimp,
                                         GimpContext        *context,
                                         GimpProgress       *progress,
                                         const GValueArray  *args,
                                         GError            **error)
{
  GValueArray *return_vals;
  gint32 transform_recursion = 0;

  g_object_get (context,
                "transform-recursion", &transform_recursion,
                NULL);

  return_vals = gimp_procedure_get_return_values (procedure, TRUE, NULL);
  g_value_set_int (&return_vals->values[1], transform_recursion);

  return return_vals;
}

static GValueArray *
context_set_transform_recursion_invoker (GimpProcedure      *procedure,
                                         Gimp               *gimp,
                                         GimpContext        *context,
                                         GimpProgress       *progress,
                                         const GValueArray  *args,
                                         GError            **error)
{
  gboolean success = TRUE;
  gint32 transform_recursion;

  transform_recursion = g_value_get_int (&args->values[0]);

  if (success)
    {
      g_object_set (context,
                    "transform-recursion", transform_recursion,
                    NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_context_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-context-push
   */
  procedure = gimp_procedure_new (context_push_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-push");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-push",
                                     "Pushes a context to the top of the plug-in's context stack.",
                                     "This procedure creates a new context by copying the current context. This copy becomes the new current context for the calling plug-in until it is popped again using 'gimp-context-pop'.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-pop
   */
  procedure = gimp_procedure_new (context_pop_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-pop");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-pop",
                                     "Pops the topmost context from the plug-in's context stack.",
                                     "This procedure removes the topmost context from the plug-in's context stack. The context that was active before the corresponding call to 'gimp-context-push' becomes the new current context of the plug-in.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-defaults
   */
  procedure = gimp_procedure_new (context_set_defaults_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-defaults");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-defaults",
                                     "Reset context settings to their default values.",
                                     "This procedure resets context settings used by various procedures to their default value. This procedure will usually be called after a context push so that a script which calls procedures affected by context settings will not be affected by changes in the global context.",
                                     "Kevin Cozens <kcozens@svn.gnome.org>",
                                     "Kevin Cozens",
                                     "2011",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-list-paint-methods
   */
  procedure = gimp_procedure_new (context_list_paint_methods_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-list-paint-methods");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-list-paint-methods",
                                     "Lists the available paint methods.",
                                     "This procedure lists the names of the available paint methods. Any of the results can be used for 'gimp-context-set-paint-method'.",
                                     "Simon Budig",
                                     "Simon Budig",
                                     "2007",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("num-paint-methods",
                                                          "num paint methods",
                                                          "The number of the available paint methods",
                                                          0, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string_array ("paint-methods",
                                                                 "paint methods",
                                                                 "The names of the available paint methods",
                                                                 GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-paint-method
   */
  procedure = gimp_procedure_new (context_get_paint_method_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-paint-method");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-paint-method",
                                     "Retrieve the currently active paint method.",
                                     "This procedure returns the name of the currently active paint method.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active paint method",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-paint-method
   */
  procedure = gimp_procedure_new (context_set_paint_method_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-paint-method");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-paint-method",
                                     "Set the specified paint method as the active paint method.",
                                     "This procedure allows the active paint method to be set by specifying its name. The name is simply a string which corresponds to one of the names of the available paint methods. If there is no matching method found, this procedure will return an error. Otherwise, the specified method becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2005",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the paint method",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-foreground
   */
  procedure = gimp_procedure_new (context_get_foreground_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-foreground");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-foreground",
                                     "Get the current GIMP foreground color.",
                                     "This procedure returns the current GIMP foreground color. The foreground color is used in a variety of tools such as paint tools, blending, and bucket fill.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("foreground",
                                                        "foreground",
                                                        "The foreground color",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-foreground
   */
  procedure = gimp_procedure_new (context_set_foreground_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-foreground");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-foreground",
                                     "Set the current GIMP foreground color.",
                                     "This procedure sets the current GIMP foreground color. After this is set, operations which use foreground such as paint tools, blending, and bucket fill will use the new value.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("foreground",
                                                    "foreground",
                                                    "The foreground color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-background
   */
  procedure = gimp_procedure_new (context_get_background_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-background");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-background",
                                     "Get the current GIMP background color.",
                                     "This procedure returns the current GIMP background color. The background color is used in a variety of tools such as blending, erasing (with non-alpha images), and image filling.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_rgb ("background",
                                                        "background",
                                                        "The background color",
                                                        FALSE,
                                                        NULL,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-background
   */
  procedure = gimp_procedure_new (context_set_background_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-background");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-background",
                                     "Set the current GIMP background color.",
                                     "This procedure sets the current GIMP background color. After this is set, operations which use background such as blending, filling images, clearing, and erasing (in non-alpha images) will use the new value.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rgb ("background",
                                                    "background",
                                                    "The background color",
                                                    FALSE,
                                                    NULL,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-default-colors
   */
  procedure = gimp_procedure_new (context_set_default_colors_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-default-colors");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-default-colors",
                                     "Set the current GIMP foreground and background colors to black and white.",
                                     "This procedure sets the current GIMP foreground and background colors to their initial default values, black and white.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-swap-colors
   */
  procedure = gimp_procedure_new (context_swap_colors_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-swap-colors");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-swap-colors",
                                     "Swap the current GIMP foreground and background colors.",
                                     "This procedure swaps the current GIMP foreground and background colors, so that the new foreground color becomes the old background color and vice versa.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-opacity
   */
  procedure = gimp_procedure_new (context_get_opacity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-opacity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-opacity",
                                     "Get the opacity.",
                                     "This procedure returns the opacity setting. The return value is a floating point number between 0 and 100.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("opacity",
                                                        "opacity",
                                                        "The opacity",
                                                        0, 100, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-opacity
   */
  procedure = gimp_procedure_new (context_set_opacity_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-opacity");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-opacity",
                                     "Set the opacity.",
                                     "This procedure modifies the opacity setting. The value should be a floating point number between 0 and 100.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("opacity",
                                                    "opacity",
                                                    "The opacity",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-paint-mode
   */
  procedure = gimp_procedure_new (context_get_paint_mode_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-paint-mode");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-paint-mode",
                                     "Get the paint mode.",
                                     "This procedure returns the paint-mode setting. The return value is an integer which corresponds to the values listed in the argument description.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("paint-mode",
                                                      "paint mode",
                                                      "The paint mode",
                                                      GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                      GIMP_NORMAL_MODE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-paint-mode
   */
  procedure = gimp_procedure_new (context_set_paint_mode_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-paint-mode");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-paint-mode",
                                     "Set the paint mode.",
                                     "This procedure modifies the paint_mode setting.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("paint-mode",
                                                  "paint mode",
                                                  "The paint mode",
                                                  GIMP_TYPE_LAYER_MODE_EFFECTS,
                                                  GIMP_NORMAL_MODE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-brush
   */
  procedure = gimp_procedure_new (context_get_brush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-brush");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-brush",
                                     "Retrieve the currently active brush.",
                                     "This procedure returns the name of the currently active brush. All paint operations and stroke operations use this brush to control the application of paint to the image.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active brush",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-brush
   */
  procedure = gimp_procedure_new (context_set_brush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-brush");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-brush",
                                     "Set the specified brush as the active brush.",
                                     "This procedure allows the active brush to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed brushes. If there is no matching brush found, this procedure will return an error. Otherwise, the specified brush becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the brush",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-pattern
   */
  procedure = gimp_procedure_new (context_get_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-pattern");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-pattern",
                                     "Retrieve the currently active pattern.",
                                     "This procedure returns name of the the currently active pattern. All clone and bucket-fill operations with patterns will use this pattern to control the application of paint to the image.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active pattern",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-pattern
   */
  procedure = gimp_procedure_new (context_set_pattern_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-pattern");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-pattern",
                                     "Set the specified pattern as the active pattern.",
                                     "This procedure allows the active pattern to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed patterns. If there is no matching pattern found, this procedure will return an error. Otherwise, the specified pattern becomes active and will be used in all subsequent paint operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the pattern",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-gradient
   */
  procedure = gimp_procedure_new (context_get_gradient_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-gradient");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-gradient",
                                     "Retrieve the currently active gradient.",
                                     "This procedure returns the name of the currently active gradient.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active gradient",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-gradient
   */
  procedure = gimp_procedure_new (context_set_gradient_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-gradient");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-gradient",
                                     "Sets the specified gradient as the active gradient.",
                                     "This procedure lets you set the specified gradient as the active or \"current\" one. The name is simply a string which corresponds to one of the loaded gradients. If no matching gradient is found, this procedure will return an error. Otherwise, the specified gradient will become active and will be used for subsequent custom gradient operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the gradient",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-palette
   */
  procedure = gimp_procedure_new (context_get_palette_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-palette");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-palette",
                                     "Retrieve the currently active palette.",
                                     "This procedure returns the name of the the currently active palette.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active palette",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-palette
   */
  procedure = gimp_procedure_new (context_set_palette_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-palette");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-palette",
                                     "Set the specified palette as the active palette.",
                                     "This procedure allows the active palette to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed palettes. If no matching palette is found, this procedure will return an error. Otherwise, the specified palette becomes active and will be used in all subsequent palette operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the palette",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-font
   */
  procedure = gimp_procedure_new (context_get_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-font");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-font",
                                     "Retrieve the currently active font.",
                                     "This procedure returns the name of the currently active font.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("name",
                                                           "name",
                                                           "The name of the active font",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-font
   */
  procedure = gimp_procedure_new (context_set_font_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-font");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-font",
                                     "Set the specified font as the active font.",
                                     "This procedure allows the active font to be set by specifying its name. The name is simply a string which corresponds to one of the names of the installed fonts. If no matching font is found, this procedure will return an error. Otherwise, the specified font becomes active and will be used in all subsequent font operations.",
                                     "Michael Natterer <mitch@gimp.org> & Sven Neumann <sven@gimp.org>",
                                     "Michael Natterer & Sven Neumann",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("name",
                                                       "name",
                                                       "The name of the font",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-antialias
   */
  procedure = gimp_procedure_new (context_get_antialias_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-antialias");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-antialias",
                                     "Get the antialias setting.",
                                     "This procedure returns the antialias setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("antialias",
                                                         "antialias",
                                                         "The antialias setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-antialias
   */
  procedure = gimp_procedure_new (context_set_antialias_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-antialias");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-antialias",
                                     "Set the antialias setting.",
                                     "This procedure modifies the antialias setting. If antialiasing is turned on, the edges of selected region will contain intermediate values which give the appearance of a sharper, less pixelized edge. This should be set as TRUE most of the time unless a binary-only selection is wanted. This settings affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color', 'gimp-image-select-round-rectangle', 'gimp-image-select-ellipse', 'gimp-image-select-polygon', 'gimp-image-select-item'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("antialias",
                                                     "antialias",
                                                     "The antialias setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-feather
   */
  procedure = gimp_procedure_new (context_get_feather_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-feather");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-feather",
                                     "Get the feather setting.",
                                     "This procedure returns the feather setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("feather",
                                                         "feather",
                                                         "The feather setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-feather
   */
  procedure = gimp_procedure_new (context_set_feather_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-feather");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-feather",
                                     "Set the feather setting.",
                                     "This procedure modifies the feather setting. If the feather option is enabled, selections will be blurred before combining. The blur is a gaussian blur; its radii can be controlled using 'gimp-context-set-feather-radius'. This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color', 'gimp-image-select-rectangle', 'gimp-image-select-round-rectangle', 'gimp-image-select-ellipse', 'gimp-image-select-polygon', 'gimp-image-select-item'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("feather",
                                                     "feather",
                                                     "The feather setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-feather-radius
   */
  procedure = gimp_procedure_new (context_get_feather_radius_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-feather-radius");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-feather-radius",
                                     "Get the feather radius setting.",
                                     "This procedure returns the feather radius setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("feather-radius-x",
                                                        "feather radius x",
                                                        "The horizontal feather radius",
                                                        0, 1000, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("feather-radius-y",
                                                        "feather radius y",
                                                        "The vertical feather radius",
                                                        0, 1000, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-feather-radius
   */
  procedure = gimp_procedure_new (context_set_feather_radius_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-feather-radius");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-feather-radius",
                                     "Set the feather radius setting.",
                                     "This procedure modifies the feather radius setting. This setting affects the all procedures that are affected by 'gimp-context-set-feather'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("feather-radius-x",
                                                    "feather radius x",
                                                    "The horizontal feather radius",
                                                    0, 1000, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("feather-radius-y",
                                                    "feather radius y",
                                                    "The vertical feather radius",
                                                    0, 1000, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-merged
   */
  procedure = gimp_procedure_new (context_get_sample_merged_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-merged");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-merged",
                                     "Get the sample merged setting.",
                                     "This procedure returns the sample merged setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("sample-merged",
                                                         "sample merged",
                                                         "The sample merged setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-merged
   */
  procedure = gimp_procedure_new (context_set_sample_merged_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-merged");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-merged",
                                     "Set the sample merged setting.",
                                     "This procedure modifies the sample merged setting. If an operation depends on the colors of the pixels present in a drawable, like when doing a seed fill, this setting controls whether the pixel data from the specified drawable is used ('sample-merged' is FALSE), or the pixel data from the composite image ('sample-merged' is TRUE. This is equivalent to sampling for colors after merging all visible layers). This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("sample-merged",
                                                     "sample merged",
                                                     "The sample merged setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-criterion
   */
  procedure = gimp_procedure_new (context_get_sample_criterion_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-criterion");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-criterion",
                                     "Get the sample criterion setting.",
                                     "This procedure returns the sample criterion setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("sample-criterion",
                                                      "sample criterion",
                                                      "The sample criterion setting",
                                                      GIMP_TYPE_SELECT_CRITERION,
                                                      GIMP_SELECT_CRITERION_COMPOSITE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-criterion
   */
  procedure = gimp_procedure_new (context_set_sample_criterion_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-criterion");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-criterion",
                                     "Set the sample criterion setting.",
                                     "This procedure modifies the sample criterion setting. If an operation depends on the colors of the pixels present in a drawable, like when doing a seed fill, this setting controls how color similarity is determined. SELECT_CRITERION_COMPOSITE is the default value. This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("sample-criterion",
                                                  "sample criterion",
                                                  "The sample criterion setting",
                                                  GIMP_TYPE_SELECT_CRITERION,
                                                  GIMP_SELECT_CRITERION_COMPOSITE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-threshold
   */
  procedure = gimp_procedure_new (context_get_sample_threshold_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-threshold");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-threshold",
                                     "Get the sample threshold setting.",
                                     "This procedure returns the sample threshold setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("sample-threshold",
                                                        "sample threshold",
                                                        "The sample threshold setting",
                                                        0.0, 1.0, 0.0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-threshold
   */
  procedure = gimp_procedure_new (context_set_sample_threshold_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-threshold");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-threshold",
                                     "Set the sample threshold setting.",
                                     "This procedure modifies the sample threshold setting. If an operation depends on the colors of the pixels present in a drawable, like when doing a seed fill, this setting controls what is \"sufficiently close\" to be considered a similar color. If the sample threshold has not been set explicitly, the default threshold set in gimprc will be used. This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("sample-threshold",
                                                    "sample threshold",
                                                    "The sample threshold setting",
                                                    0.0, 1.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-threshold-int
   */
  procedure = gimp_procedure_new (context_get_sample_threshold_int_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-threshold-int");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-threshold-int",
                                     "Get the sample threshold setting as an integer value.",
                                     "This procedure returns the sample threshold setting as an integer value. See 'gimp-context-get-sample-threshold'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("sample-threshold",
                                                          "sample threshold",
                                                          "The sample threshold setting",
                                                          0, 255, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-threshold-int
   */
  procedure = gimp_procedure_new (context_set_sample_threshold_int_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-threshold-int");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-threshold-int",
                                     "Set the sample threshold setting as an integer value.",
                                     "This procedure modifies the sample threshold setting as an integer value. See 'gimp-context-set-sample-threshold'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("sample-threshold",
                                                      "sample threshold",
                                                      "The sample threshold setting",
                                                      0, 255, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-sample-transparent
   */
  procedure = gimp_procedure_new (context_get_sample_transparent_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-sample-transparent");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-sample-transparent",
                                     "Get the sample transparent setting.",
                                     "This procedure returns the sample transparent setting.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("sample-transparent",
                                                         "sample transparent",
                                                         "The sample transparent setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-sample-transparent
   */
  procedure = gimp_procedure_new (context_set_sample_transparent_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-sample-transparent");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-sample-transparent",
                                     "Set the sample transparent setting.",
                                     "This procedure modifies the sample transparent setting. If an operation depends on the colors of the pixels present in a drawable, like when doing a seed fill, this setting controls whether transparency is considered to be a unique selectable color. When this setting is TRUE, transparent areas can be selected or filled. This setting affects the following procedures: 'gimp-image-select-color', 'gimp-image-select-contiguous-color'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2011",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("sample-transparent",
                                                     "sample transparent",
                                                     "The sample transparent setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-interpolation
   */
  procedure = gimp_procedure_new (context_get_interpolation_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-interpolation");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-interpolation",
                                     "Get the interpolation type.",
                                     "This procedure returns the interpolation setting. The return value is an integer which corresponds to the values listed in the argument description. If the interpolation has not been set explicitly by 'gimp-context-set-interpolation', the default interpolation set in gimprc will be used.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("interpolation",
                                                      "interpolation",
                                                      "The interpolation type",
                                                      GIMP_TYPE_INTERPOLATION_TYPE,
                                                      GIMP_INTERPOLATION_NONE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-interpolation
   */
  procedure = gimp_procedure_new (context_set_interpolation_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-interpolation");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-interpolation",
                                     "Set the interpolation type.",
                                     "This procedure modifies the interpolation setting. This setting affects affects the following procedures: 'gimp-item-transform-flip', 'gimp-item-transform-perspective', 'gimp-item-transform-rotate', 'gimp-item-transform-scale', 'gimp-item-transform-shear', 'gimp-item-transform-2d', 'gimp-item-transform-matrix', 'gimp-image-scale', 'gimp-layer-scale'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "The interpolation type",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-transform-direction
   */
  procedure = gimp_procedure_new (context_get_transform_direction_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-transform-direction");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-transform-direction",
                                     "Get the transform direction.",
                                     "This procedure returns the transform direction. The return value is an integer which corresponds to the values listed in the argument description.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("transform-direction",
                                                      "transform direction",
                                                      "The transform direction",
                                                      GIMP_TYPE_TRANSFORM_DIRECTION,
                                                      GIMP_TRANSFORM_FORWARD,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-transform-direction
   */
  procedure = gimp_procedure_new (context_set_transform_direction_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-transform-direction");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-transform-direction",
                                     "Set the transform direction.",
                                     "This procedure modifies the transform direction setting. This setting affects affects the following procedures: 'gimp-item-transform-flip', 'gimp-item-transform-perspective', 'gimp-item-transform-rotate', 'gimp-item-transform-scale', 'gimp-item-transform-shear', 'gimp-item-transform-2d', 'gimp-item-transform-matrix'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "The transform direction",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-transform-resize
   */
  procedure = gimp_procedure_new (context_get_transform_resize_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-transform-resize");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-transform-resize",
                                     "Get the transform resize type.",
                                     "This procedure returns the transform resize setting. The return value is an integer which corresponds to the values listed in the argument description.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("transform-resize",
                                                      "transform resize",
                                                      "The transform resize type",
                                                      GIMP_TYPE_TRANSFORM_RESIZE,
                                                      GIMP_TRANSFORM_RESIZE_ADJUST,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-transform-resize
   */
  procedure = gimp_procedure_new (context_set_transform_resize_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-transform-resize");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-transform-resize",
                                     "Set the transform resize type.",
                                     "This procedure modifies the transform resize setting. When transforming pixels, if the result of a transform operation has a different size than the original area, this setting determines how the resulting area is sized. This setting affects affects the following procedures: 'gimp-item-transform-flip', 'gimp-item-transform-flip-simple', 'gimp-item-transform-perspective', 'gimp-item-transform-rotate', 'gimp-item-transform-rotate-simple', 'gimp-item-transform-scale', 'gimp-item-transform-shear', 'gimp-item-transform-2d', 'gimp-item-transform-matrix'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-resize",
                                                  "transform resize",
                                                  "The transform resize type",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-get-transform-recursion
   */
  procedure = gimp_procedure_new (context_get_transform_recursion_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-get-transform-recursion");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-get-transform-recursion",
                                     "Get the transform supersampling recursion.",
                                     "This procedure returns the transform supersampling recursion level.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("transform-recursion",
                                                          "transform recursion",
                                                          "The transform recursion level",
                                                          1, G_MAXINT32, 1,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-context-set-transform-recursion
   */
  procedure = gimp_procedure_new (context_set_transform_recursion_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-context-set-transform-recursion");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-context-set-transform-recursion",
                                     "Set the transform supersampling recursion.",
                                     "This procedure modifies the transform supersampling recursion level setting. Whether or not a transformation does supersampling is determined by the interplolation type. The recursion level defaults to 3, which is a nice default value. This setting affects affects the following procedures: 'gimp-item-transform-flip', 'gimp-item-transform-perspective', 'gimp-item-transform-rotate', 'gimp-item-transform-scale', 'gimp-item-transform-shear', 'gimp-item-transform-2d', 'gimp-item-transform-matrix'.",
                                     "Michael Natterer <mitch@gimp.org>",
                                     "Michael Natterer",
                                     "2010",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("transform-recursion",
                                                      "transform recursion",
                                                      "The transform recursion level",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
