/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimagecolorprofile_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpimagecolorprofile
 * @title: gimpimagecolorprofile
 * @short_description: Operations on an image's color profile.
 *
 * Operations on an image's color profile.
 **/


/**
 * _gimp_image_get_color_profile:
 * @image: The image.
 * @num_bytes: (out): Number of bytes in the color_profile array.
 *
 * Returns the image's color profile
 *
 * This procedure returns the image's color profile, or NULL if the
 * image has no color profile assigned.
 *
 * Returns: (array length=num_bytes) (element-type guint8) (transfer full):
 *          The image's serialized color profile.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.10
 **/
guint8 *
_gimp_image_get_color_profile (GimpImage *image,
                               gint      *num_bytes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint8 *profile_data = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-get-color-profile",
                                              args);
  gimp_value_array_unref (args);

  *num_bytes = 0;

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      *num_bytes = GIMP_VALUES_GET_INT (return_vals, 1);
      profile_data = GIMP_VALUES_DUP_UINT8_ARRAY (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return profile_data;
}

/**
 * _gimp_image_get_effective_color_profile:
 * @image: The image.
 * @num_bytes: (out): Number of bytes in the color_profile array.
 *
 * Returns the color profile that is used for the image
 *
 * This procedure returns the color profile that is actually used for
 * this image, which is the profile returned by
 * gimp_image_get_color_profile() if the image has a profile assigned,
 * or a generated default RGB or grayscale profile, according to the
 * image's type.
 *
 * Returns: (array length=num_bytes) (element-type guint8) (transfer full):
 *          The image's serialized color profile.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.10
 **/
guint8 *
_gimp_image_get_effective_color_profile (GimpImage *image,
                                         gint      *num_bytes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint8 *profile_data = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-get-effective-color-profile",
                                              args);
  gimp_value_array_unref (args);

  *num_bytes = 0;

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      *num_bytes = GIMP_VALUES_GET_INT (return_vals, 1);
      profile_data = GIMP_VALUES_DUP_UINT8_ARRAY (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return profile_data;
}

/**
 * _gimp_image_set_color_profile:
 * @image: The image.
 * @num_bytes: Number of bytes in the color_profile array.
 * @color_profile: (array length=num_bytes) (element-type guint8): The new serialized color profile.
 *
 * Sets the image's color profile
 *
 * This procedure sets the image's color profile, or unsets it if NULL
 * is passed as 'color_profile'. This procedure does no color
 * conversion. However, it will change the pixel format of all layers
 * to contain the babl space matching the profile. You must call this
 * procedure before adding layers to the image.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
_gimp_image_set_color_profile (GimpImage    *image,
                               gint          num_bytes,
                               const guint8 *color_profile)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_INT, num_bytes,
                                          GIMP_TYPE_UINT8_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_uint8_array (gimp_value_array_index (args, 2), color_profile, num_bytes);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-set-color-profile",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_set_color_profile_from_file:
 * @image: The image.
 * @file: The file containing the new color profile.
 *
 * Sets the image's color profile from an ICC file
 *
 * This procedure sets the image's color profile from a file containing
 * an ICC profile, or unsets it if NULL is passed as 'file'. This
 * procedure does no color conversion. However, it will change the
 * pixel format of all layers to contain the babl space matching the
 * profile. You must call this procedure before adding layers to the
 * image.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_image_set_color_profile_from_file (GimpImage *image,
                                        GFile     *file)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_FILE, file,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-set-color-profile-from-file",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_image_get_simulation_profile:
 * @image: The image.
 * @num_bytes: (out): Number of bytes in the color_profile array.
 *
 * Returns the image's simulation color profile
 *
 * This procedure returns the image's simulation color profile, or NULL
 * if the image has no simulation color profile assigned.
 *
 * Returns: (array length=num_bytes) (element-type guint8) (transfer full):
 *          The image's serialized simulation color profile.
 *          The returned value must be freed with g_free().
 *
 * Since: 3.0
 **/
guint8 *
_gimp_image_get_simulation_profile (GimpImage *image,
                                    gint      *num_bytes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint8 *profile_data = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-get-simulation-profile",
                                              args);
  gimp_value_array_unref (args);

  *num_bytes = 0;

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      *num_bytes = GIMP_VALUES_GET_INT (return_vals, 1);
      profile_data = GIMP_VALUES_DUP_UINT8_ARRAY (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return profile_data;
}

/**
 * _gimp_image_set_simulation_profile:
 * @image: The image.
 * @num_bytes: Number of bytes in the color_profile array.
 * @color_profile: (array length=num_bytes) (element-type guint8): The new serialized simulation color profile.
 *
 * Sets the image's simulation color profile
 *
 * This procedure sets the image's simulation color profile, or unsets
 * it if NULL is passed as 'color_profile'. This procedure does no
 * color conversion.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
_gimp_image_set_simulation_profile (GimpImage    *image,
                                    gint          num_bytes,
                                    const guint8 *color_profile)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_INT, num_bytes,
                                          GIMP_TYPE_UINT8_ARRAY, NULL,
                                          G_TYPE_NONE);
  gimp_value_set_uint8_array (gimp_value_array_index (args, 2), color_profile, num_bytes);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-set-simulation-profile",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_set_simulation_profile_from_file:
 * @image: The image.
 * @file: The file containing the new simulation color profile.
 *
 * Sets the image's simulation color profile from an ICC file
 *
 * This procedure sets the image's simulation color profile from a file
 * containing an ICC profile, or unsets it if NULL is passed as 'file'.
 * This procedure does no color conversion.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
gimp_image_set_simulation_profile_from_file (GimpImage *image,
                                             GFile     *file)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_FILE, file,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-set-simulation-profile-from-file",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_simulation_intent:
 * @image: The image.
 *
 * Returns the image's simulation rendering intent
 *
 * This procedure returns the image's simulation rendering intent.
 *
 * Returns: The image's simulation rendering intent.
 *
 * Since: 3.0
 **/
GimpColorRenderingIntent
gimp_image_get_simulation_intent (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpColorRenderingIntent intent = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-get-simulation-intent",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    intent = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return intent;
}

/**
 * gimp_image_set_simulation_intent:
 * @image: The image.
 * @intent: A GimpColorRenderingIntent.
 *
 * Sets the image's simulation rendering intent
 *
 * This procedure sets the image's simulation rendering intent.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
gimp_image_set_simulation_intent (GimpImage                *image,
                                  GimpColorRenderingIntent  intent)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          GIMP_TYPE_COLOR_RENDERING_INTENT, intent,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-set-simulation-intent",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_get_simulation_bpc:
 * @image: The image.
 *
 * Returns whether the image has Black Point Compensation enabled for
 * its simulation
 *
 * This procedure returns whether the image has Black Point
 * Compensation enabled for its simulation
 *
 * Returns: The Black Point Compensation status.
 *
 * Since: 3.0
 **/
gboolean
gimp_image_get_simulation_bpc (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean bpc = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-get-simulation-bpc",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    bpc = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return bpc;
}

/**
 * gimp_image_set_simulation_bpc:
 * @image: The image.
 * @bpc: The Black Point Compensation status.
 *
 * Sets whether the image has Black Point Compensation enabled for its
 * simulation
 *
 * This procedure whether the image has Black Point Compensation
 * enabled for its simulation
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
gimp_image_set_simulation_bpc (GimpImage *image,
                               gboolean   bpc)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_BOOLEAN, bpc,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-set-simulation-bpc",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * _gimp_image_convert_color_profile:
 * @image: The image.
 * @num_bytes: Number of bytes in the color_profile array.
 * @color_profile: (array length=num_bytes) (element-type guint8): The serialized color profile.
 * @intent: Rendering intent.
 * @bpc: Black point compensation.
 *
 * Convert the image's layers to a color profile
 *
 * This procedure converts from the image's color profile (or the
 * default RGB or grayscale profile if none is set) to the given color
 * profile. Only RGB and grayscale color profiles are accepted,
 * according to the image's type.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
_gimp_image_convert_color_profile (GimpImage                *image,
                                   gint                      num_bytes,
                                   const guint8             *color_profile,
                                   GimpColorRenderingIntent  intent,
                                   gboolean                  bpc)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_INT, num_bytes,
                                          GIMP_TYPE_UINT8_ARRAY, NULL,
                                          GIMP_TYPE_COLOR_RENDERING_INTENT, intent,
                                          G_TYPE_BOOLEAN, bpc,
                                          G_TYPE_NONE);
  gimp_value_set_uint8_array (gimp_value_array_index (args, 2), color_profile, num_bytes);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-convert-color-profile",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_convert_color_profile_from_file:
 * @image: The image.
 * @file: The file containing the new color profile.
 * @intent: Rendering intent.
 * @bpc: Black point compensation.
 *
 * Convert the image's layers to a color profile
 *
 * This procedure converts from the image's color profile (or the
 * default RGB or grayscale profile if none is set) to an ICC profile
 * specified by 'file'. Only RGB and grayscale color profiles are
 * accepted, according to the image's type.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_image_convert_color_profile_from_file (GimpImage                *image,
                                            GFile                    *file,
                                            GimpColorRenderingIntent  intent,
                                            gboolean                  bpc)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_FILE, file,
                                          GIMP_TYPE_COLOR_RENDERING_INTENT, intent,
                                          G_TYPE_BOOLEAN, bpc,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-image-convert-color-profile-from-file",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
