/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpdisplay_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpdisplay
 * @title: gimpdisplay
 * @short_description: Functions to create, delete and flush displays (views) on an image.
 *
 * Functions to create, delete and flush displays (views) on an image.
 **/


/**
 * gimp_display_id_is_valid:
 * @display_id: The display ID to check.
 *
 * Returns TRUE if the display ID is valid.
 *
 * This procedure checks if the given display ID is valid and refers to
 * an existing display.
 *
 * Returns: Whether the display ID is valid.
 *
 * Since: 3.0
 **/
gboolean
gimp_display_id_is_valid (gint display_id)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean valid = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, display_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-display-id-is-valid",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    valid = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return valid;
}

/**
 * gimp_display_new:
 * @image: The image.
 *
 * Create a new display for the specified image.
 *
 * Creates a new display for the specified image. If the image already
 * has a display, another is added. Multiple displays are handled
 * transparently by GIMP. The newly created display is returned and can
 * be subsequently destroyed with a call to gimp_display_delete(). This
 * procedure only makes sense for use with the GIMP UI, and will result
 * in an execution error if called when GIMP has no UI.
 *
 * Returns: (transfer none): The new display.
 **/
GimpDisplay *
gimp_display_new (GimpImage *image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpDisplay *display = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-display-new",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    display = GIMP_VALUES_GET_DISPLAY (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return display;
}

/**
 * gimp_display_delete:
 * @display: The display to delete.
 *
 * Delete the specified display.
 *
 * This procedure removes the specified display. If this is the last
 * remaining display for the underlying image, then the image is
 * deleted also. Note that the display is closed no matter if the image
 * is dirty or not. Better save the image before calling this
 * procedure.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_display_delete (GimpDisplay *display)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DISPLAY, display,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-display-delete",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_display_get_window_handle:
 * @display: The display to get the window handle from.
 *
 * Get a handle to the native window for an image display.
 *
 * This procedure returns a handle to the native window for a given
 * image display.
 * It can be different types of data depending on the platform you are
 * running on. For example in the X backend of GDK, a native window
 * handle is an Xlib XID whereas on Wayland, it is a string handle. A
 * value of NULL is returned for an invalid display or if this function
 * is unimplemented for the windowing system that is being used.
 *
 * Returns: (transfer full): The native window handle or NULL.
 *
 * Since: 2.4
 **/
GBytes *
gimp_display_get_window_handle (GimpDisplay *display)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GBytes *handle = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DISPLAY, display,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-display-get-window-handle",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    handle = GIMP_VALUES_DUP_BYTES (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return handle;
}

/**
 * gimp_display_present:
 * @display: The display to present.
 *
 * Present the specified display.
 *
 * This procedure presents the specified display at the top of the
 * display stack.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.0
 **/
gboolean
gimp_display_present (GimpDisplay *display)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_DISPLAY, display,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-display-present",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_displays_flush:
 *
 * Flush all internal changes to the user interface
 *
 * This procedure takes no arguments and returns nothing except a
 * success status. Its purpose is to flush all pending updates of image
 * manipulations to the user interface. It should be called whenever
 * appropriate.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_displays_flush (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-displays-flush",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_displays_reconnect:
 * @old_image: The old image (must have at least one display).
 * @new_image: The new image (must not have a display).
 *
 * Reconnect displays from one image to another image.
 *
 * This procedure connects all displays of the old_image to the
 * new_image. If the old_image has no display or new_image already has
 * a display the reconnect is not performed and the procedure returns
 * without success. You should rarely need to use this function.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_displays_reconnect (GimpImage *old_image,
                         GimpImage *new_image)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, old_image,
                                          GIMP_TYPE_IMAGE, new_image,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-displays-reconnect",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
