/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppattern_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimppattern
 * @title: gimppattern
 * @short_description: Functions operating on a single pattern.
 *
 * Functions operating on a single pattern.
 **/


/**
 * gimp_pattern_get_info:
 * @name: The pattern name.
 * @width: (out): The pattern width.
 * @height: (out): The pattern height.
 * @bpp: (out): The pattern bpp.
 *
 * Retrieve information about the specified pattern.
 *
 * This procedure retrieves information about the specified pattern.
 * This includes the pattern extents (width and height).
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_pattern_get_info (const gchar *name,
                       gint        *width,
                       gint        *height,
                       gint        *bpp)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-pattern-get-info",
                                              args);
  gimp_value_array_unref (args);

  *width = 0;
  *height = 0;
  *bpp = 0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *width = GIMP_VALUES_GET_INT (return_vals, 1);
      *height = GIMP_VALUES_GET_INT (return_vals, 2);
      *bpp = GIMP_VALUES_GET_INT (return_vals, 3);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_pattern_get_pixels:
 * @name: The pattern name.
 * @width: (out): The pattern width.
 * @height: (out): The pattern height.
 * @bpp: (out): The pattern bpp.
 * @num_color_bytes: (out): Number of pattern bytes.
 * @color_bytes: (out) (array length=num_color_bytes) (element-type guint8) (transfer full): The pattern data.
 *
 * Retrieve information about the specified pattern (including pixels).
 *
 * This procedure retrieves information about the specified. This
 * includes the pattern extents (width and height), its bpp and its
 * pixel data.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_pattern_get_pixels (const gchar  *name,
                         gint         *width,
                         gint         *height,
                         gint         *bpp,
                         gint         *num_color_bytes,
                         guint8      **color_bytes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-pattern-get-pixels",
                                              args);
  gimp_value_array_unref (args);

  *width = 0;
  *height = 0;
  *bpp = 0;
  *num_color_bytes = 0;
  *color_bytes = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *width = GIMP_VALUES_GET_INT (return_vals, 1);
      *height = GIMP_VALUES_GET_INT (return_vals, 2);
      *bpp = GIMP_VALUES_GET_INT (return_vals, 3);
      *num_color_bytes = GIMP_VALUES_GET_INT (return_vals, 4);
      *color_bytes = GIMP_VALUES_DUP_UINT8_ARRAY (return_vals, 5);
    }

  gimp_value_array_unref (return_vals);

  return success;
}
