/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpbuffer_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpbuffer
 * @title: gimpbuffer
 * @short_description: Functions for manipulating cut buffers.
 *
 * Functions related to named cut buffers.
 **/


/**
 * gimp_buffers_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_buffers: (out): The number of buffers.
 *
 * Retrieve a complete listing of the available buffers.
 *
 * This procedure returns a complete listing of available named
 * buffers.
 *
 * Returns: (array length=num_buffers) (element-type gchar*) (transfer full):
 *          The list of buffer names.
 *          The returned value must be freed with g_strfreev().
 *
 * Since: 2.4
 **/
gchar **
gimp_buffers_get_list (const gchar *filter,
                       gint        *num_buffers)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar **buffer_list = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, filter,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-buffers-get-list",
                                              args);
  gimp_value_array_unref (args);

  *num_buffers = 0;

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      *num_buffers = GIMP_VALUES_GET_INT (return_vals, 1);
      buffer_list = GIMP_VALUES_DUP_STRING_ARRAY (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return buffer_list;
}

/**
 * gimp_buffer_rename:
 * @buffer_name: The buffer name.
 * @new_name: The buffer's new name.
 *
 * Renames a named buffer.
 *
 * This procedure renames a named buffer.
 *
 * Returns: (transfer full): The real name given to the buffer.
 *          The returned value must be freed with g_free().
 *
 * Since: 2.4
 **/
gchar *
gimp_buffer_rename (const gchar *buffer_name,
                    const gchar *new_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *real_name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, buffer_name,
                                          G_TYPE_STRING, new_name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-buffer-rename",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    real_name = GIMP_VALUES_DUP_STRING (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return real_name;
}

/**
 * gimp_buffer_delete:
 * @buffer_name: The buffer name.
 *
 * Deletes a named buffer.
 *
 * This procedure deletes a named buffer.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.4
 **/
gboolean
gimp_buffer_delete (const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, buffer_name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-buffer-delete",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_buffer_get_width:
 * @buffer_name: The buffer name.
 *
 * Retrieves the specified buffer's width.
 *
 * This procedure retrieves the specified named buffer's width.
 *
 * Returns: The buffer width.
 *
 * Since: 2.4
 **/
gint
gimp_buffer_get_width (const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint width = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, buffer_name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-buffer-get-width",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    width = GIMP_VALUES_GET_INT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return width;
}

/**
 * gimp_buffer_get_height:
 * @buffer_name: The buffer name.
 *
 * Retrieves the specified buffer's height.
 *
 * This procedure retrieves the specified named buffer's height.
 *
 * Returns: The buffer height.
 *
 * Since: 2.4
 **/
gint
gimp_buffer_get_height (const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint height = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, buffer_name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-buffer-get-height",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    height = GIMP_VALUES_GET_INT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return height;
}

/**
 * gimp_buffer_get_bytes:
 * @buffer_name: The buffer name.
 *
 * Retrieves the specified buffer's bytes.
 *
 * This procedure retrieves the specified named buffer's bytes.
 *
 * Returns: The buffer bpp.
 *
 * Since: 2.4
 **/
gint
gimp_buffer_get_bytes (const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint bytes = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, buffer_name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-buffer-get-bytes",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    bytes = GIMP_VALUES_GET_INT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return bytes;
}

/**
 * gimp_buffer_get_image_type:
 * @buffer_name: The buffer name.
 *
 * Retrieves the specified buffer's image type.
 *
 * This procedure retrieves the specified named buffer's image type.
 *
 * Returns: The buffer image type.
 *
 * Since: 2.4
 **/
GimpImageBaseType
gimp_buffer_get_image_type (const gchar *buffer_name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpImageBaseType image_type = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, buffer_name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-buffer-get-image-type",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    image_type = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return image_type;
}
