#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#version 2.0


//needs also:  "ruler1.gif" "clkfce.tga" "page.tga" "frgrnd.gif"
//             "x.inc" "y.inc" "z.inc" "handle.inc"

camera {
   location <-5, 5, -11.43>

   direction <0, 0, 1>
   up  <0, 1, 0>
   right <1.33, 0, 0>
   look_at  <0, .3, 0>
   angle 24
  // focal_point < 0, .3, 0>    // look_at point is the center of focus
  // aperture 0.2     //.4 a nice compromise/0.05 almost everything is in focus/1.5 much blurring
  // blur_samples 200      // more samples, higher quality image 4 low quality
}

light_source  { < .4 , 10 ,-.4> color rgb <.2, .2 .2 >
//area_light 1.5*x,1.5*z, 12, 12 adaptive 0
                spotlight point_at  <0, 0, 0> radius 8 falloff 25 tightness 1 }
light_source { < 15 , 10 , -15 > color rgb <.95, 1, 1>
//area_light 1.0*x,1.0*z, 12, 12 adaptive 1
                spotlight point_at  <0, 0, 0> radius 8 falloff 25 tightness 1 }
light_source { < 0 , 10 , 10 > color rgb <.55, .525, .525>
//area_light 1.0*x,1.0*z, 12, 12 adaptive 0
                spotlight point_at  <0, 0, 0> radius 8 falloff 25 tightness 1 }



//textures - some not used


#declare Yellow_Pine =   // this is adapted from a texture in "Raytracing Worlds"
// Yellow Pine layer 1
texture {
 pigment {
 wood
 turbulence 0.01
  color_map {
   [0.000, 0.222  color rgb <0.808,0.671, 0.251>
	       color rgb <0.808,0.671, 0.251>]
   [0.222, 0.342  color rgb <0.808,0.671, 0.251>
	       color rgb <0.600,0.349, 0.143>]
   [0.342, 0.393  color rgb <0.600,0.349, 0.143>
	       color rgb <0.808,0.671, 0.251>]
   [0.393, 0.709  color rgb <0.808,0.671, 0.251>
	       color rgb <0.808,0.671, 0.251>]
   [0.709, 0.821  color rgb <0.808,0.671, 0.251>
	       color rgb <0.533,0.298, 0.127>]
   [0.821, 1.000  color rgb <0.533,0.298, 0.127>
	       color rgb <0.808,0.671, 0.251>]

  }
  scale 0.1
 }
rotate <0,90,0>
}

// Yellow_Pine layer 2
texture {
 pigment {
 wood
 turbulence 0.003 //was .01
 color_map {
  [0.000, 0.120  color rgbf <1.000, 1.000,1.000, 1.000>
	       color rgbf <0.702, 0.412,0.118, 0.608>]
  [0.120, 0.231  color rgbf <0.702, 0.412,0.118, 0.608>
	       color rgbf <0.702, 0.467,0.118, 0.608>]
  [0.231, 0.496  color rgbf <0.702, 0.467,0.118, 0.608>
	       color rgbf <1.000, 1.000,1.000, 1.000>]
  [0.496, 0.701  color rgbf <1.000, 1.000,1.000, 1.000>
	       color rgbf <1.000, 1.000,1.000, 1.000>]
  [0.701, 0.829  color rgbf <1.000, 1.000,1.000, 1.000>
	       color rgbf <0.702, 0.467,0.118, 0.608>]
  [0.829, 1.000  color rgbf <0.702, 0.467,0.118, 0.608>
	       color rgbf <1.000, 1.000,1.000, 1.000>]

 }

 scale 0.5

 }
rotate <0,90,0>
}





#declare Rulertex =
   texture {
        image_map {
          gif "ruler1.gif"
          map_type 0
          filter 0,1

          interpolate 2
          once
        }
        scale < 7.805,1.1380,1>
        translate <0,-.0025,0>
        rotate <90, 0, 0>
   }


#declare Xtex =
	texture {
                color red .80 green 0.20 blue 0.10
                ambient 0
                phong 1
	}
#declare Ytex =
	texture {
                color red 0.10 green .60 blue 0.10
                ambient 0
                specular 1
              //  phong 1
	}
#declare Ztex =
	texture {
                color red 0.450 green 0.50 blue .80
                ambient 0
                phong 1
	}


#declare Facetex =
   texture {
        image_map {
          tga "clkfce.tga"
          map_type 0
          interpolate 4
          once

        }
        reflection .05
        translate <-.5, -.5, 0>
        scale 2
        rotate <90, 0, 0>
   }

#declare Booktex =
   texture {
          image_map {
          tga "page.tga"
          map_type 0
          interpolate 4
          once
        }
        scale <14,22.42,1>
        translate <-3.5, -10.101, 0>
        rotate <90, 0, 0>
   }


#declare Lens_Glass =
texture {

        color White filter .99
        phong 1
        phong_size 20
        reflection .2
        refraction 1 //was .9
        ior 1.5
        crand  .001
}


#declare Goldtex =

    texture {
       color rgb  <.93,.745,.56>  // was 1 .79 .67   then .95 .745 .54
       reflection .5   //was.5
       ambient .0
       diffuse 0.5
       metallic
       specular 1.5
       roughness .01
    }

#declare Goldtexbu =

    texture {
       color rgb  <.95,.7,.5>
       reflection .7
       ambient .0
       diffuse 0.5
       metallic
       specular 1
       roughness .01
       phong 1.0
       phong_size 150
    }

#declare Silvtex =

    texture {
       color rgb <.42,.42,.46>
       reflection .5
       ambient .05
       diffuse 0.65
       metallic
       phong 1.0 phong_size 200
    }

#declare Brasstex =

    texture {
       color rgb <.55,.42,.2>
       reflection .01
       ambient .05
       diffuse 0.65
       metallic
       phong 1.0 phong_size 200
    }



#declare Gold1 =
texture {
//        0.02
        ambient 0.1
        diffuse 0.7
        colour red 0.68 green 0.51 blue 0.05
	reflection 0.6
        brilliance 8
	specular 0.5
}


#declare Handtex =

    texture {
       color rgb <.2,.25,.6 > //was .3 .35 .8
       reflection .05
       diffuse   0
       metallic
       specular 8 roughness .0002
       phong 8 phong_size 8000
    }


//room

// set up default texture
  #default {
    pigment {
      agate
      color_map {
        [ 0.1 color Black ]
        [0.8 color White ]
        [1.0 color Black]
      }
    }
  }

sphere { <0,0,0>, 80
   inverse
   texture {
     pigment {
       agate_turb .6
       scale <120,120,120>
     }
   }
}

// girl

plane {  z, 0
   texture {
        image_map {
          gif "frgrnd.gif"
          map_type 0
          filter 0, 1
          filter 1, 1
          interpolate 4
          once
        }
        translate <-.7, -.3, 0>
        scale <50,80,1>
        rotate <0,180,0>


   }

bounded_by { box {<-80,-40,-1><80,120,1>}}
rotate <20,20,0>
translate <-13,13,-30>
}


//Book
   union {
     cylinder { <-2.5, 0, -10>,<-2.3, 0, 20>, 2.5
     scale <1,.6,1>
     translate <0,-2.,0>
     texture { Booktex }
     }
     box { <-10, -5, -10><-2.5, -.5, 20>
     texture { Booktex }
     }

     cylinder { <2.3, 0, -10>,<2.3, 0, 20>, 2.5
     scale <1,.6,1>
     translate <0,-2.,0>
     texture { Booktex }
     }
     box { <2.3, -5, -10><10, -.5, 20>
     texture { Booktex }
     }

   }

//ruler

box {<0,-.05,0><7.8,.05,1.1375>
texture {Yellow_Pine}
texture { Rulertex }
translate <-2.5,-.48,-2.92>
}




union { //entire watch

union {   //Watch body
  torus { 1.035, .035 sturm  //rim around lens
    texture { Goldtex }
    bounded_by { box { <-1.11, -.06, -1.11> <1.11, .06, 1.11> }}
    scale <1,.5,1>
    translate <0,.21,0>
    texture { Goldtex }
    }
  difference {  //main shell .21 high from center (.3 scaled by .7)
    torus { 1, .3 sturm
      texture { Goldtex }
      bounded_by { box { <-1.4, -.3, -1.4> <1.4, .3, 1.4> }}
      }
    intersection { Disk_Y
      scale <1, .4, 1>
      texture { Goldtex }
    }
    intersection { Disk_Y
      scale <1.03, .28, 1.1>
      texture { Goldtex }
    }
    box {<-1.4,.1,-1.4>,<1.4,.105,-.4>
      texture { Goldtex }
    }
  scale <1, .7, 1>

  }
  sphere { <0, 0, 0>, 1
    texture { Goldtex }
    scale <1, .1, 1>
    translate <0, -.17, 0>
  }
translate <0, -.2, 0>  //rim ends up (.21 -.2 + lip (.035 *.5)) or .0275
texture { Goldtex }
}





//Watch lens

difference {
    sphere { <0, 0, 0>, 1
        texture { Lens_Glass }
    }
    sphere { <0, 0, 0>, .95
        texture { Lens_Glass }
    }
    plane { y, -.2
        texture { Lens_Glass }
    }
bounded_by { box {<-1.01,-.21,-1.01><1.01,1.01,1.01>} }
scale <1, .1, 1>
translate <0, 0, 0>
}





union { //watch face and hands

union { //Watch face

//top layer with hours - surface at .01

  difference {
    intersection { Disk_Y
      scale <1, .01, 1>
    }
    cone { <0, 1, 0>,1.125 <0, -1, 0>,0 }
    cone { <-.01, .5, -.51>,.615 <-.01, -.5, -.51>,0 }
  texture { Facetex }
  }

//middle layer with "Hamleton" - surface at -.01

  difference {
    intersection { Disk_Y
      scale <1, .01, 1>
      translate <0, -.02, 0>
    }
//bevel
    cone { <-.01, .5, -.51>,.615 <-.01, -.5, -.51>,0 }
//hole
    intersection { Disk_Y
      scale <.05, .06, .05>
      translate <0, -.03, 0>
    }

  texture { Facetex }
  }

//bottom layer with seconds - surface at -.02
  difference {
    intersection { Disk_Y
      scale <1, .01, 1>
      translate <0, -.03, 0>
      texture { Facetex }
    }
//hole
    intersection { Disk_Y
      scale <.05, .06, .05>
      translate <0, -.03, 0>
    }

  }
translate <0,-.05,0> // move top of face down to -.04. (.0675 below rim)
                     // bottom face is -.07
                    // to make shadow
}       // end of face assembly


union {    //Big Hand
          //base
  cylinder { <0, .018, 0>,<0, .02, 0>, .04
  }
          //stem
  difference {
     cylinder { <0, -.18, 0>,<.6, -.18, 0>, .2
     texture { Handtex }
     }

     cylinder { <0, .3, 4>,<0, -.3, 4>, 3.99
     }
     cylinder { <0, .3, -4>,<0, -.3, -4>, 3.99
     }
     cylinder { <.6, .3, 5>,<.6, -.3, 5>, 4.99
     }
     cylinder { <.6, .3, -5>,<.6, -.3, -5>, 4.99
     }

     cylinder { <-.05, -.18, 0>,<.7, -.18, 0>, .199
     }
  texture { Handtex }
  }


  difference {
   intersection {
     cylinder { <.55, -.18, 0>,<.65, -.18, 0>, .2
     texture { Handtex }
     }

     cylinder { <.6, -.3, 0>,<.6, .3, 0>, .045
     }

   }
   cylinder { <.5, -.18, 0>,<.7, -.18, 0>, .199
   }
  texture { Handtex }
  }


//point
//     cylinder { <-.62, -.18, 0>,<1.9, -.18, 0>, .2
//     texture { Handtex }
//     }

  difference {
     cylinder { <.62, -.18, 0>,<.9, -.18, 0>, .2
     texture { Handtex }
     }

     cylinder { <.9, .3, 1>,<.9, -.3, 1>, 1
     }
     cylinder { <.9, .3, -1>,<.9, -.3, -1>, 1
     }

     cylinder { <.6, -.18, 0>,<.95, -.18, 0>, .199
     }
  texture { Handtex }
  }

translate <0,-.055, 0>  //top of hand from .02 to -.035
rotate <0,48,0> //23(desired minutes)/60(total minutes)*360(degrees)-90(starting orientation)=48

} // end of big hand


//Little Hand

union {
//base
  cylinder { <0, .012, 0>,<0, .02, 0>, .045
  }
//stem
  difference {
     cylinder { <0, -.18, 0>,<.6, -.18, 0>, .2
     texture { Handtex }
     }

     cylinder { <0, .3, 4>,<0, -.3, 4>, 3.99
     }
     cylinder { <0, .3, -4>,<0, -.3, -4>, 3.99
     }
     cylinder { <.6, .3, 5>,<.6, -.3, 5>, 4.99
     }
     cylinder { <.6, .3, -5>,<.6, -.3, -5>, 4.99
     }

     cylinder { <-.05, -.18, 0>,<.7, -.18, 0>, .199
     texture { Handtex }
     }
  texture { Handtex }
  }

//head
  difference {
   intersection {
     cylinder { <.45, -.18, 0>,<.75, -.18, 0>, .2
     texture { Handtex }
     }

     cylinder { <0, -.3, 0>,<0, .3, 0>, .045
     scale <1.3334,1,1>
     translate <.6,0,0>
     }

   }
  cylinder { <.5, -.18, 0>,<.7, -.18, 0>, .199
  }
  texture { Handtex }
  }
//point
//     cylinder { <-.62, -.18, 0>,<1.9, -.18, 0>, .2
//     texture { Handtex }
//     }

  difference {
     cylinder { <.62, -.18, 0>,<.9, -.18, 0>, .2
     texture { Handtex }
     }

     cylinder { <.9, -.3, 1>,<.9, .3, 1>, 1
     }
     cylinder { <.9, -.3, -1>,<.9, .3, -1>, 1
     }

     cylinder { <.6, -.18, 0>,<.95, -.18, 0>, .199
     }
  texture { Handtex }
  }
translate <0,-.0575, 0> //put it under the big hand
scale <.8, 1, 1>
rotate <0,-18.5,0> //for 2:23 2*60+23(minutes)/720(total minutes)*360(degrees)-90(starting orientation=11.5
}   // end of little hand

  sphere {<0,-.04,0>,.02   //mounting pin top
     texture {Silvtex}
  }
  intersection { Disk_Y    //mounting pin
     scale <.03,.04,.03>
     translate <0,-.085,0>
     texture {Silvtex}
  }

//sweep
  difference {
    union {
     cylinder { <-.11, 0, 0>,<.3, 0, 0>, .005
     }
     cylinder { <0, -.005, 0>,<0, .002, 0>, .025
     }
     cylinder { <-.11, -.003, 0>,<-.11, .003, 0>, .012
     }
    rotate <0,0,-1>
    }
    plane { y, 0
        texture { Handtex }
  }
  bounded_by { box {<-.15,-.001,-.026><.32,.01,.026>} }
  rotate <0, -80, 0>
  translate <-.01, -.06, -.51>
  texture { Handtex }
  }

//translate <0,.1,0> //move face & hands closer to lens
}


//Winder
//stem
union {
  object {
    difference {
      sphere { <0, 0, 0>,.2
      scale <1.1, .6, .6>
      translate <0, -.2, 1.6>
      texture { Goldtex }
      }
      sphere { <0, 0, 0>,.2
      scale <1.2, 1.2, 1.2>
      translate <0, -.2, 1.9>
      texture { Goldtex }
      }
    }
  texture { Goldtex }
  }
  cone { <0, 0, 1.1>,.12 <0, 0, 1.5>,.06
       scale <1.1, .6, 1>
       translate <0, -.2, 0>
  }
      sphere { <0,0,0>,.13
      scale <.8, .6, 1>
      translate <0,-.2,1.31>

      }


  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,15>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,30>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,45>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,60>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,75>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,90>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,105>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,120>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,135>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,150>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,165>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,180>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,195>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,210>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,225>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,240>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,255>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,270>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,285>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,300>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,315>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,330>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,345>
    translate <0,-.2,1.65>
  }
  sphere {<0, 0, 0>,.15
    scale <1,.18,.6>
    translate <-.05,0,0>
    rotate <0,30,360>
    translate <0,-.2,1.65>
  }
texture { Goldtex }
}
rotate <-30,25,0>

}

#version 1.0
//handle
union {
  #include "handle.inc"
  scale <.00242,.0022,.0022> //.0022*1.1
  rotate <30,0,0>
  translate <0,-.2,1.6>
  rotate <-30,25,0>
  texture { Goldtex }
}

union {
union {

 composite {
  #include "x.inc"
  scale <.004,.004,.002>
  rotate <0,90,0>
  translate <1.85,0,0>
 }
 cone { <2.7,0,0>,.03 <3,0,0>,0
  texture { Goldtex }
 }
  sphere { <0,0,0>,.05
    scale <.8,1,1>
    translate <2.7,0,0>
    texture {Goldtex}

  }
  sphere { <0,0,0>,.04
    scale <.6,1,1>
    translate <2.8,0,0>
    texture {Goldtex}

  }



 cylinder {<0,0,0>,<2.7,0,0>,.015
  texture { Goldtex }
 }

}

composite {
  #include "y.inc"
  scale <.004,.004,.002>
  rotate <90,0,0>
  translate <0,1.85,0>
}

  sphere { <0,0,0>,.05
    scale <1,.8,1>
    translate <0,2.7,0>
    texture {Goldtex}

  }
  sphere { <0,0,0>,.04
    scale <1,.6,1>
    translate <0,2.8,0>
    texture {Goldtex}

  }

cone { <0,2.7,0>,.03 <0,3,0>,0

  texture { Goldtex }
}
cylinder {<0,0,0>,<0,2.7,0>,.015
  texture { Goldtex }
}

union {
composite {
  #include "z.inc"
  scale <.004,.004,.002>
  rotate <0,0,0>
  translate <0,0,1.85>
}

  sphere { <0,0,0>,.05
    scale <1,1,.8>
    translate <0,0,2.7>
    texture {Goldtex}
  }
  sphere { <0,0,0>,.04
    scale <1,1,.6>
    translate <0,0,2.8>
    texture {Goldtex}

  }

cone { <0,0,2.7>,.03 <0,0,3>,0
  texture { Goldtex }
}
cylinder {<0,0,0>,<0,0,2.7>,.02
  texture { Goldtex }
}
sphere {<0,0,0>,.2 texture {Goldtex}}

torus { 1, .04 sturm
  bounded_by { box { <-1.07, -.07, -1.07><1.07, .07, 1.07> }}
  scale <.5,.5,.5>
  rotate <0,0,90>
  texture {Goldtex}
}

torus { .85, .04 sturm
  bounded_by { box { <-1.07, -.07, -1.07><1.07, .07, 1.07> }}

  scale <.5,.5,.5>
  rotate <0,0,0>
  texture {Goldtex}
}

torus { .6, .04 sturm
  bounded_by { box { <-1.07, -.07, -1.07><1.07, .07, 1.07> }}

  scale <.5,.5,.5>
  rotate <90,0,0>
  texture {Goldtex}
}

}
translate <-2.35,-.2,-2>  //x wa -2.25
}
#version 2.0





#declare RR = .3

#declare Link =

union {

    #include "link5.inc"
    rotate <90,20,0> //align along y
    scale <.15, .15,.15>
    texture {Goldtex}
}

//translate along y by the length minus twice the sphere radius

//part attached to watch

union {

object {
 Link
 rotate <0,45,0>
 translate <0,0,0>
}
object {
 Link
 rotate <0,50,0>
 translate <0,.51,0>
}
object {
 Link
 rotate <0,55,0>
 translate <0,1.02,0>
 }
object {
 Link
 rotate <0,60,0>
 translate <0,1.53,0>
 }
object {
 Link
 rotate <0,65,0>
 translate <0,2.04,0>
}
object {
 Link
 rotate <0,70,0>
 translate <0,2.55,0>
 }
object {
 Link
 rotate <0,75,0>
 translate <0,3.06,0>
 }
object {
 Link
 rotate <0,80,0>
 translate <0,3.57,0>
}
object {
 Link
 rotate <0,85,0>
 translate <0,4.08,0>
}
object {
 Link
 rotate <0,90,0>
 translate <0,4.59,0>
 }
object {
 Link
 rotate <0,95,0>
 translate <0,5.10,0>
 }
object {
 Link
 rotate <0,100,0>
 translate <0,5.61,0>
}
object {
 Link
 rotate <0,105,0>
 translate <0,6.12,0>
 }
object {
 Link
 rotate <0,110,0>
 translate <0,6.63,0>
 }
object {
 Link
 rotate <0,115,0>
 translate <0,7.14,0>
}
object {
 Link
 rotate <0,120,0>
 translate <0,7.65,0>
 }
object {
 Link
 rotate <0,125,0>
 translate <0,8.16,0>
 }
object {
 Link
 rotate <0,130,0>
 translate <0,8.67,0>
}
object {
 Link
 rotate <0,135,0>
 translate <0,9.18,0>
 }
object {
 Link
 rotate <0,140,0>
 translate <0,9.69,0>
 }
object {
 Link
 rotate <0,145,0>
 translate <0,10.2,0>
}
object {
 Link
 rotate <0,150,0>
 translate <0,10.71,0>
}
object {
 Link
 rotate <0,155,0>
 translate <0,11.22,0>
 }
object {
 Link
 rotate <0,160,0>
 translate <0,11.73,0>
 }
object {
 Link
 rotate <0,165,0>
 translate <0,12.24,0>
}
object {
 Link
 rotate <0,170,0>
 translate <0,12.75,0>
 }
object {
 Link
 rotate <0,175,0>
 translate <0,13.26,0>
 }
scale <.5, .5, .5>
rotate <0,20,0>
translate <.62,1.824,1.275>
texture {Goldtex}
}
// swivelclip
union {
  difference {
    torus { 1, .23 sturm
      bounded_by { box { <-1.25, -.24, -1.25><1.25, .24, 1.25> }}
    }
    box {<0,-.25,0>,<1.25,.25,1.25>
    rotate <0,-30,0>
    }
    box {<-1.25,-.25,0>,<0,.25,1.25>
    rotate <0,30,0>
    }
  scale <.2, .2, .2>
  }
  intersection { Disk_Z
    scale <.23,.23,1.1>
    translate <1,0,1.1>
    rotate <0,-30,0>
    scale <.2, .2, .2>
  }
  intersection { Disk_Z
    scale <.23,.23,1.1>
    translate <-1,0,1.1>
    rotate <0,30,0>
    scale <.2, .2, .2>
  }
  sphere { <0,0,0>,.15
    scale <1,1,.8>
    translate <0,0,.4>
  }
  sphere { <0,0,0>,.13
    scale <1,1,.6>
    translate <0,0,.5>
  }
  cone {<0,0,0>,.11 <0,0,.13>,.08
    translate <0,0,.55>
  }
  sphere {<0,0,0>,.10
    translate <0,0,.68>
  }
  torus { .17, .035 sturm
    bounded_by { box { <-.21, -.04, -.21><.21, .04, .21> }}
    rotate <0,0,60>
    translate <0,0,.85>

  }
scale <.6,.6,.6>
rotate <-90,100,0>
translate <.62,1.112,1.275>
texture { Goldtex }
}



//curve
union {
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 0>
   }
  object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 15>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 30>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 45>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 60>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 75>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 90>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 105>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 120>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 135>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 150>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 165>
   }
   object {
        Link
        scale <.5, .5, .5>
        translate < 1., 0, 0 >
        rotate <0, 0, 180>
   }


rotate <0,-75,180>
translate <2.5,1.8,2.5>
}

//part of chain attached to clip
union {


union {
object {
 Link
 rotate <0,115,0>
 translate <0,-2.55,0>
}
object {
 Link
 rotate <0,120,0>
 translate <0,-2.04,0>
 }
object {
 Link
 rotate <0,125,0>
 translate <0,-1.53,0>
 }
object {
 Link
 rotate <0,130,0>
 translate <0,-1.02,0>
}

object {
 Link
 rotate <0,115,0>
 translate <0,-.51,0>
}
object {
 Link
 rotate <0,120,0>
 translate <0,0,0>
 }
object {
 Link
 rotate <0,125,0>
 translate <0,.51,0>
 }
object {
 Link
 rotate <0,130,0>
 translate <0,1.02,0>
}
object {
 Link
 rotate <0,135,0>
 translate <0,1.53,0>
 }
object {
 Link
 rotate <0,140,0>
 translate <0,2.04,0>
 }
object {
 Link
 rotate <0,145,0>
 translate <0,2.55,0>
}
object {
 Link
 rotate <0,150,0>
 translate <0,3.06,0>
}
object {
 Link
 rotate <0,155,0>
 translate <0,3.57,0>
 }
object {
 Link
 rotate <0,160,0>
 translate <0,4.08,0>
 }
object {
 Link
 rotate <0,165,0>
 translate <0,4.59,0>
 }

object {
 Link
 rotate <0,115,0>
 translate <0,5.1,0>
}
object {
 Link
 rotate <0,120,0>
 translate <0,5.61,0>
 }
object {
 Link
 rotate <0,125,0>
 translate <0,6.12,0>
 }
object {
 Link
 rotate <0,130,0>
 translate <0,6.63,0>
}

object {
 Link
 rotate <0,115,0>
 translate <0,7.14,0>
}
object {
 Link
 rotate <0,120,0>
 translate <0,7.65,0>
 }
object {
 Link
 rotate <0,125,0>
 translate <0,8.16,0>
 }
object {
 Link
 rotate <0,130,0>
 translate <0,8.67,0>
}
object {
 Link
 rotate <0,135,0>
 translate <0,9.18,0>
 }
object {
 Link
 rotate <0,140,0>
 translate <0,9.69,0>
 }
object {
 Link
 rotate <0,145,0>
 translate <0,10.2,0>
}
object {
 Link
 rotate <0,150,0>
 translate <0,10.71,0>
}
object {
 Link
 rotate <0,155,0>
 translate <0,11.22,0>
 }
object {
 Link
 rotate <0,160,0>
 translate <0,11.73,0>
 }
object {
 Link
 rotate <0,165,0>
 translate <0,12.24,0>
 }
scale <.5, .5, .5>
rotate <180,60,0>
translate <0, 6.72,0>
}


// loop for beltclip

  torus { .13, .02 sturm
    bounded_by { box { <-.2, -.041, -.2><.2, .041, .2> }}
    rotate < 90,40,0 >
    translate <0, .36, 0>
    texture { Goldtex }
  }

//beltclip

difference {
   union {
    union {
      sphere { <0,0,0> .1 }
      sphere { <0,0,-.05> .1 }
      cylinder { <0,0,0><0,0,-.05>,.1 }
    rotate <60,0,0>
    translate <0,0,.4>
    }
    union {
      sphere { <0,0,0> .1 }
      cylinder { <0,0,0><0,0,-.4>,.1 }
    rotate <-60,0,0>
    translate <0,0,.4>
    }
    union {
      sphere { <0,0,0> .1 }
      sphere { <0,0,0> .1 scale <1,1,.35> translate <0,0,-.1375>}
      sphere { <0,0,0> .1 scale <1,1,.35> translate <0,0,-.2>}
      sphere { <0,0,0> .1 scale <1,1,.35> translate <0,0,-.2625>}
      cylinder { <0,0,0><0,0,-.4>,.07 }
    rotate <-60,0,0>
    translate <0,0,.4>
    rotate <60,0,0>
    }
    union {
      sphere { <0,0,0> .1 }
      cylinder { <0,0,0><0,0,-.4>,.1 }
    rotate <-60,0,0>
    translate <0,0,.4>
    rotate <120,0,0>
    }
    union {
      sphere { <0,0,0> .1 }
      cylinder { <0,0,0><0,0,-.7>,.1 }
    rotate <-60,0,0>
    translate <0,0,.4>
    rotate <180,0,0>
    }
    torus { 4, 1.8 sturm
    bounded_by { box {<-6,-2,-6><6,2,6>} }
    scale <.0325,.085,.0325>
    rotate <0,0,90>
    translate <0,.715555,0>
    }
  translate <0,-.715555,0>
  }

 box {<0,-2,-1>,<1,-.55,1>
 }

 box {<-.001,-.19,-.19>,<.5,.19,.19>
 rotate <45,0,0>
 }

scale <.3,.75,.75>
translate <-.01, 0, 0>
rotate <4,0,45>
rotate <0,40,0>
translate <.07, .24, 0>
texture {Goldtex}
}


//flipped part
difference {
  union {
    union {
      sphere { <0,0,0> .1 }
      sphere { <0,0,-.05> .1 }
      cylinder { <0,0,0><0,0,-.05>,.1 }
    rotate <60,0,0>
    translate <0,0,.4>
    }
    union {
      sphere { <0,0,0> .1 }
      cylinder { <0,0,0><0,0,-.4>,.1 }
    rotate <-60,0,0>
    translate <0,0,.4>
    }
    union {
      sphere { <0,0,0> .1 }
      sphere { <0,0,0> .1 scale <1,1,.25> translate <0,0,-.1375>}
      sphere { <0,0,0> .1 scale <1,1,.25> translate <0,0,-.2>}
      sphere { <0,0,0> .1 scale <1,1,.25> translate <0,0,-.2625>}
      cylinder { <0,0,0><0,0,-.4>,.07 }
    rotate <-60,0,0>
    translate <0,0,.4>
    rotate <60,0,0>
    }
    union {
      sphere { <0,0,0> .1 }
      cylinder { <0,0,0><0,0,-.4>,.1 }
    rotate <-60,0,0>
    translate <0,0,.4>
    rotate <120,0,0>
    }
    union {
      sphere { <0,0,0> .1 }
      cylinder { <0,0,0><0,0,-.7>,.1 }
    rotate <-60,0,0>
    translate <0,0,.4>
    rotate <180,0,0>
    }
    torus { 4, 1.8 sturm
    bounded_by { box {<-6,-2,-6><6,2,6>} }
    scale <.0325,.085,.0325>
    rotate <0,0,90>
    translate <0,.715555,0>
    }
  translate <0,-.715555,0>
  }

 box {<0,-2,-1>,<1,-.55,1>
 }

 box {<-.001,-.19,-.19>,<.5,.19,.19>
 rotate <45,0,0>
 }

scale <.3,.75,.75>
translate <-.01, 0, 0>
rotate <4,0,-45>
rotate <0,-140,0>
translate <.07, .24, 0>
texture {Goldtex}
}

rotate <0,23,0>
translate <2.5,-.1,1.5>
}


