
/****************************************************************************/

#define STRICT

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "plugin.h"		// Breeze Designer Plug-In interface
#include "pitools.h"		// Breeze Designer Plug-In tools
#include "pisample.h"

#define FUNCTION_COUNT 7

static PLUGINFUNCTIONS gPlugInFunctions[] = 
	{
	PICLASS_UTIL   ,"TestUtil"	   ,"Test Utility",
	PICLASS_LOAD   ,"TestLoad"	   ,"Test Load",
	PICLASS_SAVE   ,"TestSave"	   ,"Test Save",
	PICLASS_BUILD  ,"TestBuild"	,"Test Build",
	PICLASS_XFORM  ,"TestXform"	,"Test Transform",
	PICLASS_SCREEN ,"TestScreen"  ,"Test Screen",
	NULL			   ,NULL		      ,NULL
	};

static PICALLBACK gFunction = NULL;

static char szFilter[] = "Test File (*.txt) |*.txt||";
static char szInfo[] = "Test plugin";


/****************************************************************************
*
*   Plug-In Filter Sample for Breeze Designer
*   Written by Neville Richards
*
*   Copyright (C) 1994,1995,1996 Neville Richards. All Rights Reserved.
*
*****************************************************************************/

#ifdef _WIN32
/******************************************************************************\
*
*  FUNCTION:    DllMain
*
*  INPUTS:      hDLL       - handle of DLL
*               dwReason   - indicates why DLL called
*               lpReserved - reserved
*
*  RETURNS:     TRUE (always, in this example.)
*
*               Note that the retuRn value is used only when
*               dwReason = DLL_PROCESS_ATTACH.
*
*               Normally the function would return TRUE if DLL initial-
*               ization succeeded, or FALSE it it failed.
*
*  GLOBAL VARS: ghMod - handle of DLL (initialized when PROCESS_ATTACHes)
*
*  COMMENTS:    The function will display a dialog box informing user of
*               each notification message & the name of the attaching/
*               detaching process/thread. For more information see
*               "DllMain" in the Win32 API reference.
*
\******************************************************************************/

BOOL WINAPI DllMain (HINSTANCE hDLL, DWORD dwReason, LPVOID lpReserved)
{
  switch (dwReason)
  {
    case DLL_PROCESS_ATTACH:
      break;

    case DLL_THREAD_ATTACH:
      break;

    case DLL_THREAD_DETACH:
      break;

    case DLL_PROCESS_DETACH:
      break;
  }

return TRUE;
}
#else
/****************************************************************************
   FUNCTION: LibMain(HANDLE, WORD, WORD, LPSTR)

   PURPOSE:  Is called by LibEntry.  LibEntry is called by Windows when
             the DLL is loaded.  The LibEntry routine is provided in
             the LIBENTRY.OBJ in the SDK Link Libraries disk.  (The
             source LIBENTRY.ASM is also provided.)  

             LibEntry initializes the DLL's heap, if a HEAPSIZE value is
             specified in the DLL's DEF file.  Then LibEntry calls
             LibMain.  The LibMain function below satisfies that call.
             
             The LibMain function should perform additional initialization
             tasks required by the DLL.  In this example, no initialization
             tasks are required.  LibMain should return a value of 1 if
             the initialization is successful.
           
*******************************************************************************/
int FAR PASCAL LibMain(HANDLE hModule, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
	return 1;
}

/****************************************************************************
*    FUNCTION:  WEP(int)
*
*    PURPOSE:  Performs cleanup tasks when the DLL is unloaded.  WEP() is
*              called automatically by Windows when the DLL is unloaded (no
*              remaining tasks still have the DLL loaded).  It is strongly
*              recommended that a DLL have a WEP() function, even if it does
*              nothing but returns success (1), as in this example.
*
*/
int FAR PASCAL EXPORT _WEP (int bSystemExit)
{
    return(1);
}
#endif

#ifdef LOCAL
///////////////////////////////////////////////////////////////////////
//
BOOL piLibInit( UINT nVersion, LPPLUGININFO lpInfo, LPPIFNS lpFunctions, UINT nFunctions )
{
	//
	// Check for version number
	//
	if (nVersion != PIVERSION)
		{
		return FALSE;
		}
	//
	// Assign local function table for return
	//
	lpInfo->lpFunctions    = lpFunctions;
	lpInfo->nFunctionCount = nFunctions;

	//
	// No local data block used
	//
	lpInfo->lpPlugInData   = NULL;

	gFunction = lpInfo->lpCallBack;
}

///////////////////////////////////////////////////////////////////////
//
BOOL piLibFuncInit( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData, UINT nMode )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (lpCall->nPluginDataSize != sizeof(PLUGINDATA))
		{
		return FALSE;
		}

	//
	// If basic then TRUE only for get data operations
	//
	if (nMode == PIFUNC_BASIC)
		{
		return (nOperation == PI_GETDATA ? TRUE : FALSE);
		}

	return TRUE;
}
#endif

///////////////////////////////////////////////////////////////////////
//
BOOL OnGetCaps( LPPLUGINDATA lpCall )
{
	//
	// Return capabilities flag
	//
	lpCall->nDataType = PIDATA_FLAGS;
	lpCall->nDataSize = (PI_GETCAPS|PI_GETINFO|PI_CONFIG|PI_GETDATA);

	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL OnGetInfo( LPPLUGINDATA lpCall )
{
	//
	// Return function information string
	//
	lpCall->nDataType = PIDATA_STRING;
	lpCall->nDataSize = lstrlen(szInfo);
	lpCall->lpData    = szInfo;

	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL OnGetFilter( LPPLUGINDATA lpCall )
{
	//
	// Return file filter informatoin
	//
	lpCall->nDataType = PIDATA_STRING;
	lpCall->nDataSize = lstrlen(szFilter);
	lpCall->lpData    = szFilter;

	return TRUE;
}

/****************************************************************************
*
* Initialize one time state.
*
*/
PIAPI piInit( UINT nVersion, LPPLUGININFO lpInfo )
{
	return piLibInit( nVersion, lpInfo, gPlugInFunctions, FUNCTION_COUNT  );
}

/****************************************************************************
*
*   Clean up before unloading.
*/
PIAPI piExit( LPVOID lpLocalData )
{
	//
	// Free local data block if required
	//
	return TRUE;
}

/****************************************************************************
*
*/
PIAPI TestUtil( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	return TRUE;
}

/****************************************************************************
*
*/
PIAPI TestLoad( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	switch (nOperation)
		{
		case PI_GETCAPS:
			return OnGetCaps( lpCall );
			break;

		case PI_GETINFO:
			return OnGetInfo( lpCall );
			break;

		case PI_GETFILTER:
			return OnGetFilter( lpCall );
			break;

		case PI_GETDATA:
			//
			// Create new object(s)
			//
			break;

		default:
			return FALSE;
			break;
		}

	return FALSE;
}

/****************************************************************************
*
*/
PIAPI TestSave( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	switch (nOperation)
		{
		case PI_GETCAPS:
			return OnGetCaps( lpCall );
			break;

		case PI_GETINFO:
			return OnGetInfo( lpCall );
			break;

		case PI_GETFILTER:
			return OnGetFilter( lpCall );
			break;

		case PI_PUTDATA:
			//
			// Get local objects and write out
			//
			break;

		default:
			return FALSE;
			break;
		}

	return FALSE;
}

/****************************************************************************
*
*/
PIAPI TestBuild( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	LPPLUGINDATA lpCall = (LPPLUGINDATA)lpData;

	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	switch (nOperation)
		{
		case PI_GETCAPS:
			return OnGetCaps( lpCall );
			break;

		case PI_GETINFO:
			return OnGetInfo( lpCall );
			break;

		case PI_CONFIG:
			//
			// Call local configuration functions
			//
			break;

		case PI_GETDATA:
			//
			// Create new object(s)
			//
			break;

		default:
			return FALSE;
			break;
		}
	return FALSE;
}

/****************************************************************************
*
*/
PIAPI TestXform( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	return TRUE;
}

/****************************************************************************
*
*/
PIAPI TestScreen( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData )
{
	if (!piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) )
		{
		return FALSE;
		}

	return TRUE;
}

/****************************************************************************/
