/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1998, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell derivative works of
 * "tgif", the right to distribute "tgif" for a fee, and the
 * right to include "tgif" in a for-sale product) are reserved
 * by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/export-filters/foo/RCS/exp1main.c,v 4.0 1999/01/04 19:00:41 william Exp $
 */

#include "exp1main.h"

/*
 * Most of this file does not have to change if you are using
 *     ``protocol version 1'' expect for the next few #define lines.
 */

#include "foo.e"

#define Init               Foo_Init
#define GetProtocolVersion Foo_GetProtocolVersion
#define Load               Foo_Load
#define UnLoad             Foo_UnLoad
#define CleanUp            Foo_CleanUp
#define DoExport           Foo_DoExport

long TgifExportFilterMain(ppUserInfo, nMsg, nArg, pvArg)
   TGEF_USER_INFO *ppUserInfo;
   int nMsg, nArg;
   void *pvArg;
{
   switch (nMsg) {
   case TGEF_MSG_INIT: return Init();
   case TGEF_MSG_GET_PROTOCOL_VERSION: return GetProtocolVersion();
   case TGEF_MSG_LOAD: return Load(ppUserInfo, (TgEFProtocolInfo_1*)pvArg);
   case TGEF_MSG_UNLOAD: return UnLoad(*ppUserInfo);
   case TGEF_MSG_CLEANUP: return CleanUp();

   case TGEF_MSG_DO_EXPORT:
         return DoExport(*ppUserInfo, (TgEFProtocolInfo_1*)pvArg);
   }
   return TGEF_STATUS_UNKNOWN;
}

