/*
 * Author:      Your Name <YourEMail>
 *
 * Copyright (C) 199?-199?, Your Name.
 *
 * @(#)$Header: /mm/src/tgif/v4/export-filters/foo/RCS/foo.c,v 4.0 1999/01/04 19:00:42 william Exp $
 */

#include "../../expfdefs.h"

#include "exp1main.h"

#include "foo.e"

#include "foo.xbm"

static int nTgEFVersion=1; /* TGEF_VERSION passed in from Imakefile must be 1 */

/* --------------------- Utility Functions --------------------- */

          /*------------------------------------------*\
          |  This section should not have to change if |
          |      you are using ``protocol version 1''. |
          \*------------------------------------------*/

static
int Call_MsgBox(pUserInfo, Message, Title, IconAndBtns)
   UserInfo *pUserInfo;
   char *Message, *Title;
   int IconAndBtns;
{
   return ((MsgBoxFunc*)(pUserInfo->stProtocolInfo_1.pfnMsgBox))(Message, Title,
         IconAndBtns);
}

static
int Call_Dialog(pUserInfo, Message, Comment, ReturnStr)
   UserInfo *pUserInfo;
   char *Message, *Comment, *ReturnStr;
{
   return ((DialogFunc*)(pUserInfo->stProtocolInfo_1.pfnDialog))(Message,
         Comment, ReturnStr);
}

static
int Call_FailAllocMessage(pUserInfo)
   UserInfo *pUserInfo;
{
   return ((FailAllocMessageFunc*)(
         pUserInfo->stProtocolInfo_1.pfnFailAllocMessage))();
}

static
int Call_UtilCopyFile(pUserInfo, pszFromFile, pszToFile)
   UserInfo *pUserInfo;
   char *pszFromFile, *pszToFile;
{
   return ((UtilCopyFileFunc*)(pUserInfo->stProtocolInfo_1.pfnUtilCopyFile))(
         pszFromFile, pszToFile);
}

static
int Call_ObjInVisibleLayer(pUserInfo, pObj)
   UserInfo *pUserInfo;
   struct ObjRec *pObj;
{
   return ((ObjInVisibleLayerFunc*)(
         pUserInfo->stProtocolInfo_1.pfnObjInVisibleLayer))(pObj);
}

static
char *Call_UtilStrDup(pUserInfo, pszStr)
   UserInfo *pUserInfo;
   char *pszStr;
{
   return ((UtilStrDupFunc*)(
         pUserInfo->stProtocolInfo_1.pfnUtilStrDup))(pszStr);
}

static
void Call_UtilFree(pUserInfo, pszStr)
   UserInfo *pUserInfo;
   char *pszStr;
{
   ((UtilFreeFunc*)(pUserInfo->stProtocolInfo_1.pfnUtilFree))(pszStr);
}

static
void Call_Msg(pUserInfo, pszMsg)
   UserInfo *pUserInfo;
   char *pszMsg;
{
   ((MsgFunc*)(pUserInfo->stProtocolInfo_1.pfnMsg))(pszMsg);
}

static
void Call_SetStringStatus(pUserInfo, pszMsg)
   UserInfo *pUserInfo;
   char *pszMsg;
{
   ((SetStringStatusFunc*)(pUserInfo->stProtocolInfo_1.pfnSetStringStatus))(
         pszMsg);
}

static
void Call_UtilTrimBlanks(pUserInfo, pszStr)
   UserInfo *pUserInfo;
   char *pszStr;
{
   ((UtilTrimBlanksFunc*)(pUserInfo->stProtocolInfo_1.pfnUtilTrimBlanks))(
         pszStr);
}

static
void Call_DynStrSet(pUserInfo, pDestDynStr, pszStr)
   UserInfo *pUserInfo;
   struct DynStrRec *pDestDynStr;
   char *pszStr;
{
   ((DynStrSetFunc*)(pUserInfo->stProtocolInfo_1.pfnDynStrSet))(
         pDestDynStr, pszStr);
}

/* --------------------- INIT handler --------------------- */

long Foo_Init()
{
#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_INIT.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   return TGEF_STATUS_OK;
}

/* --------------------- CLEANUP handler --------------------- */

long Foo_CleanUp()
{
#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_CLEANUP.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   return TGEF_STATUS_OK;
}

/* --------------------- GET_PROTOCOL_VERSION handler --------------------- */

long Foo_GetProtocolVersion()
{
#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_GET_PROTOCOL_VERSION.\n",
         THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   return (long)nTgEFVersion;
}

/* --------------------- LOAD handler --------------------- */

long Foo_Load(ppUserInfo, pProtocolInfo_1)
   TGEF_USER_INFO *ppUserInfo;
   TgEFProtocolInfo_1 *pProtocolInfo_1;
{
   UserInfo *pUserInfo=NULL;

#ifdef _DEBUG
   char spec[MAXSTRING];

   fprintf(stderr, "%s: Got TGEF_MSG_LOAD.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   if (ppUserInfo == NULL || pProtocolInfo_1 == NULL) {
      return TGEF_STATUS_INVALID_ARGS;
   }
   /*
    * There is only one memory allocation here.  This is deallocated
    *       in Foo_UnLoad().
    */
   pUserInfo = (UserInfo*)malloc(sizeof(UserInfo));
   if (pUserInfo == NULL) return TGEF_STATUS_MALLOC;

   *ppUserInfo = pUserInfo;
   memset(pUserInfo, 0, sizeof(UserInfo));
   memcpy(&pUserInfo->stProtocolInfo_1, pProtocolInfo_1,
         sizeof(TgEFProtocolInfo_1));

#ifdef _DEBUG
*spec = '\0';
Call_Dialog(pUserInfo, "Input something", NULL, spec);
Call_UtilTrimBlanks(pUserInfo, spec);
sprintf(msg_buf(pUserInfo), "``%s''", spec);
Call_MsgBox(pUserInfo, msg_buf(pUserInfo), THIS_EXPORT_FILTER_NAME, INFO_MB);
#endif /* _DEBUG */
   pProtocolInfo_1->bm_bits = (char*)foo_bits;
   pProtocolInfo_1->bm_width = foo_width;
   pProtocolInfo_1->bm_height = foo_height;
   strncpy(pProtocolInfo_1->color_format_name, THIS_COLOR_EXPORT_FILTER_NAME,
         sizeof(pProtocolInfo_1->color_format_name));
   pProtocolInfo_1->color_format_name[
         sizeof(pProtocolInfo_1->color_format_name)-1] = '\0';
   strncpy(pProtocolInfo_1->bw_format_name, THIS_BW_EXPORT_FILTER_NAME,
         sizeof(pProtocolInfo_1->bw_format_name));
   pProtocolInfo_1->bw_format_name[
         sizeof(pProtocolInfo_1->bw_format_name)-1] = '\0';
   strncpy(pProtocolInfo_1->color_ext, THIS_COLOR_EXPORT_FILTER_EXT,
         sizeof(pProtocolInfo_1->color_ext));
   pProtocolInfo_1->color_ext[
         sizeof(pProtocolInfo_1->color_ext)-1] = '\0';
   strncpy(pProtocolInfo_1->bw_ext, THIS_BW_EXPORT_FILTER_EXT,
         sizeof(pProtocolInfo_1->bw_ext));
   pProtocolInfo_1->bw_ext[
         sizeof(pProtocolInfo_1->bw_ext)-1] = '\0';
   pProtocolInfo_1->capability = TGEF_CAP_MULTI_PAGE;

   return TGEF_STATUS_OK;
}

/* --------------------- UNLOAD handler --------------------- */

long Foo_UnLoad(pTgEFUserInfo)
   TGEF_USER_INFO pTgEFUserInfo;
{
#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_UNLOAD.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   if (pTgEFUserInfo != NULL) {
      UserInfo *pUserInfo=(UserInfo*)pTgEFUserInfo;
      TgEFProtocolInfo_1 *pProtocolInfo_1=(&pUserInfo->stProtocolInfo_1);

      if (pProtocolInfo_1 != NULL) {
         /*
          * Is there anything to clean up here?
          */
      }
      /*
       * There is only one memory deallocation here.  This memory is
       *       allocated in Foo_Load().
       */
      free(pUserInfo);
   }
   return TGEF_STATUS_OK;
}

/* --------------------- DO_EXPORT handler --------------------- */

long Foo_DoExport(pTgEFUserInfo, pProtocolInfo_1)
   TGEF_USER_INFO pTgEFUserInfo;
   TgEFProtocolInfo_1 *pProtocolInfo_1;
{
   UserInfo *pUserInfo=(UserInfo*)pTgEFUserInfo;

#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_DO_EXPORT.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   if (pUserInfo) { }

   /*
    * Ignore color_dump for now because we are just dumping whatever.
    */
   if (pProtocolInfo_1->color_dump) {
   } else {
   }
   return TGEF_STATUS_OK;
}

