=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::NotesCommentsLayoutingOptions;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::SlidesLayoutOptions;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Notes &amp;amp; comments layouting options.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	$self->{ layout_type } = 'NotesComments';
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Notes &amp;amp; comments layouting options.',
                                  class => 'NotesCommentsLayoutingOptions',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'layout_type' => {
    	datatype => 'string',
    	base_name => 'LayoutType',
    	description => '',
    	format => '',
    	read_only => '',
    		},
    'notes_position' => {
    	datatype => 'string',
    	base_name => 'NotesPosition',
    	description => 'Gets or sets the position of the notes on the page.',
    	format => '',
    	read_only => '',
    		},
    'comments_position' => {
    	datatype => 'string',
    	base_name => 'CommentsPosition',
    	description => 'Gets or sets the position of the comments on the page.',
    	format => '',
    	read_only => '',
    		},
    'comments_area_width' => {
    	datatype => 'int',
    	base_name => 'CommentsAreaWidth',
    	description => 'Gets or sets the width of the comment output area in pixels (Applies only if comments are displayed on the right).',
    	format => '',
    	read_only => '',
    		},
    'comments_area_color' => {
    	datatype => 'string',
    	base_name => 'CommentsAreaColor',
    	description => 'Gets or sets the color of comments area (Applies only if comments are displayed on the right).',
    	format => '',
    	read_only => '',
    		},
    'show_comments_by_no_author' => {
    	datatype => 'boolean',
    	base_name => 'ShowCommentsByNoAuthor',
    	description => 'True if comments that have no author are displayed. (Applies only if comments are displayed).',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'layout_type' => 'string',
    'notes_position' => 'string',
    'comments_position' => 'string',
    'comments_area_width' => 'int',
    'comments_area_color' => 'string',
    'show_comments_by_no_author' => 'boolean'
} );

__PACKAGE__->attribute_map( {
    'layout_type' => 'LayoutType',
    'notes_position' => 'NotesPosition',
    'comments_position' => 'CommentsPosition',
    'comments_area_width' => 'CommentsAreaWidth',
    'comments_area_color' => 'CommentsAreaColor',
    'show_comments_by_no_author' => 'ShowCommentsByNoAuthor'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
