#!/usr/bin/perl

package eBay::API::XML::DataType::DigitalDeliveryDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DigitalDeliveryDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DigitalDeliveryDetailsType

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DigitalDeliveryDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::DigitalDeliveryMethodCodeType;


my @gaProperties = ( [ 'Instructions', 'xs:string', '', '', '' ]
	, [ 'Method', 'ns:DigitalDeliveryMethodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DigitalDeliveryMethodCodeType', '' ]
	, [ 'Requirements', 'xs:string', '', '', '' ]
	, [ 'URL', 'xs:anyURI', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setInstructions()

Text instructions for accessing the digital item. For example, if no delivery URL
is provided, the seller may ask the buyer to specify an email address when they pay for the item so that
the seller can send the file to the buyer. If a Web address is specified in URL,
the seller may provide instructions on using the Web address.
The text will be displayed as is (so do not pass in HTML or Javascript).
The information will be displayed to the buyer only after payment has been confirmed.
Required if Method value is AlternateDeliveryInstructions.
Optional if Method value is DownloadURL and a DownloadURL value is specified.
Ignored if Method value is None.

MaxLength: 500 (characters)

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setInstructions {
  my $self = shift;
  $self->{'Instructions'} = shift
}

=head2 getInstructions()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getInstructions {
  my $self = shift;
  return $self->{'Instructions'};
}


=head2 setMethod()

The digital download method.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:DigitalDeliveryMethodCodeType'

=cut

sub setMethod {
  my $self = shift;
  $self->{'Method'} = shift
}

=head2 getMethod()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetCategoryListings
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

#    Returns: 'ns:DigitalDeliveryMethodCodeType'

=cut

sub getMethod {
  my $self = shift;
  return $self->{'Method'};
}


=head2 setRequirements()

File type, operating system specifications,
or other requirements for using the digital item.
In this section, specify the following information about your digital item, if applicable:<br>
- Type of file (file format). Examples include MP3, MOV, etc.<br>
- Any computer hardware or software requirements. For example, is your file compatible with both PCs and Macintosh computers?
Will it work with all operating systems (Windows XP, Windows 2000, Mac OS X, etc.)?
Does the buyer need a specific software program, such as Microsoft Word, to use the item?<br>
- Any other requirements. For example, does the buyer need to provide an email address where you will send the item?<br>
For example: "Adobe PDF (Portable Document Format) file;
buyer will need Adobe Acrobat Reader 5.0 or higher and 5MB of available hard-disk space."
Be as specific as possible so that buyers know exactly what they need to access and use
the item successfully. This information will appear in your listing so that buyers can
make an informed purchase decision.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setRequirements {
  my $self = shift;
  $self->{'Requirements'} = shift
}

=head2 getRequirements()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

  Calls: GetBidderList
         GetCategoryListings
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getRequirements {
  my $self = shift;
  return $self->{'Requirements'};
}


=head2 setURL()

The download URL for the digital item. Provide a Web address for your digital item that uses
one of the following protocols: HTTP, HTTPS, or FTP. If you do not have a Web address that meets these criteria,
specify alternate delivery information in the Instructions field instead.
The information will be displayed to the buyer only after payment has been confirmed.
Required if Method value is DownloadURL.
Ignored if Method value is AlternateDeliveryInstructions (or None).

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:anyURI'

=cut

sub setURL {
  my $self = shift;
  $self->{'URL'} = shift
}

=head2 getURL()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:anyURI'

=cut

sub getURL {
  my $self = shift;
  return $self->{'URL'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
