=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::Paragraph;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::FillFormat;
use AsposeSlidesCloud::Object::Portion;
use AsposeSlidesCloud::Object::PortionFormat;
use AsposeSlidesCloud::Object::ResourceBase;
use AsposeSlidesCloud::Object::ResourceUri;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Represents paragraph resource
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Represents paragraph resource',
                                  class => 'Paragraph',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'self_uri' => {
    	datatype => 'ResourceUri',
    	base_name => 'SelfUri',
    	description => 'Gets or sets the link to this resource.',
    	format => '',
    	read_only => '',
    		},
    'alternate_links' => {
    	datatype => 'ARRAY[ResourceUri]',
    	base_name => 'AlternateLinks',
    	description => 'List of alternate links.',
    	format => '',
    	read_only => '',
    		},
    'margin_left' => {
    	datatype => 'double',
    	base_name => 'MarginLeft',
    	description => 'Left margin.',
    	format => '',
    	read_only => '',
    		},
    'margin_right' => {
    	datatype => 'double',
    	base_name => 'MarginRight',
    	description => 'Right margin.',
    	format => '',
    	read_only => '',
    		},
    'space_before' => {
    	datatype => 'double',
    	base_name => 'SpaceBefore',
    	description => 'Left spacing.',
    	format => '',
    	read_only => '',
    		},
    'space_after' => {
    	datatype => 'double',
    	base_name => 'SpaceAfter',
    	description => 'Right spacing.',
    	format => '',
    	read_only => '',
    		},
    'space_within' => {
    	datatype => 'double',
    	base_name => 'SpaceWithin',
    	description => 'Spacing between lines.',
    	format => '',
    	read_only => '',
    		},
    'indent' => {
    	datatype => 'double',
    	base_name => 'Indent',
    	description => 'First line indent.',
    	format => '',
    	read_only => '',
    		},
    'alignment' => {
    	datatype => 'string',
    	base_name => 'Alignment',
    	description => 'Text alignment.',
    	format => '',
    	read_only => '',
    		},
    'font_alignment' => {
    	datatype => 'string',
    	base_name => 'FontAlignment',
    	description => 'Font alignment.',
    	format => '',
    	read_only => '',
    		},
    'default_tab_size' => {
    	datatype => 'double',
    	base_name => 'DefaultTabSize',
    	description => 'Default tabulation size.',
    	format => '',
    	read_only => '',
    		},
    'depth' => {
    	datatype => 'int',
    	base_name => 'Depth',
    	description => 'Depth.',
    	format => '',
    	read_only => '',
    		},
    'hanging_punctuation' => {
    	datatype => 'string',
    	base_name => 'HangingPunctuation',
    	description => 'True if hanging punctuation is used with the paragraph.',
    	format => '',
    	read_only => '',
    		},
    'east_asian_line_break' => {
    	datatype => 'string',
    	base_name => 'EastAsianLineBreak',
    	description => 'True if East Asian line break is used with the paragraph.',
    	format => '',
    	read_only => '',
    		},
    'latin_line_break' => {
    	datatype => 'string',
    	base_name => 'LatinLineBreak',
    	description => 'True if Latin line break is used with the paragraph.',
    	format => '',
    	read_only => '',
    		},
    'right_to_left' => {
    	datatype => 'string',
    	base_name => 'RightToLeft',
    	description => 'True if right to left direction is used with the paragraph.',
    	format => '',
    	read_only => '',
    		},
    'portion_list' => {
    	datatype => 'ARRAY[Portion]',
    	base_name => 'PortionList',
    	description => 'List of portion links.',
    	format => '',
    	read_only => '',
    		},
    'default_portion_format' => {
    	datatype => 'PortionFormat',
    	base_name => 'DefaultPortionFormat',
    	description => 'Default portion format.',
    	format => '',
    	read_only => '',
    		},
    'bullet_char' => {
    	datatype => 'string',
    	base_name => 'BulletChar',
    	description => 'Bullet char.',
    	format => '',
    	read_only => '',
    		},
    'bullet_height' => {
    	datatype => 'double',
    	base_name => 'BulletHeight',
    	description => 'Bullet height.',
    	format => '',
    	read_only => '',
    		},
    'bullet_type' => {
    	datatype => 'string',
    	base_name => 'BulletType',
    	description => 'Bullet type.',
    	format => '',
    	read_only => '',
    		},
    'numbered_bullet_start_with' => {
    	datatype => 'int',
    	base_name => 'NumberedBulletStartWith',
    	description => 'Starting number for a numbered bullet.',
    	format => '',
    	read_only => '',
    		},
    'numbered_bullet_style' => {
    	datatype => 'string',
    	base_name => 'NumberedBulletStyle',
    	description => 'Numbered bullet style.',
    	format => '',
    	read_only => '',
    		},
    'bullet_fill_format' => {
    	datatype => 'FillFormat',
    	base_name => 'BulletFillFormat',
    	description => 'Bullet fill format.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'self_uri' => 'ResourceUri',
    'alternate_links' => 'ARRAY[ResourceUri]',
    'margin_left' => 'double',
    'margin_right' => 'double',
    'space_before' => 'double',
    'space_after' => 'double',
    'space_within' => 'double',
    'indent' => 'double',
    'alignment' => 'string',
    'font_alignment' => 'string',
    'default_tab_size' => 'double',
    'depth' => 'int',
    'hanging_punctuation' => 'string',
    'east_asian_line_break' => 'string',
    'latin_line_break' => 'string',
    'right_to_left' => 'string',
    'portion_list' => 'ARRAY[Portion]',
    'default_portion_format' => 'PortionFormat',
    'bullet_char' => 'string',
    'bullet_height' => 'double',
    'bullet_type' => 'string',
    'numbered_bullet_start_with' => 'int',
    'numbered_bullet_style' => 'string',
    'bullet_fill_format' => 'FillFormat'
} );

__PACKAGE__->attribute_map( {
    'self_uri' => 'SelfUri',
    'alternate_links' => 'AlternateLinks',
    'margin_left' => 'MarginLeft',
    'margin_right' => 'MarginRight',
    'space_before' => 'SpaceBefore',
    'space_after' => 'SpaceAfter',
    'space_within' => 'SpaceWithin',
    'indent' => 'Indent',
    'alignment' => 'Alignment',
    'font_alignment' => 'FontAlignment',
    'default_tab_size' => 'DefaultTabSize',
    'depth' => 'Depth',
    'hanging_punctuation' => 'HangingPunctuation',
    'east_asian_line_break' => 'EastAsianLineBreak',
    'latin_line_break' => 'LatinLineBreak',
    'right_to_left' => 'RightToLeft',
    'portion_list' => 'PortionList',
    'default_portion_format' => 'DefaultPortionFormat',
    'bullet_char' => 'BulletChar',
    'bullet_height' => 'BulletHeight',
    'bullet_type' => 'BulletType',
    'numbered_bullet_start_with' => 'NumberedBulletStartWith',
    'numbered_bullet_style' => 'NumberedBulletStyle',
    'bullet_fill_format' => 'BulletFillFormat'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
