/*
* tables.c
* S-box tables for CAST5 cipher
*
* Copyright 2002-2004 by Bob Mathews
*
* This library is free software; you can redistribute it and/or modify
* it under the same terms as Perl itself.
*/

#include "cast5.h"

const U32 cast5_s1[] = {
0x30fb40d4uL, 0x9fa0ff0buL, 0x6beccd2fuL, 0x3f258c7auL, 0x1e213f2fuL,
0x9c004dd3uL, 0x6003e540uL, 0xcf9fc949uL, 0xbfd4af27uL, 0x88bbbdb5uL,
0xe2034090uL, 0x98d09675uL, 0x6e63a0e0uL, 0x15c361d2uL, 0xc2e7661duL,
0x22d4ff8euL, 0x28683b6fuL, 0xc07fd059uL, 0xff2379c8uL, 0x775f50e2uL,
0x43c340d3uL, 0xdf2f8656uL, 0x887ca41auL, 0xa2d2bd2duL, 0xa1c9e0d6uL,
0x346c4819uL, 0x61b76d87uL, 0x22540f2fuL, 0x2abe32e1uL, 0xaa54166buL,
0x22568e3auL, 0xa2d341d0uL, 0x66db40c8uL, 0xa784392fuL, 0x004dff2fuL,
0x2db9d2deuL, 0x97943facuL, 0x4a97c1d8uL, 0x527644b7uL, 0xb5f437a7uL,
0xb82cbaefuL, 0xd751d159uL, 0x6ff7f0eduL, 0x5a097a1fuL, 0x827b68d0uL,
0x90ecf52euL, 0x22b0c054uL, 0xbc8e5935uL, 0x4b6d2f7fuL, 0x50bb64a2uL,
0xd2664910uL, 0xbee5812duL, 0xb7332290uL, 0xe93b159fuL, 0xb48ee411uL,
0x4bff345duL, 0xfd45c240uL, 0xad31973fuL, 0xc4f6d02euL, 0x55fc8165uL,
0xd5b1caaduL, 0xa1ac2daeuL, 0xa2d4b76duL, 0xc19b0c50uL, 0x882240f2uL,
0x0c6e4f38uL, 0xa4e4bfd7uL, 0x4f5ba272uL, 0x564c1d2fuL, 0xc59c5319uL,
0xb949e354uL, 0xb04669feuL, 0xb1b6ab8auL, 0xc71358dduL, 0x6385c545uL,
0x110f935duL, 0x57538ad5uL, 0x6a390493uL, 0xe63d37e0uL, 0x2a54f6b3uL,
0x3a787d5fuL, 0x6276a0b5uL, 0x19a6fcdfuL, 0x7a42206auL, 0x29f9d4d5uL,
0xf61b1891uL, 0xbb72275euL, 0xaa508167uL, 0x38901091uL, 0xc6b505ebuL,
0x84c7cb8cuL, 0x2ad75a0fuL, 0x874a1427uL, 0xa2d1936buL, 0x2ad286afuL,
0xaa56d291uL, 0xd7894360uL, 0x425c750duL, 0x93b39e26uL, 0x187184c9uL,
0x6c00b32duL, 0x73e2bb14uL, 0xa0bebc3cuL, 0x54623779uL, 0x64459eabuL,
0x3f328b82uL, 0x7718cf82uL, 0x59a2cea6uL, 0x04ee002euL, 0x89fe78e6uL,
0x3fab0950uL, 0x325ff6c2uL, 0x81383f05uL, 0x6963c5c8uL, 0x76cb5ad6uL,
0xd49974c9uL, 0xca180dcfuL, 0x380782d5uL, 0xc7fa5cf6uL, 0x8ac31511uL,
0x35e79e13uL, 0x47da91d0uL, 0xf40f9086uL, 0xa7e2419euL, 0x31366241uL,
0x051ef495uL, 0xaa573b04uL, 0x4a805d8duL, 0x548300d0uL, 0x00322a3cuL,
0xbf64cddfuL, 0xba57a68euL, 0x75c6372buL, 0x50afd341uL, 0xa7c13275uL,
0x915a0bf5uL, 0x6b54bfabuL, 0x2b0b1426uL, 0xab4cc9d7uL, 0x449ccd82uL,
0xf7fbf265uL, 0xab85c5f3uL, 0x1b55db94uL, 0xaad4e324uL, 0xcfa4bd3fuL,
0x2deaa3e2uL, 0x9e204d02uL, 0xc8bd25acuL, 0xeadf55b3uL, 0xd5bd9e98uL,
0xe31231b2uL, 0x2ad5ad6cuL, 0x954329deuL, 0xadbe4528uL, 0xd8710f69uL,
0xaa51c90fuL, 0xaa786bf6uL, 0x22513f1euL, 0xaa51a79buL, 0x2ad344ccuL,
0x7b5a41f0uL, 0xd37cfbaduL, 0x1b069505uL, 0x41ece491uL, 0xb4c332e6uL,
0x032268d4uL, 0xc9600accuL, 0xce387e6duL, 0xbf6bb16cuL, 0x6a70fb78uL,
0x0d03d9c9uL, 0xd4df39deuL, 0xe01063dauL, 0x4736f464uL, 0x5ad328d8uL,
0xb347cc96uL, 0x75bb0fc3uL, 0x98511bfbuL, 0x4ffbcc35uL, 0xb58bcf6auL,
0xe11f0abcuL, 0xbfc5fe4auL, 0xa70aec10uL, 0xac39570auL, 0x3f04442fuL,
0x6188b153uL, 0xe0397a2euL, 0x5727cb79uL, 0x9ceb418fuL, 0x1cacd68duL,
0x2ad37c96uL, 0x0175cb9duL, 0xc69dff09uL, 0xc75b65f0uL, 0xd9db40d8uL,
0xec0e7779uL, 0x4744ead4uL, 0xb11c3274uL, 0xdd24cb9euL, 0x7e1c54bduL,
0xf01144f9uL, 0xd2240eb1uL, 0x9675b3fduL, 0xa3ac3755uL, 0xd47c27afuL,
0x51c85f4duL, 0x56907596uL, 0xa5bb15e6uL, 0x580304f0uL, 0xca042cf1uL,
0x011a37eauL, 0x8dbfaadbuL, 0x35ba3e4auL, 0x3526ffa0uL, 0xc37b4d09uL,
0xbc306ed9uL, 0x98a52666uL, 0x5648f725uL, 0xff5e569duL, 0x0ced63d0uL,
0x7c63b2cfuL, 0x700b45e1uL, 0xd5ea50f1uL, 0x85a92872uL, 0xaf1fbda7uL,
0xd4234870uL, 0xa7870bf3uL, 0x2d3b4d79uL, 0x42e04198uL, 0x0cd0ede7uL,
0x26470db8uL, 0xf881814cuL, 0x474d6ad7uL, 0x7c0c5e5cuL, 0xd1231959uL,
0x381b7298uL, 0xf5d2f4dbuL, 0xab838653uL, 0x6e2f1e23uL, 0x83719c9euL,
0xbd91e046uL, 0x9a56456euL, 0xdc39200cuL, 0x20c8c571uL, 0x962bda1cuL,
0xe1e696ffuL, 0xb141ab08uL, 0x7cca89b9uL, 0x1a69e783uL, 0x02cc4843uL,
0xa2f7c579uL, 0x429ef47duL, 0x427b169cuL, 0x5ac9f049uL, 0xdd8f0f00uL,
0x5c8165bfuL };

const U32 cast5_s2[] = {
0x1f201094uL, 0xef0ba75buL, 0x69e3cf7euL, 0x393f4380uL, 0xfe61cf7auL,
0xeec5207auL, 0x55889c94uL, 0x72fc0651uL, 0xada7ef79uL, 0x4e1d7235uL,
0xd55a63ceuL, 0xde0436bauL, 0x99c430efuL, 0x5f0c0794uL, 0x18dcdb7duL,
0xa1d6eff3uL, 0xa0b52f7buL, 0x59e83605uL, 0xee15b094uL, 0xe9ffd909uL,
0xdc440086uL, 0xef944459uL, 0xba83ccb3uL, 0xe0c3cdfbuL, 0xd1da4181uL,
0x3b092ab1uL, 0xf997f1c1uL, 0xa5e6cf7buL, 0x01420ddbuL, 0xe4e7ef5buL,
0x25a1ff41uL, 0xe180f806uL, 0x1fc41080uL, 0x179bee7auL, 0xd37ac6a9uL,
0xfe5830a4uL, 0x98de8b7fuL, 0x77e83f4euL, 0x79929269uL, 0x24fa9f7buL,
0xe113c85buL, 0xacc40083uL, 0xd7503525uL, 0xf7ea615fuL, 0x62143154uL,
0x0d554b63uL, 0x5d681121uL, 0xc866c359uL, 0x3d63cf73uL, 0xcee234c0uL,
0xd4d87e87uL, 0x5c672b21uL, 0x071f6181uL, 0x39f7627fuL, 0x361e3084uL,
0xe4eb573buL, 0x602f64a4uL, 0xd63acd9cuL, 0x1bbc4635uL, 0x9e81032duL,
0x2701f50cuL, 0x99847ab4uL, 0xa0e3df79uL, 0xba6cf38cuL, 0x10843094uL,
0x2537a95euL, 0xf46f6ffeuL, 0xa1ff3b1fuL, 0x208cfb6auL, 0x8f458c74uL,
0xd9e0a227uL, 0x4ec73a34uL, 0xfc884f69uL, 0x3e4de8dfuL, 0xef0e0088uL,
0x3559648duL, 0x8a45388cuL, 0x1d804366uL, 0x721d9bfduL, 0xa58684bbuL,
0xe8256333uL, 0x844e8212uL, 0x128d8098uL, 0xfed33fb4uL, 0xce280ae1uL,
0x27e19ba5uL, 0xd5a6c252uL, 0xe49754bduL, 0xc5d655dduL, 0xeb667064uL,
0x77840b4duL, 0xa1b6a801uL, 0x84db26a9uL, 0xe0b56714uL, 0x21f043b7uL,
0xe5d05860uL, 0x54f03084uL, 0x066ff472uL, 0xa31aa153uL, 0xdadc4755uL,
0xb5625dbfuL, 0x68561be6uL, 0x83ca6b94uL, 0x2d6ed23buL, 0xeccf01dbuL,
0xa6d3d0bauL, 0xb6803d5cuL, 0xaf77a709uL, 0x33b4a34cuL, 0x397bc8d6uL,
0x5ee22b95uL, 0x5f0e5304uL, 0x81ed6f61uL, 0x20e74364uL, 0xb45e1378uL,
0xde18639buL, 0x881ca122uL, 0xb96726d1uL, 0x8049a7e8uL, 0x22b7da7buL,
0x5e552d25uL, 0x5272d237uL, 0x79d2951cuL, 0xc60d894cuL, 0x488cb402uL,
0x1ba4fe5buL, 0xa4b09f6buL, 0x1ca815cfuL, 0xa20c3005uL, 0x8871df63uL,
0xb9de2fcbuL, 0x0cc6c9e9uL, 0x0beeff53uL, 0xe3214517uL, 0xb4542835uL,
0x9f63293cuL, 0xee41e729uL, 0x6e1d2d7cuL, 0x50045286uL, 0x1e6685f3uL,
0xf33401c6uL, 0x30a22c95uL, 0x31a70850uL, 0x60930f13uL, 0x73f98417uL,
0xa1269859uL, 0xec645c44uL, 0x52c877a9uL, 0xcdff33a6uL, 0xa02b1741uL,
0x7cbad9a2uL, 0x2180036fuL, 0x50d99c08uL, 0xcb3f4861uL, 0xc26bd765uL,
0x64a3f6abuL, 0x80342676uL, 0x25a75e7buL, 0xe4e6d1fcuL, 0x20c710e6uL,
0xcdf0b680uL, 0x17844d3buL, 0x31eef84duL, 0x7e0824e4uL, 0x2ccb49ebuL,
0x846a3baeuL, 0x8ff77888uL, 0xee5d60f6uL, 0x7af75673uL, 0x2fdd5cdbuL,
0xa11631c1uL, 0x30f66f43uL, 0xb3faec54uL, 0x157fd7fauL, 0xef8579ccuL,
0xd152de58uL, 0xdb2ffd5euL, 0x8f32ce19uL, 0x306af97auL, 0x02f03ef8uL,
0x99319ad5uL, 0xc242fa0fuL, 0xa7e3ebb0uL, 0xc68e4906uL, 0xb8da230cuL,
0x80823028uL, 0xdcdef3c8uL, 0xd35fb171uL, 0x088a1bc8uL, 0xbec0c560uL,
0x61a3c9e8uL, 0xbca8f54duL, 0xc72feffauL, 0x22822e99uL, 0x82c570b4uL,
0xd8d94e89uL, 0x8b1c34bcuL, 0x301e16e6uL, 0x273be979uL, 0xb0ffeaa6uL,
0x61d9b8c6uL, 0x00b24869uL, 0xb7ffce3fuL, 0x08dc283buL, 0x43daf65auL,
0xf7e19798uL, 0x7619b72fuL, 0x8f1c9ba4uL, 0xdc8637a0uL, 0x16a7d3b1uL,
0x9fc393b7uL, 0xa7136eebuL, 0xc6bcc63euL, 0x1a513742uL, 0xef6828bcuL,
0x520365d6uL, 0x2d6a77abuL, 0x3527ed4buL, 0x821fd216uL, 0x095c6e2euL,
0xdb92f2fbuL, 0x5eea29cbuL, 0x145892f5uL, 0x91584f7fuL, 0x5483697buL,
0x2667a8ccuL, 0x85196048uL, 0x8c4baceauL, 0x833860d4uL, 0x0d23e0f9uL,
0x6c387e8auL, 0x0ae6d249uL, 0xb284600cuL, 0xd835731duL, 0xdcb1c647uL,
0xac4c56eauL, 0x3ebd81b3uL, 0x230eabb0uL, 0x6438bc87uL, 0xf0b5b1fauL,
0x8f5ea2b3uL, 0xfc184642uL, 0x0a036b7auL, 0x4fb089bduL, 0x649da589uL,
0xa345415euL, 0x5c038323uL, 0x3e5d3bb9uL, 0x43d79572uL, 0x7e6dd07cuL,
0x06dfdf1euL, 0x6c6cc4efuL, 0x7160a539uL, 0x73bfbe70uL, 0x83877605uL,
0x4523ecf1uL };

const U32 cast5_s3[] = {
0x8defc240uL, 0x25fa5d9fuL, 0xeb903dbfuL, 0xe810c907uL, 0x47607fffuL,
0x369fe44buL, 0x8c1fc644uL, 0xaececa90uL, 0xbeb1f9bfuL, 0xeefbcaeauL,
0xe8cf1950uL, 0x51df07aeuL, 0x920e8806uL, 0xf0ad0548uL, 0xe13c8d83uL,
0x927010d5uL, 0x11107d9fuL, 0x07647db9uL, 0xb2e3e4d4uL, 0x3d4f285euL,
0xb9afa820uL, 0xfade82e0uL, 0xa067268buL, 0x8272792euL, 0x553fb2c0uL,
0x489ae22buL, 0xd4ef9794uL, 0x125e3fbcuL, 0x21fffceeuL, 0x825b1bfduL,
0x9255c5eduL, 0x1257a240uL, 0x4e1a8302uL, 0xbae07fffuL, 0x528246e7uL,
0x8e57140euL, 0x3373f7bfuL, 0x8c9f8188uL, 0xa6fc4ee8uL, 0xc982b5a5uL,
0xa8c01db7uL, 0x579fc264uL, 0x67094f31uL, 0xf2bd3f5fuL, 0x40fff7c1uL,
0x1fb78dfcuL, 0x8e6bd2c1uL, 0x437be59buL, 0x99b03dbfuL, 0xb5dbc64buL,
0x638dc0e6uL, 0x55819d99uL, 0xa197c81cuL, 0x4a012d6euL, 0xc5884a28uL,
0xccc36f71uL, 0xb843c213uL, 0x6c0743f1uL, 0x8309893cuL, 0x0feddd5fuL,
0x2f7fe850uL, 0xd7c07f7euL, 0x02507fbfuL, 0x5afb9a04uL, 0xa747d2d0uL,
0x1651192euL, 0xaf70bf3euL, 0x58c31380uL, 0x5f98302euL, 0x727cc3c4uL,
0x0a0fb402uL, 0x0f7fef82uL, 0x8c96fdaduL, 0x5d2c2aaeuL, 0x8ee99a49uL,
0x50da88b8uL, 0x8427f4a0uL, 0x1eac5790uL, 0x796fb449uL, 0x8252dc15uL,
0xefbd7d9buL, 0xa672597duL, 0xada840d8uL, 0x45f54504uL, 0xfa5d7403uL,
0xe83ec305uL, 0x4f91751auL, 0x925669c2uL, 0x23efe941uL, 0xa903f12euL,
0x60270df2uL, 0x0276e4b6uL, 0x94fd6574uL, 0x927985b2uL, 0x8276dbcbuL,
0x02778176uL, 0xf8af918duL, 0x4e48f79euL, 0x8f616ddfuL, 0xe29d840euL,
0x842f7d83uL, 0x340ce5c8uL, 0x96bbb682uL, 0x93b4b148uL, 0xef303cabuL,
0x984faf28uL, 0x779faf9buL, 0x92dc560duL, 0x224d1e20uL, 0x8437aa88uL,
0x7d29dc96uL, 0x2756d3dcuL, 0x8b907ceeuL, 0xb51fd240uL, 0xe7c07ce3uL,
0xe566b4a1uL, 0xc3e9615euL, 0x3cf8209duL, 0x6094d1e3uL, 0xcd9ca341uL,
0x5c76460euL, 0x00ea983buL, 0xd4d67881uL, 0xfd47572cuL, 0xf76cedd9uL,
0xbda8229cuL, 0x127dadaauL, 0x438a074euL, 0x1f97c090uL, 0x081bdb8auL,
0x93a07ebeuL, 0xb938ca15uL, 0x97b03cffuL, 0x3dc2c0f8uL, 0x8d1ab2ecuL,
0x64380e51uL, 0x68cc7bfbuL, 0xd90f2788uL, 0x12490181uL, 0x5de5ffd4uL,
0xdd7ef86auL, 0x76a2e214uL, 0xb9a40368uL, 0x925d958fuL, 0x4b39fffauL,
0xba39aee9uL, 0xa4ffd30buL, 0xfaf7933buL, 0x6d498623uL, 0x193cbcfauL,
0x27627545uL, 0x825cf47auL, 0x61bd8ba0uL, 0xd11e42d1uL, 0xcead04f4uL,
0x127ea392uL, 0x10428db7uL, 0x8272a972uL, 0x9270c4a8uL, 0x127de50buL,
0x285ba1c8uL, 0x3c62f44fuL, 0x35c0eaa5uL, 0xe805d231uL, 0x428929fbuL,
0xb4fcdf82uL, 0x4fb66a53uL, 0x0e7dc15buL, 0x1f081fabuL, 0x108618aeuL,
0xfcfd086duL, 0xf9ff2889uL, 0x694bcc11uL, 0x236a5caeuL, 0x12deca4duL,
0x2c3f8cc5uL, 0xd2d02dfeuL, 0xf8ef5896uL, 0xe4cf52dauL, 0x95155b67uL,
0x494a488cuL, 0xb9b6a80cuL, 0x5c8f82bcuL, 0x89d36b45uL, 0x3a609437uL,
0xec00c9a9uL, 0x44715253uL, 0x0a874b49uL, 0xd773bc40uL, 0x7c34671cuL,
0x02717ef6uL, 0x4feb5536uL, 0xa2d02fffuL, 0xd2bf60c4uL, 0xd43f03c0uL,
0x50b4ef6duL, 0x07478cd1uL, 0x006e1888uL, 0xa2e53f55uL, 0xb9e6d4bcuL,
0xa2048016uL, 0x97573833uL, 0xd7207d67uL, 0xde0f8f3duL, 0x72f87b33uL,
0xabcc4f33uL, 0x7688c55duL, 0x7b00a6b0uL, 0x947b0001uL, 0x570075d2uL,
0xf9bb88f8uL, 0x8942019euL, 0x4264a5ffuL, 0x856302e0uL, 0x72dbd92buL,
0xee971b69uL, 0x6ea22fdeuL, 0x5f08ae2buL, 0xaf7a616duL, 0xe5c98767uL,
0xcf1febd2uL, 0x61efc8c2uL, 0xf1ac2571uL, 0xcc8239c2uL, 0x67214cb8uL,
0xb1e583d1uL, 0xb7dc3e62uL, 0x7f10bdceuL, 0xf90a5c38uL, 0x0ff0443duL,
0x606e6dc6uL, 0x60543a49uL, 0x5727c148uL, 0x2be98a1duL, 0x8ab41738uL,
0x20e1be24uL, 0xaf96da0fuL, 0x68458425uL, 0x99833be5uL, 0x600d457duL,
0x282f9350uL, 0x8334b362uL, 0xd91d1120uL, 0x2b6d8da0uL, 0x642b1e31uL,
0x9c305a00uL, 0x52bce688uL, 0x1b03588auL, 0xf7baefd5uL, 0x4142ed9cuL,
0xa4315c11uL, 0x83323ec5uL, 0xdfef4636uL, 0xa133c501uL, 0xe9d3531cuL,
0xee353783uL };

const U32 cast5_s4[] = {
0x9db30420uL, 0x1fb6e9deuL, 0xa7be7befuL, 0xd273a298uL, 0x4a4f7bdbuL,
0x64ad8c57uL, 0x85510443uL, 0xfa020ed1uL, 0x7e287affuL, 0xe60fb663uL,
0x095f35a1uL, 0x79ebf120uL, 0xfd059d43uL, 0x6497b7b1uL, 0xf3641f63uL,
0x241e4adfuL, 0x28147f5fuL, 0x4fa2b8cduL, 0xc9430040uL, 0x0cc32220uL,
0xfdd30b30uL, 0xc0a5374fuL, 0x1d2d00d9uL, 0x24147b15uL, 0xee4d111auL,
0x0fca5167uL, 0x71ff904cuL, 0x2d195ffeuL, 0x1a05645fuL, 0x0c13fefeuL,
0x081b08cauL, 0x05170121uL, 0x80530100uL, 0xe83e5efeuL, 0xac9af4f8uL,
0x7fe72701uL, 0xd2b8ee5fuL, 0x06df4261uL, 0xbb9e9b8auL, 0x7293ea25uL,
0xce84ffdfuL, 0xf5718801uL, 0x3dd64b04uL, 0xa26f263buL, 0x7ed48400uL,
0x547eebe6uL, 0x446d4ca0uL, 0x6cf3d6f5uL, 0x2649abdfuL, 0xaea0c7f5uL,
0x36338cc1uL, 0x503f7e93uL, 0xd3772061uL, 0x11b638e1uL, 0x72500e03uL,
0xf80eb2bbuL, 0xabe0502euL, 0xec8d77deuL, 0x57971e81uL, 0xe14f6746uL,
0xc9335400uL, 0x6920318fuL, 0x081dbb99uL, 0xffc304a5uL, 0x4d351805uL,
0x7f3d5ce3uL, 0xa6c866c6uL, 0x5d5bcca9uL, 0xdaec6feauL, 0x9f926f91uL,
0x9f46222fuL, 0x3991467duL, 0xa5bf6d8euL, 0x1143c44fuL, 0x43958302uL,
0xd0214eebuL, 0x022083b8uL, 0x3fb6180cuL, 0x18f8931euL, 0x281658e6uL,
0x26486e3euL, 0x8bd78a70uL, 0x7477e4c1uL, 0xb506e07cuL, 0xf32d0a25uL,
0x79098b02uL, 0xe4eabb81uL, 0x28123b23uL, 0x69dead38uL, 0x1574ca16uL,
0xdf871b62uL, 0x211c40b7uL, 0xa51a9ef9uL, 0x0014377buL, 0x041e8ac8uL,
0x09114003uL, 0xbd59e4d2uL, 0xe3d156d5uL, 0x4fe876d5uL, 0x2f91a340uL,
0x557be8deuL, 0x00eae4a7uL, 0x0ce5c2ecuL, 0x4db4bba6uL, 0xe756bdffuL,
0xdd3369acuL, 0xec17b035uL, 0x06572327uL, 0x99afc8b0uL, 0x56c8c391uL,
0x6b65811cuL, 0x5e146119uL, 0x6e85cb75uL, 0xbe07c002uL, 0xc2325577uL,
0x893ff4ecuL, 0x5bbfc92duL, 0xd0ec3b25uL, 0xb7801ab7uL, 0x8d6d3b24uL,
0x20c763efuL, 0xc366a5fcuL, 0x9c382880uL, 0x0ace3205uL, 0xaac9548auL,
0xeca1d7c7uL, 0x041afa32uL, 0x1d16625auL, 0x6701902cuL, 0x9b757a54uL,
0x31d477f7uL, 0x9126b031uL, 0x36cc6fdbuL, 0xc70b8b46uL, 0xd9e66a48uL,
0x56e55a79uL, 0x026a4cebuL, 0x52437effuL, 0x2f8f76b4uL, 0x0df980a5uL,
0x8674cde3uL, 0xedda04ebuL, 0x17a9be04uL, 0x2c18f4dfuL, 0xb7747f9duL,
0xab2af7b4uL, 0xefc34d20uL, 0x2e096b7cuL, 0x1741a254uL, 0xe5b6a035uL,
0x213d42f6uL, 0x2c1c7c26uL, 0x61c2f50fuL, 0x6552daf9uL, 0xd2c231f8uL,
0x25130f69uL, 0xd8167fa2uL, 0x0418f2c8uL, 0x001a96a6uL, 0x0d1526abuL,
0x63315c21uL, 0x5e0a72ecuL, 0x49bafefduL, 0x187908d9uL, 0x8d0dbd86uL,
0x311170a7uL, 0x3e9b640cuL, 0xcc3e10d7uL, 0xd5cad3b6uL, 0x0caec388uL,
0xf73001e1uL, 0x6c728affuL, 0x71eae2a1uL, 0x1f9af36euL, 0xcfcbd12fuL,
0xc1de8417uL, 0xac07be6buL, 0xcb44a1d8uL, 0x8b9b0f56uL, 0x013988c3uL,
0xb1c52fcauL, 0xb4be31cduL, 0xd8782806uL, 0x12a3a4e2uL, 0x6f7de532uL,
0x58fd7eb6uL, 0xd01ee900uL, 0x24adffc2uL, 0xf4990fc5uL, 0x9711aac5uL,
0x001d7b95uL, 0x82e5e7d2uL, 0x109873f6uL, 0x00613096uL, 0xc32d9521uL,
0xada121ffuL, 0x29908415uL, 0x7fbb977fuL, 0xaf9eb3dbuL, 0x29c9ed2auL,
0x5ce2a465uL, 0xa730f32cuL, 0xd0aa3fe8uL, 0x8a5cc091uL, 0xd49e2ce7uL,
0x0ce454a9uL, 0xd60acd86uL, 0x015f1919uL, 0x77079103uL, 0xdea03af6uL,
0x78a8565euL, 0xdee356dfuL, 0x21f05cbeuL, 0x8b75e387uL, 0xb3c50651uL,
0xb8a5c3efuL, 0xd8eeb6d2uL, 0xe523be77uL, 0xc2154529uL, 0x2f69efdfuL,
0xafe67afbuL, 0xf470c4b2uL, 0xf3e0eb5buL, 0xd6cc9876uL, 0x39e4460cuL,
0x1fda8538uL, 0x1987832fuL, 0xca007367uL, 0xa99144f8uL, 0x296b299euL,
0x492fc295uL, 0x9266beabuL, 0xb5676e69uL, 0x9bd3dddauL, 0xdf7e052fuL,
0xdb25701cuL, 0x1b5e51eeuL, 0xf65324e6uL, 0x6afce36cuL, 0x0316cc04uL,
0x8644213euL, 0xb7dc59d0uL, 0x7965291fuL, 0xccd6fd43uL, 0x41823979uL,
0x932bcdf6uL, 0xb657c34duL, 0x4edfd282uL, 0x7ae5290cuL, 0x3cb9536buL,
0x851e20feuL, 0x9833557euL, 0x13ecf0b0uL, 0xd3ffb372uL, 0x3f85c5c1uL,
0x0aef7ed2uL };

const U32 cast5_s5[] = {
0x7ec90c04uL, 0x2c6e74b9uL, 0x9b0e66dfuL, 0xa6337911uL, 0xb86a7fffuL,
0x1dd358f5uL, 0x44dd9d44uL, 0x1731167fuL, 0x08fbf1fauL, 0xe7f511ccuL,
0xd2051b00uL, 0x735aba00uL, 0x2ab722d8uL, 0x386381cbuL, 0xacf6243auL,
0x69befd7auL, 0xe6a2e77fuL, 0xf0c720cduL, 0xc4494816uL, 0xccf5c180uL,
0x38851640uL, 0x15b0a848uL, 0xe68b18cbuL, 0x4caadeffuL, 0x5f480a01uL,
0x0412b2aauL, 0x259814fcuL, 0x41d0efe2uL, 0x4e40b48duL, 0x248eb6fbuL,
0x8dba1cfeuL, 0x41a99b02uL, 0x1a550a04uL, 0xba8f65cbuL, 0x7251f4e7uL,
0x95a51725uL, 0xc106ecd7uL, 0x97a5980auL, 0xc539b9aauL, 0x4d79fe6auL,
0xf2f3f763uL, 0x68af8040uL, 0xed0c9e56uL, 0x11b4958buL, 0xe1eb5a88uL,
0x8709e6b0uL, 0xd7e07156uL, 0x4e29fea7uL, 0x6366e52duL, 0x02d1c000uL,
0xc4ac8e05uL, 0x9377f571uL, 0x0c05372auL, 0x578535f2uL, 0x2261be02uL,
0xd642a0c9uL, 0xdf13a280uL, 0x74b55bd2uL, 0x682199c0uL, 0xd421e5ecuL,
0x53fb3ce8uL, 0xc8adedb3uL, 0x28a87fc9uL, 0x3d959981uL, 0x5c1ff900uL,
0xfe38d399uL, 0x0c4eff0buL, 0x062407eauL, 0xaa2f4fb1uL, 0x4fb96976uL,
0x90c79505uL, 0xb0a8a774uL, 0xef55a1ffuL, 0xe59ca2c2uL, 0xa6b62d27uL,
0xe66a4263uL, 0xdf65001fuL, 0x0ec50966uL, 0xdfdd55bcuL, 0x29de0655uL,
0x911e739auL, 0x17af8975uL, 0x32c7911cuL, 0x89f89468uL, 0x0d01e980uL,
0x524755f4uL, 0x03b63cc9uL, 0x0cc844b2uL, 0xbcf3f0aauL, 0x87ac36e9uL,
0xe53a7426uL, 0x01b3d82buL, 0x1a9e7449uL, 0x64ee2d7euL, 0xcddbb1dauL,
0x01c94910uL, 0xb868bf80uL, 0x0d26f3fduL, 0x9342ede7uL, 0x04a5c284uL,
0x636737b6uL, 0x50f5b616uL, 0xf24766e3uL, 0x8eca36c1uL, 0x136e05dbuL,
0xfef18391uL, 0xfb887a37uL, 0xd6e7f7d4uL, 0xc7fb7dc9uL, 0x3063fcdfuL,
0xb6f589deuL, 0xec2941dauL, 0x26e46695uL, 0xb7566419uL, 0xf654efc5uL,
0xd08d58b7uL, 0x48925401uL, 0xc1bacb7fuL, 0xe5ff550fuL, 0xb6083049uL,
0x5bb5d0e8uL, 0x87d72e5auL, 0xab6a6ee1uL, 0x223a66ceuL, 0xc62bf3cduL,
0x9e0885f9uL, 0x68cb3e47uL, 0x086c010fuL, 0xa21de820uL, 0xd18b69deuL,
0xf3f65777uL, 0xfa02c3f6uL, 0x407edac3uL, 0xcbb3d550uL, 0x1793084duL,
0xb0d70ebauL, 0x0ab378d5uL, 0xd951fb0cuL, 0xded7da56uL, 0x4124bbe4uL,
0x94ca0b56uL, 0x0f5755d1uL, 0xe0e1e56euL, 0x6184b5beuL, 0x580a249fuL,
0x94f74bc0uL, 0xe327888euL, 0x9f7b5561uL, 0xc3dc0280uL, 0x05687715uL,
0x646c6bd7uL, 0x44904db3uL, 0x66b4f0a3uL, 0xc0f1648auL, 0x697ed5afuL,
0x49e92ff6uL, 0x309e374fuL, 0x2cb6356auL, 0x85808573uL, 0x4991f840uL,
0x76f0ae02uL, 0x083be84duL, 0x28421c9auL, 0x44489406uL, 0x736e4cb8uL,
0xc1092910uL, 0x8bc95fc6uL, 0x7d869cf4uL, 0x134f616fuL, 0x2e77118duL,
0xb31b2be1uL, 0xaa90b472uL, 0x3ca5d717uL, 0x7d161bbauL, 0x9cad9010uL,
0xaf462ba2uL, 0x9fe459d2uL, 0x45d34559uL, 0xd9f2da13uL, 0xdbc65487uL,
0xf3e4f94euL, 0x176d486fuL, 0x097c13eauL, 0x631da5c7uL, 0x445f7382uL,
0x175683f4uL, 0xcdc66a97uL, 0x70be0288uL, 0xb3cdcf72uL, 0x6e5dd2f3uL,
0x20936079uL, 0x459b80a5uL, 0xbe60e2dbuL, 0xa9c23101uL, 0xeba5315cuL,
0x224e42f2uL, 0x1c5c1572uL, 0xf6721b2cuL, 0x1ad2fff3uL, 0x8c25404euL,
0x324ed72fuL, 0x4067b7fduL, 0x0523138euL, 0x5ca3bc78uL, 0xdc0fd66euL,
0x75922283uL, 0x784d6b17uL, 0x58ebb16euL, 0x44094f85uL, 0x3f481d87uL,
0xfcfeae7buL, 0x77b5ff76uL, 0x8c2302bfuL, 0xaaf47556uL, 0x5f46b02auL,
0x2b092801uL, 0x3d38f5f7uL, 0x0ca81f36uL, 0x52af4a8auL, 0x66d5e7c0uL,
0xdf3b0874uL, 0x95055110uL, 0x1b5ad7a8uL, 0xf61ed5aduL, 0x6cf6e479uL,
0x20758184uL, 0xd0cefa65uL, 0x88f7be58uL, 0x4a046826uL, 0x0ff6f8f3uL,
0xa09c7f70uL, 0x5346aba0uL, 0x5ce96c28uL, 0xe176eda3uL, 0x6bac307fuL,
0x376829d2uL, 0x85360fa9uL, 0x17e3fe2auL, 0x24b79767uL, 0xf5a96b20uL,
0xd6cd2595uL, 0x68ff1ebfuL, 0x7555442cuL, 0xf19f06beuL, 0xf9e0659auL,
0xeeb9491duL, 0x34010718uL, 0xbb30cab8uL, 0xe822fe15uL, 0x88570983uL,
0x750e6249uL, 0xda627e55uL, 0x5e76ffa8uL, 0xb1534546uL, 0x6d47de08uL,
0xefe9e7d4uL };

const U32 cast5_s6[] = {
0xf6fa8f9duL, 0x2cac6ce1uL, 0x4ca34867uL, 0xe2337f7cuL, 0x95db08e7uL,
0x016843b4uL, 0xeced5cbcuL, 0x325553acuL, 0xbf9f0960uL, 0xdfa1e2eduL,
0x83f0579duL, 0x63ed86b9uL, 0x1ab6a6b8uL, 0xde5ebe39uL, 0xf38ff732uL,
0x8989b138uL, 0x33f14961uL, 0xc01937bduL, 0xf506c6dauL, 0xe4625e7euL,
0xa308ea99uL, 0x4e23e33cuL, 0x79cbd7ccuL, 0x48a14367uL, 0xa3149619uL,
0xfec94bd5uL, 0xa114174auL, 0xeaa01866uL, 0xa084db2duL, 0x09a8486fuL,
0xa888614auL, 0x2900af98uL, 0x01665991uL, 0xe1992863uL, 0xc8f30c60uL,
0x2e78ef3cuL, 0xd0d51932uL, 0xcf0fec14uL, 0xf7ca07d2uL, 0xd0a82072uL,
0xfd41197euL, 0x9305a6b0uL, 0xe86be3dauL, 0x74bed3cduL, 0x372da53cuL,
0x4c7f4448uL, 0xdab5d440uL, 0x6dba0ec3uL, 0x083919a7uL, 0x9fbaeed9uL,
0x49dbcfb0uL, 0x4e670c53uL, 0x5c3d9c01uL, 0x64bdb941uL, 0x2c0e636auL,
0xba7dd9cduL, 0xea6f7388uL, 0xe70bc762uL, 0x35f29adbuL, 0x5c4cdd8duL,
0xf0d48d8cuL, 0xb88153e2uL, 0x08a19866uL, 0x1ae2eac8uL, 0x284caf89uL,
0xaa928223uL, 0x9334be53uL, 0x3b3a21bfuL, 0x16434be3uL, 0x9aea3906uL,
0xefe8c36euL, 0xf890cdd9uL, 0x80226daeuL, 0xc340a4a3uL, 0xdf7e9c09uL,
0xa694a807uL, 0x5b7c5eccuL, 0x221db3a6uL, 0x9a69a02fuL, 0x68818a54uL,
0xceb2296fuL, 0x53c0843auL, 0xfe893655uL, 0x25bfe68auL, 0xb4628abcuL,
0xcf222ebfuL, 0x25ac6f48uL, 0xa9a99387uL, 0x53bddb65uL, 0xe76ffbe7uL,
0xe967fd78uL, 0x0ba93563uL, 0x8e342bc1uL, 0xe8a11be9uL, 0x4980740duL,
0xc8087dfcuL, 0x8de4bf99uL, 0xa11101a0uL, 0x7fd37975uL, 0xda5a26c0uL,
0xe81f994fuL, 0x9528cd89uL, 0xfd339feduL, 0xb87834bfuL, 0x5f04456duL,
0x22258698uL, 0xc9c4c83buL, 0x2dc156beuL, 0x4f628daauL, 0x57f55ec5uL,
0xe2220abeuL, 0xd2916ebfuL, 0x4ec75b95uL, 0x24f2c3c0uL, 0x42d15d99uL,
0xcd0d7fa0uL, 0x7b6e27ffuL, 0xa8dc8af0uL, 0x7345c106uL, 0xf41e232fuL,
0x35162386uL, 0xe6ea8926uL, 0x3333b094uL, 0x157ec6f2uL, 0x372b74afuL,
0x692573e4uL, 0xe9a9d848uL, 0xf3160289uL, 0x3a62ef1duL, 0xa787e238uL,
0xf3a5f676uL, 0x74364853uL, 0x20951063uL, 0x4576698duL, 0xb6fad407uL,
0x592af950uL, 0x36f73523uL, 0x4cfb6e87uL, 0x7da4cec0uL, 0x6c152daauL,
0xcb0396a8uL, 0xc50dfe5duL, 0xfcd707abuL, 0x0921c42fuL, 0x89dff0bbuL,
0x5fe2be78uL, 0x448f4f33uL, 0x754613c9uL, 0x2b05d08duL, 0x48b9d585uL,
0xdc049441uL, 0xc8098f9buL, 0x7dede786uL, 0xc39a3373uL, 0x42410005uL,
0x6a091751uL, 0x0ef3c8a6uL, 0x890072d6uL, 0x28207682uL, 0xa9a9f7beuL,
0xbf32679duL, 0xd45b5b75uL, 0xb353fd00uL, 0xcbb0e358uL, 0x830f220auL,
0x1f8fb214uL, 0xd372cf08uL, 0xcc3c4a13uL, 0x8cf63166uL, 0x061c87beuL,
0x88c98f88uL, 0x6062e397uL, 0x47cf8e7auL, 0xb6c85283uL, 0x3cc2acfbuL,
0x3fc06976uL, 0x4e8f0252uL, 0x64d8314duL, 0xda3870e3uL, 0x1e665459uL,
0xc10908f0uL, 0x513021a5uL, 0x6c5b68b7uL, 0x822f8aa0uL, 0x3007cd3euL,
0x74719eefuL, 0xdc872681uL, 0x073340d4uL, 0x7e432fd9uL, 0x0c5ec241uL,
0x8809286cuL, 0xf592d891uL, 0x08a930f6uL, 0x957ef305uL, 0xb7fbffbduL,
0xc266e96fuL, 0x6fe4ac98uL, 0xb173ecc0uL, 0xbc60b42auL, 0x953498dauL,
0xfba1ae12uL, 0x2d4bd736uL, 0x0f25faabuL, 0xa4f3fcebuL, 0xe2969123uL,
0x257f0c3duL, 0x9348af49uL, 0x361400bcuL, 0xe8816f4auL, 0x3814f200uL,
0xa3f94043uL, 0x9c7a54c2uL, 0xbc704f57uL, 0xda41e7f9uL, 0xc25ad33auL,
0x54f4a084uL, 0xb17f5505uL, 0x59357cbeuL, 0xedbd15c8uL, 0x7f97c5abuL,
0xba5ac7b5uL, 0xb6f6deafuL, 0x3a479c3auL, 0x5302da25uL, 0x653d7e6auL,
0x54268d49uL, 0x51a477eauL, 0x5017d55buL, 0xd7d25d88uL, 0x44136c76uL,
0x0404a8c8uL, 0xb8e5a121uL, 0xb81a928auL, 0x60ed5869uL, 0x97c55b96uL,
0xeaec991buL, 0x29935913uL, 0x01fdb7f1uL, 0x088e8dfauL, 0x9ab6f6f5uL,
0x3b4cbf9fuL, 0x4a5de3abuL, 0xe6051d35uL, 0xa0e1d855uL, 0xd36b4cf1uL,
0xf544edebuL, 0xb0e93524uL, 0xbebb8fbduL, 0xa2d762cfuL, 0x49c92f54uL,
0x38b5f331uL, 0x7128a454uL, 0x48392905uL, 0xa65b1db8uL, 0x851c97bduL,
0xd675cf2fuL };

const U32 cast5_s7[] = {
0x85e04019uL, 0x332bf567uL, 0x662dbfffuL, 0xcfc65693uL, 0x2a8d7f6fuL,
0xab9bc912uL, 0xde6008a1uL, 0x2028da1fuL, 0x0227bce7uL, 0x4d642916uL,
0x18fac300uL, 0x50f18b82uL, 0x2cb2cb11uL, 0xb232e75cuL, 0x4b3695f2uL,
0xb28707deuL, 0xa05fbcf6uL, 0xcd4181e9uL, 0xe150210cuL, 0xe24ef1bduL,
0xb168c381uL, 0xfde4e789uL, 0x5c79b0d8uL, 0x1e8bfd43uL, 0x4d495001uL,
0x38be4341uL, 0x913cee1duL, 0x92a79c3fuL, 0x089766beuL, 0xbaeeadf4uL,
0x1286becfuL, 0xb6eacb19uL, 0x2660c200uL, 0x7565bde4uL, 0x64241f7auL,
0x8248dca9uL, 0xc3b3ad66uL, 0x28136086uL, 0x0bd8dfa8uL, 0x356d1cf2uL,
0x107789beuL, 0xb3b2e9ceuL, 0x0502aa8fuL, 0x0bc0351euL, 0x166bf52auL,
0xeb12ff82uL, 0xe3486911uL, 0xd34d7516uL, 0x4e7b3affuL, 0x5f43671buL,
0x9cf6e037uL, 0x4981ac83uL, 0x334266ceuL, 0x8c9341b7uL, 0xd0d854c0uL,
0xcb3a6c88uL, 0x47bc2829uL, 0x4725ba37uL, 0xa66ad22buL, 0x7ad61f1euL,
0x0c5cbafauL, 0x4437f107uL, 0xb6e79962uL, 0x42d2d816uL, 0x0a961288uL,
0xe1a5c06euL, 0x13749e67uL, 0x72fc081auL, 0xb1d139f7uL, 0xf9583745uL,
0xcf19df58uL, 0xbec3f756uL, 0xc06eba30uL, 0x07211b24uL, 0x45c28829uL,
0xc95e317fuL, 0xbc8ec511uL, 0x38bc46e9uL, 0xc6e6fa14uL, 0xbae8584auL,
0xad4ebc46uL, 0x468f508buL, 0x7829435fuL, 0xf124183buL, 0x821dba9fuL,
0xaff60ff4uL, 0xea2c4e6duL, 0x16e39264uL, 0x92544a8buL, 0x009b4fc3uL,
0xaba68ceduL, 0x9ac96f78uL, 0x06a5b79auL, 0xb2856e6euL, 0x1aec3ca9uL,
0xbe838688uL, 0x0e0804e9uL, 0x55f1be56uL, 0xe7e5363buL, 0xb3a1f25duL,
0xf7debb85uL, 0x61fe033cuL, 0x16746233uL, 0x3c034c28uL, 0xda6d0c74uL,
0x79aac56cuL, 0x3ce4e1aduL, 0x51f0c802uL, 0x98f8f35auL, 0x1626a49fuL,
0xeed82b29uL, 0x1d382fe3uL, 0x0c4fb99auL, 0xbb325778uL, 0x3ec6d97buL,
0x6e77a6a9uL, 0xcb658b5cuL, 0xd45230c7uL, 0x2bd1408buL, 0x60c03eb7uL,
0xb9068d78uL, 0xa33754f4uL, 0xf430c87duL, 0xc8a71302uL, 0xb96d8c32uL,
0xebd4e7beuL, 0xbe8b9d2duL, 0x7979fb06uL, 0xe7225308uL, 0x8b75cf77uL,
0x11ef8da4uL, 0xe083c858uL, 0x8d6b786fuL, 0x5a6317a6uL, 0xfa5cf7a0uL,
0x5dda0033uL, 0xf28ebfb0uL, 0xf5b9c310uL, 0xa0eac280uL, 0x08b9767auL,
0xa3d9d2b0uL, 0x79d34217uL, 0x021a718duL, 0x9ac6336auL, 0x2711fd60uL,
0x438050e3uL, 0x069908a8uL, 0x3d7fedc4uL, 0x826d2befuL, 0x4eeb8476uL,
0x488dcf25uL, 0x36c9d566uL, 0x28e74e41uL, 0xc2610acauL, 0x3d49a9cfuL,
0xbae3b9dfuL, 0xb65f8de6uL, 0x92aeaf64uL, 0x3ac7d5e6uL, 0x9ea80509uL,
0xf22b017duL, 0xa4173f70uL, 0xdd1e16c3uL, 0x15e0d7f9uL, 0x50b1b887uL,
0x2b9f4fd5uL, 0x625aba82uL, 0x6a017962uL, 0x2ec01b9cuL, 0x15488aa9uL,
0xd716e740uL, 0x40055a2cuL, 0x93d29a22uL, 0xe32dbf9auL, 0x058745b9uL,
0x3453dc1euL, 0xd699296euL, 0x496cff6fuL, 0x1c9f4986uL, 0xdfe2ed07uL,
0xb87242d1uL, 0x19de7eaeuL, 0x053e561auL, 0x15ad6f8cuL, 0x66626c1cuL,
0x7154c24cuL, 0xea082b2auL, 0x93eb2939uL, 0x17dcb0f0uL, 0x58d4f2aeuL,
0x9ea294fbuL, 0x52cf564cuL, 0x9883fe66uL, 0x2ec40581uL, 0x763953c3uL,
0x01d6692euL, 0xd3a0c108uL, 0xa1e7160euL, 0xe4f2dfa6uL, 0x693ed285uL,
0x74904698uL, 0x4c2b0edduL, 0x4f757656uL, 0x5d393378uL, 0xa132234fuL,
0x3d321c5duL, 0xc3f5e194uL, 0x4b269301uL, 0xc79f022fuL, 0x3c997e7euL,
0x5e4f9504uL, 0x3ffafbbduL, 0x76f7ad0euL, 0x296693f4uL, 0x3d1fce6fuL,
0xc61e45beuL, 0xd3b5ab34uL, 0xf72bf9b7uL, 0x1b0434c0uL, 0x4e72b567uL,
0x5592a33duL, 0xb5229301uL, 0xcfd2a87fuL, 0x60aeb767uL, 0x1814386buL,
0x30bcc33duL, 0x38a0c07duL, 0xfd1606f2uL, 0xc363519buL, 0x589dd390uL,
0x5479f8e6uL, 0x1cb8d647uL, 0x97fd61a9uL, 0xea7759f4uL, 0x2d57539duL,
0x569a58cfuL, 0xe84e63aduL, 0x462e1b78uL, 0x6580f87euL, 0xf3817914uL,
0x91da55f4uL, 0x40a230f3uL, 0xd1988f35uL, 0xb6e318d2uL, 0x3ffa50bcuL,
0x3d40f021uL, 0xc3c0bdaeuL, 0x4958c24cuL, 0x518f36b2uL, 0x84b1d370uL,
0x0fedce83uL, 0x878ddadauL, 0xf2a279c7uL, 0x94e01be8uL, 0x90716f4buL,
0x954b8aa3uL };

const U32 cast5_s8[] = {
0xe216300duL, 0xbbddfffcuL, 0xa7ebdabduL, 0x35648095uL, 0x7789f8b7uL,
0xe6c1121buL, 0x0e241600uL, 0x052ce8b5uL, 0x11a9cfb0uL, 0xe5952f11uL,
0xece7990auL, 0x9386d174uL, 0x2a42931cuL, 0x76e38111uL, 0xb12def3auL,
0x37ddddfcuL, 0xde9adeb1uL, 0x0a0cc32cuL, 0xbe197029uL, 0x84a00940uL,
0xbb243a0fuL, 0xb4d137cfuL, 0xb44e79f0uL, 0x049eedfduL, 0x0b15a15duL,
0x480d3168uL, 0x8bbbde5auL, 0x669ded42uL, 0xc7ece831uL, 0x3f8f95e7uL,
0x72df191buL, 0x7580330duL, 0x94074251uL, 0x5c7dcdfauL, 0xabbe6d63uL,
0xaa402164uL, 0xb301d40auL, 0x02e7d1cauL, 0x53571daeuL, 0x7a3182a2uL,
0x12a8ddecuL, 0xfdaa335duL, 0x176f43e8uL, 0x71fb46d4uL, 0x38129022uL,
0xce949ad4uL, 0xb84769aduL, 0x965bd862uL, 0x82f3d055uL, 0x66fb9767uL,
0x15b80b4euL, 0x1d5b47a0uL, 0x4cfde06fuL, 0xc28ec4b8uL, 0x57e8726euL,
0x647a78fcuL, 0x99865d44uL, 0x608bd593uL, 0x6c200e03uL, 0x39dc5ff6uL,
0x5d0b00a3uL, 0xae63aff2uL, 0x7e8bd632uL, 0x70108c0cuL, 0xbbd35049uL,
0x2998df04uL, 0x980cf42auL, 0x9b6df491uL, 0x9e7edd53uL, 0x06918548uL,
0x58cb7e07uL, 0x3b74ef2euL, 0x522fffb1uL, 0xd24708ccuL, 0x1c7e27cduL,
0xa4eb215buL, 0x3cf1d2e2uL, 0x19b47a38uL, 0x424f7618uL, 0x35856039uL,
0x9d17dee7uL, 0x27eb35e6uL, 0xc9aff67buL, 0x36baf5b8uL, 0x09c467cduL,
0xc18910b1uL, 0xe11dbf7buL, 0x06cd1af8uL, 0x7170c608uL, 0x2d5e3354uL,
0xd4de495auL, 0x64c6d006uL, 0xbcc0c62cuL, 0x3dd00db3uL, 0x708f8f34uL,
0x77d51b42uL, 0x264f620fuL, 0x24b8d2bfuL, 0x15c1b79euL, 0x46a52564uL,
0xf8d7e54euL, 0x3e378160uL, 0x7895cda5uL, 0x859c15a5uL, 0xe6459788uL,
0xc37bc75fuL, 0xdb07ba0cuL, 0x0676a3abuL, 0x7f229b1euL, 0x31842e7buL,
0x24259fd7uL, 0xf8bef472uL, 0x835ffcb8uL, 0x6df4c1f2uL, 0x96f5b195uL,
0xfd0af0fcuL, 0xb0fe134cuL, 0xe2506d3duL, 0x4f9b12eauL, 0xf215f225uL,
0xa223736fuL, 0x9fb4c428uL, 0x25d04979uL, 0x34c713f8uL, 0xc4618187uL,
0xea7a6e98uL, 0x7cd16efcuL, 0x1436876cuL, 0xf1544107uL, 0xbedeee14uL,
0x56e9af27uL, 0xa04aa441uL, 0x3cf7c899uL, 0x92ecbae6uL, 0xdd67016duL,
0x151682ebuL, 0xa842eedfuL, 0xfdba60b4uL, 0xf1907b75uL, 0x20e3030fuL,
0x24d8c29euL, 0xe139673buL, 0xefa63fb8uL, 0x71873054uL, 0xb6f2cf3buL,
0x9f326442uL, 0xcb15a4ccuL, 0xb01a4504uL, 0xf1e47d8duL, 0x844a1be5uL,
0xbae7dfdcuL, 0x42cbda70uL, 0xcd7dae0auL, 0x57e85b7auL, 0xd53f5af6uL,
0x20cf4d8cuL, 0xcea4d428uL, 0x79d130a4uL, 0x3486ebfbuL, 0x33d3cddcuL,
0x77853b53uL, 0x37effcb5uL, 0xc5068778uL, 0xe580b3e6uL, 0x4e68b8f4uL,
0xc5c8b37euL, 0x0d809ea2uL, 0x398feb7cuL, 0x132a4f94uL, 0x43b7950euL,
0x2fee7d1cuL, 0x223613bduL, 0xdd06caa2uL, 0x37df932buL, 0xc4248289uL,
0xacf3ebc3uL, 0x5715f6b7uL, 0xef3478dduL, 0xf267616fuL, 0xc148cbe4uL,
0x9052815euL, 0x5e410fabuL, 0xb48a2465uL, 0x2eda7fa4uL, 0xe87b40e4uL,
0xe98ea084uL, 0x5889e9e1uL, 0xefd390fcuL, 0xdd07d35buL, 0xdb485694uL,
0x38d7e5b2uL, 0x57720101uL, 0x730edebcuL, 0x5b643113uL, 0x94917e4fuL,
0x503c2fbauL, 0x646f1282uL, 0x7523d24auL, 0xe0779695uL, 0xf9c17a8fuL,
0x7a5b2121uL, 0xd187b896uL, 0x29263a4duL, 0xba510cdfuL, 0x81f47c9fuL,
0xad1163eduL, 0xea7b5965uL, 0x1a00726euL, 0x11403092uL, 0x00da6d77uL,
0x4a0cdd61uL, 0xad1f4603uL, 0x605bdfb0uL, 0x9eedc364uL, 0x22ebe6a8uL,
0xcee7d28auL, 0xa0e736a0uL, 0x5564a6b9uL, 0x10853209uL, 0xc7eb8f37uL,
0x2de705cauL, 0x8951570fuL, 0xdf09822buL, 0xbd691a6cuL, 0xaa12e4f2uL,
0x87451c0fuL, 0xe0f6a27auL, 0x3ada4819uL, 0x4cf1764fuL, 0x0d771c2buL,
0x67cdb156uL, 0x350d8384uL, 0x5938fa0fuL, 0x42399ef3uL, 0x36997b07uL,
0x0e84093duL, 0x4aa93e61uL, 0x8360d87buL, 0x1fa98b0cuL, 0x1149382cuL,
0xe97625a5uL, 0x0614d1b7uL, 0x0e25244buL, 0x0c768347uL, 0x589e8d82uL,
0x0d2059d1uL, 0xa466bb1euL, 0xf8da0a82uL, 0x04f19130uL, 0xba6e4ec0uL,
0x99265164uL, 0x1ee7230duL, 0x50b2ad80uL, 0xeaee6801uL, 0x8db2a283uL,
0xea8bf59euL };

/* end tables.c */
