use v6.c;

use Method::Also;

use NativeCall;

use GIO::Raw::Types;
use GIO::Raw::MemoryInputStream;

use GIO::InputStream;

use GIO::Roles::Seekable;
use GIO::Roles::PollableInputStream;

our subset GMemoryInputStreamAncestry is export of Mu
  where GMemoryInputStream | GPollableInputStream | GSeekable | GInputStream;

class GIO::MemoryInputStream is GIO::InputStream {
  also does GIO::Roles::Seekable;
  also does GIO::Roles::PollableInputStream;

  has GMemoryInputStream $!mis is implementor;

  submethod BUILD (:$memory-stream) {
    self.setMemoryInputStream($memory-stream) if $memory-stream;
  }

  method setMemoryInputStream (GMemoryInputStreamAncestry $_) {
    my $to-parent;

    $!mis = do {
      when GMemoryInputStream {
        $to-parent = cast(GInputStream, $_);
        $_;
      }

      when GSeekable {
        $to-parent = cast(GInputStream, $_);
        $!s = $_;
        cast(GMemoryInputStream, $_);
      }

      when GPollableInputStream {
        $to-parent = cast(GInputStream, $_);
        $!pis = $_;
        cast(GMemoryInputStream, $_);
      }

      default {
        $to-parent = $_;
        cast(GMemoryInputStream, $_)
      }
    }
    self.roleInit-Seekable            unless $!s;
    self.roleInit-PollableInputStream unless $!pis;
    self.setInputStream($to-parent);
  }

  method GIO::Raw::Definitions::GMemoryInputStream
    is also<GMemoryInputStream>
  { $!mis }

  multi method new (GMemoryInputStreamAncestry $memory-stream, :$ref = True) {
    return unless $memory-stream;

    my $o = self.bless( :$memory-stream );
    $o.ref if $ref;
    $o;
  }
  multi method new {
    my $memory-stream = g_memory_input_stream_new();

    $memory-stream ?? self.bless( :$memory-stream ) !! Nil;
  }

  method new_from_bytes (GBytes() $bytes) is also<new-from-bytes> {
    my $memory-stream = g_memory_input_stream_new_from_bytes($bytes);

    $memory-stream ?? self.bless( :$memory-stream ) !! Nil;
  }

  method new_from_data (
    Blob()         $data,
    Int()          $len     = -1,
    GDestroyNotify $destroy = Pointer
  )
    is also<new-from-data>
  {
    my gssize $l = $len;
    my $memory-stream = g_memory_input_stream_new_from_data(
      $data,
      $l,
      $destroy
    );

    $memory-stream ?? self.bless( :$memory-stream ) !! Nil;
  }

  method add_bytes (GBytes() $bytes) is also<add-bytes> {
    g_memory_input_stream_add_bytes($!mis, $bytes);
  }

  method add_data (
    Blob()         $data,
    Int()          $len     = -1,
    GDestroyNotify $destroy = Pointer
  )
    is also<add-data>
  {
    my gssize $l = $len;

    g_memory_input_stream_add_data($!mis, $data, $l, $destroy);
  }

  method get_type is also<get-type> {
    state ($n, $t);

    unstable_get_type( self.^name, &g_memory_input_stream_get_type, $n, $t );
  }

}
