/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import ucar.units.Factor;

public abstract class Dimension {
    protected final Factor[] _factors;
    private volatile transient int hashCode;

    public Dimension() {
        this(new Factor[0]);
    }

    protected Dimension(Factor factor) {
        this(new Factor[]{factor});
    }

    protected Dimension(Factor[] factors) {
        this._factors = factors;
    }

    public final int getRank() {
        return this._factors.length;
    }

    public final Factor[] getFactors() {
        Factor[] factors = new Factor[this._factors.length];
        System.arraycopy(this._factors, 0, factors, 0, factors.length);
        return factors;
    }

    protected Factor[] mult(Dimension that) {
        Factor[] factors1 = this._factors;
        Factor[] factors2 = that._factors;
        int i1 = 0;
        int i2 = 0;
        int k = 0;
        Factor[] newFactors = new Factor[factors1.length + factors2.length];
        while (true) {
            int n;
            if (i1 == factors1.length) {
                n = factors2.length - i2;
                System.arraycopy(factors2, i2, newFactors, k, n);
                k += n;
                break;
            }
            if (i2 == factors2.length) {
                n = factors1.length - i1;
                System.arraycopy(factors1, i1, newFactors, k, n);
                k += n;
                break;
            }
            Factor f1 = factors1[i1];
            Factor f2 = factors2[i2];
            int comp = f1.getID().compareTo(f2.getID());
            if (comp < 0) {
                newFactors[k++] = f1;
                ++i1;
                continue;
            }
            if (comp == 0) {
                int exponent = f1.getExponent() + f2.getExponent();
                if (exponent != 0) {
                    newFactors[k++] = new Factor(f1, exponent);
                }
                ++i1;
                ++i2;
                continue;
            }
            newFactors[k++] = f2;
            ++i2;
        }
        if (k < newFactors.length) {
            Factor[] tmp = new Factor[k];
            System.arraycopy(newFactors, 0, tmp, 0, k);
            newFactors = tmp;
        }
        return newFactors;
    }

    protected Factor[] pow(int power) {
        Factor[] factors;
        if (power == 0) {
            factors = new Factor[]{};
        } else {
            factors = this.getFactors();
            if (power != 1) {
                int i = factors.length;
                while (--i >= 0) {
                    factors[i] = factors[i].pow(power);
                }
            }
        }
        return factors;
    }

    public final boolean isReciprocalOf(Dimension that) {
        boolean isReciprocalOf;
        Factor[] theseFactors = this._factors;
        Factor[] thoseFactors = that._factors;
        if (theseFactors.length != thoseFactors.length) {
            isReciprocalOf = false;
        } else {
            int i = theseFactors.length;
            while (--i >= 0 && theseFactors[i].isReciprocalOf(thoseFactors[i])) {
            }
            isReciprocalOf = i < 0;
        }
        return isReciprocalOf;
    }

    public final boolean equals(Object object) {
        boolean equals;
        if (this == object) {
            equals = true;
        } else if (!(object instanceof Dimension)) {
            equals = false;
        } else {
            Factor[] thatFactors = ((Dimension)object)._factors;
            if (this._factors.length != thatFactors.length) {
                equals = false;
            } else {
                int i = this._factors.length;
                while (--i >= 0 && this._factors[i].equals(thatFactors[i])) {
                }
                equals = i < 0;
            }
        }
        return equals;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 0;
            for (int i = 0; i < this._factors.length; ++i) {
                hash ^= this._factors[i].hashCode();
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public final boolean isDimensionless() {
        int i = this._factors.length;
        while (--i >= 0) {
            if (this._factors[i].isDimensionless()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(40);
        for (int i = 0; i < this._factors.length; ++i) {
            buf.append(this._factors[i]).append('.');
        }
        if (buf.length() != 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }
}

