[![Build Status](https://travis-ci.org/mudler/Mojolicious-Plugin-ViewBuilder.png?branch=master)](https://travis-ci.org/mudler/Mojolicious-Plugin-ViewBuilder)
# NAME

Mojolicious::Plugin::ViewBuilder - a Mojolicious plugin that allows to chain templates generated by other plugins

# SYNOPSIS

    #Load the plugin

    # - Mojolicious
    $self->plugin('ViewBuilder');

    # - Mojolicious::Lite
    plugin 'ViewBuilder';

    # then, use it in your template, declare a new area, labeled "profile"
    <%= pluggable_view 'profile' %>

    # now, in the plugin, that will attach the new helper to the view

    sub register {
        my ( $self, $app, $conf ) = @_;

        $app->helper(
            test => sub {
                shift->render_to_string( "test", some_data => 1 );
            }
        );

        #attach the test helper to the view "profile"
        $app->add_view( "profile", "test" );

    }
    1;

    # or you can append a callback

    sub register {
        my ( $self, $app, $conf ) = @_;
        $app->add_view(
            profile => sub {
                shift->render_to_string( "test", some_data => 42 );
            }
        );
    }
    1;
    __DATA__
    @@ test.html.ep
    huuuray!
    % if( stash("some_data") and stash("some_data")==42){
     double it!
    % }

# DESCRIPTION

[Mojolicious::Plugin::ViewBuilder](https://metacpan.org/pod/Mojolicious::Plugin::ViewBuilder) is a [Mojolicious](https://metacpan.org/pod/Mojolicious) plugin. Chains templates generated by other plugins, associating them within the view. This is useful only if your workflow is to reap into little pieces the webapp (e.g. in plugins)

# METHODS

[Mojolicious::Plugin::ViewBuilder](https://metacpan.org/pod/Mojolicious::Plugin::ViewBuilder) inherits all methods from
[Mojolicious::Plugin](https://metacpan.org/pod/Mojolicious::Plugin) and implements the following new ones.

## pluggable\_view

    <%=pluggable_view "profile" %>

Will render all the attached plugin associated within the view

## add\_view

    $app->add_view("view","helper");
    $app->add_view(view => sub{shift->render_to_string("Hello mojolicious!")});

Attach the "helper" within the "view"

# LICENSE

Copyright (C) mudler.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

# AUTHOR

mudler <mudler@dark-lab.net>
