#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Akamai
#     ABSTRACT:  identify Akamai owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Thu Nov  6 11:03:41 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Akamai;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.111'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of of of known Akamai IP blocks as of May 2015
    # AS12222 AS16625 AS16702 AS17334 AS18680 AS18717 AS20189 AS20940
    # AS21342 AS21357 AS21399 AS22207 AS23454 AS23455 AS23903 AS24319
    # AS30675 AS31107 AS31108 AS31109 AS31110 AS31377 AS33905 AS34164
    # AS34850 AS35204 AS35993 AS35994 AS36183 AS39836 AS43639 AS45700
    # AS48163 AS55770 AS393560
    $self->ips( # 187 Network Blocks
        '2.16.0.0/13',
        '23.0.0.0/12',
        # extending 23.32.0.0/11 to include 23.64.0.0/14
        '23.32.0.0-23.67.255.255',
        '23.72.0.0/13',
        '23.192.0.0/11',
        '42.99.255.0/24',
        # extending 46.33.64.0/21 to include 46.33.72.0/22
        # extending 46.33.64.0-46.33.75.255 to include 46.33.76.0/23
        '46.33.64.0-46.33.77.255',
        # extending 58.27.86.0/24 to include 58.27.87.0/24
        '58.27.86.0/23',
        '59.144.52.0/24',
        '59.144.56.0/24',
        '59.144.115.0/24',
        '59.151.128.0/18',
        '60.254.128.0/18',
        '62.154.232.0/24',
        '62.156.209.0/24',
        '62.159.74.0/24',
        '63.84.59.0/24',
        '63.85.36.0/24',
        '63.141.192.0/23',
        '63.141.195.0/24',
        '63.141.200.0/23',
        '63.144.176.0/24',
        '63.150.131.0/24',
        '63.162.234.0/24',
        '63.168.61.0/24',
        '63.208.195.0/24',
        '63.243.206.0/23',
        # extending 63.243.241.0/24 to include 63.243.242.0/24
        '63.243.241.0-63.243.242.255',
        '64.86.133.0/24',
        '64.86.201.0/24',
        '64.145.68.0/22',
        '64.145.75.0/24',
        '64.145.84.0/24',
        # extending 64.145.87.0/24 to include 64.145.88.0/24
        # extending 64.145.87.0-64.145.88.255 to include 64.145.89.0/24
        '64.145.87.0-64.145.89.255',
        '64.145.95.0/24',
        '65.121.210.0/23',
        '65.122.93.0/24',
        '65.163.176.0/24',
        '65.171.167.0/24',
        '65.173.24.0/24',
        '65.197.197.0/24',
        '65.197.244.0/24',
        '66.171.224.0/23',
        '66.171.227.0/24',
        # extending 66.171.230.0/24 to include 66.171.231.0/24
        '66.171.230.0/23',
        '66.171.234.0/23',
        '66.198.8.0/24',
        '67.131.232.0/24',
        '69.22.154.0/23',
        '69.31.20.0/24',
        '69.31.57.0/24',
        # extending 69.31.72.0/23 to include 69.31.74.0/23
        # extending 69.31.72.0/22 to include 69.31.76.0/23
        '69.31.72.0-69.31.77.255',
        '69.31.89.0/24',
        '69.31.97.0/24',
        '69.31.106.0/23',
        '69.31.116.0/23',
        '69.31.132.0/23',
        '69.31.138.0/24',
        '69.192.0.0/16',
        '70.39.163.0/24',
        '70.39.178.0/23',
        '72.246.0.0/15',
        '80.12.192.0/24',
        '80.67.64.0/19',
        '80.146.174.0/24',
        '80.231.241.0/24',
        '81.52.134.0/24',
        '81.52.201.0/24',
        '82.96.58.0/24',
        '84.53.128.0/18',
        '88.221.0.0/16',
        '92.122.0.0/15',
        '93.92.66.0/24',
        '93.123.37.0/24',
        '93.158.110.0/23',
        '95.100.0.0/15',
        '96.6.0.0/15',
        '96.16.0.0/15',
        '103.238.148.0/22',
        '104.64.0.0/10',
        '111.92.162.0/24',
        '114.141.72.0/21',
        '115.124.93.0/24',
        '118.214.0.0/15',
        '122.252.32.0/19',
        '122.252.128.0/20',
        '125.56.128.0/17',
        '125.252.192.0/18',
        '172.224.0.0/12',
        '173.205.78.0/23',
        '173.222.0.0/15',
        '173.245.192.0/23',
        # extending 173.245.196.0/24 to include 173.245.197.0/24
        # extending 173.245.196.0/23 to include 173.245.198.0/24
        '173.245.196.0-173.245.198.255',
        # extending 173.245.212.0/23 to include 173.245.214.0/24
        '173.245.212.0-173.245.214.255',
        '184.24.0.0/13',
        '184.50.0.0/15',
        '184.84.0.0/14',
        # extending 189.125.84.0/24 to include 189.125.85.0/24
        '189.125.84.0/23',
        # extending 190.90.221.0/24 to include 190.90.222.0/24
        # extending 190.90.221.0-190.90.222.255 to include 190.90.223.0/24
        '190.90.221.0-190.90.223.255',
        '190.210.32.0/24',
        '193.108.88.0/21',
        '193.108.152.0/22',
        # extending 193.247.166.0/24 to include 193.247.167.0/24
        '193.247.166.0/23',
        '194.224.66.0/24',
        '195.49.93.0/24',
        '195.57.81.0/24',
        '195.57.152.0/23',
        '195.59.122.0/24',
        '195.95.192.0/23',
        '195.175.68.0/22',
        # extending 195.245.124.0/23 to include 195.245.126.0/23
        '195.245.124.0/22',
        '196.41.99.0/24',
        '198.47.108.0/24',
        '198.144.96.0/24',
        # extending 198.144.98.0/24 to include 198.144.99.0/24
        # extending 198.144.98.0/23 to include 198.144.100.0/24
        '198.144.98.0-198.144.100.255',
        '198.144.112.0/24',
        '198.144.115.0/24',
        '198.144.119.0/24',
        '201.220.10.0/24',
        '202.74.62.0/23',
        '202.125.100.0/23',
        '203.101.53.0/24',
        '203.146.247.0/24',
        '204.8.48.0/22',
        '204.10.28.0/22',
        '204.93.32.0/24',
        '204.93.34.0/24',
        # extending 204.93.36.0/24 to include 204.93.37.0/24
        # extending 204.93.36.0/23 to include 204.93.38.0/23
        # extending 204.93.36.0/22 to include 204.93.40.0/24
        '204.93.36.0-204.93.40.255',
        # extending 204.93.42.0/23 to include 204.93.44.0/24
        '204.93.42.0-204.93.44.255',
        # extending 204.93.46.0/23 to include 204.93.48.0/24
        '204.93.46.0-204.93.48.255',
        '204.93.62.0/23',
        '204.95.24.0/23',
        '205.161.113.0/24',
        '205.185.204.0/23',
        '205.234.218.0/24',
        '205.234.225.0/24',
        '205.246.30.0/23',
        '208.34.250.0/24',
        '209.95.152.0/24',
        # extending 209.107.202.0/24 to include 209.107.203.0/24
        '209.107.202.0/23',
        # extending 209.107.205.0/24 to include 209.107.206.0/24
        # extending 209.107.205.0-209.107.206.255 to include 209.107.207.0/24
        '209.107.205.0-209.107.207.255',
        '209.107.209.0/24',
        '209.107.213.0/24',
        '209.107.215.0/24',
        # extending 209.107.220.0/24 to include 209.107.221.0/24
        # extending 209.107.220.0/23 to include 209.107.222.0/24
        # extending 209.107.220.0-209.107.222.255 to include 209.107.223.0/24
        '209.107.220.0/22',
        '209.136.40.0/24',
        '209.170.90.0/24',
        '209.170.94.0/24',
        '209.170.97.0/24',
        '209.170.113.0/24',
        # extending 209.170.115.0/24 to include 209.170.116.0/24
        # extending 209.170.115.0-209.170.116.255 to include 209.170.117.0/24
        # extending 209.170.115.0-209.170.117.255 to include 209.170.118.0/24
        '209.170.115.0-209.170.118.255',
        '209.234.250.0/24',
        '209.234.252.0/24',
        '210.16.40.0/24',
        '213.254.17.0/24',
        '216.151.176.0/24',
        '216.151.187.0/24',
        '216.206.30.0/24',
        '216.246.75.0/24',
        '216.246.87.0/24',
        '216.246.93.0/24',
        '216.246.122.0/24',
        '217.89.107.0/24',
        '2001:218:3003::/48',
        '2001:590:1::/48',
        # extending 2001:590:1009::/48 to include 2001:590:100a::/48
        # extending 2001:0590:1009:0000:0000:0000:0000:0000-2001:0590:100a:ffff:ffff:ffff:ffff:ffff to include 2001:590:100b::/48
        '2001:0590:1009:0000:0000:0000:0000:0000-2001:0590:100b:ffff:ffff:ffff:ffff:ffff',
        # extending 2001:590:140a::/48 to include 2001:590:140b::/48
        # extending 2001:590:140a::/47 to include 2001:590:140c::/48
        '2001:0590:140a:0000:0000:0000:0000:0000-2001:0590:140c:ffff:ffff:ffff:ffff:ffff',
        # extending 2001:590:1807::/48 to include 2001:590:1808::/48
        '2001:0590:1807:0000:0000:0000:0000:0000-2001:0590:1808:ffff:ffff:ffff:ffff:ffff',
        # extending 2001:590:1c09::/48 to include 2001:590:1c0a::/48
        # extending 2001:0590:1c09:0000:0000:0000:0000:0000-2001:0590:1c0a:ffff:ffff:ffff:ffff:ffff to include 2001:590:1c0b::/48
        '2001:0590:1c09:0000:0000:0000:0000:0000-2001:0590:1c0b:ffff:ffff:ffff:ffff:ffff',
        # extending 2001:590:2009::/48 to include 2001:590:200a::/48
        # extending 2001:0590:2009:0000:0000:0000:0000:0000-2001:0590:200a:ffff:ffff:ffff:ffff:ffff to include 2001:590:200b::/48
        '2001:0590:2009:0000:0000:0000:0000:0000-2001:0590:200b:ffff:ffff:ffff:ffff:ffff',
        # extending 2001:590:2406::/48 to include 2001:590:2407::/48
        # extending 2001:590:2406::/47 to include 2001:590:2408::/48
        '2001:0590:2406:0000:0000:0000:0000:0000-2001:0590:2408:ffff:ffff:ffff:ffff:ffff',
        '2001:590:2807::/48',
        # extending 2001:590:2809::/48 to include 2001:590:280a::/48
        '2001:0590:2809:0000:0000:0000:0000:0000-2001:0590:280a:ffff:ffff:ffff:ffff:ffff',
        '2001:590:4803::/48',
        # extending 2001:5a0:3b00::/48 to include 2001:5a0:3b01::/48
        '2001:5a0:3b00::/47',
        '2001:5a0:3c00::/48',
        '2001:5a0:3d00::/48',
        '2001:4878::/32',
        '2404:4e00::/32',
        '2600:2:d80:3::/64',
        '2600:3:500:4::/64',
        '2600:3:500:6::/64',
        '2600:5:3d40:3::/64',
        '2600:1400::/27',
        # extending 2a01:3e0:402::/48 to include 2a01:3e0:403::/48
        '2a01:3e0:402::/47',
        '2a02:b60::/64',
        '2a02:26f0::/32',
    );
    return $self;
}

sub name {
    return 'Akamai';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Akamai - identify Akamai owned IP addresses

=head1 VERSION

version 0.111

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Akamai;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Akamai identifies Akamai host IPs.  Autonomous
System (AS) numbers include (many thanks to Hurricane Electric and their
BGP toolkit at http://bgp.he.net/):

    AS12222 AS16625 AS16702 AS17334 AS18680 AS18717 AS20189 AS20940
    AS21342 AS21357 AS21399 AS22207 AS23454 AS23455 AS23903 AS24319
    AS30675 AS31107 AS31108 AS31109 AS31110 AS31377 AS33905 AS34164
    AS34850 AS35204 AS35993 AS35994 AS36183 AS39836 AS43639 AS45700
    AS48163 AS55770 AS393560

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Akamai object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
