/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

import java.net.ProtocolException;
import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.protocol.BinaryArithmeticCommand;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryGetCommand;
import org.couchbase.mock.memcached.protocol.BinaryHelloCommand;
import org.couchbase.mock.memcached.protocol.BinaryObserveCommand;
import org.couchbase.mock.memcached.protocol.BinaryObserveSeqnoCommand;
import org.couchbase.mock.memcached.protocol.BinaryStoreCommand;
import org.couchbase.mock.memcached.protocol.CommandCode;

public class CommandFactory {
    public static BinaryCommand create(ByteBuffer header) throws ProtocolException {
        header.rewind();
        if (header.get() != -128) {
            throw new ProtocolException("Illegal magic");
        }
        CommandCode cc = CommandCode.valueOf(header.get());
        header.rewind();
        switch (cc) {
            case ADD: 
            case ADDQ: 
            case APPEND: 
            case APPENDQ: 
            case PREPEND: 
            case PREPENDQ: 
            case SET: 
            case SETQ: 
            case REPLACE: 
            case REPLACEQ: {
                return new BinaryStoreCommand(header);
            }
            case INCREMENT: 
            case INCREMENTQ: 
            case DECREMENT: 
            case DECREMENTQ: {
                return new BinaryArithmeticCommand(header);
            }
            case GET: 
            case GETQ: 
            case GETK: 
            case GETKQ: 
            case GAT: 
            case GATQ: 
            case TOUCH: 
            case GETL: 
            case GET_REPLICA: {
                return new BinaryGetCommand(header);
            }
            case OBSERVE: {
                return new BinaryObserveCommand(header);
            }
            case HELLO: {
                return new BinaryHelloCommand(header);
            }
            case OBSERVE_SEQNO: {
                return new BinaryObserveSeqnoCommand(header);
            }
        }
        return new BinaryCommand(header);
    }

    private CommandFactory() {
    }
}

