use strict;
use warnings;
use Test::More 0.88;
# This is a relatively nice way to avoid Test::NoWarnings breaking our
# expectations by adding extra tests, without using no_plan.  It also helps
# avoid any other test module that feels introducing random tests, or even
# test plans, is a nice idea.
our $success = 0;
END { $success && done_testing; }

# List our own version used to generate this
my $v = "\nGenerated by Dist::Zilla::Plugin::ReportVersions::Tiny v1.05\n";

eval {                     # no excuses!
    # report our Perl details
    my $want = 'v5.10.1';
    my $pv = ($^V || $]);
    $v .= "perl: $pv (wanted $want) on $^O from $^X\n\n";
};
defined($@) and diag("$@");

# Now, our module version dependencies:
sub pmver {
    my ($module, $wanted) = @_;
    $wanted = " (want $wanted)";
    my $pmver;
    eval "require $module;";
    if ($@) {
        if ($@ =~ m/Can't locate .* in \@INC/) {
            $pmver = 'module not found.';
        } else {
            diag("${module}: $@");
            $pmver = 'died during require.';
        }
    } else {
        my $version;
        eval { $version = $module->VERSION; };
        if ($@) {
            diag("${module}: $@");
            $pmver = 'died during VERSION check.';
        } elsif (defined $version) {
            $pmver = "$version";
        } else {
            $pmver = '<undef>';
        }
    }

    # So, we should be good, right?
    return sprintf('%-45s => %-10s%-15s%s', $module, $pmver, $wanted, "\n");
}

eval { $v .= pmver('Acme::Indent','0.01') };
eval { $v .= pmver('Dist::Zilla','1.093220') };
eval { $v .= pmver('Dist::Zilla::Plugin::Git::Check','1.093250') };
eval { $v .= pmver('Dist::Zilla::Role::Git::DirtyFiles','1.100740') };
eval { $v .= pmver('Dist::Zilla::Role::Git::LocalRepository','v0.1.1') };
eval { $v .= pmver('Dist::Zilla::Role::Git::Remote','v0.1.1') };
eval { $v .= pmver('Dist::Zilla::Role::Git::Remote::Branch','v0.1.1') };
eval { $v .= pmver('Dist::Zilla::Role::Git::Remote::Check','v0.1.1') };
eval { $v .= pmver('Dist::Zilla::Role::Git::Remote::Update','v0.1.1') };
eval { $v .= pmver('Dist::Zilla::Role::Git::Repo','1.113220') };
eval { $v .= pmver('Dist::Zilla::Role::MetaCPANInterfacer','0.90') };
eval { $v .= pmver('File::Slurp','9999.14') };
eval { $v .= pmver('List::AllUtils','0.01') };
eval { $v .= pmver('Moose','0.34') };
eval { $v .= pmver('Moose::Autobox','0.09') };
eval { $v .= pmver('MooseX::Has::Sugar','0.0100') };
eval { $v .= pmver('MooseX::Types::Moose','any version') };
eval { $v .= pmver('Test::CheckDeps','0.002') };
eval { $v .= pmver('Test::UseAllModules','0.10') };
eval { $v .= pmver('sanity','0.91') };


# All done.
$v .= <<'EOT';

Thanks for using my code.  I hope it works for you.
If not, please try and include this output in the bug report.
That will help me reproduce the issue and solve your problem.

EOT

diag($v);
ok(1, "we really didn't test anything, just reporting data");
$success = 1;

# Work around another nasty module on CPAN. :/
no warnings 'once';
$Template::Test::NO_FLUSH = 1;
exit 0;
