package Bundle::Math::Geometry;
use strict;
use warnings;

$VERSION = '1.00';

1;

__END__

=head1 NAME

Bundle::Math::Geometry - Bundle of modules related to 2D and 3D geometry

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math::Geometry'

=head1 CONTENTS

Math::Bezier

Math::Bezier::Convert

Math::Geometry

Math::Geometry::GPC

Math::Geometry::Planar

Math::Polyhedra

Math::Project

Math::Project3D

Math::Project3D::Plot

Math::QuadTree

Math::SO3

Math::Volume::Rotational

=head1 DESCRIPTION

This is a bundle of modules related to 2D and 3D geometry.

Please have a look at L<Bundle::Math>.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
