#!/usr/bin/perl

package eBay::API::XML::DataType::TransactionStatusType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. TransactionStatusType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::TransactionStatusType

=head1 DESCRIPTION

Contains the transaction status, e.g. the buyer's online
payment and whether the checkout process for the transaction is complete.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::TransactionStatusType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType;
use eBay::API::XML::DataType::Enum::CheckoutStatusCodeType;
use eBay::API::XML::DataType::Enum::CompleteStatusCodeType;
use eBay::API::XML::DataType::Enum::PaymentHoldStatusCodeType;
use eBay::API::XML::DataType::Enum::PaymentStatusCodeType;


my @gaProperties = ( [ 'BuyerSelectedShipping', 'xs:boolean', '', '', '' ]
	, [ 'CheckoutStatus', 'ns:CheckoutStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CheckoutStatusCodeType', '' ]
	, [ 'CompleteStatus', 'ns:CompleteStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CompleteStatusCodeType', '' ]
	, [ 'LastTimeModified', 'xs:dateTime', '', '', '' ]
	, [ 'PaymentHoldStatus', 'ns:PaymentHoldStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PaymentHoldStatusCodeType', '' ]
	, [ 'PaymentMethodUsed', 'ns:BuyerPaymentMethodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType', '' ]
	, [ 'eBayPaymentStatus', 'ns:PaymentStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PaymentStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBuyerSelectedShipping()

Indicates whether the buyer has selected shipping details
during checkout. False indicates that the shipping service was
selected by eBay for the buyer. For example, if the buyer has
not yet completed the Review Your Purchase page, he has not
picked a shipping service. If it is false, the application
should ignore ShippingServiceCost and ShippingServiceSelected
(items whose values are defaulted by eBay).

#    Argument: 'xs:boolean'

=cut

sub setBuyerSelectedShipping {
  my $self = shift;
  $self->{'BuyerSelectedShipping'} = shift
}

=head2 isBuyerSelectedShipping()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBuyerSelectedShipping {
  my $self = shift;
  return $self->{'BuyerSelectedShipping'};
}


=head2 setCheckoutStatus()

Indicates the current status of the checkout process for the transaction.

#    Argument: 'ns:CheckoutStatusCodeType'

=cut

sub setCheckoutStatus {
  my $self = shift;
  $self->{'CheckoutStatus'} = shift
}

=head2 getCheckoutStatus()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:CheckoutStatusCodeType'

=cut

sub getCheckoutStatus {
  my $self = shift;
  return $self->{'CheckoutStatus'};
}


=head2 setCompleteStatus()

Indicates whether the transaction process is complete or incomplete.

#    Argument: 'ns:CompleteStatusCodeType'

=cut

sub setCompleteStatus {
  my $self = shift;
  $self->{'CompleteStatus'} = shift
}

=head2 getCompleteStatus()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:CompleteStatusCodeType'

=cut

sub getCompleteStatus {
  my $self = shift;
  return $self->{'CompleteStatus'};
}


=head2 setLastTimeModified()

Indicates date and time a transaction's status or incomplete
state was last updated (in GMT).

#    Argument: 'xs:dateTime'

=cut

sub setLastTimeModified {
  my $self = shift;
  $self->{'LastTimeModified'} = shift
}

=head2 getLastTimeModified()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:dateTime'

=cut

sub getLastTimeModified {
  my $self = shift;
  return $self->{'LastTimeModified'};
}


=head2 setPaymentHoldStatus()

Contains the current status of a hold on a PayPal payment.
The payment hold that is referred to as a "payment review" hold
results from a possible issue with a buyer.  
The payment hold referred to as
a "merchant hold" results from a possible issue with a seller.
For more information, please see the link below.
Additionally, in the cases of the GetMyeBaySelling and GetMyeBayBuying calls,
the PaymentHoldStatus value can affect the value returned in 
in SellerPaidStatus and BuyerPaidStatus; see the PaymentHoldStatus applicable values.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=HoldsOnPayPalPayments
Title: Holds on PayPal Payments

#    Argument: 'ns:PaymentHoldStatusCodeType'

=cut

sub setPaymentHoldStatus {
  my $self = shift;
  $self->{'PaymentHoldStatus'} = shift
}

=head2 getPaymentHoldStatus()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Conditionally
  Details: DetailLevel: none

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: WonList
           DeletedFromWonList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList
           DeletedFromSoldList

#    Returns: 'ns:PaymentHoldStatusCodeType'

=cut

sub getPaymentHoldStatus {
  my $self = shift;
  return $self->{'PaymentHoldStatus'};
}


=head2 setPaymentMethodUsed()

Payment method the buyer selected for paying the seller
for the transaction. If checkout is not yet complete,
PaymentMethodUsed is set to whatever the buyer selected as his
or her preference on the Review Your Purchase page.

#    Argument: 'ns:BuyerPaymentMethodCodeType'

=cut

sub setPaymentMethodUsed {
  my $self = shift;
  $self->{'PaymentMethodUsed'} = shift
}

=head2 getPaymentMethodUsed()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:BuyerPaymentMethodCodeType'

=cut

sub getPaymentMethodUsed {
  my $self = shift;
  return $self->{'PaymentMethodUsed'};
}


=head2 setEBayPaymentStatus()

Indicates the success or failure of the buyer's online payment
for a transaction. Only applicable if the buyer chose PayPal as
the payment method for the transaction. If the payment failed,
the value returned indicates the reason for the failure. Output
only.

#    Argument: 'ns:PaymentStatusCodeType'

=cut

sub setEBayPaymentStatus {
  my $self = shift;
  $self->{'eBayPaymentStatus'} = shift
}

=head2 getEBayPaymentStatus()

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'ns:PaymentStatusCodeType'

=cut

sub getEBayPaymentStatus {
  my $self = shift;
  return $self->{'eBayPaymentStatus'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
