NAME
    RISCOS::Chunk -- manipulate Chunks in Acorn Chunkfiles

SYNOPSIS
        use RISCOS::Chunk;

        $chunk = new RISCOS::Chunk $chunkid, substr ($file, $offset, $size), $size,
    			       $index, $offset;


DESCRIPTION
    `RISCOS::Chunk' provides a class to hold details about a chunk
    in a chunkfile.

  Methods

    new <ID>, <data>, [<length>, [<index>, [<offset>]]]
        Returns a new `RISCOS::Chunk' object with a ChunkID *ID*,
        and contents *data*. If <length> is defined it is checked
        against `length *data*'. The *index* of the chunk in the
        chunkfile header and the *offset* of the chunk data in the
        chunkfile are stored if supplied.

    ID  Returns the chunk ID.

    Data
        Returns the chunk data.

    Length
        Returns the length of the chunk data - *i.e.* literally
        `length Data()'

    Index
        Returns the index of the chunk in the chunkfile header (if
        known, else returns undefined);

    Offset
        Returns the offset of the chunk data in the chunkfile (if
        known, else returns undefined);


BUGS
    None known.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

