= Win32::Registry

== Win32::Registry class

=== included modules

* ((<Enumerable>))
* ((<Registry::Constants|Win32::Registry/Registry::Constants module>))

=== class methods
--- Registry.new(key, subkey, desired = KEY_READ, opt = REG_OPTION_RESERVED)
--- Registry.new(key, subkey, desired = KEY_READ, opt = REG_OPTION_RESERVED) { |reg| ... }
--- Registry.open(key, subkey, desired = KEY_READ, opt = REG_OPTION_RESERVED)
--- Registry.open(key, subkey, desired = KEY_READ, opt = REG_OPTION_RESERVED) { |reg| ... }
    쥸ȥꥭ ((|key|)) Υ ((|subkey|)) 򳫤
    ɽ Win32::Registry ֥Ȥ֤ޤ
    ((|key|)) ϿƤΥ Win32::Registry ֥Ȥǻꤷޤ
    ƤΥˤѥ HKEY_* ѤǤޤ (((<Win32::Registry/constants>)))
    
    ((|desired|)) ϥޥǤ((|opt|)) ϥΥץǤ
    ܺ٤ ((<MSDN Library|URL:http://msdn.microsoft.com/library/en-us/sysinfo/base/registry_key_security_and_access_rights.asp>)) 򻲾ȤƤ
    
    ֥åͿȡϼưŪĤޤ

--- Registry.create(key, subkey, desired = KEY_ALL_ACCESS, opt = REG_OPTION_RESERVED)
--- Registry.create(key, subkey, desired = KEY_ALL_ACCESS, opt = REG_OPTION_RESERVED) { |reg| ... }
    쥸ȥꥭ ((|key|)) ˥ ((|subkey|)) 
    ɽ Win32::Registry ֥Ȥ֤ޤ
    ((|key|)) ϿƤΥ Win32::Registry ֥Ȥǻꤷޤ
    ƤΥˤѥ HKEY_* ѤǤޤ (((<Win32::Registry/constants>)))
    
    ֥¸ߤƤХϤ졤(({((<created?|Win32::Registry/created?>))}))
    ᥽åɤ false ֤ޤ
    
    ֥åͿȡϼưŪĤޤ

--- Registry.expand_environ(str)
    ((|str|))  (({%\w+%})) Ȥ¤ӤĶѿִޤ
    REG_EXPAND_SZ Ѥޤ
    
    ܺ٤ ((<ExpandEnvironmentStrings|URL:http://msdn.microsoft.com/library/en-us/sysinfo/base/expandenvironmentstrings.asp>)) Win32 API 򻲾ȤƤ

--- Registry.type2name(type)
    쥸ȥͤηʸѴޤ

--- Registry.wtime2time(wtime)
    64bit  ((<FILETIME|URL:http://msdn.microsoft.com/library/en-us/sysinfo/base/filetime_str.asp>))  Time ֥ȤѴޤ

--- Registry.time2wtime(time)
    Time ֥Ȥޤ Integer ֥Ȥꡤ
    64bit  FILETIME Ѵޤ

=== instance methods
--- open(subkey, desired = KEY_READ, opt = REG_OPTION_RESERVED)
    (({((<Win32::Registry.open|Win32::Registry/Registry.open>))(self, subkey, desired, opt)})) ƱǤ

--- create(subkey, desired = KEY_ALL_ACCESS, opt = REG_OPTION_RESERVED)
    (({((<Win32::Registry.create|Win32::Registry/Registry.create>))(self, subkey, desired, opt)})) ƱǤ

--- close
    Ƥ륭Ĥޤ
    
    Ĥ줿Ǥϡ¿Υ᥽åɤ㳰ȯޤ

--- read(name, *rtype)
    쥸ȥ ((|name|)) ɤߡ[ ((|type|)), ((|data|)) ] 
    ֤ޤ
    ((|name|))  nil ξ硤(ɸ) 쥸ȥͤɤ߹ޤޤ
    
    ((|type|)) ϥ쥸ȥͤηǤ(((<Registry::Constants module|Win32::Registry/Registry::Constants module>)))
    ((|data|)) ϥ쥸ȥͤΥǡǡ饹ϰʲ̤Ǥ:
    :REG_SZ, REG_EXPAND_SZ
       String
    :REG_MULTI_SZ
       String 
    :REG_DWORD, REG_DWORD_BIG_ENDIAN, REG_QWORD
       Integer
    :REG_BINARY
       String (Хʥǡޤߤޤ)
    
    ץ ((|rtype|)) ꤵƤ硤쥸ȥͤη
    Ϳ줿 ((|rtype|)) ¸ߤ뤫å졤¸ߤʤ
    ((<TypeError>)) ȯޤ

--- self[name, *rtype]
    쥸ȥ ((|name|)) ɤߡ֤ͤޤ饹
    (({((<read|Win32::Registry/read>))})) ˽सޤ
    
    쥸ȥͤη REG_EXPAND_SZ ä硤Ķѿִޤ
    쥸ȥͤη REG_SZ, REG_EXPAND_SZ, REG_MULTI_SZ, REG_DWORD,
    REG_DWORD_BIG_ENDIAN, REG_QWORD ʳä TypeError ȯޤ
    
    ץ ((|rtype|)) ΰ̣ (({read})) ƱǤ

--- read_s(name)
--- read_i(name)
--- read_bin(name)
    줾 REG_SZ(read_s), REG_DWORD(read_i), REG_BINARY(read_bin)
    Ǥ쥸ȥ ((|name|)) ɤߡ֤ͤޤ
    
    ޥåʤä硤TypeError ȯޤ

--- read_s_expand(name)
     REG_SZ ޤ REG_EXPAND_SZ Ǥ쥸ȥ ((|name|)) ɤߡ
    ֤ͤޤ
    
     REG_EXPAND_SZ ä硤Ķѿִ줿֤ͤޤ
    REG_SZ ޤ REG_EXPAND_SZ ʳä硤TypeError ȯޤ

--- write(name, type, data)
    쥸ȥ ((|name|)) ˷ ((|type|))  ((|data|)) 񤭹ߤޤ
    ((|name|))  nil ξ硤(ɸ) 쥸ȥͤ˽񤭹ߤޤ
    
    ((|type|)) ϥ쥸ȥͤηǤ(((<Registry::Constants module|Win32::Registry/Registry::Constants module>)))
    ((|data|)) Υ饹 (({((<read|Win32::Registry/read>))}))
    ᥽åɤ˽सƤʤФʤޤ

--- self[name, wtype = nil] = value
    쥸ȥ ((|name|))  ((|value|)) 񤭹ߤޤ
    
    ץ ((|wtype|)) ꤷϡηǽ񤭹ߤޤ
    ꤷʤä硤((|value|)) Υ饹˱Ƽηǽ񤭹ߤޤ:
    :Integer
      REG_DWORD
    :String
      REG_SZ
    :Array
      REG_MULTI_SZ

--- write_s(name, value)
--- write_i(name, value)
--- write_bin(name, value)
    쥸ȥ ((|name|))  ((|value|)) 񤭹ߤޤ
    
    쥸ȥͤηϤ줾 REG_SZ(write_s), REG_DWORD(write_i),
    REG_BINARY(write_bin) Ǥ

--- each { |name, type, value| ... }
--- each_value { |name, type, value| ... }
    ĥ쥸ȥͤ󤷤ޤ

--- each_key { |subkey, wtime| ... }
    Υ֥󤷤ޤ
    
    ((|subkey|)) ϥ֥̾ɽ String Ǥ
    ((|wtime|)) Ϻǽɽ FILETIME (64-bit ) Ǥ
    ((({((<Registry.wtime2time|Win32::Registry/Registry.wtime2time>))})))

--- delete(name)
--- delete_value(name)
    쥸ȥ ((|name|)) ޤ
    (ɸ) 쥸ȥͤ뤳ȤϤǤޤ

--- delete_key(name, recursive = false)
    ֥ ((|name|)) ȤΥĤ٤Ƥͤޤ
    
    ((|recursive|))  false ξ硤Υ֥ϥ֥äƤƤϤʤޤ
    true ξ硤ϺƵŪ˺ޤ

--- flush
    ƤΥǡ쥸ȥե˽񤭹ߤޤ

--- created?
    ((**))줿硤֤ޤ
    ((({((<Registry.create|Win32::Registry/Registry.create>))})))

--- opened?
    ޤĤƤʤ硤֤ޤ

--- parent
    ƤΥɽ Win32::Registry ֥Ȥ֤ޤ
    ѥǤ nil ֤ޤ

--- keyname
    (({((<Registry.open|Win32::Registry/Registry.open>))})) ޤ (({((<Registry.create|Win32::Registry/Registry.create>))})) ˻ꤵ줿
    ((|subkey|)) ֤ͤޤ

--- disposition
     disposition ֤ͤޤ
    (REG_CREATED_NEW_KEY ޤ REG_OPENED_EXISTING_KEY)

--- name
--- to_s
    Υեѥ (({'HKEY_CURRENT_USER\SOFTWARE\foo\bar'}))
    Τ褦ʷ֤ޤ

--- info
    ʲ֤ͤޤ:
    :num_keys
      ֥θĿ
    :max_key_length
      ֥̾κĹ
    :num_values
      ͤθĿ
    :max_value_name_length
      ͤ̾κĹ
    :max_value_length
      ͤκĹ
    :descriptor_length
      ƥһҤĹ
    :wtime
      ǽ (FILETIME)
    
    ܺ٤ ((<RegQueryInfoKey|URL:http://msdn.microsoft.com/library/en-us/sysinfo/base/regqueryinfokey.asp>)) Win32 API 򻲾ȤƤ

--- num_keys
--- max_key_length
--- num_values
--- max_value_name_length
--- max_value_length
--- descriptor_length
--- wtime
    θġ֤ͤޤ

=== constants

--- HKEY_CLASSES_ROOT
--- HKEY_CURRENT_USER
--- HKEY_LOCAL_MACHINE
--- HKEY_PERFORMANCE_DATA
--- HKEY_CURRENT_CONFIG
--- HKEY_DYN_DATA
    줾ѥɽ Win32::Registry ֥ȤǤ
    ܺ٤ ((<MSDN Library|URL:httphttp://msdn.microsoft.com/library/en-us/sysinfo/base/predefined_keys.asp>)) 򻲾ȤƤ

== Registry::Constants module

ܺ٤ ((<MSDN Library|URL:http://msdn.microsoft.com/library/en-us/sysinfo/base/registry.asp>)) 򻲾ȤƤ

--- HKEY_*
    ѥ((**)).
     Integer ǡWin32::Registry ֥ȤǤϤޤ

--- REG_*
    쥸ȥͤη

--- KEY_*
    ƥޥ

--- KEY_OPTIONS_*
    ץ

--- REG_CREATED_NEW_KEY
--- REG_OPENED_EXISTING_KEY
    줿¸줿
    (({((<disposition|Win32::Registry/disposition>))})) ᥽åɤ⻲ȤƤ
