#!/bin/sh

# This script invalidates any stale swsusp and Software Suspend 2 images. It
# searches all swap partitions on your machine, as well as Suspend2's
# filewriter files (by way of the hibernate script telling it where to find
# it).
#
# It should be called on boot, after mounting filesystems, but before enabling
# swap or clearing out /var/run. Copy this into /etc/init.d/ (or the appropriate
# place on your system), then add a symlink at the appropriate point on boot.
# On a Debian system, you would do this:
#   update-rc.d hibernate-cleanup.sh start 31 S .
#
# On other SysV-based systems, you would do something like:
#   ln -s ../init.d/hibernate-cleanup.sh /etc/rcS.d/S31hibernate-cleanup.sh
#
### BEGIN INIT INFO
# Provides:          hibernate-cleanup
# Default-Start:     S
# Default-Stop:
# Required-Start:
# Required-Stop:
# Short-Description: invalidates stale swsusp and Software Suspend 2 image
# Description:       This script invalidates any stale swsusp and Software Suspend 2 images. It
#                    searches all swap partitions on your machine, as well as
#                    Suspend2's filewriter files (by way of the hibernate
#                    script telling it where to find it).
### END INIT INFO

HIBERNATE_FILEWRITER_TRAIL="/var/run/suspend2_filewriter_image_exists"

clear_swap() {
	local where wason
	where=$1
	wason=
	swapoff $where 2>/dev/null && wason=yes
	mkswap $where > /dev/null || msg_status " (failed: $?)"
	[ -n "$wason" ] && swapon $where
}

check_swap_sig() {
	local where what type rest p c
	while read  where what type rest ; do
		test "$type" = "swap" || continue
		case "$(dd if=$where bs=1 count=6 skip=4086 2>/dev/null)" in
			S1SUSP|S2SUSP|pmdisk|[zZ]*)
				msg_status "$where"
				clear_swap $where
				msg_status ", "
		esac
	done < /etc/fstab
}

check_filewriter_sig() {
	local target
	[ -f "$HIBERNATE_FILEWRITER_TRAIL" ] || return 0
	read target < $HIBERNATE_FILEWRITER_TRAIL
	[ -f "$target" ] || return
	case "`dd \"if=$target\" bs=8 count=1 2>/dev/null`" in
		HaveImag)
			/bin/echo -ne "Suspend2\n\0\0" | dd "of=$target" bs=11 count=1 conv=notrunc 2>/dev/null
			msg_status -n "$target, "
			rm -f $HIBERNATE_FILEWRITER_TRAIL
	esac
}

do_start() {
	check_swap_sig
	check_filewriter_sig
}

do_stop() {
	:
}

do_reload() {
	:
}














msg_status() {
	echo -n "$1"
}

msg() {
	echo "$1"
}

case "$1" in
start)
	msg_status "Invalidating stale software suspend images... "
	do_start
	msg "done."
	;;
stop)
	do_stop
	;;
restart|force-reload)
	do_reload
	;;
*)
	msg "Usage: /etc/init.d/hibernate {start|stop|restart|force-reload}"
esac

exit 0
