#!/bin/bash
# mecab-ipadic	(http://mecab.sourceforge.net/)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-07-16
# require:
#	MeCab
#
SRC_URI=http://downloads.sourceforge.net/mecab/mecab-ipadic-2.7.0-20070801.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}
VERDATE=${PAC_NAME##*-}
PLX_NAME=${PAC_NAME%%-$VERDATE}
echo $PLX_NAME


REL=P1
CPU=noname
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/text
PAC_DIR=$PLAMO/Packages/4.5/Text
BUILD_DIR=$PLAMO/mecab
CUSTOM_DIR=$BUILD_DIR/Custom

#PAT_FILE=$CUSTOM_DIR/e.patch
PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME || exit 1
if [ -f "$PAT_FILE" ]; then
  patch < $PAT_FILE
fi
./configure --prefix=/usr --with-charset=utf8
make
/usr/libexec/mecab/mecab-dict-index -f euc-jp -t utf-8
make install DESTDIR=$WORK

touch $WORK/install/doinst.sh

DOC_DIR=usr/share/doc/$PLX_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
      AUTHORS NEWS README INSTALL COPYING \
    $WORK/$DOC_DIR
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX,go-w $WORK/$DOC_DIR/


mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=1 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/$TYP.$PLX_NAME.list <<__EOCL__
TYP	$TYP
NAM	${PLX_NAME}
URL	http://mecab.sourceforge.net/
DOC	/usr/share/doc/$PLX_NAME
REM	MeCabѤIPA
__EOCL__


cd $WORK
echo "y
1
" | makepkg ${PLX_NAME}.tgz


echo -n "$PAC_DIR/${PLX_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PLX_NAME}.tgz  $PAC_DIR/${PLX_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD

