#! /usr/bin/perl
# Authors : Roland SEUHS <roland@wertkarten.net> 
#         Dominique CARON <domi@lpm.univ-montp2.fr> 
# GPL License 
# TODO
# Multiple audio stream
# Movie Title detecting
#
#
# ChangeLog:
#
# Release 0.4.0
# runclust is now include in the perlscript vob2divx.pl ( Do not need the shell script runclust anymore)
# Adding the SubTitle transcode Feature
# Detecting the transcode release ( For the -B option)
# Detecting the Vob Audio format (ac3 or mp3) and warning the user if it is mp3 (lame needed)
#
# Release 0.5.0
# Corrected a bug which do not allow to run vob2divx /path/to/vobs filesize
# Corrected a Bug about audiobitrate in cluster mode
# Added rip feature
# Some minor modifications in the usage message
#
# Release 0.5.1
# Corrected bugs in extsub and rip 
# Modify the incrementation of -B option when transcode release > 0.6.pre3
# Modify the detection of the main DVD title to rip ( thank to Christian Vogelgsang) and use the -T tccat option not the -P
#
#  Release 0.6.0
# Transcode before 0.6pre4 no more supported
# Some bugs fix
# Autofind the best zooming in -B or -Z mode (thank to Vogelgsang)
# Best finding the main title in rip mode (thank to Vogelgsang)
#
# Release 0.6.1
# Autodetect if deinterlacing is needed
# Autodetect if there is a multiangle video stream and exit with WARNING if yes
#
# Release 0.7.0
# It'now possible to encode multi sequence units vob files in clustermode.
#
# Release 0.7.1
# Detecting if Slow zooming is necessary.
# 
# Release 0.7.2
# Bug in Fast Zooming Image size detection corrected

use POSIX;
#
#			Choose your preferred encoder
#$DIVX=divx4;           
#$DIVX=divx5;           
$DIVX=xvid;	       

#		Image Viewer
# WARNING !!! If you modify this (for example display from ImageMagick), modify also options at line 108  (more or less ;-)
$XV=xv;   

#     		Vobs Player
$XINE=xine; # You may modify your vob Viewer (mplayer for example)

# 		DivX Player
$AVIPLAY=aviplay; # You may modify your DivX4 Viewer (mplayer) 
#

#		Cluster config if you intend to use cluster mode
$CLUSTER_CONFIG="/home/magenta/domi/etc/cluster";  # YOU MUST MODIFY THIS LINE !!!

# 		remote command if you intend to use cluster mode
$RMCMD=ssh   ; 			# change this to ssh if you need


#################END USER CONFIG##################################

#   DO NOT TOUCH AFTER HERE UNLESS YOU KNOW WHAT YOU ARE DOING !!!!! 
$release="0.7.2";
$PGMFINDCLIP=pgmfindclip; # New tool of transcode
system("clear");
$RED="\033[1;31m";
$GREEN="\033[0;32m";
$NORM="\033[0;39m";

#    Found the transcode release (for the -B option)
$tr_vers=`transcode -v 2>&1 | awk '{print \$2}'| sed s/^v// `;
@vers = split /pre/,$tr_vers;
@vers_nodate = split /-/,$vers[1];
chomp($vers_nodate[0]);
@Vers = split /\./,$vers[0];
if ( $Vers[1] < 6 )
{	 $tr_vers=0 ;
	$clust_percent="";
	print $RED;
	print "This vob2divx perl script does not support your transcode release\n Please upgrade to the lastest transcode release (0.6pre4 at least)\n";
	print $NORM;
	exit(1);
}
elsif ( $vers_nodate[0] < 4 )
{ 	$tr_vers=0 ; 
	$clust_percent=""; 
	print $RED;
        print "This vob2divx perl script does not support your transcode release\n Please upgrade to the lastest transcode release (0.6pre4 at least)\n";
        print $NORM;
        exit(1);}
else 
{ 	$tr_vers=N; 
	$clust_percent="--cluster_percentage";
}
print " Transcode detected release = ".$Vers[0].".".$Vers[1].".".$Vers[2]."pre".$vers_nodate[0]."\n";

foreach $pgm ( $XV , $XINE , $AVIPLAY ) 
{
	if ( system("which ".$pgm." > /dev/null ") )
	{ 
		print "".$pgm." is not installed on this System :-( \n Modify the vob2divx perl script to reach your configuration (DVD player, DivX player, Image viewer) \n"; exit (0);
	}
}

$XV="xv -maxpect"; # display option is -geometry <width_display>x<height_display>
$PGMF=system("which ".$PGMFINDCLIP." > /dev/null >& /dev/null");
if ( $PGMF == 0  ) { $PGMFINDCLIP=OK }
# system("clear");


$warnclust = 
" ".$RED."***********  WARNING ABOUT CLUSTER MODE *************".$NORM."
If you want to use a cluster :
a) The /path/to/vobs directory must be NFS mounted on each node
and have the same name.
b) You must have rsh or ssh permission on each node,
( modify the  perl vob2divx script to select rsh or ssh ).
c) You need to have a ".$RED.$CLUSTER_CONFIG.$NORM." file (change this value in the perl vob2divx script) on the node you run vob2divx on.
This file must contain all the nodenames of your cluster:the percentage of frames to encode by each node.
Syntax of this file:
# This is a Comment
asterix:25   #  Duron 333 Mhz
obelix:5  # 486 66Mhz
vercingetorix:70 # Thunderbird 1.2 Ghz
".$RED."Of course the total of percentage frames to encode MUST be 100".$NORM."
\n\n";

$usage =
$RED."            *****  Warning  *****".$NORM."
Please note that you are only allowed to use this program according to fair-use
laws which vary from country to country. You are not allowed to
redistribute copyrighted material. Also note that you have to use this software
at your own risk.
 
------------------------------------------------------
You may want first rip vob files from a DVD :
then use:

% vob2divx /path/to/vobs rip
(where /path/to/vobs is the directory where vob files will be ripped)
\n\n
---------------------------------------------------

NB: ".$RED." transcode will encode your movie in ".$DIVX." format , to change this, edit the vob2divx script and change the $DIVX variable. ".$NORM."

There are 2 ways of using this program to encode your vob file(s):

1: Easy
-----------

% vob2divx /path/to/vobs 700
(where 700 is the desired filesize in Megabytes, and /path/to/vobs the directory where are the unencrypted vob files)

2: Better
----------

% vob2divx /path/to/vobs sample
This will ask all what it need to make the better movie ;-)
( /path/to/vobs is the directory where are the unencrypted vob files)

------------

You can interrupt the program anytime. To continue encoding, just run the script
without parameters in the same directory.
\n\n
";
$last_sec=0;
$audio_bitrate = 0 ;
$nice = 10;
$keyframes = 1000;
$sample = "";
$audiosample_length = 1000;
$videosample_length = 100;
$create_timeout = 2;
$timeout = 600;
$long_timeout = 20;
$as=0;   # default audio stream to encode
# You may Modify the Next value but take care
# it's use to estimate the image size of the encoded clip
$quality_ratio=0.2;   # This value =  bitrate x 1000 / ( fps x height x width ) 


#  Functions Declarations
sub audioformat;
sub create_nav;
sub create_extract;
sub calculate_nbrframe;
sub calculate_bitrate;
sub aviencode;
sub a_bitrate;
sub sub_continue;
sub get_params;
sub make_sample;
sub cluster;
sub merge;
sub ask_filesize;

#		ASK if Cluster is used 
sub ask_clust
{   print "--->  Enter ask_clust\n";

system("/bin/rm tmp/cluster.args 2&> /dev/null");
print ($warnclust);
print $GREEN;
print("\n Do you want to use a cluster ? [y/n] : ");
print $NORM;
$CLUSTER=<STDIN>;
chomp($CLUSTER);
if ( $CLUSTER eq "y" || $CLUSTER eq "Y" || $CLUSTER eq "o" || $CLUSTER eq "0")
{	
	if ( ! -e "tmp/filenav-ok")
	{	create_nav;
	}
	$strF=`tail -1 tmp/file.nav | awk '{print \$1}'`;
	chomp($strF);
	if ( $strF > 0 )  # Take care there are several sequence units !!
	{       
	    $display=$strF + 1;
	    print $RED; print "\n*********** WARNING !!!!************\n there is ".$display." Video stream sequence units in the Vob file(s)\n";
	    print $NORM;
	}
	open(CLUSTERMODE,">tmp/clustermode");
	print CLUSTERMODE $strF;
	close(CLUSTERMODE);

}else
{	open(CLUSTERMODE,">tmp/clustermode");
	print CLUSTERMODE NO;
	close(CLUSTERMODE);
}
# End sub ask_clust
}



#********** Cluster MODE ************
sub cluster
{ print "--->  Enter cluster\n";
system("/bin/rm -f tmp/merge.make tmp/sync.make 2>&1 > /dev/null");
$wdir=`pwd`;
chomp($wdir);
if ( ! -e $CLUSTER_CONFIG )
{	print $warnclust;
	print $NORM; 
	exit(1);
}
open(GOODNODE,">/tmp/node");
$NODE=`grep -v "^[[:space:]]*#" $CLUSTER_CONFIG | grep -v '^[[:space:]]*$$' | wc -l`;
print "Number of Nodes : ".$NODE;	
if ( $NODE != 0 )
{
	$poweroff=0;
	$poweron=0;
	$localhost=`hostname`;
	chomp($localhost);
	@allnodes=`grep -v "^[[:space:]]*#" $CLUSTER_CONFIG | grep -v '^[[:space:]]*$$'| awk -F"#" '{print \$1}'`;
	foreach $node  ( @allnodes )	
	{
		@chost=split /:/, $node;
		$rhost=@chost[0];
		if ( $rhost ne "$localhost" )
		{	$rs=system($RMCMD." ".$rhost." whoami 2>&1 > /dev/null ");
			if ( $rs != 0 )
			{
				print $RED ;
				$NODE = $NODE - 1;
				print "Node ".$rhost." unreachable ...\n";
				$P=@chost[1];
				chomp($P);
				$poweroff = $poweroff + $P;
				print " Need to calculate ".$poweroff." % of frames on other node(s)";
				if ( $poweroff >= 100 )
				{	last;
				}
				print $NORM; 
			}else{
			$P=@chost[1];
			chomp($P);
			print GOODNODE $rhost.":".$P."\n";
			$poweron = $poweron + $P;
			}
		}else{
			$P=@chost[1];
			chomp($P);
#			print "Host : ".@chost[0]." , Pow = ".$P."\n";
			print GOODNODE $rhost.":".$P."\n";
                        $poweron = $poweron + $P;
		}
	}
	$ addpower = $poweroff / $NODE;
	close(GOODNODE);
}else{
	system("/bin/rm /tmp/node");
}
if ( -e "/tmp/node" )
{	
	$tabpower="";
	$sumpow=0;
	$max=0;	
	$i=0;
	@allnodes=`cat /tmp/node`;
	system("/bin/rm /tmp/node");
	foreach $node (@allnodes )     
        { 
                @chost=split /:/, $node; 
                $rhost=@chost[0];
		if ( $sumpow < 100 )
		{	$pow=@chost[1];
			$pow=$pow + $addpower;
			$max=$sumpow + $pow;
			if ( $max > 100 )
			{	$pow = 100 - $sumpow;
			}
			open(CLUSTERARGS,">tmp/cluster.args");
			print CLUSTERARGS $sumpow.",".$pow."\n";
			close(CLUSTERARGS);
			print $GREEN; 
			print "Encoding on node ".$rhost."  with -W ".$sumpow.",".$pow."\n";
			print $NORM; 
			if ( $rhost ne "$localhost" ) 
                	{ 	system ("xterm -n ".rhost." -e ".$RMCMD." ".$rhost." vob2divx runclust ".$wdir." &");
			}else{

				system ("xterm -n ".$rhost." -e vob2divx runclust ".$wdir." &");
			}
		@tabpower[$i]=$sumpow;
		$i++;
		$sumpow= $sumpow + $pow;
		sleep (7);
		}
	}
	if  ( $sumpow <  100 )
	{
		$pow = 100 - $sumpow;
		open(CLUSTERARGS,">tmp/cluster.args");
		print  CLUSTERARGS $sumpow.",".$pow."\n";
		close(CLUSTERARGS);
		print $GREEN; 
		print "Encoding on localnode with -W ".$sumpow.",".$pow." to finish...";
		print $NORM;
		system ("xterm -e vob2divx runclust ".$wdir." &");
		@tabpower[$i]=$sumpow;
		sleep(3);
	}
	print "Wait for nodes finish ....\n";
	foreach $endnode ( @tabpower )
	{	while ( ! -e "tmp/2-AVI".$endnode."_0.finish" ) {print "."; sleep(20);}
		print "Node ".$endnode." has finished to encode\n";
	}	
	print $GREEN;
	print "Now We merge Video files and Audio MP3\n";
	system("touch tmp/merge.make tmp/sync.make");
	print $NORM;
	merge;
	system("/bin/rm tmp/cluster.args");
} else {
	print " Nothing to do :-( ";
}
exit(0);
# End cluster Sub routine
}


#  ******************** Create Nav File (For cluster) ********************

sub create_nav
{
	 print("Using Cluster : creating tmp/file.nav\n");
	print("cat ".$vobpath."/*.vob | tcdemux -W > tmp/file.nav\n");
	system("cat ".$vobpath."/*.[Vv][Oo][Bb] | tcdemux -W > tmp/file.nav") == 0 && system("touch tmp/filenav-ok");
	 if ( ! -e "tmp/filenav-ok"){ exit(0) };
}


# ***********************Create extract info (to calculate bitrate) *******

sub create_extract
{	print "--->  Enter create_extract\n";
	audioformat("-a ".$as);	
	print("creating tmp/extract.text\n");
	print("This will take a little while....\n");
	$sys = " nice -".$nice." cat ".$vobpath."/*.[Vv][Oo][Bb] | nice -".$nice." tcextract -x ".$audio_format." -t vob | nice -".$nice." tcdecode -x ".$audio_format." | nice -".$nice." tcscan -b ".$audio_bitrate." -x pcm 2>> tmp/extract.text  >> tmp/extract.text";
	print ($sys."\n");
	system ("nice -".$nice." ".$sys) == 0 && system("touch tmp/extract-ok");
	if ( ! -e "tmp/extract-ok"){ exit(0) };
# Next Line may be not Needed ...
#	$tmp = `cat tmp/extract.text | grep "A:" | grep MB`;
}

# **********************Calculate How many Frames to encode ******************

sub calculate_nbrframe
{
#	We need Info about Clip
	if (! -e "tmp/extract-ok" ||  ! -e "tmp/extract.text")
        { create_extract;
        }		

    $info = `cat tmp/extract.text`;
	if (! ( $info =~ m,V: (\d+) frames,))
	{       print $RED;
                print "Error: Unable to find number of frames\n";
                print $NORM;
                exit(1);
        }
	$tot_frames = $1;
	
    	if ( -e "tmp/endtime.conf" )
    	{ 	$last_sec = `cat tmp/endtime.conf`;
    	}

   	if (! ( $info =~ m,sec @ (\d+\.\d+) fps,))
        {       print $RED;
                print "Error: Unable to find number of FPS\n";
                print $NORM;
                exit(1);
        }
        $FPS=$1;

    	$nbr_frames= $tot_frames - $last_sec*$FPS;
    	if ( $CLUSTER eq NO  )
    	{
    		print ("Number of frames to encode : ".$nbr_frames.", @ ".$FPS." frames per/sec\n");	
    	}
}

# ********** Calculate Bitrate ****************

sub calculate_bitrate
{	print "--->  Enter calculate_bitrate\n";

# We need Audio Bitrate
	 if ( ! -e "tmp/audio_bitrate.conf")
       	 {	a_bitrate;
	 }else{
		$audio_bitrate=`cat tmp/audio_bitrate.conf`;
                chomp($audio_bitrate);
        }

# And Also Info about Clip
	if (! -e "tmp/extract-ok" ||  ! -e "tmp/extract.text")
	{ create_extract;
	}	
	
	$info = `cat tmp/extract.text `;
	if (! ( $info =~ m,frames\, (\d+) sec @ ,))
	{       print $RED;
                print "Error: Unable to find Video Runtime\n";
		print $NORM;
                exit(1);
        }
	$fulltime=$1;
        $runtime=$fulltime - $last_sec;

    	if ( $CLUSTER eq NO  )
	{	print("Runtime to encode : ".$runtime." sec.\n");
	}

	if (! ( $info =~ m, A: (\d+\.*\d+) MB @ ,))
	{
		print $RED;
                print "Error: Unable to find Audio Size\n";
		print $NORM;
                exit(1);
        }
	$audio_size = $1*$runtime/$fulltime;

	if ($CLUSTER eq NO)
        {
	printf("Audio_size: %.2f Mb @ ".$audio_bitrate." Kb/s\n",$audio_size);
	}
	if ( ! -e "tmp/filesize.conf" )
        {        ask_filesize;
        }else{
                $filesize = `cat tmp/filesize.conf`;
                chomp ($filesize);
        }

	$bitrate = floor(($filesize - $audio_size)/$runtime * 1024 * 1024 * 8 / 1000);
	if ($bitrate < 20)
	{	
		print("\n#### ATTENTION ####\n\tCalculated bitrate is ".$bitrate." kbps, \nwhich does not make much sense, I'll use 700 kbps instead. \nFilesize will not match your preferred filesize. Sorry");
		$bitrate = 700;
	}
	if (! ( $info =~ m,suggested volume rescale=(\d+.*\d+),))
	{
		print $RED;
                print "Error: Unable to find Suggested volume rescale\n";
		print $NORM;
                exit(1);
        }
	if ( $1  > 1)
	{      
                $audio_rescale = $1;
        } else
        {       $audio_rescale = 1;
        }

	if ($CLUSTER eq NO )
        {
		print ("Audio rescale: ".$audio_rescale."\n");
		system ("echo ".$audio_rescale." > tmp/audio_rescale.conf");
		print ("Bitrate: ".$bitrate." Kb/s \n");
		system ("echo ".$bitrate." > tmp/bitrate.conf");
		$videosize=$bitrate*1000*$runtime/(1024*1024*8);
		printf("Video Size: %.2f Mb\n",$videosize);
		$totalsize=$videosize+$audio_size;
		printf("Total Size estimated : %.2f Mb\n",$totalsize);
	}

} # END calculate_bitrate

# ********** Main Avi encode ***************

sub aviencode
{       	print "--->  Enter aviencode\n";
	a_bitrate;
	if (! -e "tmp/extract-ok")
	{	create_extract;
	}
	calculate_nbrframe;
  	calculate_bitrate;

	$CLUSTER=`cat tmp/clustermode`;
	if ( $CLUSTER ne "NO" && ! -e "tmp/cluster.args")
	{	cluster;
	}

	if (  $CLUSTER ne "NO" )
	{ 	$cluster=`cat tmp/cluster.args`;
		chomp($cluster);
		$cluster="-W ".$cluster.",tmp/file.nav";
		$node=`cat tmp/cluster.args| awk -F, '{print \$1}'`;
		chomp($node);
		$params=$params." ".$cluster;
		chomp($CLUSTER);
		$sequnit=$CLUSTER;
	}else{
		$cluster="";
		$node="";
		$params=$params." -c 0-".$nbr_frames."";
		$sequnit=0;
	}

#-c is not good in clustermode	$params=$params." ".$cluster." -c 0-".$nbr_frames."";

	$tmp = `ls -1 $vobpath | grep ".[Vv][Oo][Bb]"  `;
	if (  $CLUSTER ne "NO" )
 	{	print("***  Cluster Mode ON ===>  NODE number : ".$node." ******* \n");
		print("*** SEQ UNIT = ".$sequnit." ********\n");
	}


	system("rm tmp/*.done  2&> /dev/null");
	
	for ( $i=$sequnit; $i >= 0 ; $i--  )
    	{      
# WE NEED the next 4 lines  because in non cluster mode we do not have the $sequnit value, 
# And WE want encode all the sequences unit (so, no -S option) .
		if ( $sequnit != 0 )
                {       $seqopt="-S ".$i.",all";
                }else
		{       $seqopt="";
		    }
		if (! -e "tmp/1-AVI".$node."_".$i.".finish")
		{
			system("rm tmp/merge.finish 2&> /dev/null");
			print("Encode: ".$vobpath." Pass One ....\n");
                	my $pid = fork();
                	die "couldn't fork\n" unless defined $pid;
                	if ($pid)
                	{       while(! -e  "tmp/1-AVI".$node."_".$i.".done")
                        	{       sleep $long_timeout;
                        	}
                        	system("touch tmp/1-AVI".$node."_".$i.".finish");
                 	} else
                 	{	
				$sys = "transcode -i ".$vobpath."/ ".$seqopt." ".$clust_percent." ".$params." -s ".$audio_rescale." -w ".$bitrate.",".$keyframes." -x vob -y ".$DIVX.",null -V  -R 1,".$DIVX."AVI".$node."_".$i.".log -o /dev/null";
                		print($sys."\n");
				system("nice -".$nice." ".$sys) == 0 && system("touch tmp/1-AVI".$node."_".$i.".done");
				exit(0);
			}
		} else
		{	print("AVI".$node."_".$i." already encoded, remove \"tmp/1-AVI".$node."_".$i.".finish\" to reencode \n");
		}

		if (! -e "tmp/2-AVI".$node."_".$i.".finish")
		{	system("rm tmp/merge.finish 2&> /dev/null");	
			print("Encode: ".$vobpath." Pass two ....\n");
               	         my $pid = fork();
                 	 die "couldn't fork\n" unless defined $pid;
                       	if ($pid)
                       	{       while(! -e  "tmp/2-AVI".$node."_".$i.".done")
                               	{       sleep $long_timeout;
				}
                               	system("touch tmp/2-AVI".$node."_".$i.".finish");
                       	} else
                       	{	
				$sys = "transcode -i ".$vobpath."/ ".$seqopt." ".$clust_percent." ".$params." -s ".$audio_rescale." -w ".$bitrate.",".$keyframes." -b ".$audio_bitrate." -x vob -y ".$DIVX." -V -R 2,".$DIVX."AVI".$node."_".$i.".log -o tmp/2-AVI".$node."_".$i.".avi";
                             	print($sys."\n");
                               	system("nice -".$nice." ".$sys) == 0 && system("touch tmp/2-AVI".$node."_".$i.".done");
                                 exit(0);
			}
		} else
		{	print("AVI".$node."_".$i." already encoded, remove \"tmp/2-AVI".$node."_".$i.".finish\" to reencode \n");
		}
	} # end boucle for
	if ( $CLUSTER ne "NO")
        {       print ("Finished ... Wait \n ");
                sleep (3);
        }
	if ( $CLUSTER eq NO ) { system(" touch tmp/merge.make");}
} # END Aviencode

#			********* MERGING (and Syncing) Function **************
sub merge
{	print "--->  Enter merge\n";
	if (! -e "tmp/merge.finish" &&  -e "tmp/merge.make")
	{       
		my $pid = fork();
		die "couldn't fork\n" unless defined $pid;
		if ($pid)
		{	while(! -e  "tmp/merge.done")
			{	sleep $long_timeout;
			}
			system("touch tmp/merge.finish");
		} else
# $CLUSTER  is known because we've pass through aviencode before
		{	if ( $CLUSTER ne "NO" )
			{	for ( $i=$CLUSTER ; $i >= 0 ; $i-- )
				{ 	$sys = "avimerge -i tmp/2-*_".$i.".avi -o tmp/tmp_movie_".$i.".avi";
				}
			}else{
			      $sys="mv tmp/2-AVI_0.avi Movie.avi";
			}
			print($sys."\n");
			system("nice -".$nice." ".$sys);
			system("touch tmp/merge.done");
			exit(0);
		}
	}
	if (! -e "tmp/sync.finish" &&  $CLUSTER ne "NO" &&  -e "tmp/sync.make")
	{
		my $pid = fork();
                die "couldn't fork\n" unless defined $pid;
                if ($pid)
                {       while(! -e  "tmp/sync.done")
                        {       sleep $long_timeout;
                        }
                        system("touch tmp/sync.finish");
                } else
                {
			$tmp = `cat tmp/params.conf`;
			@tmp = split /-j/,$tmp;
			$audio_params=@tmp[0];
			print "AudioParams : ".$audio_bitrate."\n";
			for ( $i=$CLUSTER; $i >= 0 ; $i--)
			{
		 		$sys = "transcode -p ".$vobpath." -W 100,100,tmp/file.nav ".$audio_params." -S ".$i.",all -b ".$audio_bitrate." -s ".$audio_rescale." -i tmp/tmp_movie_".$i.".avi -P 1 -x avi,vob -y raw -o tmp/Movie_".$i.".avi -u 50"; print($sys."\n");
                       	system("nice -".$nice." ".$sys);
			}
			system ("avimerge -i tmp/Movie_*.avi -o Movie.avi");
			system("touch tmp/sync.done");
			exit(0);
		}
	}
# TODO add another audio stream:
#  transcode -i (...) -x null,amod -g 0x0 -y raw -a 1 -o add-on.avi -u 50
#   avimerge -i movie.avi -o dualaudiomovie.avi -p add-on.avi  
print "Bye !!!\n";
}


#  *************   Get Audio Bitrage ************

sub a_bitrate
{       print "--->  Enter Audio_bitrate\n";
	if ( ! -e "tmp/audio_bitrate.conf")
        {  
                while ( $audio_bitrate ne 32 && $audio_bitrate ne 48 && $audio_bitrate ne 64 && $audio_bitrate ne 96 && $audio_bitrate ne 128 && $audio_bitrate ne 256 )
                {
			print $GREEN;
                        print("\n By default the MP3 Audio output bitrate is set to 96kbs, enter another value to change this : ");
			print $NORM;
                        $audio_bitrate=<STDIN>;
                        chomp($audio_bitrate);
                        if ( $audio_bitrate eq "" )
                        {
                        $audio_bitrate=96;
			last;
                        }
                }
		open(ABR,">tmp/audio_bitrate.conf");
		print ABR $audio_bitrate;
		close(ABR);
        }else{
                $audio_bitrate=`cat tmp/audio_bitrate.conf`;
		chomp($audio_bitrate);
        }
	print "<--- Audio_bitrate\n";
}

# *************   Restore parameters to continue ********
sub sub_continue
{ 	print "--->  Enter sub_continue\n";
if (-e "tmp/vobpath.conf" && -e "tmp/filesize.conf" && -e "tmp/params.conf")
{       $vobpath = `cat tmp/vobpath.conf`;
        chomp($vobpath);
        if (! -d $vobpath)
        {       print("Path: ".$vobpath." does not exist.\n");
                exit(1);
         }
	if ( ! -e "tmp/filesize.conf" ) 
	{	 ask_filesize;
	}else{
         	$filesize = `cat tmp/filesize.conf`;
         	chomp ($filesize);
	}
         $params = `cat tmp/params.conf`;
         chomp ($params);
} else
{        print($usage);
         exit(1);
}
if ( ! -e "tmp/clustermode" )
{	ask_clust;
}
$CLUSTER=`cat tmp/clustermode`;
if (  $CLUSTER eq NO  )
{
         print("Path to VOBs: ".$vobpath."\n");
         print("Preferred Filesize: ".$filesize."\n");
        print("Additional Parameters: ".$params."\n");
}
	print "<---- sub_continue\n";
}

# ********************* Get Needed parameters ************
sub get_params
{  	print "--->  Enter get_params\n";
	$i = 0;
        if ( -e $ARGV[$i])
        {       $vobpath = $ARGV[$i];
                $i ++;
        } else
        {       if ( ! -e "tmp/vobpath.conf")
                {       print $RED;
			print("Please supply path to find vobfiles\n");
			print $NORM;
                        exit(1);
                } else
                {       $vobpath = `cat tmp/vobpath.conf`;
                        chomp($vobpath);
                        if (! -e $vobpath)
                        {       print $RED;
				print("Path: ".$vobpath." does not exist.\n");
				print $NORM;
                                exit(1);
                        }
                }
        }
        if ($ARGV[$i] > 1)
        {       $filesize = $ARGV[$i];
                $i++;
        } else  
	{
               if (-e "tmp/filesize.conf")
                {       $filesize = `cat tmp/filesize.conf`;
                        chomp($filesize);
                } else
                {       print("Please supply filesize \n\t or \"sample\" if you want to create samples for cropping.\n\n");
                        exit(1);
                }
        }
        while(defined($ARGV[$i]))
        {       @tmp = split /\./, $ARGV[$i];
                $t = $tmp[1];
                $t =~ tr [_] [ ];
                $params .= $t;
                $i++;
        }

	a_bitrate;

	if ( ! -e "tmp/clustermode" )
	{       ask_clust;
	}
	$CLUSTER=`cat tmp/clustermode`;
	if ( $CLUSTER eq NO  )
	{	open(VOBPATH,">tmp/vobpath.conf");
		open(FILESIZE,">tmp/filesize.conf");
		open(PARAMS,">tmp/params.conf");
                print("Path to VOBs: ".$vobpath."\n");
		print VOBPATH $vobpath;
                print("Preferred Filesize: ".$filesize."\n");
		print FILESIZE $filesize;
                print("Additional Parameters: ".$params."\n");
		print PARAMS $params;
		close(VOBPATH);
		close(FILESIZE);
		close(PARAMS);
        }
	print "<--- sub get_params\n";


}
###################### Audio Input format ###################
sub audioformat
{
	print "---> Enter audioformat\n";
	if (! defined(@_[0]))
        {       @_[0] = "-a 0 ";
        }
	 if ( ! -e "tmp/audioformat" )
        {
	$audio_format=`transcode -i $vobpath/$sample @_[0] -w 100,100 -c 0-20 -o /dev/null 2>&1 | grep decode_mp3`;
                if ( $audio_format eq "" )
                {       $audio_format=ac3;
                }else
                {
                        $audio_format=mp3;
                        print $RED;
                        print("\n *******   WARNING !! *************\n You need transcode compile with lame to encode this Vob file(s)\n\n");
                        print $NORM;
                }
                open(AUDIOFORMAT,">tmp/audioformat");
                print AUDIOFORMAT $audio_format;
                close(AUDIOFORMAT);
	}else
	{ 	$audio_format=`cat tmp/audioformat`;
	}
	
}

#******************* Make Audio sample **************
sub make_sample
{
	#print @_[0];
	if (! defined(@_[2]))
	{	@_[2] = 100;
	}
	$prefix = @_[1];
	$sys = "transcode -i ".$vobpath."/".$sample." ".@_[0]." -w 100,".@_[2]." -c 0-".@_[2]." -o ".$prefix.".avi 2&> /dev/null";
	print ($sys."\n");
	system ("nice -".$nice." ".$sys);
	audioformat;
}

sub ask_filesize
{
		print $GREEN;
                print("\n Now Enter the maximal avifile size (in MB) : ");
                print $NORM;
                $filesize=<STDIN>;
                chomp($filesize);
                open(FILESIZE,">tmp/filesize.conf");
                print FILESIZE $filesize;
                close(FILESIZE);
}



# ********************** Main() ****************************

mkdir ("tmp",0777);

sub config
{       print "--->  Enter config\n";
	$vobpath = $ARGV[0];
	if ( ! -e $vobpath )
	{ 	print STDOUT "Directory \"".$vobpath."\" does not exist \n Sorry \n";
		exit(1);
	}
	$tmp = `ls -1 $vobpath | grep ".[Vv][Oo][Bb]"`;
	@dateien = split /\n/, $tmp;
	$i = 0;
	open(VOBPATH,">tmp/vobpath.conf");
	print VOBPATH $vobpath;
	close(VOBPATH);
#	system("/bin/rm -f tmp/filenav-ok");
	foreach $datei (@dateien)
	{	$i++;
		print ("File ".$i.": ".$datei."\n");
	}
	$sample = $dateien[floor($i / 2)];
	$lastvob = $dateien[$i-1];
	$anzahl = $i;
	$good_audio="audio_sample._-a_?_.000.avi";
	$good_video="video_s._-j_?,?_-[ZB]_?[x?].avi";
	$samples_look_like_crap = "Please note that these samples are exclusively to find the right
	cropping parameters (video_sample.*) and audio track (audio_sample.*)\n\n";

	print ("-> Using \"".$sample."\" to create low quality samples ".$samples_look_like_crap);
	print $GREEN; 
	print ("\n Have a Look with ".$XINE." on the Vob File ".$lastvob." to get the aspect\n Look also how long is the movie after the END (so we can remove the end generic)\n You may also decide the audio stream number and the subtitle number if you want it\n");
	print $NORM;
	print ("Press Enter -> ");
	$junk=<STDIN>;
	system ("".$XINE." ".$vobpath."/".$lastvob."; clear");
#
# How many second remove from end of movie...
	print $GREEN;
	print (" How long in seconds is the end generic (so transcode will not encode this to have better bitrate) ? " );
	print $NORM;
        $last_sec=<STDIN>;
        chomp($last_sec);
        if ( $last_sec eq "" || $last_sec < 10 )
	{	 $last_sec=0;
	}
		open(LASTSEC,">tmp/endtime.conf");
		print LASTSEC $last_sec;
		close LASTSEC;
#		system("echo ".$last_sec." > tmp/endtime.conf");

#
#############################SOUND SAMPLE###########################################
	$as=10;
	print $GREEN;
        print STDOUT "Do you want to make Sound samples ?(Y/N) ";
        print $NORM;
        $rep=<STDIN>;
        chomp($rep);
	if ( $rep ne "o" &&  $rep ne "O" && $rep ne "y" && $rep ne "Y" )
	{
	    while ( $as >= 10 )
	    {       
		print $GREEN;
		print STDOUT "By default audio stream 0 is encoded. If you want another, enter audio stream number ( MAX = 9 ) : ";
		print $NORM;
		$as=<STDIN>;
		chomp($as);
		if ( $as eq "" ) 
		{ 
		    $as = 0 ;
		}
	    }
                $good_audio="audio_sample._-a_".$as.".avi";
		system("touch audio_sample._-a_".$as.".avi");
        }else
	{
	    for ($i = 0; $i <= 6; $i ++)
	    {
		 make_sample("-x vob -y ".$DIVX." -V -a ".$i." ", "audio_sample._-a_".$i."_", $audiosample_length);
		 print STDOUT "Ear this audio sample, please\n";
		 print "Press Enter ->";
		 $junk=<STDIN>;
		 system("".$AVIPLAY." audio_sample._-a_".$i."_.avi");
		 print STDOUT "Was the Sound Good ?(Y/N) : ";
		 $rep= <STDIN>;
		 chomp($rep);
		 if ($rep eq "O" or $rep eq "o" or $rep eq "y" or $rep eq "Y")
		 {	
		     print $GREEN;
		     print STDOUT "Fine  \n";
		     print $NORM;
		     $good_audio="audio_sample._-a_".$i."_.avi";
		     $as=$i;
		     last;
		 }
		 else
		 {
		     system("rm audio_sample._-a_".$i."_.avi");
		 }
	     }
	}
####################################### CROPPING TOP/BOTTOM ################################"
	print $GREEN;
	print STDOUT "Clipping Top/Bottom \n You must have the smallest black LetterBox at top/bottom \n (It's better to leave black LetterBox at top/bottom if you intend to have SubTitle)\n";
	print $NORM; 
	if ( $PGMFINDCLIP eq OK )
	{
		system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -x vob,null -y ppm -c 10-11 -o autoclip 2&> /dev/null ");
		system("convert -colorspace gray autoclip00000.ppm autoclip.pgm");
		$clip=`pgmfindclip autoclip.pgm`;
		system("/bin/rm autoclip00000.ppm autoclip.pgm");
		print (" Pgmfindclip proposal  : -j".$clip."\n");
	}
       	print ("Press Enter -> ");
       	$junk=<STDIN>;
	for ($i = 0; $i <= 80; $i += 16 )
	{
		printf("transcode -z -k -i ".$vobpath."/".$sample." -j ".$i.",0  -x vob,null -y ppm -c 10-11 -o video_s._-j_".$i.",0_\n");
        	system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$i.",0 -x vob,null -y ppm -c 10-11 -o video_s._-j_".$i.",0_  2&> /dev/null ");
        	system ("".$XV." video_s._-j_".$i.",0_00000.ppm" );
		print $GREEN;
		print STDOUT "Was this Cripping Good ?(Y/N) : ";
		print $NORM;
		$rep= <STDIN>;
		chomp($rep);
		if ($rep eq "O" or $rep eq "o" or $rep eq "y" or $rep eq "Y")
		{	print $GREEN;
			print STDOUT "Fine  \n";
			print $NORM;
			$tb=$i;
			system("rm video_s._-j_".$i.",0_00000.ppm" );
			$left_right=1;
			last;
		}else{
			system("rm video_s._-j_".$i.",0_00000.ppm" );
			$left_right=0;
		}
	}
#	system("clear");
#################################SUBTITLE###################################################
	$st=10;
	print $GREEN;	
	print STDOUT "Do you want subtitle ? (Y/N) ";
	print $NORM;
	$rep= <STDIN>; 
        chomp($rep); 
        if ($rep eq "O" or $rep eq "o" or $rep eq "y" or $rep eq "Y") 
        { 
                 print STDOUT "Which SubTitle Number do you want ?(Max=9): ";
		 while ( $st >= 10 )
                 {
                      print STDOUT "By default SubTitle 0 is encode, enter SubTitle number if you want other ( MAX = 9 ) : ";
                      $st=<STDIN>;
                      chomp($st);
                      if ( $st eq "" ) { $st = 0 ;}
                  }
                 $sub_title="-J extsub=".$st.":".$i;
         }

			

#######################################CROPPING LEFT RIGHT #####################################
	print $GREEN;
	print STDOUT " Now Clipping Left/Right \n";
	print $NORM;
        print ("Press Enter -> ");
        $junk=<STDIN>;

	for ($j = 0; $j <= 80; $j += 8)
	{
		printf("transcode -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$j." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$j."_\n");
       		system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$j." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$j."_ 2&> /dev/null ");
       		system ("".$XV."  video_s._-j_".$tb.",".$j."_00000.ppm" );
		 print $GREEN;
       		print STDOUT "Was this Cripping Good ?(Y/N) : ";
		 print $NORM;
       		$rep= <STDIN>;
		chomp($rep);
       		if ( $rep eq "O" || $rep eq "o" or $rep eq "y" or $rep eq "Y" )
        	{	print $GREEN;
			print "Fine\n";
			print $NORM;
			$lr=$j;
			system("rm video_s._-j_".$tb.",".$j."_00000.ppm");
			$top_bot=1;
                       	last;
               	}else{
			system("rm video_s._-j_".$tb.",".$j."_00000.ppm");
			$top_bot=0;
		}
        }
####################     ANTIALIASING DEINTERLACING   ##################"
	print "Trying to detect if frames are interlaced.....  \n";
	$interlace=`transcode -i $vobpath/$sample -J 32detect -c 100-101 2>&1 | grep interlaced`;
	if ( ! ( $interlace =~  m,interlaced = (yes),))
	{	
		if ( ! ( $interlace =~  m,interlaced = (no),))
		{	print $RED;
			print "Unable to Detect Interlacing\n";
			print $NORM;
			exit(1);
		}
		$INTERLACE="no";
	}else{
		$INTERLACE="yes";
	}
	print $RED;
	if ( $INTERLACE eq "no")
	{ 
		print "It seems that this movie DOES'NT NEED deinterlacing\n";
	}else
	{ 	print "It seems that this movie NEED deinterlacing\n";
	}
	print $GREEN;
 	print STDOUT "Does your clip need Deinterlacing (slower :-( ? ";
	print $NORM;
       	$rep= <STDIN>;
       	chomp($rep);
        if ( $rep eq "O" || $rep eq "o" || $rep eq "y" || $rep eq "Y" )
        {	
		print $GREEN;
		print "Vob2divx is unable to determine if you have compile transcode with the --with-libpostproc-builddir configure option\n this filter is much more faster than the builtin deinterlacing filter\n Have you compile transcode with the Mplayer libraries ?(Y/N) ";
		print $NORM;
        	$rep= <STDIN>;
        	chomp($rep);
       		if ( $rep eq "O" || $rep eq "o" || $rep eq "y" || $rep eq "Y" )
		{	 $dintl="_-J_pp=lb";
		}else{
	 		$dintl="_-I_3";
		}
        }  
	print $GREEN;
        print STDOUT "Does your clip need Antialiasing (slower :-( ? ";
	print $NORM;
        $rep= <STDIN>;
        chomp($rep);
       if ( $rep eq "O" || $rep eq "o" || $rep eq "y" || $rep eq "Y" )
       { 	$aalias="_-C_3";
       }
############################" ZOOMING #######################################
# We need the Bitrate to calculate new image Size for the quality_ratio 
		calculate_bitrate;
#		We need also the Frame rate $FPS
		calculate_nbrframe;


                $probe = `tcprobe -i  $vobpath/$sample`;
                if (! ( $probe =~ m,import frame size: -g (\d+)x,))
                {       print $RED;
                        print "Error: Unable to find Width size of vob file\n";
                        print $NORM;
                        exit(1);
                }
                $Xaxis=$1;
                if (! ( $probe =~ m,import frame size: -g \d+x(\d+).*,))
                {       print $RED;
                        print "Error: Unable to find Hight size of vob file\n";
                        print $NORM;
                        exit(1);
                }
                $Yaxis=$1;
		if (! ( $probe =~ m,aspect ratio: (\d+):(\d+).*,))
			{       print $RED;
                        print "Error: Unable to find Aspect ratio of vob file\n";
                        print $NORM;
                        exit(1);
                }
		$aspect_ratio=$1/$2;

                $Width=$Xaxis-$lr;
# New reCalculate Width Image = SQRT (Bitrate * aspect / QualityRatio x FPS )
                $NXaxis=sqrt(1000*$bitrate*$aspect_ratio/($quality_ratio*$FPS));
# Finale Image MUST have a multiple of 8 size
		$NXaxis=16*floor($NXaxis/16);
                if ( $NXaxis > $Width ) {
                        $NXaxis = 640;
                }
                if ( $NXaxis < 320){
                        $NXaxis = 320;
                }

#                       New Height
# Finale Image MUST have a multiple of 16 size
             $NYaxis=16*floor((($NXaxis*(1-2*$tb/$Xaxis))/$aspect_ratio)/16);

	 print $GREEN;
	print STDOUT "Now Zooming\n ";
	if ( ($Xaxis - 2*$lr)/16 == floor(($Xaxis - 2*$lr)/16) && ($Yaxis - 2*$tb)/16 == floor (($Yaxis - 2*$tb)/16) )
	{
	print $RED;
	print "NB: Because the cripped image size is a multiple of 16, using the Slow Zooming is not necessary\n"; 
	print "New image Size= ".$NXaxis."x".$NYaxis."\n";
	print "Old image Size= ".$Xaxis."x".$Yaxis."\n";
	}else{
	print $RED;
        print "WARNING : Cripped Image size is not a multiple of 16 .. You MUST use the Slow Zooming\n";
	}
	print $GREEN;
	print STDOUT "Do You want Fast Zooming(F) or Slow Zooming(S) ? [default: F] ";
	 print $NORM;
        $quality=<STDIN>;
	chomp($quality);
	if ( $quality ne "S" && $quality ne "s" ) { $quality=F ; }
	if ( $quality eq "F" || $quality eq "f" ) 
	{
                        $row="16";
#  Zooming 
               $zH=floor(($Yaxis-2*$tb-$NYaxis)/$row);
               $zW=floor(($Xaxis-2*$lr-$NXaxis)/$row);
		$rep=Z;
		while ( $rep ne o && $rep ne "O" && $rep ne "y" && $rep ne "Y" )
                {
        		printf("transcode -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$lr." -B ".$zH.",".$zW.",".$row." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$lr."_-B_".$zH."\n");
        		system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$lr." -B ".$zH.",".$zW.",".$row." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$lr."_-B_".$zH." 2&> /dev/null ");
       		 	system ("".$XV." video_s._-j_".$tb.",".$lr."_-B_".$zH."00000.ppm" );
			 print $GREEN;
			print STDOUT "Was this Zooming Good ?(Y) , to Small ?(S), To Big ?(B) : ";
			print $NORM;
			$rep= <STDIN>;
                        chomp($rep);
                        if ( $rep eq "O" || $rep eq "o" || $rep eq "y"  || $rep eq "Y" )
                        {
                       	system("mv video_s._-j_".$tb.",".$lr."_-B_".$zH."00000.ppm video_s._-j_".$tb.",".$lr."_-B_".$zH.",".$zW.",".$row.".avi");
                        	$good_video="video_s._-j_".$tb.",".$lr."_-B_".$zH.",".$zW.",".$row.$dintl.$aalias.".avi";
				$zoom=1;
				last;
			}elsif ( $rep eq "S" || $rep eq "s"  ) {
                               system("rm video_s._-j_".$tb.",".$lr."_-B_".$zH."00000.ppm");	
				$zoom=0;
				$zH=$zH-1;
			}elsif ( $rep eq "B" || $rep eq "b"  ) {
                                system("rm video_s._-j_".$tb.",".$lr."_-B_".$zH."00000.ppm");
                                $zoom=0;
                                $zH=$zH+1;
			}
		}	
	}else {
		$inc=128; #  Multiple de 8 meme apres /2 */
		$rep=n;
		$prep=Z;
		while ( $rep ne o && $rep ne "O" && $rep ne "y" && $rep ne "Y" )
		{
			printf("transcode -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$lr." -Z ".$NXaxis."x".$NYaxis." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$lr."_-Z_".$NXaxis."x_".$NYaxis."\n");
			system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$lr." -Z ".$NXaxis."x".$NYaxis." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$lr."_-Z_".$NXaxis."x".$NYaxis."");
			system ("".$XV." video_s._-j_".$tb.",".$lr."_-Z_".$NXaxis."x".$NYaxis."00000.ppm" );
			print STDOUT "Was this Zooming Good ?(Y) , to Small ?(S), To Big ?(B) : ";
        		$rep= <STDIN>;
			chomp($rep);
        		if ( $rep eq "O" || $rep eq "o" || $rep eq "y"  || $rep eq "Y" )
	               	{
				printf(" Image Size = ".$NXaxis."x".$NYaxis."\n");
				system("mv video_s._-j_".$tb.",".$lr."_-Z_".$NXaxis."x".$NYaxis."00000.ppm video_s._-j_".$tb.",".$lr.$dintl.$aalias."_-Z_".$NXaxis."x".$NYaxis.".avi");
				$good_video="video_s._-j_".$tb.",".$lr.$dintl.$aalias."_-Z_".$NXaxis."x".$NYaxis.".avi";
				$zoom=1;
                        	last;
			}elsif ( $rep eq "S" || $rep eq "s"  ) {
				system("rm video_s._-j_".$tb.",".$lr."_-Z_".$NXaxis."x".$NYaxis."00000.ppm");
				$zoom=0;
				if ( $rep ne  $prep  && $prep ne Z ) 
				{ 	$inc = $inc/2; 
				}
				$prep=$rep;
				$NYaxis= $NYaxis + $inc;
			}elsif ( $rep eq "B" || $rep eq "b"  ) {
                		system("rm video_s._-j_".$tb.",".$lr."_-Z_".$NXaxis."x".$NYaxis."00000.ppm");
				$zoom=0;
				if ( $rep ne  $prep  && $prep ne Z )
				{	 $inc = $inc/2;
				}
                		$prep=$rep;
                		$NYaxis= $NYaxis - $inc;
                	}
      		} 
	}
#
#
###################################  ENCODE #######################################

	if ( $left_right eq 1 && $top_bot eq 1 && $zoom eq 1  )
	{
		$par=$good_audio." ".$good_video;
	        @tmp = split /\./, $par;
		for ( $i = 1 ; $i < 4 ; $i = $i + 2  )
		{
                	$t = $tmp[$i];
                	$t =~ tr [_] [ ];
                	$params .= $t;
		}
		$params=$params." ".$sub_title;
		open (PARAMS,">tmp/params.conf");
		print PARAMS $params;
		close(PARAMS);
	
	} else 
	{
	print(" OK, You must now run vob2divx <MaxFilesize>  ".$good_audio." ".$good_video."\n\n");
	exit(1);
	}
	ask_clust;
}

if ($ARGV[1] eq "sample")
{ config;
}



if ($ARGV[0] eq runclust )
{
        if (defined($ARGV[1]))
        {
                $wdir=$ARGV[1];
                chdir($wdir) or die "$wdir does not exist or is'nt a directory\n
";
                sub_continue;
                aviencode;
		exit(0);
        }else{
#                 cluster;
		  print "Error: Why run vob2divx with runclust option ?\n";
        }
# We do never come here !
exit(1);
}
if ( $ARGV[0] eq "-v" )
{
	print "Vob2divx release ".$release."\n";
	exit(0);
}

if ( $ARGV[0] eq "-h" || $ARGV[0] eq "--help" )
{
	print $usage;
	exit(0);
}

if ($ARGV[1] eq "rip" )
{ 	
# TODO recuperer les langues ?
#  possibilite de recup Runtime .. mais -> Howto rescaled sound ?	
	$vobpath = $ARGV[0];
        if ( ! -e $vobpath )
        {       print STDOUT "Directory \"".$vobpath."\" does not exist \n Sorry \n";
                exit(1);
        }
	print $RED;
	print "******* WARNING *********\n";
	print "All files in $vobpath will be deleted !!!\n";
	print "Press Enter to continue or <Ctrl-C> to Abort\n";
	print $NORM;
	$rep=<STDIN>;
	print $GREEN;
	print "On which device is your DVD (to detect the main title)[ default: /dev/dvd] ?" ;
	print $NORM;
	$dvd=<STDIN>;
	chomp($dvd);
	if ( $dvd eq "" ) { $dvd="/dev/dvd";}
# From the excellent cpdvd of Vogelgsang (http://www9.informatik.uni-erlangen.de/~Vogelgsang/)
	$probe = `tcprobe -i \"$dvd\" 2>&1`;
	if(!($probe =~ m,DVD title \d+/(\d+),)) {
 		 print STDERR "Probing DVD failed! - No DVD?\n";
 		 exit(1);
	}
	$totalTitles = $1;
	print " titles: total=$totalTitles\n";

	@checkTitles = 1 .. $totalTitles;
# now probe each title and find longest
	$longestLen   = 0;
	$longestTitle = 0;
	for(@checkTitles) {
  # call tcprobe for info
		  $probe = `tcprobe -i \"$dvd\" 2>&1 -T $_`;
  # extract title playback time -> titlelen
  		if(!($probe =~ m,title playback time: .* (\d+) sec,)) {
    			print STDERR "No time found in tcprobe for title $_ !\n";
    			exit(1);
  		}
 		 $titleLen[$_] = $1;
  # extract title set (VTS file) -> titleset
  		if(!($probe =~ m,title set (\d+),)) {
    			print STDERR "No title set found in tcprobe for title $_ !\n";
    			exit(1);
  		}
  		$titleSet[$_] = $1;
  # extract angles
  		if(!($probe =~ m,(\d+) angle\(s\),)) {
    			print STDERR "No angle found in tcprobe for title $_ !\n";
    			exit(1);
  		}
  		$angles = $1;
  # extract chapters
  		if(!($probe =~ m,(\d+) chapter\(s\),)) {
    			print STDERR "No chapter found in tcprobe for title $_ !\n";
    			exit(1);
 		 }
  		$chapters = $1;

  # calc hour, minute of title len
  		$sec  = $titleLen[$_];
  		$hour = int($sec / 3600);
  		$sec -= $hour * 3600;
  		$min  = int($sec / 60);
  		$sec -= $min * 60;
 
  # verbose
  		printf("%02d: len=%02d:%02d:%02d titleset=%02d angles=%02d chapters=%02d\n", $_,$hour,$min,$sec,$titleSet[$_],$angles,$chapters);
 
  # find largest title
  		if($titleLen[$_] > $longestLen) {
   			 $longestLen   = $titleLen[$_];
    			$longestTitle = $_;
 		 }
	}
# Thank to Christian Vogelgsang ;-)
	print "Thank to Christian Vogelgsang ;-), the Main Title seems to be the Title No : $longestTitle, OK ? (y/n) :";
	print $NORM;
	$rep=<STDIN>;
        chomp($rep);
	if ( $rep ne "o" &&  $rep ne "O" && $rep ne "y" && $rep ne "Y" ) 
	{ 	
	    print "Ups... Enter the Title number please : ";
	    $longestTitle=<STDIN>;
	    chomp($longestTitle);
	}
#  Check if this title is multiangle ....
	$probe = `tcprobe -i \"$dvd\" 2>&1 -T $longestTitle`;
	if(!($probe =~ m,(\d+) angle\(s\),)) {
                        print STDERR "No angle found in tcprobe for title $_ !\n";
                        exit(1);
                }
        $angles = $1;
	if ( $angles > 1 )
        { 	print $RED;
                  print "***************** WARNING!!!! *********************\n\t This is a multi angles video stream. A known bug in transcode doesn't permit to encode this type of stream correctly.\n You may try the experimental \"-i ".$dvd." -x dvd -T".$longestTitle.",-1\" option, in place of the usual \" -i ".$vobpath." -x vob\", to encode this\n";
		print"\n\n\n Do you want always rip this DVD ?(Y/N): ";
                print $NORM;
		$rep=<STDIN>;
        	chomp($rep);
        	if ( $rep ne "o" &&  $rep ne "O" && $rep ne "y" && $rep ne "Y" )
        	{
			print "OK .. Bye\n";
                	exit(1);
                }
		print $GREEN;
		print "OK ... we continue ...\n";
		print "There is ".$angles." which one do you want ? :";
		print $NORM;
                $angle=<STDIN>;
                chomp($angle);
	}else{
		$angle=1;
	}
	
#	
	system("/bin/rm -f ".$vobpath."/*  2&> /dev/null");
	chdir($vobpath);
	$sys="tccat -i /dev/dvd -T ".$longestTitle.",-1,".$angle." | split -b 1024m - VTS_0".$title."_" ;
	print ($sys."\n");
	system("nice -".$nice." ".$sys);
	$tmp = `/bin/ls -1 .`;
	@dateien = split /\n/, $tmp;
 	foreach $vob ( @dateien )
	{
		print("mv $vob $vob.vob\n");
		system("mv $vob $vob.vob");
	}
	print $GREEN;
	print "You may now run vob2divx with yours arguments to encode the vob file(s)\n\n";
	print $NORM;
exit(0);
}
	


if ($ARGV[1] eq "continue" || $ARGV[0] eq "continue" || ! defined($ARGV[0]))
{	system("/bin/rm tmp/cluster.args 2&> /dev/null");
	sub_continue;
}  
if ($ARGV[1] > 1 )
{
print "ICI 1\n";
$audio_bitrate=96;
get_params;
}
if (1)
{
	get_params;
	aviencode;	
	merge;
# We do never come here !
	exit(1);
}
