#! /usr/bin/perl
# Authors : Roland SEUHS <roland@wertkarten.net> 
#         Dominique CARON <domi@lpm.univ-montp2.fr> 
# GPL License 
#
# Release 0.4.0
# ChangeLog:
# runclust is now include in the perlscript vob2divx.pl ( Do not need the shell script runclust anymore)
# Adding the SubTitle transcode Feature
# Detecting the transcode release ( For the -B option)
# Detecting the Vob Audio format (ac3 or mp3) and warning the user if it is mp3 (lame needed)

use POSIX;

$DIVX=divx4;           # Choose your preferred encoder
#$DIVX=xvid;	       #     Choose your preferred encoder
$XV=xv;   # WARNING !!! If you modified this (for example display from ImageMagick), modified also options at line 65  
$XINE=xine; # You may modified your vob Viewer (mplayer for example)
$AVIPLAY=aviplay; # You may modified your DivX4 Viewer (mplayer) 
$PGMFINDCLIP=pgmfindclip; # New tool of transcode

$CLUSTER_CONFIG="/local/home/domi/etc/cluster";  # YOU MUST MODIFY THIS LINE !!!

$RMCMD=rsh   ; # change this to ssh if you need

#   DO NOT TOUCH AFTER HERE UNLESS YOU KNOW WHAT YOU ARE DOING !!!!! 
system("clear");
$RED="\033[1;31m";
$GREEN="\033[0;32m";
$NORM="\033[0;39m";

#    Found the transcode release (for the -B option)
$tr_vers=`transcode -v 2>&1 | awk '{print \$2}'| sed s/^v// `;
@vers = split /pre/,$tr_vers;
@vers_nodate = split /-/,$vers[1];
chomp($vers_nodate[0]);
@Vers = split /\./,$vers[0];
if ( $Vers[0] > 0 )
{	$tr_vers=N;
        $clust_percent = "--cluster_percentage";
}
elsif ( $Vers[1] > 6 )
{	$tr_vers=N; 
	$clust_percent = "--cluster_percentage";
}
elsif ( $Vers[1] < 6 )
{	 $tr_vers=0 ;
	$clust_percent="";
}
elsif ( $vers_nodate[0] < 4 )
{ 	$tr_vers=0 ; 
	$clust_percent=""; }
else 
{ 	$tr_vers=N; 
	$clust_percent="--cluster_percentage";
}
print " Transcode detected release = ".$Vers[0].".".$Vers[1].".".$Vers[2]."pre".$vers_nodate[0]."\n";
#if ( $tr_vers eq N ) 
#{ print " Nice !! this is a release after 0.6.0pre3\n"; 
#} else {
#	print " :-( ,  this is a release older than 0.6.0pre4 \n";
#}



foreach $pgm ( $XV , $XINE , $AVIPLAY ) 
{
	if ( system("which ".$pgm." > /dev/null ") )
	{ 
		print "".$pgm." is not installed on this System :-( \n"; exit (0);
	}
}

$XV="xv -maxpect"; # display option is -geometry <width_display>x<height_display>
$PGMF=system("which ".$PGMFINDCLIP." > /dev/null >& /dev/null");
if ( $PGMF == 0  ) { $PGMFINDCLIP=OK }
# system("clear");


$warnclust = 
" ".$RED."***********  WARNING ABOUT CLUSTER MODE *************".$NORM."
If you want to use a cluster :
a) The /path/to/vobs directory must be NFS mounted on each node
and have the same name.
b) You must have rsh or ssh permission on each node,
modify the  perl vob2divx script to select rsh or ssh ).
c) You need to have a ".$RED.$CLUSTER_CONFIG.$NORM." file (change this value in the perl vob2divx scr
ipt) on the node you run vob2divx on.
This file must contain all the nodenames of your cluster:the percentage of frames to encode by each n
ode.
Syntax of this file:
# This is a Comment
asterix:25   #  Duron 333 Mhz
obelix:30  # 486 66Mhz
vercingetorix:45 # Thunderbird 1.2 Ghz
Of course the total of percentage frames to encode MUST be 100
";

$usage =
"Warning:

Please note that you are only allowed to use this program according to fair-use
laws which vary from country to country. You are not allowed to
redistribute copyrighted material. Also note that you have to use this software
at your own risk.

There are 2 ways of using this program:

1: Easy
-----------

vob2divx /path/to/vobs 700
(where 700 is the desired filesize in Megabytes)

2: Better
----------

vob2divx /path/to/vobs sample
This will ask all what it need to make the better movie ;-)

------------

You can interrupt the program anytime. To continue encoding, just run the script
without parameters in the same directory.

";

$audio_bitrate = 0 ;
$nice = 10;
$keyframes = 1000;
$sample = "";
$audiosample_length = 1000;
$videosample_length = 100;
$create_timeout = 2;
$timeout = 600;
$long_timeout = 20;


#  Functions Declarations
sub create_nav;
sub create_extract;
sub calculate_nbrframe;
sub calculate_bitrate;
sub aviencode;
sub a_bitrate;
sub sub_continue;
sub get_params;
sub make_sample;
sub cluster;
sub merge;


sub ask_clust
{   print "Enter ask_clust\n";

system("/bin/rm tmp/cluster.args 2&> /dev/null");
print ($warnclust);

print $GREEN;
print("\n Do you want to use a cluster ? [y/n] : ");
print $NORM;
$CLUSTER=<STDIN>;
chomp($CLUSTER);
if ( $CLUSTER eq "y" || $CLUSTER eq "Y" || $CLUSTER eq "o" || $CLUSTER eq "0")
{	open(CLUSTERMODE,">tmp/clustermode");
	print CLUSTERMODE YES;
	close(CLUSTERMODE);
	if ( ! -e "tmp/filenav-ok")
	{	create_nav;
	}
	$strD=`head -1 tmp/file.nav | awk '{print \$1}'`;
$strF=`tail -1 tmp/file.nav | awk '{print \$1}'`;
	if ( $strD != $strF )
	{       print $RED; print "\n*********** WARNING !!!!************\n there is sev
eral Video stream in the Vob file(s)\n\n";
        	print $GREEN;
        	print "Which unit do you want to encode ? : ";
        	print $NORM;
        	$unit=<STDIN>;
        	chomp($unit);
        	$params=`cat tmp/params.conf`;
        	chomp($params);
        	$params .= "-S ".$unit;
        	open(PARAMS,">tmp/params.conf");
        	print PARAMS $params;
        	close(PARAMS);
	}

}else
{	open(CLUSTERMODE,">tmp/clustermode");
	print CLUSTERMODE NO;
	close(CLUSTERMODE);
}
# End sub ask_clust
}



#********** Cluster MODE ************
sub cluster
{ print "Enter cluster\n";
system("/bin/rm -f tmp/merge.make tmp/sync.make 2>&1 > /dev/null");
$wdir=`pwd`;
chomp($wdir);
if ( ! -e $CLUSTER_CONFIG )
{	print $RED;
	print " ******** WARNING  ***********\n You need a cluster config file ( ".$CLUSTER_CONFIG." )\n Or Modify the vob2divx perl script to set the CLUSTER_CONFIG variable\n Each line has the form:\n name of a node:frames percentage to skip,frames percentage to encode\n Example:\n nodename1:20\nnodename2:50\n nodename3:30";
	print $NORM; 
	exit(1);
}
open(GOODNODE,">/tmp/node");
$NODE=`grep -v "^[[:space:]]*#" $CLUSTER_CONFIG | grep -v '^[[:space:]]*$$' | wc -l`;
print "Number of Nodes : ".$NODE;	
if ( $NODE != 0 )
{
	$poweroff=0;
	$poweron=0;
	$localhost=`hostname`;
	chomp($localhost);
	@allnodes=`grep -v "^[[:space:]]*#" $CLUSTER_CONFIG | grep -v '^[[:space:]]*$$'| awk -F"#" '{print \$1}'`;
	foreach $node  ( @allnodes )	
	{
		@chost=split /:/, $node;
		$rhost=@chost[0];
		if ( $rhost ne "$localhost" )
		{	$rs=system($RMCMD." ".$rhost." whoami 2>&1 > /dev/null ");
			if ( $rs != 0 )
			{
				print $RED ;
				$NODE = $NODE - 1;
				print "Node ".$rhost." unreachable ...\n";
				$P=@chost[1];
				chomp($P);
				$poweroff = $poweroff + $P;
				print " Need to calculate ".$poweroff." % of frames on other node(s)";
				if ( $poweroff >= 100 )
				{	last;
				}
				print $NORM; 
			}else{
			$P=@chost[1];
			chomp($P);
			print GOODNODE $rhost.":".$P."\n";
			$poweron = $poweron + $P;
			}
		}else{
			$P=@chost[1];
			chomp($P);
			print "Host : ".@chost[0]." , Pow = ".$P."\n";
			print GOODNODE $rhost.":".$P."\n";
                        $poweron = $poweron + $P;
		}
	}
	$ addpower = $poweroff / $NODE;
	close(GOODNODE);
}else{
	system("/bin/rm /tmp/node");
}
if ( -e "/tmp/node" )
{	
	$tabpower="";
	$sumpow=0;
	$max=0;	
	$i=0;
	@allnodes=`cat /tmp/node`;
	system("/bin/rm /tmp/node");
	foreach $node (@allnodes )     
        { 
                @chost=split /:/, $node; 
                $rhost=@chost[0];
		if ( $sumpow < 100 )
		{	$pow=@chost[1];
			$pow=$pow + $addpower;
			$max=$sumpow + $pow;
			if ( $max > 100 )
			{	$pow = 100 - $sumpow;
			}
			open(CLUSTERARGS,">tmp/cluster.args");
			print CLUSTERARGS $sumpow.",".$pow."\n";
			close(CLUSTERARGS);
			print $GREEN; 
			print "Encoding on node ".$rhost."  with -W ".$sumpow.",".$pow."\n";
			print $NORM; 
			if ( $rhost ne "$localhost" ) 
                	{ 	system ("xterm -n ".rhost." -e ".$RMCMD." ".$rhost." vob2divx runclust ".$wdir." &");
			}else{

				system ("xterm -n ".$rhost." -e vob2divx runclust ".$wdir." &");
			}
		@tabpower[$i]=$sumpow;
		$i++;
		$sumpow= $sumpow + $pow;
		sleep (7);
		}
	}
	if  ( $sumpow <  100 )
	{
		$pow = 100 - $sumpow;
		open(CLUSTERARGS,">tmp/cluster.args");
		print  CLUSTERARGS $sumpow.",".$pow."\n";
		close(CLUSTERARGS);
		print $GREEN; 
		print "Encoding on localnode with -W ".$sumpow.",".$pow." to finish...";
		print $NORM;
		system ("xterm -e vob2divx runclust ".$wdir." &");
		@tabpower[$i]=$sumpow;
		sleep(3);
	}
	print "Wait for nodes finish ....\n";
	foreach $endnode ( @tabpower )
	{	while ( ! -e "tmp/2-AVI".$endnode.".finish" ) {print "."; sleep(20);}
		print "Node ".$endnode." has finished to encode\n";
	}	
	print $GREEN;
	print "Now We merge Video files and Audio MP3\n";
	system("touch tmp/merge.make tmp/sync.make");
	print $NORM;
	merge;
	system("/bin/rm tmp/cluster.args");
} else {
	print " Nothing to do :-( ";
}
exit(0);
# End cluster Sub routine
}


#  ******************** Create Nav File (For cluster) ********************

sub create_nav
{
	 print("Using Cluster : creating tmp/file.nav\n");
	print("cat ".$vobpath."/*.vob | tcdemux -W > tmp/file.nav\n");
	system("cat ".$vobpath."/*.[Vv][Oo][Bb] | tcdemux -W > tmp/file.nav") == 0 && system("touch tmp/filenav-ok");
	 if ( ! -e "tmp/filenav-ok"){ exit(0) };
}


# ***********************Create extract info (to calculate bitrate) *******

sub create_extract
{	
	if (! -e "tmp/audioformat.conf" )
	{
	print("Is the audiostream mp3 or ac3 (You need Transcode compiled with Lame to import MP3) ?[default:ac3] ");
                $audio_format=<STDIN>;
                chomp( $audio_format);
                if ( $audio_format ne mp3 )
	 	{ 	$audio_format=ac3;
	 	}
		system("echo ".$audio_format." > tmp/audioformat.conf");
	}else
	{	$audio_format = `cat tmp/audioformat.conf`;
		chomp( $audio_format);
	}
	
	if (! -e "tmp/extract-ok" ||  ! -e "tmp/extract.text")
	{	print("creating tmp/extract.text\n");
		print("This will take a little while....\n");
		$sys = " nice -".$nice." cat ".$vobpath."/*.[Vv][Oo][Bb] | nice -".$nice." tcextract -x ".$audio_format." -t vob | nice -".$nice." tcdecode -x ".$audio_format." | nice -".$nice." tcscan -b ".$audio_bitrate." -x pcm 2>> tmp/extract.text  >> tmp/extract.text";
		print ($sys."\n");
		system ("nice -".$nice." ".$sys) == 0 && system("touch tmp/extract-ok");
		if ( ! -e "tmp/extract-ok"){ exit(0) };
	}
	$tmp = `cat tmp/extract.text | grep "A:" | grep MB`;
}

# **********************Calculate How many Frames to encode ******************

sub calculate_nbrframe
{
    $tmp = `cat tmp/extract.text | grep "frames,"`;
    @tmp = split /V:/,$tmp;
    @tmp2 = split /frames,/, @tmp[1];
    foreach $tmp (@tmp2)
        {       if ($tmp > 1)
                {
                        $tot_frames = $tmp;
                        last;
                }
        }
    $last_sec = `cat tmp/endtime.conf`;

    $tmp = `cat tmp/extract.text | grep "fps"`;
    @tmp = split /@ /,$tmp;
    @tmp2 = split /\./, @tmp[1];
        foreach $tmp (@tmp2)
        {       if ($tmp > 1)
                {
                        $FPS = int($tmp);
                        last;
                }
        }

    $nbr_frames= $tot_frames - $last_sec*$FPS;
    if ( $CLUSTER eq NO  )
    {
    	print ("Number of frames to encode : ".$nbr_frames.", @ ".$FPS." frames per/sec\n");	
    }
}

# ********** Calculate Bitrate ****************

sub calculate_bitrate
{
	$tmp = `cat tmp/extract.text | grep "frames,"`;
        @tmp = split /frames,/, $tmp;
        @tmp2 = split /sec/, @tmp[1];
        foreach $tmp (@tmp2)
        {       if ($tmp > 1)
                {
                        $runtime = $tmp;
                        last;
                }
        }
        $runtime=$runtime - $last_sec;

    	if ( $CLUSTER eq NO  )
	{	print("Runtime: ".$runtime."\n");
	}

 	$tmp = `cat tmp/extract.text | grep "A:" | grep MB`;
 	@tmp = split /A:/, $tmp;
	@tmp2 = split /MB/, @tmp[1];
	foreach $tmp (@tmp2)
	{	if ($tmp > 1)
		{
			$audio_size = $tmp -($last_sec * $audio_bitrate*1000)/(1024*8192);
			last;
		}
	}
	if ($CLUSTER eq NO)
        {
	printf("Audio_size: %.2f Mb @ ".$audio_bitrate." Kbs\n",$audio_size);
	}

	$bitrate = floor(($filesize - $audio_size)/$runtime * 1024 * 1024 * 8 / 1000);
	if ($bitrate < 20)
	{	$bitrate = 700;
		print("\n#### ATTENTION ####\n\tCalculated bitrate is ".$bitrate." kbps, \nwhich does not make much sense, I'll use 700 kbps instead. \nFilesize will not match your preferred filesize. Sorry");
	}

	$tmp = `cat tmp/extract.text | grep "volume rescale"`;
	@tmp = split /rescale=/, $tmp;
	if ($tmp[1] > 1)
	{	chomp ($tmp[1]);
		$audio_rescale = $tmp[1];
	} else
	{	$audio_rescale = 1;
	}
	if ($CLUSTER eq NO )
        {
		print ("Audio rescale: ".$audio_rescale."\n");
		system ("echo ".$audio_rescale." > tmp/audio_rescale.conf");
		print ("Bitrate: ".$bitrate."\n");
		system ("echo ".$bitrate." > tmp/bitrate.conf");
		$videosize=$bitrate*1000*$runtime/(1024*1024*8);
		printf("Video Size: %.2f Mb\n",$videosize);
		$totalsize=$videosize+$audio_size;
		printf("Total Size estimated : %.2f Mb\n",$totalsize);
	}

}

# ********** Main Avi encode ***************

sub aviencode
{       	print "Enter aviencode\n";
	a_bitrate;
	if (! -e "tmp/extract-ok")
	{	create_extract;
	}
	calculate_nbrframe;
  	calculate_bitrate;

	$CLUSTER=`cat tmp/clustermode`;
	if ( $CLUSTER eq "YES" && ! -e "tmp/cluster.args")
	{	cluster;
	}

	if ( $CLUSTER eq "YES" )
	{ 	$cluster=`cat tmp/cluster.args`;
		chomp($cluster);
		$cluster="-W ".$cluster.",tmp/file.nav";
		$node=`cat tmp/cluster.args| awk -F, '{print \$1}'`;
		$nbr_node=`cat tmp/cluster.args| awk -F, '{print \$2}'`;
				chomp($nbr_node);
		chomp($node);
	}else{
		$cluster="";
		$node="";
	}

	$params=$params." ".$cluster." -c 0-".$nbr_frames."";

	$tmp = `ls -1 $vobpath | grep ".[Vv][Oo][Bb]"  `;
	$i = 0;
	if ( $CLUSTER eq "YES" )
 	{	print("***  Cluster Mode ON ===>  NODE number : ".$node." ******* \n");
	}


	system("rm tmp/*.done");

	if (! -e "tmp/1-AVI".$node.".finish")
	{
		print("Encode: ".$vobpath." Pass One ....\n");
                my $pid = fork();
                die "couldn't fork\n" unless defined $pid;
                if ($pid)
                {       while(! -e  "tmp/1-AVI".$node.".done")
                        {       sleep $long_timeout;
                        }
                        system("touch tmp/1-AVI".$node.".finish");
                 } else
                 {	
			$sys = "transcode -i ".$vobpath."/ ".$clust_percent." ".$params." -s ".$audio_rescale." -w ".$bitrate.",".$keyframes." -x vob -y ".$DIVX.",null -V  -R 1,".$DIVX."AVI".$node.".log -o /dev/null";
			print($sys."\n");
			system("nice -".$nice." ".$sys) == 0 && system("touch tmp/1-AVI".$node.".done");
			exit(0);
		}
	} else
	{	print("AVI".$node." already encoded, remove \"tmp/1-AVI".$node.".finish\" to reencode \n");
	}


	if (! -e "tmp/2-AVI".$node.".finish")
	{	print("Encode: ".$vobpath." Pass two ....\n");
                        my $pid = fork();
                        die "couldn't fork\n" unless defined $pid;
                        if ($pid)
                        {       while(! -e  "tmp/2-AVI".$node.".done")
                                {       sleep $long_timeout;
				}
                                system("touch tmp/2-AVI".$node.".finish");
                        } else
                        {
				$sys = "transcode -i ".$vobpath."/ ".$clust_percent." ".$params." -s ".$audio_rescale." -w ".$bitrate.",".$keyframes." -b ".$audio_bitrate." -x vob -y ".$DIVX." -V -R 2,".$DIVX."AVI".$node.".log -o tmp/2-AVI".$node.".avi";
				print($sys."\n");
				 system("nice -".$nice." ".$sys) == 0 && system("touch tmp/2-AVI".$node.".done");
				if ($CLUSTER eq "YES") 
				{	print ("You may now create empty file tmp/merge.make to merge Video and Audio streams\n Do nothing if you are using runclust\n");
					sleep (3);
				}
			exit(0);
			}
	} else
	{	print("AVI".$node." already encoded, remove \"tmp/2-AVI".$node.".finish\" to reencode \n");
	}

	if ( $CLUSTER eq NO ) { system(" touch tmp/merge.make");}
} # END Aviencode

#********* MERGING Function **************
sub merge
{	print "Enter merge\n";
	if (! -e "tmp/merge.finish" &&  -e "tmp/merge.make")
	{       my $pid = fork();
		die "couldn't fork\n" unless defined $pid;
		if ($pid)
		{	while(! -e  "tmp/merge.done")
			{	sleep $long_timeout;
			}
			system("touch tmp/merge.finish");
		} else
		{	if ( $CLUSTER eq "YES" )
			{	$sys = "avimerge -i tmp/2-*.avi -o tmp/tmp_movie.avi";
			}else
			{	$sys = "mv tmp/2-AVI.avi Movie.avi";
			}
			print($sys."\n");
			system("nice -".$nice." ".$sys);
		system("touch tmp/merge.done");
		exit(0);
                }
	}
# $CLUSTER  is known because we've pass through aviencode before
	if (! -e "tmp/sync.finish" && $CLUSTER eq "YES" &&  -e "tmp/sync.make")
	{
		my $pid = fork();
                die "couldn't fork\n" unless defined $pid;
                if ($pid)
                {       while(! -e  "tmp/sync.done")
                        {       sleep $long_timeout;
                        }
                        system("touch tmp/sync.finish");
                } else
                {
			$tmp = `cat tmp/params.conf`;
			@tmp = split /-j/,$tmp;
			$audio_params=@tmp[0];
# $nbr_frames is known because we've pass through aviencode before
			print "AudioParams : ".$audio_bitrate."\n";
		 	$sys = "transcode -p ".$vobpath." -W 100,100,tmp/file.nav ".$audio_params." -c 0-".$nbr_frames." -s ".$audio_rescale." -i tmp/tmp_movie.avi -P 1 -x avi,vob -y raw -o Movie.avi -u 50";
			print($sys."\n");
                       	system("nice -".$nice." ".$sys);
			system("touch tmp/sync.done");
			exit(0);
		}
	}
print "Bye !!!\n";
}


#  *************   Get Audio Bitrate ************

sub a_bitrate
{       print "Enter Audio_bitrate\n";
	if ( ! -e "tmp/audio_bitrate.conf")
        {
                while ( $audio_bitrate ne 32 && $audio_bitrate ne 64 && $audio_bitrate ne 96 && $audio_bitrate ne 128 && $audio_bitrate ne 256 )
                {
                        print("\n By default the MP3 Audio output bitrate is set to 96kbs, enter another value to change this : ");
                        $audio_bitrate=<STDIN>;
                        chomp($audio_bitrate);
                        if ( $audio_bitrate eq "" )
                        {
                        $audio_bitrate=96;
                        }
                }
		open(ABR,">tmp/audio_bitrate.conf");
		print ABR $audio_bitrate;
		close(ABR);
        }else{
                $audio_bitrate=`cat tmp/audio_bitrate.conf`;
		chomp($audio_bitrate);
        }
}

# *************   Restore parameters to continue ********
sub sub_continue
{ 	print "Enter sub_continue\n";
if (-e "tmp/vobpath.conf" && -e "tmp/filesize.conf" && -e "tmp/params.conf")
{       $vobpath = `cat tmp/vobpath.conf`;
        chomp($vobpath);
        if (! -d $vobpath)
        {       print("Path: ".$vobpath." does not exist.\n");
                exit(1);
         }
         $filesize = `cat tmp/filesize.conf`;
         chomp ($filesize);
         $params = `cat tmp/params.conf`;
         chomp ($params);
} else
{        print($usage);
	
	print($warnclust);
         exit(1);
}
if ( ! -e "tmp/clustermode" )
{	ask_clust;
}
$CLUSTER=`cat tmp/clustermode`;
if ( $CLUSTER eq NO  )
{
         print("Path to VOBs: ".$vobpath."\n");
         print("Preferred Filesize: ".$filesize."\n");
        print("Additional Parameters: ".$params."\n");
}
}

# ********************* Get Needed parameters ************
sub get_params
{  	print "Enter get_params\n";
	$i = 0;
        if ( -e $ARGV[$i])
        {       $vobpath = $ARGV[$i];
                $i ++;
        } else
        {       if ( ! -e "tmp/vobpath.conf")
                {       print("Please supply path to find vobfiles\n");
                        exit(1);
                } else
                {       $vobpath = `cat tmp/vobpath.conf`;
                        chomp($vobpath);
                        if (! -e $vobpath)
                        {       print("Path: ".$vobpath." does not exist.\n");
                                exit(1);
                        }
                }
        }
        if ($ARGV[$i] > 1)
        {       $filesize = $ARGV[$i];
                $i++;
        } else  
	{
               if (-e "tmp/filesize.conf")
                {       $filesize = `cat tmp/filesize.conf`;
                        chomp($filesize);
                } else
                {       print("Please supply filesize \n\tor \"sample\" if you want to create samples for cropping.\n\n");
                        exit(1);
                }
        }
        while(defined($ARGV[$i]))
        {       @tmp = split /\./, $ARGV[$i];
                $t = $tmp[1];
                $t =~ tr [_] [ ];
                $params .= $t;
                $i++;
        }

	a_bitrate;

	if ( ! -e "tmp/clustermode" )
	{       ask_clust;
	}
	$CLUSTER=`cat tmp/clustermode`;
	if ( $CLUSTER eq NO  )
	{	open(VOBPATH,">tmp/vobpath.conf");
		open(FILESIZE,">tmp/filesize.conf");
		open(PARAMS,">tmp/params.conf");
                print("Path to VOBs: ".$vobpath."\n");
		print VOBPATH $vobpath;
                print("Preferred Filesize: ".$filesize."\n");
		print FILESIZE $filesize;
                print("Additional Parameters: ".$params."\n");
		print PARAMS $params;
		close(VOBPATH);
		close(FILESIZE);
		close(PARAMS);
        }
# End sub get_params
}

#******************* Make Audio sample **************
sub make_sample
{
	#print @_[0];
	if (! defined(@_[2]))
	{	@_[2] = 100;
	}
	$prefix = @_[1];
	$sys = "transcode -i ".$vobpath."/".$sample." ".@_[0]." -w 100,".@_[2]." -c 0-".@_[2]." -o ".$prefix.".avi 2&> /dev/null";
	print ($sys."\n");
	system ("nice -".$nice." ".$sys);
	if ( ! -e "tmp/audioformat" )
	{
		$audio_format=`transcode -i $vobpath/$sample @_[0] -w 100,@_[2] -c 0-20 -o /dev/null 2>&1 | grep decode_mp3`;
		if ( $audio_format eq "" ) 
		{	$audio_format=ac3;
		}else
		{
			$audio_format=mp3;
			print $RED;
			print("\n *******   WARNING !! *************\n You need transcode compile with lame to encode this Vob file(s)\n\n");
			print $NORM;
		}
		open(AUDIOFORMAT,">tmp/audioformat.conf");
		print AUDIOFORMAT $audio_format;
		close(AUDIOFORMAT);
#		system(" echo $audio_format > tmp/audioformat.conf");
	}
}



# ********************** Main() ****************************

mkdir ("tmp",0777);


if ($ARGV[1] eq "sample")
{       
	$vobpath = $ARGV[0];
	if ( ! -e $vobpath )
	{ 	print STDOUT "Directory \"".$vobpath."\" does not exist \n Sorry \n";
		exit(1);
	}
	$tmp = `ls -1 $vobpath | grep ".[Vv][Oo][Bb]"`;
	@dateien = split /\n/, $tmp;
	$i = 0;
	open(VOBPATH,">tmp/vobpath.conf");
	print VOBPATH $vobpath;
	close(VOBPATH);
	system("/bin/rm -f tmp/filenav-ok");
	system("/bin/rm -f tmp/extract-ok");
	foreach $datei (@dateien)
	{	$i++;
		print ("File ".$i.": ".$datei."\n");
	}
	$sample = $dateien[floor($i / 2)];
	$lastvob = $dateien[$i-1];
	$anzahl = $i;
	$good_audio="audio_sample._-a_?_.000.avi";
	$good_video="video_s._-j_?,?_-[ZB]_?[x?].avi";
	$samples_look_like_crap = "Please note that these samples are exclusively to find the right
	cropping parameters (video_sample.*) and audio track (audio_sample.*)\n\n";

	print ("-> Using \"".$sample."\" to create low quality samples ".$samples_look_like_crap);
	print $GREEN; 
	print ("\n Have a Look with ".$XINE." on the Vob File ".$lastvob." to get the aspect\n Look also how long is the movie after the END (so we can remove the end generic)\n You may also decide the audio stream number and the subtitle number if you want it\n");
	print $NORM;
	print ("Press Enter -> ");
	$junk=<STDIN>;
	system ("".$XINE." ".$vobpath."/".$lastvob."; clear");
#
# How many second remove from end of movie...
	print (" How long in seconds is the movie after the END ? " );
        $last_sec=<STDIN>;
        chomp($last_sec);
        if ( $last_sec eq "" || $last_sec < 10 )
	{	 $last_sec=0;
	}
		open(LASTSEC,">tmp/endtime.conf");
		print LASTSEC $last_sec;
		close LASTSEC;
#		system("echo ".$last_sec." > tmp/endtime.conf");

#
#############################SOUND SAMPLE###########################################
	$rep=n;
	$as=10;
	for ($i = 0; $i <= 6; $i ++)
	{
		if ( $rep eq "n" )
		{	print STDOUT "Do you want to make Sound samples ?(Y/N)";
			$rep=<STDIN>;
			chomp($rep)
		}
		if ( $rep ne "o" &&  $rep ne "O" && $rep ne "y" && $rep ne "Y" ) 
		{
			while ( $as >= 10 )
			{	print STDOUT "By default audio stream 0 is encode, enter audio stream number if you want other ( MAX = 9 ) : ";
				$as=<STDIN>;
                        	chomp($as);
				if ( $as eq "" ) { $as = 0 ;}
			}
# We need next line to know the audio format (AC3 or MP3)
			make_sample("-x vob -y ".$DIVX." -V -a ".$i." ", "audio_sample._-a_".$as."_", 10);
			$good_audio="audio_sample._-a_".$as.".avi";
		 	last; 
		}
		make_sample("-x vob -y ".$DIVX." -V -a ".$i." ", "audio_sample._-a_".$i."_", $audiosample_length);
        	print STDOUT "Ear this audio sample, please\n";
		print "Press Enter ->";
		$junk=<STDIN>;
		system("".$AVIPLAY." audio_sample._-a_".$i."_.avi");
		print STDOUT "What the Sound Good ?(Y/N) : ";
		$rep= <STDIN>;
        	chomp($rep);
        	if ($rep eq "O" or $rep eq "o" or $rep eq "y" or $rep eq "Y")
       		{
        		print STDOUT "Fine  \n";
			$good_audio="audio_sample._-a_".$i."_.avi";
			last;
		}else{
			system("rm audio_sample._-a_".$i."_.avi");
		}
	}
####################################### CROPPING TOP/BOTTOM ################################"
	print $GREEN;
	print STDOUT "Clipping Top/Bottom \n You must have the smallest black LetterBox at top/bottom \n (It's better to left black LetterBox at top/bottom if you intend to have SubTitle)\n";
	print $NORM; 
	if ( $PGMFINDCLIP eq OK )
	{
		system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$i.",0 -x vob,null -y ppm -c 10-11 -o autoclip 2&> /dev/null ");
		system("convert -colorspace gray autoclip00000.ppm autoclip.pgm");
		$clip=`pgmfindclip autoclip.pgm`;
		system("/bin/rm autoclip00000.ppm autoclip.pgm");
		print (" Pgmfindclip proposal  : -j".$clip."\n");
	}
       	print ("Press Enter -> ");
       	$junk=<STDIN>;
	for ($i = 0; $i <= 80; $i += 16 )
	{
		printf("transcode -z -k -i ".$vobpath."/".$sample." -j ".$i.",0  -x vob,null -y ppm -c 10-11 -o video_s._-j_".$i.",0_\n");
        	system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$i.",0 -x vob,null -y ppm -c 10-11 -o video_s._-j_".$i.",0_  2&> /dev/null ");
        	system ("".$XV." video_s._-j_".$i.",0_00000.ppm" );
		print $GREEN;
		print STDOUT "What this Cripping Good ?(Y/N) : ";
		print $NORM;
		$rep= <STDIN>;
		chomp($rep);
		if ($rep eq "O" or $rep eq "o" or $rep eq "y" or $rep eq "Y")
		{
			print STDOUT "Fine  \n";
			$tb=$i;
			system("rm video_s._-j_".$i.",0_00000.ppm" );
			$left_right=1;
			last;
		}else{
			system("rm video_s._-j_".$i.",0_00000.ppm" );
			$left_right=0;
		}
	}
#	system("clear");
#################################SUBTITLE###################################################
	if ($tr_vers eq N ) 
	{ 	$st=10;
		
		print STDOUT "Do you want subtitle ? [Y/N]";
		$rep= <STDIN>; 
                chomp($rep); 
                if ($rep eq "O" or $rep eq "o" or $rep eq "y" or $rep eq "Y") 
                { 
                        print STDOUT "Which SubTitle Number do you want ?(Max=9): ";
			 while ( $st >= 10 )
                        {
                                print STDOUT "By default SubTitle 0 is encode, enter SubTitle number if you want other ( MAX = 9 ) : ";
                                $st=<STDIN>;
                                chomp($st);
                                if ( $st eq "" ) { $st = 0 ;}
                        }
                        $sub_title="-J extsub:".$st.":".$i;
                }
	}

			

#######################################CROPPING LEFT RIGHT #####################################
	print $GREEN;
	print STDOUT " Now Clipping Left/Right \n";
	print $NORM;
        print ("Press Enter -> ");
        $junk=<STDIN>;

	for ($j = 0; $j <= 80; $j += 8)
	{
		printf("transcode -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$j." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$j."_\n");
       		system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$j." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$j."_ 2&> /dev/null ");
       		system ("".$XV."  video_s._-j_".$tb.",".$j."_00000.ppm" );
		 print $GREEN;
       		print STDOUT "What this Cripping Good ?(Y/N) : ";
		 print $NORM;
       		$rep= <STDIN>;
		chomp($rep);
       		if ( $rep eq "O" || $rep eq "o" or $rep eq "y" or $rep eq "Y" )
        	{	print "Fine\n";
			$lr=$j;
			system("rm video_s._-j_".$tb.",".$j."_00000.ppm");
			$top_bot=1;
                       	last;
               	}else{
			system("rm video_s._-j_".$tb.",".$j."_00000.ppm");
			$top_bot=0;
		}
        }
#	system("clear");
############################" ZOOMING #######################################
	 print $GREEN;
	print STDOUT "Now Zooming\n ";
	print("Generally: for Cartoons smaller than 1h30mns Good Quality is enough\n");
	print("For Movies longer than 1h30 (till 2h30 on one CD) better choose High Quality\n\n");
	print STDOUT "Do You want Good Quality fast (G) or High Quality slow (H)? [default: G] ";
	 print $NORM;
        $quality=<STDIN>;
	chomp($quality);
	if ( $quality ne H && $quality ne h ) { $quality=G ; }
	if ( $quality eq "G" || $quality eq "g" ) 
	{
		if ( $tr_vers eq N )
		{	$inc=2;
			$row=",16";
		}else
		{	$inc=1;
			$row="";
		}
		for ($B = 0; $B <= 8*$inc; $B=$B+$inc)
        	{
        		printf("transcode -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$lr." -B ".$B.",0".$row." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$lr."_-B_".$B."\n");
        		system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$lr." -B ".$B.",0".$row." -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$lr."_-B_".$B." 2&> /dev/null ");
       		 	system ("".$XV." video_s._-j_".$tb.",".$lr."_-B_".$B."00000.ppm" );
			 print $GREEN;
        		print STDOUT "What this Zooming Good ?(Y/N) : ";
			 print $NORM;
        		$rep= <STDIN>;
        		chomp($rep);
        		if ( $rep eq "O" || $rep eq "o" || $rep eq "y"  || $rep eq "Y" )
               		{
                        	system("mv video_s._-j_".$tb.",".$lr."_-B_".$B."00000.ppm video_s._-j_".$tb.",".$lr."_-B_".$B.",0".$row.".avi");
                        	$good_video="video_s._-j_".$tb.",".$lr."_-B_".$B.",0".$row.".avi";
				$zoom=1;
                        	last;
                	}else{
                		system("rm video_s._-j_".$tb.",".$lr."_-B_".$B."00000.ppm");
				$zoom=0;
               		}
	    	}	
	}else {
		$inc=128; #  Multiple de 8 meme apres /2 */
		$rep=n;
		$prep=Z;
		$Yaxis=320;
		while ( $rep ne o && $rep ne "O" && $rep ne "y" && $rep ne "Y" )
		{
			printf("transcode -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$lr." -Z 720x".$Yaxis.",0 -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$lr."_-Z_720x_".$Yaxis."\n");
			system ("transcode -q 0 -z -k -i ".$vobpath."/".$sample." -j ".$tb.",".$lr." -Z 720x".$Yaxis.",0 -x vob,null -y ppm -c 10-11 -o video_s._-j_".$tb.",".$lr."_-Z_720x".$Yaxis."");
			system ("".$XV." video_s._-j_".$tb.",".$lr."_-Z_720x".$Yaxis."00000.ppm" );
			print STDOUT "What this Zooming Good ?(Y) , to Small ?(S), To Big ?(B) : ";
        		$rep= <STDIN>;
			chomp($rep);
        		if ( $rep eq "O" || $rep eq "o" || $rep eq "y"  || $rep eq "Y" )
	               	{
				system("mv video_s._-j_".$tb.",".$lr."_-Z_720x".$Yaxis."00000.ppm video_s._-j_".$tb.",".$lr."_-I_3_-C_3_-Z_720x".$Yaxis.".avi");
				$good_video="video_s._-j_".$tb.",".$lr."_-I_3_-C_3_-Z_720x".$Yaxis.".avi";
				$zoom=1;
                        	last;
			}elsif ( $rep eq "S" || $rep eq "s"  ) {
				system("rm video_s._-j_".$tb.",".$lr."_-Z_720x".$Yaxis."00000.ppm");
				$zoom=0;
				if ( $rep ne  $prep  && $prep ne Z ) { $inc = $inc/2; }
				$prep=$rep;
				$Yaxis= $Yaxis + $inc;
			}elsif ( $rep eq "B" || $rep eq "b"  ) {
                		system("rm video_s._-j_".$tb.",".$lr."_-Z_720x".$Yaxis."00000.ppm");
				$zoom=0;
				if ( $rep ne  $prep  && $prep ne Z ) { $inc = $inc/2; }
                		$prep=$rep;
                		$Yaxis= $Yaxis- $inc;
                	}
      		} 
	}
#
#
###################################" FILE SIZE AND DIVX ENCODE #######################################

	a_bitrate;
	if ( $left_right eq 1 && $top_bot eq 1 && $zoom eq 1  )
	{
		print $GREEN;
		print("\n Now Enter the maximal avifile size (in MB) : ");
		print $NORM;
		$filesize=<STDIN>;
		chomp($filesize);
		open(FILESIZE,">tmp/filesize.conf");
		print FILESIZE $filesize;
		close(FILESIZE);
		$par=$good_audio." ".$good_video;
	        @tmp = split /\./, $par;
		for ( $i = 1 ; $i < 4 ; $i = $i + 2  )
		{
                	$t = $tmp[$i];
                	$t =~ tr [_] [ ];
                	$params .= $t;
		}
		$params=$params." ".$sub_title;
		open (PARAMS,">tmp/params.conf");
		print PARAMS $params;
		close(PARAMS);
	
	} else 
	{
	print(" OK, You must now run vob2divx <MaxFilesize>  ".$good_audio." ".$good_video."\n\n");
	exit(1);
	}
	ask_clust;
}



if ($ARGV[0] eq runclust )
{
        if (defined($ARGV[1]))
        {
                $wdir=$ARGV[1];
                chdir($wdir) or die "$wdir does not exist or is'nt a directory\n
";
                sub_continue;
                aviencode;
		exit(0);
        }else{
                cluster;
        }
# We do never come here !
exit(1);
}


if ($ARGV[1] eq "continue" || $ARGV[0] eq "continue" || ! defined($ARGV[0]))
{	system("/bin/rm tmp/cluster.args 2&> /dev/null");
	sub_continue;
}  
# WARNING get_params probably uneeded !!!
if (1)
{
	aviencode;	
	merge;
# We do never come here !
	exit(1);
}
# 4.0 
