/* Terminal settings for IBM's aixterm */
/* By Oliver Kiddle (opk@thoth.u-net.com) */

/* Written and tested with AIX 3.2.5 */

/* #includes */ /*{{{C}}}*//*{{{*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "setterm.h"
/*}}}*/

static void set_title(const char *arg)
{
  printf("\033]2;%s\007",arg);
}

static void set_icon(const char *arg)
{
  printf("\033]1;%s\007",arg);
}

static void status_echo(const char *arg)
{
  char *arg2,*end;
  int column;
  
  if ((arg2=strchr(arg,','))!=(char*)0)
  {
    *arg2='\0';
    column=strtol(arg,&end,10);
    if (! *end && column>0)
    {
      printf("\033[?%dT%s\033[?F", column, ++arg2);
      return;
    }
    else *arg2=',';
  }
  
  /* Default to column 1 */
  printf("\033[?1T%s\033[?F", arg);
}

static void get_cursory(const char *arg)
{
  char posn[10];
  int i = 0;
  
  cbreak();
  fprintf(tty,"\033[6n"); fflush(tty);
  for (i=0; i<(sizeof(posn)-1) && ((posn[i] = getchar()) != ';'); i++);
  posn[i] = '\0';
  if (i>2) printf("%s\n",posn+2); fflush(stdout);
  cooked();
}

static void get_cursorx(const char *arg)
{
  char posn[14];
  int i = 0;
  
  cbreak();
  fprintf(tty,"\033[6n"); fflush(tty);
  for (i=0; i<(sizeof(posn)-1) && ((posn[i] = getchar()) != 'R'); i++);
  posn[i] = '\0';
  if (i>2) printf("%s\n",posn+5); fflush(stdout);
  cooked();
}

      
static Name names[]=
{
  "aixterm",
  (const char*)0
};

static Name hftnames[]=
{
  "hft",  /* hft is the initial green terminal on an RS/6000 */
  (const char*)0
};

static Option opts[]=
{
  { "-title", "Title", (const char*)0, set_title },
  { "-icon", "Title", (const char*)0, set_icon },
  { "-scroll", "smooth", "\033[?4h", (void(*)(const char*))0 },
  { "-scroll", "jump", "\033[?4l", (void(*)(const char*))0 },
  { "-inversescreen", "on", "\033[?5h", (void(*)(const char*))0 },
  { "-inversescreen", "off", "\033[?5l", (void(*)(const char*))0 },
  { "-linewrap", "on", "\033[?7h", (void(*)(const char*))0 },
  { "-linewrap", "off", "\033[?7l", (void(*)(const char*))0 },
  { "-repeat", "on", "\033[?8h", (void(*)(const char*))0 },
  { "-repeat", "off", "\033[?8l", (void(*)(const char*))0 },
  { "-scrollbar", "on", "\033[?42h", (void(*)(const char*))0 },
  { "-scrollbar", "off", "\033[?42l", (void(*)(const char*))0 },
  { "-statusline", "hide", "\033[?H", (void(*)(const char*))0 },
  { "-statusline", "show", "\033[?S", (void(*)(const char*))0 },
  { "-statusline", "erase", "\033[?E", (void(*)(const char*))0 },
  { "-statusline", "reverse", "\033[?48h", (void(*)(const char*))0 },
  { "-statusline", "normal", "\033[?48l", (void(*)(const char*))0 },
  { "-statusecho", "column,string", (const char*)0, status_echo },
  { "-getcursory", (const char*)0, (const char*)0, get_cursory },
  { "-getcursorx", (const char*)0, (const char*)0, get_cursorx },
  { (const char*)0, (const char*)0, (const char*)0, (void(*)(const char*))0 },
};

static Option hftopts[]=
{
  { "-linewrap", "on", "\033[?7h", (void(*)(const char*))0 },
  { "-linewrap", "off", "\033[?7l", (void(*)(const char*))0 },
  { (const char*)0, (const char*)0, (const char*)0, (void(*)(const char*))0 },
};

Terminal aixterm = { names, opts };
Terminal hft = { hftnames, hftopts };
