#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "setterm.h"

static Name names[]=
{
  "linux",
  (const char*)0
};

static Name names_m[]=
{
  "linux-m",
  (const char*)0
};

static void blank(const char *arg)
{
  long minutes;
  char *end;

  minutes=strtol(arg,&end,10);
  if (*end || minutes<1 || minutes>60) fprintf(stderr,"setterm: %s must be between 1 and 60\n",arg);
  printf("\033[9;%ld]",minutes); fflush(stdout);
}

static void beep(const char *arg)
{
  long hz;
  char *end;

  if (strcmp(arg,"default")==0) printf("\033[10]");
  else 
  {
    if (strcmp(arg,"off")==0) hz=0;
    else
    {
      hz=strtol(arg,&end,10);
      if (*end || hz<20 || hz>32767) fprintf(stderr,"setterm: %s must be between 20 and 32767\n",arg);
    }
    printf("\033[10;%ld]",hz); 
  }
  fflush(stdout);
}

static Option opts[]=
{
  { "-cursor", "noblink", "\033[?33l", (void(*)(const char*))0 },
  { "-cursor", "blink", "\033[?33h", (void(*)(const char*))0 },
  { "-cursor", "underline", "\033[?32l", (void(*)(const char*))0 },
  { "-cursor", "block", "\033[?32h", (void(*)(const char*))0 },
  { "-cursor", "8colour", "\033[?31l", (void(*)(const char*))0 },
  { "-cursor", "16colour", "\033[?31h", (void(*)(const char*))0 },
  { "-cursor", "black", "\033[100m", (void(*)(const char*))0 },
  { "-cursor", "blue", "\033[116m", (void(*)(const char*))0 },
  { "-cursor", "green", "\033[132m", (void(*)(const char*))0 },
  { "-cursor", "cyan", "\033[148m", (void(*)(const char*))0 },
  { "-cursor", "red", "\033[164m", (void(*)(const char*))0 },
  { "-cursor", "magenta", "\033[180m", (void(*)(const char*))0 },
  { "-cursor", "orange", "\033[196m", (void(*)(const char*))0 },
  { "-cursor", "white", "\033[212m", (void(*)(const char*))0 },
  { "-cursor", "gray", "\033[228m", (void(*)(const char*))0 },
  { "-cursor", "bblue", "\033[244m", (void(*)(const char*))0 },
  { "-cursor", "bgreen", "\033[260m", (void(*)(const char*))0 },
  { "-cursor", "bcyan", "\033[276m", (void(*)(const char*))0 },
  { "-cursor", "bred", "\033[292m", (void(*)(const char*))0 },
  { "-cursor", "pink", "\033[308m", (void(*)(const char*))0 },
  { "-cursor", "yellow", "\033[324m", (void(*)(const char*))0 },
  { "-cursor", "bwhite", "\033[340m", (void(*)(const char*))0 },
  { "-blank", "minutes", (const char*)0, blank },
  { "-noblank",(const char*)0, "\033[9;0]", (void(*)(const char*))0 },
  { "-beep", "hz|default|off", (const char*)0, beep },
  { "-linewrap", "on", "\033[?7h", (void(*)(const char*))0 },
  { "-linewrap", "off", "\033[?7l", (void(*)(const char*))0 },
  { "-repeat", "on", "\033[?8h", (void(*)(const char*))0 },
  { "-repeat", "off", "\033[?8l", (void(*)(const char*))0 },
  { "-inversescreen", "on", "\033[?5h", (void(*)(const char*))0 },
  { "-inversescreen", "off", "\033[?5l", (void(*)(const char*))0 },
  { (const char*)0, (const char*)0, (const char*)0, (void(*)(const char*))0 },
};

static Option opts_m[]=
{
  { "-cursor", "noblink", "\033[?33l", (void(*)(const char*))0 },
  { "-cursor", "blink", "\033[?33h", (void(*)(const char*))0 },
  { "-cursor", "underline", "\033[?32l", (void(*)(const char*))0 },
  { "-cursor", "block", "\033[?32h", (void(*)(const char*))0 },
  { "-blank", "minutes", (const char*)0, blank },
  { "-noblank",(const char*)0, "\033[9;0]", (void(*)(const char*))0 },
  { "-beep", "hz|default|off", (const char*)0, beep },
  { "-linewrap", "on", "\033[?7h", (void(*)(const char*))0 },
  { "-linewrap", "off", "\033[?7l", (void(*)(const char*))0 },
  { "-repeat", "on", "\033[?8h", (void(*)(const char*))0 },
  { "-repeat", "off", "\033[?8l", (void(*)(const char*))0 },
  { "-inversescreen", "on", "\033[?5h", (void(*)(const char*))0 },
  { "-inversescreen", "off", "\033[?5l", (void(*)(const char*))0 },
  { (const char*)0, (const char*)0, (const char*)0, (void(*)(const char*))0 },
};

Terminal linux = { names, opts };
Terminal linux_m = { names_m, opts_m };
